/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.uaa.users;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.uaa.users._InviteUsersRequest;

public final class InviteUsersRequest
extends _InviteUsersRequest {
    @Nullable
    private final String clientId;
    private final List<String> emails;
    private final String redirectUri;

    private InviteUsersRequest(Builder builder) {
        this.clientId = builder.clientId;
        this.emails = InviteUsersRequest.createUnmodifiableList(true, builder.emails);
        this.redirectUri = builder.redirectUri;
    }

    @Override
    @Nullable
    public String getClientId() {
        return this.clientId;
    }

    @Override
    public List<String> getEmails() {
        return this.emails;
    }

    @Override
    public String getRedirectUri() {
        return this.redirectUri;
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof InviteUsersRequest && this.equalTo((InviteUsersRequest)another);
    }

    private boolean equalTo(InviteUsersRequest another) {
        return Objects.equals(this.clientId, another.clientId) && this.emails.equals(another.emails) && this.redirectUri.equals(another.redirectUri);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + Objects.hashCode(this.clientId);
        h = h * 17 + this.emails.hashCode();
        h = h * 17 + this.redirectUri.hashCode();
        return h;
    }

    public String toString() {
        return "InviteUsersRequest{clientId=" + this.clientId + ", emails=" + this.emails + ", redirectUri=" + this.redirectUri + "}";
    }

    private static InviteUsersRequest validate(InviteUsersRequest instance) {
        instance.check();
        return instance;
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    public static final class Builder {
        private static final long INIT_BIT_REDIRECT_URI = 1L;
        private long initBits = 1L;
        private String clientId;
        private List<String> emails = new ArrayList<String>();
        private String redirectUri;

        private Builder() {
        }

        public final Builder from(InviteUsersRequest instance) {
            return this.from((_InviteUsersRequest)instance);
        }

        final Builder from(_InviteUsersRequest instance) {
            Objects.requireNonNull(instance, "instance");
            String clientIdValue = instance.getClientId();
            if (clientIdValue != null) {
                this.clientId(clientIdValue);
            }
            this.addAllEmails(instance.getEmails());
            this.redirectUri(instance.getRedirectUri());
            return this;
        }

        public final Builder clientId(@Nullable String clientId) {
            this.clientId = clientId;
            return this;
        }

        public final Builder email(String element) {
            this.emails.add(Objects.requireNonNull(element, "emails element"));
            return this;
        }

        public final Builder email(String ... elements) {
            for (String element : elements) {
                this.emails.add(Objects.requireNonNull(element, "emails element"));
            }
            return this;
        }

        public final Builder emails(Iterable<String> elements) {
            this.emails.clear();
            return this.addAllEmails(elements);
        }

        public final Builder addAllEmails(Iterable<String> elements) {
            for (String element : elements) {
                this.emails.add(Objects.requireNonNull(element, "emails element"));
            }
            return this;
        }

        public final Builder redirectUri(String redirectUri) {
            this.redirectUri = Objects.requireNonNull(redirectUri, "redirectUri");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public InviteUsersRequest build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return InviteUsersRequest.validate(new InviteUsersRequest(this));
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("redirectUri");
            }
            return "Cannot build InviteUsersRequest, some of required attributes are not set " + attributes;
        }
    }
}

