/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.uaa.users;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.cloudfoundry.uaa.users.AbstractUserId;
import org.cloudfoundry.uaa.users.AbstractUserSummary;
import org.cloudfoundry.uaa.users.Email;
import org.cloudfoundry.uaa.users.Meta;
import org.cloudfoundry.uaa.users.Name;
import org.cloudfoundry.uaa.users._VerifyUserResponse;

public final class VerifyUserResponse
extends _VerifyUserResponse {
    private final Boolean active;
    private final List<Email> email;
    private final Meta meta;
    private final Name name;
    private final String passwordLastModified;
    private final List<String> schemas;
    private final Boolean verified;
    private final String zoneId;
    private final String id;
    private final String origin;
    private final String userName;

    private VerifyUserResponse(Builder builder) {
        this.active = builder.active;
        this.email = VerifyUserResponse.createUnmodifiableList(true, builder.email);
        this.meta = builder.meta;
        this.name = builder.name;
        this.passwordLastModified = builder.passwordLastModified;
        this.schemas = VerifyUserResponse.createUnmodifiableList(true, builder.schemas);
        this.verified = builder.verified;
        this.zoneId = builder.zoneId;
        this.id = builder.id;
        this.origin = builder.origin;
        this.userName = builder.userName;
    }

    @Override
    @JsonProperty(value="active")
    public Boolean getActive() {
        return this.active;
    }

    @Override
    @JsonProperty(value="emails")
    public List<Email> getEmail() {
        return this.email;
    }

    @Override
    @JsonProperty(value="meta")
    public Meta getMeta() {
        return this.meta;
    }

    @Override
    @JsonProperty(value="name")
    public Name getName() {
        return this.name;
    }

    @Override
    @JsonProperty(value="passwordLastModified")
    public String getPasswordLastModified() {
        return this.passwordLastModified;
    }

    @Override
    @JsonProperty(value="schemas")
    public List<String> getSchemas() {
        return this.schemas;
    }

    @Override
    @JsonProperty(value="verified")
    public Boolean getVerified() {
        return this.verified;
    }

    @Override
    @JsonProperty(value="zoneId")
    public String getZoneId() {
        return this.zoneId;
    }

    @Override
    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    @Override
    @JsonProperty(value="origin")
    public String getOrigin() {
        return this.origin;
    }

    @Override
    @JsonProperty(value="userName")
    public String getUserName() {
        return this.userName;
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof VerifyUserResponse && this.equalTo((VerifyUserResponse)another);
    }

    private boolean equalTo(VerifyUserResponse another) {
        return this.active.equals(another.active) && this.email.equals(another.email) && this.meta.equals(another.meta) && this.name.equals(another.name) && this.passwordLastModified.equals(another.passwordLastModified) && this.schemas.equals(another.schemas) && this.verified.equals(another.verified) && this.zoneId.equals(another.zoneId) && this.id.equals(another.id) && this.origin.equals(another.origin) && this.userName.equals(another.userName);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.active.hashCode();
        h = h * 17 + this.email.hashCode();
        h = h * 17 + this.meta.hashCode();
        h = h * 17 + this.name.hashCode();
        h = h * 17 + this.passwordLastModified.hashCode();
        h = h * 17 + this.schemas.hashCode();
        h = h * 17 + this.verified.hashCode();
        h = h * 17 + this.zoneId.hashCode();
        h = h * 17 + this.id.hashCode();
        h = h * 17 + this.origin.hashCode();
        h = h * 17 + this.userName.hashCode();
        return h;
    }

    public String toString() {
        return "VerifyUserResponse{active=" + this.active + ", email=" + this.email + ", meta=" + this.meta + ", name=" + this.name + ", passwordLastModified=" + this.passwordLastModified + ", schemas=" + this.schemas + ", verified=" + this.verified + ", zoneId=" + this.zoneId + ", id=" + this.id + ", origin=" + this.origin + ", userName=" + this.userName + "}";
    }

    @Deprecated
    @JsonCreator
    static VerifyUserResponse fromJson(Json json) {
        Builder builder = VerifyUserResponse.builder();
        if (json.active != null) {
            builder.active(json.active);
        }
        if (json.email != null) {
            builder.addAllEmail(json.email);
        }
        if (json.meta != null) {
            builder.meta(json.meta);
        }
        if (json.name != null) {
            builder.name(json.name);
        }
        if (json.passwordLastModified != null) {
            builder.passwordLastModified(json.passwordLastModified);
        }
        if (json.schemas != null) {
            builder.addAllSchemas(json.schemas);
        }
        if (json.verified != null) {
            builder.verified(json.verified);
        }
        if (json.zoneId != null) {
            builder.zoneId(json.zoneId);
        }
        if (json.id != null) {
            builder.id(json.id);
        }
        if (json.origin != null) {
            builder.origin(json.origin);
        }
        if (json.userName != null) {
            builder.userName(json.userName);
        }
        return builder.build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    public static final class Builder {
        private static final long INIT_BIT_ACTIVE = 1L;
        private static final long INIT_BIT_META = 2L;
        private static final long INIT_BIT_NAME = 4L;
        private static final long INIT_BIT_PASSWORD_LAST_MODIFIED = 8L;
        private static final long INIT_BIT_VERIFIED = 16L;
        private static final long INIT_BIT_ZONE_ID = 32L;
        private static final long INIT_BIT_ID = 64L;
        private static final long INIT_BIT_ORIGIN = 128L;
        private static final long INIT_BIT_USER_NAME = 256L;
        private long initBits = 511L;
        private Boolean active;
        private List<Email> email = new ArrayList<Email>();
        private Meta meta;
        private Name name;
        private String passwordLastModified;
        private List<String> schemas = new ArrayList<String>();
        private Boolean verified;
        private String zoneId;
        private String id;
        private String origin;
        private String userName;

        private Builder() {
        }

        public final Builder from(AbstractUserSummary instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(AbstractUserId instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(VerifyUserResponse instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        final Builder from(_VerifyUserResponse instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            AbstractUserId instance;
            if (object instanceof AbstractUserSummary) {
                instance = (AbstractUserSummary)object;
                this.meta(((AbstractUserSummary)instance).getMeta());
                this.addAllSchemas(((AbstractUserSummary)instance).getSchemas());
                this.name(((AbstractUserSummary)instance).getName());
                this.verified(((AbstractUserSummary)instance).getVerified());
                this.active(((AbstractUserSummary)instance).getActive());
                this.zoneId(((AbstractUserSummary)instance).getZoneId());
                this.passwordLastModified(((AbstractUserSummary)instance).getPasswordLastModified());
                this.addAllEmail(((AbstractUserSummary)instance).getEmail());
            }
            if (object instanceof AbstractUserId) {
                instance = (AbstractUserId)object;
                this.userName(instance.getUserName());
                this.origin(instance.getOrigin());
                this.id(instance.getId());
            }
        }

        public final Builder active(Boolean active) {
            this.active = Objects.requireNonNull(active, "active");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder email(Email element) {
            this.email.add(Objects.requireNonNull(element, "email element"));
            return this;
        }

        public final Builder email(Email ... elements) {
            for (Email element : elements) {
                this.email.add(Objects.requireNonNull(element, "email element"));
            }
            return this;
        }

        public final Builder email(Iterable<? extends Email> elements) {
            this.email.clear();
            return this.addAllEmail(elements);
        }

        public final Builder addAllEmail(Iterable<? extends Email> elements) {
            for (Email email : elements) {
                this.email.add(Objects.requireNonNull(email, "email element"));
            }
            return this;
        }

        public final Builder meta(Meta meta) {
            this.meta = Objects.requireNonNull(meta, "meta");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder name(Name name) {
            this.name = Objects.requireNonNull(name, "name");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public final Builder passwordLastModified(String passwordLastModified) {
            this.passwordLastModified = Objects.requireNonNull(passwordLastModified, "passwordLastModified");
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        public final Builder schema(String element) {
            this.schemas.add(Objects.requireNonNull(element, "schemas element"));
            return this;
        }

        public final Builder schema(String ... elements) {
            for (String element : elements) {
                this.schemas.add(Objects.requireNonNull(element, "schemas element"));
            }
            return this;
        }

        public final Builder schemas(Iterable<String> elements) {
            this.schemas.clear();
            return this.addAllSchemas(elements);
        }

        public final Builder addAllSchemas(Iterable<String> elements) {
            for (String element : elements) {
                this.schemas.add(Objects.requireNonNull(element, "schemas element"));
            }
            return this;
        }

        public final Builder verified(Boolean verified) {
            this.verified = Objects.requireNonNull(verified, "verified");
            this.initBits &= 0xFFFFFFFFFFFFFFEFL;
            return this;
        }

        public final Builder zoneId(String zoneId) {
            this.zoneId = Objects.requireNonNull(zoneId, "zoneId");
            this.initBits &= 0xFFFFFFFFFFFFFFDFL;
            return this;
        }

        public final Builder id(String id) {
            this.id = Objects.requireNonNull(id, "id");
            this.initBits &= 0xFFFFFFFFFFFFFFBFL;
            return this;
        }

        public final Builder origin(String origin) {
            this.origin = Objects.requireNonNull(origin, "origin");
            this.initBits &= 0xFFFFFFFFFFFFFF7FL;
            return this;
        }

        public final Builder userName(String userName) {
            this.userName = Objects.requireNonNull(userName, "userName");
            this.initBits &= 0xFFFFFFFFFFFFFEFFL;
            return this;
        }

        public VerifyUserResponse build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new VerifyUserResponse(this);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("active");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("meta");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("name");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("passwordLastModified");
            }
            if ((this.initBits & 0x10L) != 0L) {
                attributes.add("verified");
            }
            if ((this.initBits & 0x20L) != 0L) {
                attributes.add("zoneId");
            }
            if ((this.initBits & 0x40L) != 0L) {
                attributes.add("id");
            }
            if ((this.initBits & 0x80L) != 0L) {
                attributes.add("origin");
            }
            if ((this.initBits & 0x100L) != 0L) {
                attributes.add("userName");
            }
            return "Cannot build VerifyUserResponse, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    static final class Json
    extends _VerifyUserResponse {
        Boolean active;
        List<Email> email = Collections.emptyList();
        Meta meta;
        Name name;
        String passwordLastModified;
        List<String> schemas = Collections.emptyList();
        Boolean verified;
        String zoneId;
        String id;
        String origin;
        String userName;

        Json() {
        }

        @JsonProperty(value="active")
        public void setActive(Boolean active) {
            this.active = active;
        }

        @JsonProperty(value="emails")
        public void setEmail(List<Email> email) {
            this.email = email;
        }

        @JsonProperty(value="meta")
        public void setMeta(Meta meta) {
            this.meta = meta;
        }

        @JsonProperty(value="name")
        public void setName(Name name) {
            this.name = name;
        }

        @JsonProperty(value="passwordLastModified")
        public void setPasswordLastModified(String passwordLastModified) {
            this.passwordLastModified = passwordLastModified;
        }

        @JsonProperty(value="schemas")
        public void setSchemas(List<String> schemas) {
            this.schemas = schemas;
        }

        @JsonProperty(value="verified")
        public void setVerified(Boolean verified) {
            this.verified = verified;
        }

        @JsonProperty(value="zoneId")
        public void setZoneId(String zoneId) {
            this.zoneId = zoneId;
        }

        @JsonProperty(value="id")
        public void setId(String id) {
            this.id = id;
        }

        @JsonProperty(value="origin")
        public void setOrigin(String origin) {
            this.origin = origin;
        }

        @JsonProperty(value="userName")
        public void setUserName(String userName) {
            this.userName = userName;
        }

        @Override
        public Boolean getActive() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<Email> getEmail() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Meta getMeta() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Name getName() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getPasswordLastModified() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<String> getSchemas() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Boolean getVerified() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getZoneId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getOrigin() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getUserName() {
            throw new UnsupportedOperationException();
        }
    }
}

