package org.cloudfoundry.client.v2.applications;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Generated;
import org.cloudfoundry.Nullable;

/**
 * The request payload for the v2 Update Application request
 */
@SuppressWarnings({"all", "deprecation"})
@Generated({"Immutables.generator", "_UpdateApplicationRequest"})
public final class UpdateApplicationRequest
    extends org.cloudfoundry.client.v2.applications._UpdateApplicationRequest {
  private final String applicationId;
  private final @Nullable String buildpack;
  private final @Nullable String command;
  private final @Nullable Boolean console;
  private final @Nullable String debug;
  private final @Nullable Boolean diego;
  private final @Nullable Integer diskQuota;
  private final @Nullable Map<String, Object> dockerCredentialsJsons;
  private final @Nullable String dockerImage;
  private final @Nullable Boolean enableSsh;
  private final @Nullable Map<String, Object> environmentJsons;
  private final @Nullable Integer healthCheckTimeout;
  private final @Nullable String healthCheckType;
  private final @Nullable Integer instances;
  private final @Nullable Integer memory;
  private final @Nullable String name;
  private final @Nullable String production;
  private final @Nullable String spaceId;
  private final @Nullable String stackId;
  private final @Nullable String state;

  private UpdateApplicationRequest(UpdateApplicationRequest.Builder builder) {
    this.applicationId = builder.applicationId;
    this.buildpack = builder.buildpack;
    this.command = builder.command;
    this.console = builder.console;
    this.debug = builder.debug;
    this.diego = builder.diego;
    this.diskQuota = builder.diskQuota;
    this.dockerCredentialsJsons = builder.dockerCredentialsJsons == null ? null : createUnmodifiableMap(false, false, builder.dockerCredentialsJsons);
    this.dockerImage = builder.dockerImage;
    this.enableSsh = builder.enableSsh;
    this.environmentJsons = builder.environmentJsons == null ? null : createUnmodifiableMap(false, false, builder.environmentJsons);
    this.healthCheckTimeout = builder.healthCheckTimeout;
    this.healthCheckType = builder.healthCheckType;
    this.instances = builder.instances;
    this.memory = builder.memory;
    this.name = builder.name;
    this.production = builder.production;
    this.spaceId = builder.spaceId;
    this.stackId = builder.stackId;
    this.state = builder.state;
  }

  /**
   * The application id
   */
  @Override
  public String getApplicationId() {
    return applicationId;
  }

  /**
   * Buildpack to build the application
   */
  @Override
  public @Nullable String getBuildpack() {
    return buildpack;
  }

  /**
   * The command to start the application after it is staged
   */
  @Override
  public @Nullable String getCommand() {
    return command;
  }

  /**
   * Open the console port for the application (at {@code $CONSOLE_PORT})
   */
  @Deprecated
  @Override
  public @Nullable Boolean getConsole() {
    return console;
  }

  /**
   * Open the debug port for the application (at {@code $DEBUG_PORT})
   */
  @Deprecated
  @Override
  public @Nullable String getDebug() {
    return debug;
  }

  /**
   * Use diego to stage and to run when available
   */
  @Override
  public @Nullable Boolean getDiego() {
    return diego;
  }

  /**
   * The maximum amount of disk available to an instance of an application. In megabytes.
   */
  @Override
  public @Nullable Integer getDiskQuota() {
    return diskQuota;
  }

  /**
   * Docker credentials for pulling docker image
   */
  @Override
  public @Nullable Map<String, Object> getDockerCredentialsJsons() {
    return dockerCredentialsJsons;
  }

  /**
   * Name of the Docker image containing the application
   */
  @Override
  public @Nullable String getDockerImage() {
    return dockerImage;
  }

  /**
   * Enable SSH for the application
   */
  @Override
  public @Nullable Boolean getEnableSsh() {
    return enableSsh;
  }

  /**
   * Key/value pairs of all the environment variables to run in your application. Does not include any system or service variables.
   */
  @Override
  public @Nullable Map<String, Object> getEnvironmentJsons() {
    return environmentJsons;
  }

  /**
   * Timeout for health checking of an staged application when starting up
   */
  @Override
  public @Nullable Integer getHealthCheckTimeout() {
    return healthCheckTimeout;
  }

  /**
   * Type of health check to perform
   */
  @Override
  public @Nullable String getHealthCheckType() {
    return healthCheckType;
  }

  /**
   * The number of instances of the application to run. To ensure optimal availability, ensure there are at least 2 instances.
   */
  @Override
  public @Nullable Integer getInstances() {
    return instances;
  }

  /**
   * The amount of memory each instance should have. In megabytes.
   */
  @Override
  public @Nullable Integer getMemory() {
    return memory;
  }

  /**
   * The name of the application
   */
  @Override
  public @Nullable String getName() {
    return name;
  }

  /**
   * Whether the application is production
   */
  @Deprecated
  @Override
  public @Nullable String getProduction() {
    return production;
  }

  /**
   * The id of the associated space
   */
  @Override
  public @Nullable String getSpaceId() {
    return spaceId;
  }

  /**
   * The id of the associated stack
   */
  @Override
  public @Nullable String getStackId() {
    return stackId;
  }

  /**
   * The current desired state of the application
   */
  @Override
  public @Nullable String getState() {
    return state;
  }

  /**
   * This instance is equal to all instances of {@code UpdateApplicationRequest} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof UpdateApplicationRequest
        && equalTo((UpdateApplicationRequest) another);
  }

  private boolean equalTo(UpdateApplicationRequest another) {
    return applicationId.equals(another.applicationId)
        && Objects.equals(buildpack, another.buildpack)
        && Objects.equals(command, another.command)
        && Objects.equals(console, another.console)
        && Objects.equals(debug, another.debug)
        && Objects.equals(diego, another.diego)
        && Objects.equals(diskQuota, another.diskQuota)
        && Objects.equals(dockerCredentialsJsons, another.dockerCredentialsJsons)
        && Objects.equals(dockerImage, another.dockerImage)
        && Objects.equals(enableSsh, another.enableSsh)
        && Objects.equals(environmentJsons, another.environmentJsons)
        && Objects.equals(healthCheckTimeout, another.healthCheckTimeout)
        && Objects.equals(healthCheckType, another.healthCheckType)
        && Objects.equals(instances, another.instances)
        && Objects.equals(memory, another.memory)
        && Objects.equals(name, another.name)
        && Objects.equals(production, another.production)
        && Objects.equals(spaceId, another.spaceId)
        && Objects.equals(stackId, another.stackId)
        && Objects.equals(state, another.state);
  }

  /**
   * Computes a hash code from attributes: {@code applicationId}, {@code buildpack}, {@code command}, {@code console}, {@code debug}, {@code diego}, {@code diskQuota}, {@code dockerCredentialsJsons}, {@code dockerImage}, {@code enableSsh}, {@code environmentJsons}, {@code healthCheckTimeout}, {@code healthCheckType}, {@code instances}, {@code memory}, {@code name}, {@code production}, {@code spaceId}, {@code stackId}, {@code state}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + applicationId.hashCode();
    h += (h << 5) + Objects.hashCode(buildpack);
    h += (h << 5) + Objects.hashCode(command);
    h += (h << 5) + Objects.hashCode(console);
    h += (h << 5) + Objects.hashCode(debug);
    h += (h << 5) + Objects.hashCode(diego);
    h += (h << 5) + Objects.hashCode(diskQuota);
    h += (h << 5) + Objects.hashCode(dockerCredentialsJsons);
    h += (h << 5) + Objects.hashCode(dockerImage);
    h += (h << 5) + Objects.hashCode(enableSsh);
    h += (h << 5) + Objects.hashCode(environmentJsons);
    h += (h << 5) + Objects.hashCode(healthCheckTimeout);
    h += (h << 5) + Objects.hashCode(healthCheckType);
    h += (h << 5) + Objects.hashCode(instances);
    h += (h << 5) + Objects.hashCode(memory);
    h += (h << 5) + Objects.hashCode(name);
    h += (h << 5) + Objects.hashCode(production);
    h += (h << 5) + Objects.hashCode(spaceId);
    h += (h << 5) + Objects.hashCode(stackId);
    h += (h << 5) + Objects.hashCode(state);
    return h;
  }

  /**
   * Prints the immutable value {@code UpdateApplicationRequest} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "UpdateApplicationRequest{"
        + "applicationId=" + applicationId
        + ", buildpack=" + buildpack
        + ", command=" + command
        + ", console=" + console
        + ", debug=" + debug
        + ", diego=" + diego
        + ", diskQuota=" + diskQuota
        + ", dockerCredentialsJsons=" + dockerCredentialsJsons
        + ", dockerImage=" + dockerImage
        + ", enableSsh=" + enableSsh
        + ", environmentJsons=" + environmentJsons
        + ", healthCheckTimeout=" + healthCheckTimeout
        + ", healthCheckType=" + healthCheckType
        + ", instances=" + instances
        + ", memory=" + memory
        + ", name=" + name
        + ", production=" + production
        + ", spaceId=" + spaceId
        + ", stackId=" + stackId
        + ", state=" + state
        + "}";
  }

  /**
   * Creates a builder for {@link UpdateApplicationRequest UpdateApplicationRequest}.
   * @return A new UpdateApplicationRequest builder
   */
  public static UpdateApplicationRequest.Builder builder() {
    return new UpdateApplicationRequest.Builder();
  }

  /**
   * Builds instances of type {@link UpdateApplicationRequest UpdateApplicationRequest}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  public static final class Builder {
    private static final long INIT_BIT_APPLICATION_ID = 0x1L;
    private long initBits = 0x1L;

    private String applicationId;
    private String buildpack;
    private String command;
    private Boolean console;
    private String debug;
    private Boolean diego;
    private Integer diskQuota;
    private Map<String, Object> dockerCredentialsJsons = null;
    private String dockerImage;
    private Boolean enableSsh;
    private Map<String, Object> environmentJsons = null;
    private Integer healthCheckTimeout;
    private String healthCheckType;
    private Integer instances;
    private Integer memory;
    private String name;
    private String production;
    private String spaceId;
    private String stackId;
    private String state;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code UpdateApplicationRequest} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(UpdateApplicationRequest instance) {
      return from((_UpdateApplicationRequest) instance);
    }

    /**
     * Copy abstract value type {@code _UpdateApplicationRequest} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_UpdateApplicationRequest instance) {
      Objects.requireNonNull(instance, "instance");
      applicationId(instance.getApplicationId());
      String buildpackValue = instance.getBuildpack();
      if (buildpackValue != null) {
        buildpack(buildpackValue);
      }
      String commandValue = instance.getCommand();
      if (commandValue != null) {
        command(commandValue);
      }
      Boolean consoleValue = instance.getConsole();
      if (consoleValue != null) {
        console(consoleValue);
      }
      String debugValue = instance.getDebug();
      if (debugValue != null) {
        debug(debugValue);
      }
      Boolean diegoValue = instance.getDiego();
      if (diegoValue != null) {
        diego(diegoValue);
      }
      Integer diskQuotaValue = instance.getDiskQuota();
      if (diskQuotaValue != null) {
        diskQuota(diskQuotaValue);
      }
      Map<String, Object> dockerCredentialsJsonsValue = instance.getDockerCredentialsJsons();
      if (dockerCredentialsJsonsValue != null) {
        putAllDockerCredentialsJsons(dockerCredentialsJsonsValue);
      }
      String dockerImageValue = instance.getDockerImage();
      if (dockerImageValue != null) {
        dockerImage(dockerImageValue);
      }
      Boolean enableSshValue = instance.getEnableSsh();
      if (enableSshValue != null) {
        enableSsh(enableSshValue);
      }
      Map<String, Object> environmentJsonsValue = instance.getEnvironmentJsons();
      if (environmentJsonsValue != null) {
        putAllEnvironmentJsons(environmentJsonsValue);
      }
      Integer healthCheckTimeoutValue = instance.getHealthCheckTimeout();
      if (healthCheckTimeoutValue != null) {
        healthCheckTimeout(healthCheckTimeoutValue);
      }
      String healthCheckTypeValue = instance.getHealthCheckType();
      if (healthCheckTypeValue != null) {
        healthCheckType(healthCheckTypeValue);
      }
      Integer instancesValue = instance.getInstances();
      if (instancesValue != null) {
        instances(instancesValue);
      }
      Integer memoryValue = instance.getMemory();
      if (memoryValue != null) {
        memory(memoryValue);
      }
      String nameValue = instance.getName();
      if (nameValue != null) {
        name(nameValue);
      }
      String productionValue = instance.getProduction();
      if (productionValue != null) {
        production(productionValue);
      }
      String spaceIdValue = instance.getSpaceId();
      if (spaceIdValue != null) {
        spaceId(spaceIdValue);
      }
      String stackIdValue = instance.getStackId();
      if (stackIdValue != null) {
        stackId(stackIdValue);
      }
      String stateValue = instance.getState();
      if (stateValue != null) {
        state(stateValue);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link _UpdateApplicationRequest#getApplicationId() applicationId} attribute.
     * @param applicationId The value for applicationId 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder applicationId(String applicationId) {
      this.applicationId = Objects.requireNonNull(applicationId, "applicationId");
      initBits &= ~INIT_BIT_APPLICATION_ID;
      return this;
    }

    /**
     * Initializes the value for the {@link _UpdateApplicationRequest#getBuildpack() buildpack} attribute.
     * @param buildpack The value for buildpack (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder buildpack(@Nullable String buildpack) {
      this.buildpack = buildpack;
      return this;
    }

    /**
     * Initializes the value for the {@link _UpdateApplicationRequest#getCommand() command} attribute.
     * @param command The value for command (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder command(@Nullable String command) {
      this.command = command;
      return this;
    }

    /**
     * Initializes the value for the {@link _UpdateApplicationRequest#getConsole() console} attribute.
     * @param console The value for console (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @Deprecated
    public final Builder console(@Nullable Boolean console) {
      this.console = console;
      return this;
    }

    /**
     * Initializes the value for the {@link _UpdateApplicationRequest#getDebug() debug} attribute.
     * @param debug The value for debug (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @Deprecated
    public final Builder debug(@Nullable String debug) {
      this.debug = debug;
      return this;
    }

    /**
     * Initializes the value for the {@link _UpdateApplicationRequest#getDiego() diego} attribute.
     * @param diego The value for diego (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder diego(@Nullable Boolean diego) {
      this.diego = diego;
      return this;
    }

    /**
     * Initializes the value for the {@link _UpdateApplicationRequest#getDiskQuota() diskQuota} attribute.
     * @param diskQuota The value for diskQuota (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder diskQuota(@Nullable Integer diskQuota) {
      this.diskQuota = diskQuota;
      return this;
    }

    /**
     * Put one entry to the {@link _UpdateApplicationRequest#getDockerCredentialsJsons() dockerCredentialsJsons} map.
     * @param key The key in the dockerCredentialsJsons map
     * @param value The associated value in the dockerCredentialsJsons map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder dockerCredentialsJson(String key, Object value) {
      if (this.dockerCredentialsJsons == null) {
        this.dockerCredentialsJsons = new LinkedHashMap<String, Object>();
      }
      this.dockerCredentialsJsons.put(key, value);
      return this;
    }

    /**
     * Put one entry to the {@link _UpdateApplicationRequest#getDockerCredentialsJsons() dockerCredentialsJsons} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder dockerCredentialsJson(Map.Entry<String, ? extends Object> entry) {
      if (this.dockerCredentialsJsons == null) {
        this.dockerCredentialsJsons = new LinkedHashMap<String, Object>();
      }
      String k = entry.getKey();
      Object v = entry.getValue();
      this.dockerCredentialsJsons.put(k, v);
      return this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link _UpdateApplicationRequest#getDockerCredentialsJsons() dockerCredentialsJsons} map. Nulls are not permitted as keys or values, but parameter itself can be null
     * @param dockerCredentialsJsons The entries that will be added to the dockerCredentialsJsons map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder dockerCredentialsJsons(@Nullable Map<String, ? extends Object> dockerCredentialsJsons) {
      if (dockerCredentialsJsons == null) {
        this.dockerCredentialsJsons = null;
        return this;
      }
      this.dockerCredentialsJsons = new LinkedHashMap<String, Object>();
      return putAllDockerCredentialsJsons(dockerCredentialsJsons);
    }

    /**
     * Put all mappings from the specified map as entries to {@link _UpdateApplicationRequest#getDockerCredentialsJsons() dockerCredentialsJsons} map. Nulls are not permitted
     * @param dockerCredentialsJsons The entries that will be added to the dockerCredentialsJsons map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder putAllDockerCredentialsJsons(Map<String, ? extends Object> dockerCredentialsJsons) {
      if (this.dockerCredentialsJsons == null) {
        this.dockerCredentialsJsons = new LinkedHashMap<String, Object>();
      }
      for (Map.Entry<String, ? extends Object> entry : dockerCredentialsJsons.entrySet()) {
        String k = entry.getKey();
        Object v = entry.getValue();
        this.dockerCredentialsJsons.put(k, v);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link _UpdateApplicationRequest#getDockerImage() dockerImage} attribute.
     * @param dockerImage The value for dockerImage (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder dockerImage(@Nullable String dockerImage) {
      this.dockerImage = dockerImage;
      return this;
    }

    /**
     * Initializes the value for the {@link _UpdateApplicationRequest#getEnableSsh() enableSsh} attribute.
     * @param enableSsh The value for enableSsh (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder enableSsh(@Nullable Boolean enableSsh) {
      this.enableSsh = enableSsh;
      return this;
    }

    /**
     * Put one entry to the {@link _UpdateApplicationRequest#getEnvironmentJsons() environmentJsons} map.
     * @param key The key in the environmentJsons map
     * @param value The associated value in the environmentJsons map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder environmentJson(String key, Object value) {
      if (this.environmentJsons == null) {
        this.environmentJsons = new LinkedHashMap<String, Object>();
      }
      this.environmentJsons.put(key, value);
      return this;
    }

    /**
     * Put one entry to the {@link _UpdateApplicationRequest#getEnvironmentJsons() environmentJsons} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder environmentJson(Map.Entry<String, ? extends Object> entry) {
      if (this.environmentJsons == null) {
        this.environmentJsons = new LinkedHashMap<String, Object>();
      }
      String k = entry.getKey();
      Object v = entry.getValue();
      this.environmentJsons.put(k, v);
      return this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link _UpdateApplicationRequest#getEnvironmentJsons() environmentJsons} map. Nulls are not permitted as keys or values, but parameter itself can be null
     * @param environmentJsons The entries that will be added to the environmentJsons map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder environmentJsons(@Nullable Map<String, ? extends Object> environmentJsons) {
      if (environmentJsons == null) {
        this.environmentJsons = null;
        return this;
      }
      this.environmentJsons = new LinkedHashMap<String, Object>();
      return putAllEnvironmentJsons(environmentJsons);
    }

    /**
     * Put all mappings from the specified map as entries to {@link _UpdateApplicationRequest#getEnvironmentJsons() environmentJsons} map. Nulls are not permitted
     * @param environmentJsons The entries that will be added to the environmentJsons map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder putAllEnvironmentJsons(Map<String, ? extends Object> environmentJsons) {
      if (this.environmentJsons == null) {
        this.environmentJsons = new LinkedHashMap<String, Object>();
      }
      for (Map.Entry<String, ? extends Object> entry : environmentJsons.entrySet()) {
        String k = entry.getKey();
        Object v = entry.getValue();
        this.environmentJsons.put(k, v);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link _UpdateApplicationRequest#getHealthCheckTimeout() healthCheckTimeout} attribute.
     * @param healthCheckTimeout The value for healthCheckTimeout (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder healthCheckTimeout(@Nullable Integer healthCheckTimeout) {
      this.healthCheckTimeout = healthCheckTimeout;
      return this;
    }

    /**
     * Initializes the value for the {@link _UpdateApplicationRequest#getHealthCheckType() healthCheckType} attribute.
     * @param healthCheckType The value for healthCheckType (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder healthCheckType(@Nullable String healthCheckType) {
      this.healthCheckType = healthCheckType;
      return this;
    }

    /**
     * Initializes the value for the {@link _UpdateApplicationRequest#getInstances() instances} attribute.
     * @param instances The value for instances (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder instances(@Nullable Integer instances) {
      this.instances = instances;
      return this;
    }

    /**
     * Initializes the value for the {@link _UpdateApplicationRequest#getMemory() memory} attribute.
     * @param memory The value for memory (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder memory(@Nullable Integer memory) {
      this.memory = memory;
      return this;
    }

    /**
     * Initializes the value for the {@link _UpdateApplicationRequest#getName() name} attribute.
     * @param name The value for name (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder name(@Nullable String name) {
      this.name = name;
      return this;
    }

    /**
     * Initializes the value for the {@link _UpdateApplicationRequest#getProduction() production} attribute.
     * @param production The value for production (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @Deprecated
    public final Builder production(@Nullable String production) {
      this.production = production;
      return this;
    }

    /**
     * Initializes the value for the {@link _UpdateApplicationRequest#getSpaceId() spaceId} attribute.
     * @param spaceId The value for spaceId (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder spaceId(@Nullable String spaceId) {
      this.spaceId = spaceId;
      return this;
    }

    /**
     * Initializes the value for the {@link _UpdateApplicationRequest#getStackId() stackId} attribute.
     * @param stackId The value for stackId (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder stackId(@Nullable String stackId) {
      this.stackId = stackId;
      return this;
    }

    /**
     * Initializes the value for the {@link _UpdateApplicationRequest#getState() state} attribute.
     * @param state The value for state (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder state(@Nullable String state) {
      this.state = state;
      return this;
    }

    /**
     * Builds a new {@link UpdateApplicationRequest UpdateApplicationRequest}.
     * @return An immutable instance of UpdateApplicationRequest
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public UpdateApplicationRequest build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new UpdateApplicationRequest(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<String>();
      if ((initBits & INIT_BIT_APPLICATION_ID) != 0) attributes.add("applicationId");
      return "Cannot build UpdateApplicationRequest, some of required attributes are not set " + attributes;
    }
  }

  private static <K, V> Map<K, V> createUnmodifiableMap(boolean checkNulls, boolean skipNulls, Map<? extends K, ? extends V> map) {
    switch (map.size()) {
    case 0: return Collections.emptyMap();
    case 1: {
      Map.Entry<? extends K, ? extends V> e = map.entrySet().iterator().next();
      K k = e.getKey();
      V v = e.getValue();
      if (checkNulls) {
        Objects.requireNonNull(k, "key");
        Objects.requireNonNull(v, "value");
      }
      if (skipNulls && (k == null || v == null)) {
        return Collections.emptyMap();
      }
      return Collections.singletonMap(k, v);
    }
    default: {
      Map<K, V> linkedMap = new LinkedHashMap<K, V>(map.size());
      if (skipNulls || checkNulls) {
        for (Map.Entry<? extends K, ? extends V> e : map.entrySet()) {
          K k = e.getKey();
          V v = e.getValue();
          if (skipNulls) {
            if (k == null || v == null) continue;
          } else if (checkNulls) {
            Objects.requireNonNull(k, "key");
            Objects.requireNonNull(v, "value");
          }
          linkedMap.put(k, v);
        }
      } else {
        linkedMap.putAll(map);
      }
      return Collections.unmodifiableMap(linkedMap);
    }
    }
  }
}
