package org.cloudfoundry.client.v2.applicationusageevents;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.Objects;
import javax.annotation.Generated;
import org.cloudfoundry.Nullable;

/**
 * The entity response payload for the Application Usage Event resource
 */
@SuppressWarnings({"all"})
@Generated({"Immutables.generator", "_ApplicationUsageEventEntity"})
public final class ApplicationUsageEventEntity
    extends org.cloudfoundry.client.v2.applicationusageevents._ApplicationUsageEventEntity {
  private final @Nullable String applicationId;
  private final @Nullable String applicationName;
  private final @Nullable String buildpackId;
  private final @Nullable String buildpackName;
  private final @Nullable Integer instanceCount;
  private final @Nullable Integer memoryInMbPerInstances;
  private final @Nullable String organizationId;
  private final @Nullable String packageState;
  private final @Nullable String parentApplicationId;
  private final @Nullable String parentApplicationName;
  private final @Nullable String processType;
  private final @Nullable String spaceId;
  private final @Nullable String spaceName;
  private final @Nullable String state;
  private final @Nullable String taskId;
  private final @Nullable String taskName;

  private ApplicationUsageEventEntity(ApplicationUsageEventEntity.Builder builder) {
    this.applicationId = builder.applicationId;
    this.applicationName = builder.applicationName;
    this.buildpackId = builder.buildpackId;
    this.buildpackName = builder.buildpackName;
    this.instanceCount = builder.instanceCount;
    this.memoryInMbPerInstances = builder.memoryInMbPerInstances;
    this.organizationId = builder.organizationId;
    this.packageState = builder.packageState;
    this.parentApplicationId = builder.parentApplicationId;
    this.parentApplicationName = builder.parentApplicationName;
    this.processType = builder.processType;
    this.spaceId = builder.spaceId;
    this.spaceName = builder.spaceName;
    this.state = builder.state;
    this.taskId = builder.taskId;
    this.taskName = builder.taskName;
  }

  /**
   * The application id
   */
  @JsonProperty("app_guid")
  @Override
  public @Nullable String getApplicationId() {
    return applicationId;
  }

  /**
   * The application name
   */
  @JsonProperty("app_name")
  @Override
  public @Nullable String getApplicationName() {
    return applicationName;
  }

  /**
   * The buildpack id
   */
  @JsonProperty("buildpack_guid")
  @Override
  public @Nullable String getBuildpackId() {
    return buildpackId;
  }

  /**
   * The buildpack name
   */
  @JsonProperty("buildpack_name")
  @Override
  public @Nullable String getBuildpackName() {
    return buildpackName;
  }

  /**
   * The instance count
   */
  @JsonProperty("instance_count")
  @Override
  public @Nullable Integer getInstanceCount() {
    return instanceCount;
  }

  /**
   * The memory in mb by instances
   */
  @JsonProperty("memory_in_mb_per_instance")
  @Override
  public @Nullable Integer getMemoryInMbPerInstances() {
    return memoryInMbPerInstances;
  }

  /**
   * The organization id
   */
  @JsonProperty("org_guid")
  @Override
  public @Nullable String getOrganizationId() {
    return organizationId;
  }

  /**
   * The state of the package
   */
  @JsonProperty("package_state")
  @Override
  public @Nullable String getPackageState() {
    return packageState;
  }

  /**
   * The parent application id if one exists (experimental)
   */
  @JsonProperty("parent_app_guid")
  @Override
  public @Nullable String getParentApplicationId() {
    return parentApplicationId;
  }

  /**
   * The parent application name if one exists (experimental)
   */
  @JsonProperty("parent_app_name")
  @Override
  public @Nullable String getParentApplicationName() {
    return parentApplicationName;
  }

  /**
   * The process type (experimental)
   */
  @JsonProperty("process_type")
  @Override
  public @Nullable String getProcessType() {
    return processType;
  }

  /**
   * The space id
   */
  @JsonProperty("space_guid")
  @Override
  public @Nullable String getSpaceId() {
    return spaceId;
  }

  /**
   * The space name
   */
  @JsonProperty("space_name")
  @Override
  public @Nullable String getSpaceName() {
    return spaceName;
  }

  /**
   * The desired state of the application
   */
  @JsonProperty("state")
  @Override
  public @Nullable String getState() {
    return state;
  }

  /**
   * The task id if one exists (experimental)
   */
  @JsonProperty("task_guid")
  @Override
  public @Nullable String getTaskId() {
    return taskId;
  }

  /**
   * The task name if one exists (experimental)
   */
  @JsonProperty("task_name")
  @Override
  public @Nullable String getTaskName() {
    return taskName;
  }

  /**
   * This instance is equal to all instances of {@code ApplicationUsageEventEntity} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ApplicationUsageEventEntity
        && equalTo((ApplicationUsageEventEntity) another);
  }

  private boolean equalTo(ApplicationUsageEventEntity another) {
    return Objects.equals(applicationId, another.applicationId)
        && Objects.equals(applicationName, another.applicationName)
        && Objects.equals(buildpackId, another.buildpackId)
        && Objects.equals(buildpackName, another.buildpackName)
        && Objects.equals(instanceCount, another.instanceCount)
        && Objects.equals(memoryInMbPerInstances, another.memoryInMbPerInstances)
        && Objects.equals(organizationId, another.organizationId)
        && Objects.equals(packageState, another.packageState)
        && Objects.equals(parentApplicationId, another.parentApplicationId)
        && Objects.equals(parentApplicationName, another.parentApplicationName)
        && Objects.equals(processType, another.processType)
        && Objects.equals(spaceId, another.spaceId)
        && Objects.equals(spaceName, another.spaceName)
        && Objects.equals(state, another.state)
        && Objects.equals(taskId, another.taskId)
        && Objects.equals(taskName, another.taskName);
  }

  /**
   * Computes a hash code from attributes: {@code applicationId}, {@code applicationName}, {@code buildpackId}, {@code buildpackName}, {@code instanceCount}, {@code memoryInMbPerInstances}, {@code organizationId}, {@code packageState}, {@code parentApplicationId}, {@code parentApplicationName}, {@code processType}, {@code spaceId}, {@code spaceName}, {@code state}, {@code taskId}, {@code taskName}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + Objects.hashCode(applicationId);
    h += (h << 5) + Objects.hashCode(applicationName);
    h += (h << 5) + Objects.hashCode(buildpackId);
    h += (h << 5) + Objects.hashCode(buildpackName);
    h += (h << 5) + Objects.hashCode(instanceCount);
    h += (h << 5) + Objects.hashCode(memoryInMbPerInstances);
    h += (h << 5) + Objects.hashCode(organizationId);
    h += (h << 5) + Objects.hashCode(packageState);
    h += (h << 5) + Objects.hashCode(parentApplicationId);
    h += (h << 5) + Objects.hashCode(parentApplicationName);
    h += (h << 5) + Objects.hashCode(processType);
    h += (h << 5) + Objects.hashCode(spaceId);
    h += (h << 5) + Objects.hashCode(spaceName);
    h += (h << 5) + Objects.hashCode(state);
    h += (h << 5) + Objects.hashCode(taskId);
    h += (h << 5) + Objects.hashCode(taskName);
    return h;
  }

  /**
   * Prints the immutable value {@code ApplicationUsageEventEntity} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "ApplicationUsageEventEntity{"
        + "applicationId=" + applicationId
        + ", applicationName=" + applicationName
        + ", buildpackId=" + buildpackId
        + ", buildpackName=" + buildpackName
        + ", instanceCount=" + instanceCount
        + ", memoryInMbPerInstances=" + memoryInMbPerInstances
        + ", organizationId=" + organizationId
        + ", packageState=" + packageState
        + ", parentApplicationId=" + parentApplicationId
        + ", parentApplicationName=" + parentApplicationName
        + ", processType=" + processType
        + ", spaceId=" + spaceId
        + ", spaceName=" + spaceName
        + ", state=" + state
        + ", taskId=" + taskId
        + ", taskName=" + taskName
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json
      extends org.cloudfoundry.client.v2.applicationusageevents._ApplicationUsageEventEntity {
    String applicationId;
    String applicationName;
    String buildpackId;
    String buildpackName;
    Integer instanceCount;
    Integer memoryInMbPerInstances;
    String organizationId;
    String packageState;
    String parentApplicationId;
    String parentApplicationName;
    String processType;
    String spaceId;
    String spaceName;
    String state;
    String taskId;
    String taskName;
    @JsonProperty("app_guid")
    public void setApplicationId(@Nullable String applicationId) {
      this.applicationId = applicationId;
    }
    @JsonProperty("app_name")
    public void setApplicationName(@Nullable String applicationName) {
      this.applicationName = applicationName;
    }
    @JsonProperty("buildpack_guid")
    public void setBuildpackId(@Nullable String buildpackId) {
      this.buildpackId = buildpackId;
    }
    @JsonProperty("buildpack_name")
    public void setBuildpackName(@Nullable String buildpackName) {
      this.buildpackName = buildpackName;
    }
    @JsonProperty("instance_count")
    public void setInstanceCount(@Nullable Integer instanceCount) {
      this.instanceCount = instanceCount;
    }
    @JsonProperty("memory_in_mb_per_instance")
    public void setMemoryInMbPerInstances(@Nullable Integer memoryInMbPerInstances) {
      this.memoryInMbPerInstances = memoryInMbPerInstances;
    }
    @JsonProperty("org_guid")
    public void setOrganizationId(@Nullable String organizationId) {
      this.organizationId = organizationId;
    }
    @JsonProperty("package_state")
    public void setPackageState(@Nullable String packageState) {
      this.packageState = packageState;
    }
    @JsonProperty("parent_app_guid")
    public void setParentApplicationId(@Nullable String parentApplicationId) {
      this.parentApplicationId = parentApplicationId;
    }
    @JsonProperty("parent_app_name")
    public void setParentApplicationName(@Nullable String parentApplicationName) {
      this.parentApplicationName = parentApplicationName;
    }
    @JsonProperty("process_type")
    public void setProcessType(@Nullable String processType) {
      this.processType = processType;
    }
    @JsonProperty("space_guid")
    public void setSpaceId(@Nullable String spaceId) {
      this.spaceId = spaceId;
    }
    @JsonProperty("space_name")
    public void setSpaceName(@Nullable String spaceName) {
      this.spaceName = spaceName;
    }
    @JsonProperty("state")
    public void setState(@Nullable String state) {
      this.state = state;
    }
    @JsonProperty("task_guid")
    public void setTaskId(@Nullable String taskId) {
      this.taskId = taskId;
    }
    @JsonProperty("task_name")
    public void setTaskName(@Nullable String taskName) {
      this.taskName = taskName;
    }
    @Override
    public String getApplicationId() { throw new UnsupportedOperationException(); }
    @Override
    public String getApplicationName() { throw new UnsupportedOperationException(); }
    @Override
    public String getBuildpackId() { throw new UnsupportedOperationException(); }
    @Override
    public String getBuildpackName() { throw new UnsupportedOperationException(); }
    @Override
    public Integer getInstanceCount() { throw new UnsupportedOperationException(); }
    @Override
    public Integer getMemoryInMbPerInstances() { throw new UnsupportedOperationException(); }
    @Override
    public String getOrganizationId() { throw new UnsupportedOperationException(); }
    @Override
    public String getPackageState() { throw new UnsupportedOperationException(); }
    @Override
    public String getParentApplicationId() { throw new UnsupportedOperationException(); }
    @Override
    public String getParentApplicationName() { throw new UnsupportedOperationException(); }
    @Override
    public String getProcessType() { throw new UnsupportedOperationException(); }
    @Override
    public String getSpaceId() { throw new UnsupportedOperationException(); }
    @Override
    public String getSpaceName() { throw new UnsupportedOperationException(); }
    @Override
    public String getState() { throw new UnsupportedOperationException(); }
    @Override
    public String getTaskId() { throw new UnsupportedOperationException(); }
    @Override
    public String getTaskName() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ApplicationUsageEventEntity fromJson(Json json) {
    ApplicationUsageEventEntity.Builder builder = ApplicationUsageEventEntity.builder();
    if (json.applicationId != null) {
      builder.applicationId(json.applicationId);
    }
    if (json.applicationName != null) {
      builder.applicationName(json.applicationName);
    }
    if (json.buildpackId != null) {
      builder.buildpackId(json.buildpackId);
    }
    if (json.buildpackName != null) {
      builder.buildpackName(json.buildpackName);
    }
    if (json.instanceCount != null) {
      builder.instanceCount(json.instanceCount);
    }
    if (json.memoryInMbPerInstances != null) {
      builder.memoryInMbPerInstances(json.memoryInMbPerInstances);
    }
    if (json.organizationId != null) {
      builder.organizationId(json.organizationId);
    }
    if (json.packageState != null) {
      builder.packageState(json.packageState);
    }
    if (json.parentApplicationId != null) {
      builder.parentApplicationId(json.parentApplicationId);
    }
    if (json.parentApplicationName != null) {
      builder.parentApplicationName(json.parentApplicationName);
    }
    if (json.processType != null) {
      builder.processType(json.processType);
    }
    if (json.spaceId != null) {
      builder.spaceId(json.spaceId);
    }
    if (json.spaceName != null) {
      builder.spaceName(json.spaceName);
    }
    if (json.state != null) {
      builder.state(json.state);
    }
    if (json.taskId != null) {
      builder.taskId(json.taskId);
    }
    if (json.taskName != null) {
      builder.taskName(json.taskName);
    }
    return builder.build();
  }

  /**
   * Creates a builder for {@link ApplicationUsageEventEntity ApplicationUsageEventEntity}.
   * @return A new ApplicationUsageEventEntity builder
   */
  public static ApplicationUsageEventEntity.Builder builder() {
    return new ApplicationUsageEventEntity.Builder();
  }

  /**
   * Builds instances of type {@link ApplicationUsageEventEntity ApplicationUsageEventEntity}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  public static final class Builder {
    private String applicationId;
    private String applicationName;
    private String buildpackId;
    private String buildpackName;
    private Integer instanceCount;
    private Integer memoryInMbPerInstances;
    private String organizationId;
    private String packageState;
    private String parentApplicationId;
    private String parentApplicationName;
    private String processType;
    private String spaceId;
    private String spaceName;
    private String state;
    private String taskId;
    private String taskName;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code ApplicationUsageEventEntity} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(ApplicationUsageEventEntity instance) {
      return from((_ApplicationUsageEventEntity) instance);
    }

    /**
     * Copy abstract value type {@code _ApplicationUsageEventEntity} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_ApplicationUsageEventEntity instance) {
      Objects.requireNonNull(instance, "instance");
      String applicationIdValue = instance.getApplicationId();
      if (applicationIdValue != null) {
        applicationId(applicationIdValue);
      }
      String applicationNameValue = instance.getApplicationName();
      if (applicationNameValue != null) {
        applicationName(applicationNameValue);
      }
      String buildpackIdValue = instance.getBuildpackId();
      if (buildpackIdValue != null) {
        buildpackId(buildpackIdValue);
      }
      String buildpackNameValue = instance.getBuildpackName();
      if (buildpackNameValue != null) {
        buildpackName(buildpackNameValue);
      }
      Integer instanceCountValue = instance.getInstanceCount();
      if (instanceCountValue != null) {
        instanceCount(instanceCountValue);
      }
      Integer memoryInMbPerInstancesValue = instance.getMemoryInMbPerInstances();
      if (memoryInMbPerInstancesValue != null) {
        memoryInMbPerInstances(memoryInMbPerInstancesValue);
      }
      String organizationIdValue = instance.getOrganizationId();
      if (organizationIdValue != null) {
        organizationId(organizationIdValue);
      }
      String packageStateValue = instance.getPackageState();
      if (packageStateValue != null) {
        packageState(packageStateValue);
      }
      String parentApplicationIdValue = instance.getParentApplicationId();
      if (parentApplicationIdValue != null) {
        parentApplicationId(parentApplicationIdValue);
      }
      String parentApplicationNameValue = instance.getParentApplicationName();
      if (parentApplicationNameValue != null) {
        parentApplicationName(parentApplicationNameValue);
      }
      String processTypeValue = instance.getProcessType();
      if (processTypeValue != null) {
        processType(processTypeValue);
      }
      String spaceIdValue = instance.getSpaceId();
      if (spaceIdValue != null) {
        spaceId(spaceIdValue);
      }
      String spaceNameValue = instance.getSpaceName();
      if (spaceNameValue != null) {
        spaceName(spaceNameValue);
      }
      String stateValue = instance.getState();
      if (stateValue != null) {
        state(stateValue);
      }
      String taskIdValue = instance.getTaskId();
      if (taskIdValue != null) {
        taskId(taskIdValue);
      }
      String taskNameValue = instance.getTaskName();
      if (taskNameValue != null) {
        taskName(taskNameValue);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link _ApplicationUsageEventEntity#getApplicationId() applicationId} attribute.
     * @param applicationId The value for applicationId (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("app_guid")
    public final Builder applicationId(@Nullable String applicationId) {
      this.applicationId = applicationId;
      return this;
    }

    /**
     * Initializes the value for the {@link _ApplicationUsageEventEntity#getApplicationName() applicationName} attribute.
     * @param applicationName The value for applicationName (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("app_name")
    public final Builder applicationName(@Nullable String applicationName) {
      this.applicationName = applicationName;
      return this;
    }

    /**
     * Initializes the value for the {@link _ApplicationUsageEventEntity#getBuildpackId() buildpackId} attribute.
     * @param buildpackId The value for buildpackId (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("buildpack_guid")
    public final Builder buildpackId(@Nullable String buildpackId) {
      this.buildpackId = buildpackId;
      return this;
    }

    /**
     * Initializes the value for the {@link _ApplicationUsageEventEntity#getBuildpackName() buildpackName} attribute.
     * @param buildpackName The value for buildpackName (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("buildpack_name")
    public final Builder buildpackName(@Nullable String buildpackName) {
      this.buildpackName = buildpackName;
      return this;
    }

    /**
     * Initializes the value for the {@link _ApplicationUsageEventEntity#getInstanceCount() instanceCount} attribute.
     * @param instanceCount The value for instanceCount (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("instance_count")
    public final Builder instanceCount(@Nullable Integer instanceCount) {
      this.instanceCount = instanceCount;
      return this;
    }

    /**
     * Initializes the value for the {@link _ApplicationUsageEventEntity#getMemoryInMbPerInstances() memoryInMbPerInstances} attribute.
     * @param memoryInMbPerInstances The value for memoryInMbPerInstances (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("memory_in_mb_per_instance")
    public final Builder memoryInMbPerInstances(@Nullable Integer memoryInMbPerInstances) {
      this.memoryInMbPerInstances = memoryInMbPerInstances;
      return this;
    }

    /**
     * Initializes the value for the {@link _ApplicationUsageEventEntity#getOrganizationId() organizationId} attribute.
     * @param organizationId The value for organizationId (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("org_guid")
    public final Builder organizationId(@Nullable String organizationId) {
      this.organizationId = organizationId;
      return this;
    }

    /**
     * Initializes the value for the {@link _ApplicationUsageEventEntity#getPackageState() packageState} attribute.
     * @param packageState The value for packageState (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("package_state")
    public final Builder packageState(@Nullable String packageState) {
      this.packageState = packageState;
      return this;
    }

    /**
     * Initializes the value for the {@link _ApplicationUsageEventEntity#getParentApplicationId() parentApplicationId} attribute.
     * @param parentApplicationId The value for parentApplicationId (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("parent_app_guid")
    public final Builder parentApplicationId(@Nullable String parentApplicationId) {
      this.parentApplicationId = parentApplicationId;
      return this;
    }

    /**
     * Initializes the value for the {@link _ApplicationUsageEventEntity#getParentApplicationName() parentApplicationName} attribute.
     * @param parentApplicationName The value for parentApplicationName (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("parent_app_name")
    public final Builder parentApplicationName(@Nullable String parentApplicationName) {
      this.parentApplicationName = parentApplicationName;
      return this;
    }

    /**
     * Initializes the value for the {@link _ApplicationUsageEventEntity#getProcessType() processType} attribute.
     * @param processType The value for processType (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("process_type")
    public final Builder processType(@Nullable String processType) {
      this.processType = processType;
      return this;
    }

    /**
     * Initializes the value for the {@link _ApplicationUsageEventEntity#getSpaceId() spaceId} attribute.
     * @param spaceId The value for spaceId (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("space_guid")
    public final Builder spaceId(@Nullable String spaceId) {
      this.spaceId = spaceId;
      return this;
    }

    /**
     * Initializes the value for the {@link _ApplicationUsageEventEntity#getSpaceName() spaceName} attribute.
     * @param spaceName The value for spaceName (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("space_name")
    public final Builder spaceName(@Nullable String spaceName) {
      this.spaceName = spaceName;
      return this;
    }

    /**
     * Initializes the value for the {@link _ApplicationUsageEventEntity#getState() state} attribute.
     * @param state The value for state (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("state")
    public final Builder state(@Nullable String state) {
      this.state = state;
      return this;
    }

    /**
     * Initializes the value for the {@link _ApplicationUsageEventEntity#getTaskId() taskId} attribute.
     * @param taskId The value for taskId (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("task_guid")
    public final Builder taskId(@Nullable String taskId) {
      this.taskId = taskId;
      return this;
    }

    /**
     * Initializes the value for the {@link _ApplicationUsageEventEntity#getTaskName() taskName} attribute.
     * @param taskName The value for taskName (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("task_name")
    public final Builder taskName(@Nullable String taskName) {
      this.taskName = taskName;
      return this;
    }

    /**
     * Builds a new {@link ApplicationUsageEventEntity ApplicationUsageEventEntity}.
     * @return An immutable instance of ApplicationUsageEventEntity
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ApplicationUsageEventEntity build() {
      return new ApplicationUsageEventEntity(this);
    }
  }
}
