package org.cloudfoundry.client.v2.featureflags;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.Generated;

/**
 * The response payload for the List Feature Flags operation
 */
@SuppressWarnings({"all"})
@Generated({"Immutables.generator", "_ListFeatureFlagsResponse"})
public final class ListFeatureFlagsResponse
    extends org.cloudfoundry.client.v2.featureflags._ListFeatureFlagsResponse {
  private final List<FeatureFlagEntity> featureFlags;

  private ListFeatureFlagsResponse(ListFeatureFlagsResponse.Builder builder) {
    this.featureFlags = createUnmodifiableList(true, builder.featureFlags);
  }

  /**
   * The feature flags
   */
  @JsonProperty("featureFlags")
  @Override
  public List<FeatureFlagEntity> getFeatureFlags() {
    return featureFlags;
  }

  /**
   * This instance is equal to all instances of {@code ListFeatureFlagsResponse} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ListFeatureFlagsResponse
        && equalTo((ListFeatureFlagsResponse) another);
  }

  private boolean equalTo(ListFeatureFlagsResponse another) {
    return featureFlags.equals(another.featureFlags);
  }

  /**
   * Computes a hash code from attributes: {@code featureFlags}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + featureFlags.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code ListFeatureFlagsResponse} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "ListFeatureFlagsResponse{"
        + "featureFlags=" + featureFlags
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json extends org.cloudfoundry.client.v2.featureflags._ListFeatureFlagsResponse {
    List<FeatureFlagEntity> featureFlags = Collections.emptyList();
    @JsonProperty("featureFlags")
    public void setFeatureFlags(List<FeatureFlagEntity> featureFlags) {
      this.featureFlags = featureFlags;
    }
    @Override
    public List<FeatureFlagEntity> getFeatureFlags() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ListFeatureFlagsResponse fromJson(Json json) {
    ListFeatureFlagsResponse.Builder builder = ListFeatureFlagsResponse.builder();
    if (json.featureFlags != null) {
      builder.addAllFeatureFlags(json.featureFlags);
    }
    return builder.build();
  }

  /**
   * Creates a builder for {@link ListFeatureFlagsResponse ListFeatureFlagsResponse}.
   * @return A new ListFeatureFlagsResponse builder
   */
  public static ListFeatureFlagsResponse.Builder builder() {
    return new ListFeatureFlagsResponse.Builder();
  }

  /**
   * Builds instances of type {@link ListFeatureFlagsResponse ListFeatureFlagsResponse}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  public static final class Builder {
    private List<FeatureFlagEntity> featureFlags = new ArrayList<FeatureFlagEntity>();

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code ListFeatureFlagsResponse} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(ListFeatureFlagsResponse instance) {
      return from((_ListFeatureFlagsResponse) instance);
    }

    /**
     * Copy abstract value type {@code _ListFeatureFlagsResponse} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_ListFeatureFlagsResponse instance) {
      Objects.requireNonNull(instance, "instance");
      addAllFeatureFlags(instance.getFeatureFlags());
      return this;
    }

    /**
     * Adds one element to {@link _ListFeatureFlagsResponse#getFeatureFlags() featureFlags} list.
     * @param element A featureFlags element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder featureFlag(FeatureFlagEntity element) {
      this.featureFlags.add(Objects.requireNonNull(element, "featureFlags element"));
      return this;
    }

    /**
     * Adds elements to {@link _ListFeatureFlagsResponse#getFeatureFlags() featureFlags} list.
     * @param elements An array of featureFlags elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder featureFlag(FeatureFlagEntity... elements) {
      for (FeatureFlagEntity element : elements) {
        this.featureFlags.add(Objects.requireNonNull(element, "featureFlags element"));
      }
      return this;
    }

    /**
     * Sets or replaces all elements for {@link _ListFeatureFlagsResponse#getFeatureFlags() featureFlags} list.
     * @param elements An iterable of featureFlags elements
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("featureFlags")
    public final Builder featureFlags(Iterable<? extends FeatureFlagEntity> elements) {
      this.featureFlags.clear();
      return addAllFeatureFlags(elements);
    }

    /**
     * Adds elements to {@link _ListFeatureFlagsResponse#getFeatureFlags() featureFlags} list.
     * @param elements An iterable of featureFlags elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllFeatureFlags(Iterable<? extends FeatureFlagEntity> elements) {
      for (FeatureFlagEntity element : elements) {
        this.featureFlags.add(Objects.requireNonNull(element, "featureFlags element"));
      }
      return this;
    }

    /**
     * Builds a new {@link ListFeatureFlagsResponse ListFeatureFlagsResponse}.
     * @return An immutable instance of ListFeatureFlagsResponse
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ListFeatureFlagsResponse build() {
      return new ListFeatureFlagsResponse(this);
    }
  }

  private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
    ArrayList<T> list;
    if (iterable instanceof Collection<?>) {
      int size = ((Collection<?>) iterable).size();
      if (size == 0) return Collections.emptyList();
      list = new ArrayList<T>();
    } else {
      list = new ArrayList<T>();
    }
    for (T element : iterable) {
      if (skipNulls && element == null) continue;
      if (checkNulls) Objects.requireNonNull(element, "element");
      list.add(element);
    }
    return list;
  }

  private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
    switch(list.size()) {
    case 0: return Collections.emptyList();
    case 1: return Collections.singletonList(list.get(0));
    default:
      if (clone) {
        return Collections.unmodifiableList(new ArrayList<T>(list));
      } else {
        if (list instanceof ArrayList<?>) {
          ((ArrayList<?>) list).trimToSize();
        }
        return Collections.unmodifiableList(list);
      }
    }
  }
}
