package org.cloudfoundry.client.v2.organizations;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.Objects;
import javax.annotation.Generated;
import org.cloudfoundry.Nullable;

/**
 * The Space part of an Organization summary
 */
@SuppressWarnings({"all"})
@Generated({"Immutables.generator", "_OrganizationSpaceSummary"})
public final class OrganizationSpaceSummary
    extends org.cloudfoundry.client.v2.organizations._OrganizationSpaceSummary {
  private final @Nullable Integer applicationCount;
  private final @Nullable String id;
  private final @Nullable Integer memoryDevelopmentTotal;
  private final @Nullable Integer memoryProductionTotal;
  private final @Nullable String name;
  private final @Nullable Integer serviceCount;

  private OrganizationSpaceSummary(OrganizationSpaceSummary.Builder builder) {
    this.applicationCount = builder.applicationCount;
    this.id = builder.id;
    this.memoryDevelopmentTotal = builder.memoryDevelopmentTotal;
    this.memoryProductionTotal = builder.memoryProductionTotal;
    this.name = builder.name;
    this.serviceCount = builder.serviceCount;
  }

  /**
   * The application count
   */
  @JsonProperty("app_count")
  @Override
  public @Nullable Integer getApplicationCount() {
    return applicationCount;
  }

  /**
   * The space id
   */
  @JsonProperty("guid")
  @Override
  public @Nullable String getId() {
    return id;
  }

  /**
   * The mem_dev_total
   */
  @JsonProperty("mem_dev_total")
  @Override
  public @Nullable Integer getMemoryDevelopmentTotal() {
    return memoryDevelopmentTotal;
  }

  /**
   * The mem_prod_total
   */
  @JsonProperty("mem_prod_total")
  @Override
  public @Nullable Integer getMemoryProductionTotal() {
    return memoryProductionTotal;
  }

  /**
   * The space name
   */
  @JsonProperty("name")
  @Override
  public @Nullable String getName() {
    return name;
  }

  /**
   * The service count
   */
  @JsonProperty("service_count")
  @Override
  public @Nullable Integer getServiceCount() {
    return serviceCount;
  }

  /**
   * This instance is equal to all instances of {@code OrganizationSpaceSummary} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof OrganizationSpaceSummary
        && equalTo((OrganizationSpaceSummary) another);
  }

  private boolean equalTo(OrganizationSpaceSummary another) {
    return Objects.equals(applicationCount, another.applicationCount)
        && Objects.equals(id, another.id)
        && Objects.equals(memoryDevelopmentTotal, another.memoryDevelopmentTotal)
        && Objects.equals(memoryProductionTotal, another.memoryProductionTotal)
        && Objects.equals(name, another.name)
        && Objects.equals(serviceCount, another.serviceCount);
  }

  /**
   * Computes a hash code from attributes: {@code applicationCount}, {@code id}, {@code memoryDevelopmentTotal}, {@code memoryProductionTotal}, {@code name}, {@code serviceCount}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + Objects.hashCode(applicationCount);
    h += (h << 5) + Objects.hashCode(id);
    h += (h << 5) + Objects.hashCode(memoryDevelopmentTotal);
    h += (h << 5) + Objects.hashCode(memoryProductionTotal);
    h += (h << 5) + Objects.hashCode(name);
    h += (h << 5) + Objects.hashCode(serviceCount);
    return h;
  }

  /**
   * Prints the immutable value {@code OrganizationSpaceSummary} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "OrganizationSpaceSummary{"
        + "applicationCount=" + applicationCount
        + ", id=" + id
        + ", memoryDevelopmentTotal=" + memoryDevelopmentTotal
        + ", memoryProductionTotal=" + memoryProductionTotal
        + ", name=" + name
        + ", serviceCount=" + serviceCount
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json extends org.cloudfoundry.client.v2.organizations._OrganizationSpaceSummary {
    Integer applicationCount;
    String id;
    Integer memoryDevelopmentTotal;
    Integer memoryProductionTotal;
    String name;
    Integer serviceCount;
    @JsonProperty("app_count")
    public void setApplicationCount(@Nullable Integer applicationCount) {
      this.applicationCount = applicationCount;
    }
    @JsonProperty("guid")
    public void setId(@Nullable String id) {
      this.id = id;
    }
    @JsonProperty("mem_dev_total")
    public void setMemoryDevelopmentTotal(@Nullable Integer memoryDevelopmentTotal) {
      this.memoryDevelopmentTotal = memoryDevelopmentTotal;
    }
    @JsonProperty("mem_prod_total")
    public void setMemoryProductionTotal(@Nullable Integer memoryProductionTotal) {
      this.memoryProductionTotal = memoryProductionTotal;
    }
    @JsonProperty("name")
    public void setName(@Nullable String name) {
      this.name = name;
    }
    @JsonProperty("service_count")
    public void setServiceCount(@Nullable Integer serviceCount) {
      this.serviceCount = serviceCount;
    }
    @Override
    public Integer getApplicationCount() { throw new UnsupportedOperationException(); }
    @Override
    public String getId() { throw new UnsupportedOperationException(); }
    @Override
    public Integer getMemoryDevelopmentTotal() { throw new UnsupportedOperationException(); }
    @Override
    public Integer getMemoryProductionTotal() { throw new UnsupportedOperationException(); }
    @Override
    public String getName() { throw new UnsupportedOperationException(); }
    @Override
    public Integer getServiceCount() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static OrganizationSpaceSummary fromJson(Json json) {
    OrganizationSpaceSummary.Builder builder = OrganizationSpaceSummary.builder();
    if (json.applicationCount != null) {
      builder.applicationCount(json.applicationCount);
    }
    if (json.id != null) {
      builder.id(json.id);
    }
    if (json.memoryDevelopmentTotal != null) {
      builder.memoryDevelopmentTotal(json.memoryDevelopmentTotal);
    }
    if (json.memoryProductionTotal != null) {
      builder.memoryProductionTotal(json.memoryProductionTotal);
    }
    if (json.name != null) {
      builder.name(json.name);
    }
    if (json.serviceCount != null) {
      builder.serviceCount(json.serviceCount);
    }
    return builder.build();
  }

  /**
   * Creates a builder for {@link OrganizationSpaceSummary OrganizationSpaceSummary}.
   * @return A new OrganizationSpaceSummary builder
   */
  public static OrganizationSpaceSummary.Builder builder() {
    return new OrganizationSpaceSummary.Builder();
  }

  /**
   * Builds instances of type {@link OrganizationSpaceSummary OrganizationSpaceSummary}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  public static final class Builder {
    private Integer applicationCount;
    private String id;
    private Integer memoryDevelopmentTotal;
    private Integer memoryProductionTotal;
    private String name;
    private Integer serviceCount;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code OrganizationSpaceSummary} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(OrganizationSpaceSummary instance) {
      return from((_OrganizationSpaceSummary) instance);
    }

    /**
     * Copy abstract value type {@code _OrganizationSpaceSummary} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_OrganizationSpaceSummary instance) {
      Objects.requireNonNull(instance, "instance");
      Integer applicationCountValue = instance.getApplicationCount();
      if (applicationCountValue != null) {
        applicationCount(applicationCountValue);
      }
      String idValue = instance.getId();
      if (idValue != null) {
        id(idValue);
      }
      Integer memoryDevelopmentTotalValue = instance.getMemoryDevelopmentTotal();
      if (memoryDevelopmentTotalValue != null) {
        memoryDevelopmentTotal(memoryDevelopmentTotalValue);
      }
      Integer memoryProductionTotalValue = instance.getMemoryProductionTotal();
      if (memoryProductionTotalValue != null) {
        memoryProductionTotal(memoryProductionTotalValue);
      }
      String nameValue = instance.getName();
      if (nameValue != null) {
        name(nameValue);
      }
      Integer serviceCountValue = instance.getServiceCount();
      if (serviceCountValue != null) {
        serviceCount(serviceCountValue);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link _OrganizationSpaceSummary#getApplicationCount() applicationCount} attribute.
     * @param applicationCount The value for applicationCount (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("app_count")
    public final Builder applicationCount(@Nullable Integer applicationCount) {
      this.applicationCount = applicationCount;
      return this;
    }

    /**
     * Initializes the value for the {@link _OrganizationSpaceSummary#getId() id} attribute.
     * @param id The value for id (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("guid")
    public final Builder id(@Nullable String id) {
      this.id = id;
      return this;
    }

    /**
     * Initializes the value for the {@link _OrganizationSpaceSummary#getMemoryDevelopmentTotal() memoryDevelopmentTotal} attribute.
     * @param memoryDevelopmentTotal The value for memoryDevelopmentTotal (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("mem_dev_total")
    public final Builder memoryDevelopmentTotal(@Nullable Integer memoryDevelopmentTotal) {
      this.memoryDevelopmentTotal = memoryDevelopmentTotal;
      return this;
    }

    /**
     * Initializes the value for the {@link _OrganizationSpaceSummary#getMemoryProductionTotal() memoryProductionTotal} attribute.
     * @param memoryProductionTotal The value for memoryProductionTotal (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("mem_prod_total")
    public final Builder memoryProductionTotal(@Nullable Integer memoryProductionTotal) {
      this.memoryProductionTotal = memoryProductionTotal;
      return this;
    }

    /**
     * Initializes the value for the {@link _OrganizationSpaceSummary#getName() name} attribute.
     * @param name The value for name (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("name")
    public final Builder name(@Nullable String name) {
      this.name = name;
      return this;
    }

    /**
     * Initializes the value for the {@link _OrganizationSpaceSummary#getServiceCount() serviceCount} attribute.
     * @param serviceCount The value for serviceCount (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("service_count")
    public final Builder serviceCount(@Nullable Integer serviceCount) {
      this.serviceCount = serviceCount;
      return this;
    }

    /**
     * Builds a new {@link OrganizationSpaceSummary OrganizationSpaceSummary}.
     * @return An immutable instance of OrganizationSpaceSummary
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public OrganizationSpaceSummary build() {
      return new OrganizationSpaceSummary(this);
    }
  }
}
