package org.cloudfoundry.client.v2.routemappings;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Generated;
import org.cloudfoundry.Nullable;

/**
 * The request payload object for the Delete a Route Mapping operation
 */
@SuppressWarnings({"all"})
@Generated({"Immutables.generator", "_DeleteRouteMappingRequest"})
public final class DeleteRouteMappingRequest
    extends org.cloudfoundry.client.v2.routemappings._DeleteRouteMappingRequest {
  private final @Nullable Boolean async;
  private final String routeMappingId;

  private DeleteRouteMappingRequest(DeleteRouteMappingRequest.Builder builder) {
    this.async = builder.async;
    this.routeMappingId = builder.routeMappingId;
  }

  /**
   * The async parameter
   */
  @Override
  public @Nullable Boolean getAsync() {
    return async;
  }

  /**
   * The route mapping id
   */
  @Override
  public String getRouteMappingId() {
    return routeMappingId;
  }

  /**
   * This instance is equal to all instances of {@code DeleteRouteMappingRequest} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof DeleteRouteMappingRequest
        && equalTo((DeleteRouteMappingRequest) another);
  }

  private boolean equalTo(DeleteRouteMappingRequest another) {
    return Objects.equals(async, another.async)
        && routeMappingId.equals(another.routeMappingId);
  }

  /**
   * Computes a hash code from attributes: {@code async}, {@code routeMappingId}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + Objects.hashCode(async);
    h += (h << 5) + routeMappingId.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code DeleteRouteMappingRequest} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "DeleteRouteMappingRequest{"
        + "async=" + async
        + ", routeMappingId=" + routeMappingId
        + "}";
  }

  /**
   * Creates a builder for {@link DeleteRouteMappingRequest DeleteRouteMappingRequest}.
   * @return A new DeleteRouteMappingRequest builder
   */
  public static DeleteRouteMappingRequest.Builder builder() {
    return new DeleteRouteMappingRequest.Builder();
  }

  /**
   * Builds instances of type {@link DeleteRouteMappingRequest DeleteRouteMappingRequest}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  public static final class Builder {
    private static final long INIT_BIT_ROUTE_MAPPING_ID = 0x1L;
    private long initBits = 0x1L;

    private Boolean async;
    private String routeMappingId;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code DeleteRouteMappingRequest} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(DeleteRouteMappingRequest instance) {
      return from((_DeleteRouteMappingRequest) instance);
    }

    /**
     * Copy abstract value type {@code _DeleteRouteMappingRequest} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_DeleteRouteMappingRequest instance) {
      Objects.requireNonNull(instance, "instance");
      Boolean asyncValue = instance.getAsync();
      if (asyncValue != null) {
        async(asyncValue);
      }
      routeMappingId(instance.getRouteMappingId());
      return this;
    }

    /**
     * Initializes the value for the {@link _DeleteRouteMappingRequest#getAsync() async} attribute.
     * @param async The value for async (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder async(@Nullable Boolean async) {
      this.async = async;
      return this;
    }

    /**
     * Initializes the value for the {@link _DeleteRouteMappingRequest#getRouteMappingId() routeMappingId} attribute.
     * @param routeMappingId The value for routeMappingId 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder routeMappingId(String routeMappingId) {
      this.routeMappingId = Objects.requireNonNull(routeMappingId, "routeMappingId");
      initBits &= ~INIT_BIT_ROUTE_MAPPING_ID;
      return this;
    }

    /**
     * Builds a new {@link DeleteRouteMappingRequest DeleteRouteMappingRequest}.
     * @return An immutable instance of DeleteRouteMappingRequest
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public DeleteRouteMappingRequest build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new DeleteRouteMappingRequest(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<String>();
      if ((initBits & INIT_BIT_ROUTE_MAPPING_ID) != 0) attributes.add("routeMappingId");
      return "Cannot build DeleteRouteMappingRequest, some of required attributes are not set " + attributes;
    }
  }
}
