package org.cloudfoundry.client.v2.routes;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.Objects;
import javax.annotation.Generated;
import org.cloudfoundry.Nullable;

/**
 * The entity response payload for the Route resource
 */
@SuppressWarnings({"all"})
@Generated({"Immutables.generator", "_RouteEntity"})
public final class RouteEntity extends org.cloudfoundry.client.v2.routes._RouteEntity {
  private final @Nullable String applicationsUrl;
  private final @Nullable String domainId;
  private final @Nullable String domainUrl;
  private final @Nullable String host;
  private final @Nullable String path;
  private final @Nullable Integer port;
  private final @Nullable String routeMappingsUrl;
  private final @Nullable String serviceInstanceId;
  private final @Nullable String serviceInstanceUrl;
  private final @Nullable String spaceId;
  private final @Nullable String spaceUrl;

  private RouteEntity(RouteEntity.Builder builder) {
    this.applicationsUrl = builder.applicationsUrl;
    this.domainId = builder.domainId;
    this.domainUrl = builder.domainUrl;
    this.host = builder.host;
    this.path = builder.path;
    this.port = builder.port;
    this.routeMappingsUrl = builder.routeMappingsUrl;
    this.serviceInstanceId = builder.serviceInstanceId;
    this.serviceInstanceUrl = builder.serviceInstanceUrl;
    this.spaceId = builder.spaceId;
    this.spaceUrl = builder.spaceUrl;
  }

  /**
   * The applications url
   */
  @JsonProperty("apps_url")
  @Override
  public @Nullable String getApplicationsUrl() {
    return applicationsUrl;
  }

  /**
   * The domain id
   */
  @JsonProperty("domain_guid")
  @Override
  public @Nullable String getDomainId() {
    return domainId;
  }

  /**
   * The domain url
   */
  @JsonProperty("domain_url")
  @Override
  public @Nullable String getDomainUrl() {
    return domainUrl;
  }

  /**
   * The host
   */
  @JsonProperty("host")
  @Override
  public @Nullable String getHost() {
    return host;
  }

  /**
   * The path
   */
  @JsonProperty("path")
  @Override
  public @Nullable String getPath() {
    return path;
  }

  /**
   * The port
   */
  @JsonProperty("port")
  @Override
  public @Nullable Integer getPort() {
    return port;
  }

  /**
   * The route mappings url
   */
  @JsonProperty("route_mappings_url")
  @Override
  public @Nullable String getRouteMappingsUrl() {
    return routeMappingsUrl;
  }

  /**
   * The service instance id
   */
  @JsonProperty("service_instance_guid")
  @Override
  public @Nullable String getServiceInstanceId() {
    return serviceInstanceId;
  }

  /**
   * The service instance url
   */
  @JsonProperty("service_instance_url")
  @Override
  public @Nullable String getServiceInstanceUrl() {
    return serviceInstanceUrl;
  }

  /**
   * The space id
   */
  @JsonProperty("space_guid")
  @Override
  public @Nullable String getSpaceId() {
    return spaceId;
  }

  /**
   * The space url
   */
  @JsonProperty("space_url")
  @Override
  public @Nullable String getSpaceUrl() {
    return spaceUrl;
  }

  /**
   * This instance is equal to all instances of {@code RouteEntity} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof RouteEntity
        && equalTo((RouteEntity) another);
  }

  private boolean equalTo(RouteEntity another) {
    return Objects.equals(applicationsUrl, another.applicationsUrl)
        && Objects.equals(domainId, another.domainId)
        && Objects.equals(domainUrl, another.domainUrl)
        && Objects.equals(host, another.host)
        && Objects.equals(path, another.path)
        && Objects.equals(port, another.port)
        && Objects.equals(routeMappingsUrl, another.routeMappingsUrl)
        && Objects.equals(serviceInstanceId, another.serviceInstanceId)
        && Objects.equals(serviceInstanceUrl, another.serviceInstanceUrl)
        && Objects.equals(spaceId, another.spaceId)
        && Objects.equals(spaceUrl, another.spaceUrl);
  }

  /**
   * Computes a hash code from attributes: {@code applicationsUrl}, {@code domainId}, {@code domainUrl}, {@code host}, {@code path}, {@code port}, {@code routeMappingsUrl}, {@code serviceInstanceId}, {@code serviceInstanceUrl}, {@code spaceId}, {@code spaceUrl}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + Objects.hashCode(applicationsUrl);
    h += (h << 5) + Objects.hashCode(domainId);
    h += (h << 5) + Objects.hashCode(domainUrl);
    h += (h << 5) + Objects.hashCode(host);
    h += (h << 5) + Objects.hashCode(path);
    h += (h << 5) + Objects.hashCode(port);
    h += (h << 5) + Objects.hashCode(routeMappingsUrl);
    h += (h << 5) + Objects.hashCode(serviceInstanceId);
    h += (h << 5) + Objects.hashCode(serviceInstanceUrl);
    h += (h << 5) + Objects.hashCode(spaceId);
    h += (h << 5) + Objects.hashCode(spaceUrl);
    return h;
  }

  /**
   * Prints the immutable value {@code RouteEntity} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "RouteEntity{"
        + "applicationsUrl=" + applicationsUrl
        + ", domainId=" + domainId
        + ", domainUrl=" + domainUrl
        + ", host=" + host
        + ", path=" + path
        + ", port=" + port
        + ", routeMappingsUrl=" + routeMappingsUrl
        + ", serviceInstanceId=" + serviceInstanceId
        + ", serviceInstanceUrl=" + serviceInstanceUrl
        + ", spaceId=" + spaceId
        + ", spaceUrl=" + spaceUrl
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json extends org.cloudfoundry.client.v2.routes._RouteEntity {
    String applicationsUrl;
    String domainId;
    String domainUrl;
    String host;
    String path;
    Integer port;
    String routeMappingsUrl;
    String serviceInstanceId;
    String serviceInstanceUrl;
    String spaceId;
    String spaceUrl;
    @JsonProperty("apps_url")
    public void setApplicationsUrl(@Nullable String applicationsUrl) {
      this.applicationsUrl = applicationsUrl;
    }
    @JsonProperty("domain_guid")
    public void setDomainId(@Nullable String domainId) {
      this.domainId = domainId;
    }
    @JsonProperty("domain_url")
    public void setDomainUrl(@Nullable String domainUrl) {
      this.domainUrl = domainUrl;
    }
    @JsonProperty("host")
    public void setHost(@Nullable String host) {
      this.host = host;
    }
    @JsonProperty("path")
    public void setPath(@Nullable String path) {
      this.path = path;
    }
    @JsonProperty("port")
    public void setPort(@Nullable Integer port) {
      this.port = port;
    }
    @JsonProperty("route_mappings_url")
    public void setRouteMappingsUrl(@Nullable String routeMappingsUrl) {
      this.routeMappingsUrl = routeMappingsUrl;
    }
    @JsonProperty("service_instance_guid")
    public void setServiceInstanceId(@Nullable String serviceInstanceId) {
      this.serviceInstanceId = serviceInstanceId;
    }
    @JsonProperty("service_instance_url")
    public void setServiceInstanceUrl(@Nullable String serviceInstanceUrl) {
      this.serviceInstanceUrl = serviceInstanceUrl;
    }
    @JsonProperty("space_guid")
    public void setSpaceId(@Nullable String spaceId) {
      this.spaceId = spaceId;
    }
    @JsonProperty("space_url")
    public void setSpaceUrl(@Nullable String spaceUrl) {
      this.spaceUrl = spaceUrl;
    }
    @Override
    public String getApplicationsUrl() { throw new UnsupportedOperationException(); }
    @Override
    public String getDomainId() { throw new UnsupportedOperationException(); }
    @Override
    public String getDomainUrl() { throw new UnsupportedOperationException(); }
    @Override
    public String getHost() { throw new UnsupportedOperationException(); }
    @Override
    public String getPath() { throw new UnsupportedOperationException(); }
    @Override
    public Integer getPort() { throw new UnsupportedOperationException(); }
    @Override
    public String getRouteMappingsUrl() { throw new UnsupportedOperationException(); }
    @Override
    public String getServiceInstanceId() { throw new UnsupportedOperationException(); }
    @Override
    public String getServiceInstanceUrl() { throw new UnsupportedOperationException(); }
    @Override
    public String getSpaceId() { throw new UnsupportedOperationException(); }
    @Override
    public String getSpaceUrl() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static RouteEntity fromJson(Json json) {
    RouteEntity.Builder builder = RouteEntity.builder();
    if (json.applicationsUrl != null) {
      builder.applicationsUrl(json.applicationsUrl);
    }
    if (json.domainId != null) {
      builder.domainId(json.domainId);
    }
    if (json.domainUrl != null) {
      builder.domainUrl(json.domainUrl);
    }
    if (json.host != null) {
      builder.host(json.host);
    }
    if (json.path != null) {
      builder.path(json.path);
    }
    if (json.port != null) {
      builder.port(json.port);
    }
    if (json.routeMappingsUrl != null) {
      builder.routeMappingsUrl(json.routeMappingsUrl);
    }
    if (json.serviceInstanceId != null) {
      builder.serviceInstanceId(json.serviceInstanceId);
    }
    if (json.serviceInstanceUrl != null) {
      builder.serviceInstanceUrl(json.serviceInstanceUrl);
    }
    if (json.spaceId != null) {
      builder.spaceId(json.spaceId);
    }
    if (json.spaceUrl != null) {
      builder.spaceUrl(json.spaceUrl);
    }
    return builder.build();
  }

  /**
   * Creates a builder for {@link RouteEntity RouteEntity}.
   * @return A new RouteEntity builder
   */
  public static RouteEntity.Builder builder() {
    return new RouteEntity.Builder();
  }

  /**
   * Builds instances of type {@link RouteEntity RouteEntity}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  public static final class Builder {
    private String applicationsUrl;
    private String domainId;
    private String domainUrl;
    private String host;
    private String path;
    private Integer port;
    private String routeMappingsUrl;
    private String serviceInstanceId;
    private String serviceInstanceUrl;
    private String spaceId;
    private String spaceUrl;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code RouteEntity} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(RouteEntity instance) {
      return from((_RouteEntity) instance);
    }

    /**
     * Copy abstract value type {@code _RouteEntity} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_RouteEntity instance) {
      Objects.requireNonNull(instance, "instance");
      String applicationsUrlValue = instance.getApplicationsUrl();
      if (applicationsUrlValue != null) {
        applicationsUrl(applicationsUrlValue);
      }
      String domainIdValue = instance.getDomainId();
      if (domainIdValue != null) {
        domainId(domainIdValue);
      }
      String domainUrlValue = instance.getDomainUrl();
      if (domainUrlValue != null) {
        domainUrl(domainUrlValue);
      }
      String hostValue = instance.getHost();
      if (hostValue != null) {
        host(hostValue);
      }
      String pathValue = instance.getPath();
      if (pathValue != null) {
        path(pathValue);
      }
      Integer portValue = instance.getPort();
      if (portValue != null) {
        port(portValue);
      }
      String routeMappingsUrlValue = instance.getRouteMappingsUrl();
      if (routeMappingsUrlValue != null) {
        routeMappingsUrl(routeMappingsUrlValue);
      }
      String serviceInstanceIdValue = instance.getServiceInstanceId();
      if (serviceInstanceIdValue != null) {
        serviceInstanceId(serviceInstanceIdValue);
      }
      String serviceInstanceUrlValue = instance.getServiceInstanceUrl();
      if (serviceInstanceUrlValue != null) {
        serviceInstanceUrl(serviceInstanceUrlValue);
      }
      String spaceIdValue = instance.getSpaceId();
      if (spaceIdValue != null) {
        spaceId(spaceIdValue);
      }
      String spaceUrlValue = instance.getSpaceUrl();
      if (spaceUrlValue != null) {
        spaceUrl(spaceUrlValue);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link _RouteEntity#getApplicationsUrl() applicationsUrl} attribute.
     * @param applicationsUrl The value for applicationsUrl (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("apps_url")
    public final Builder applicationsUrl(@Nullable String applicationsUrl) {
      this.applicationsUrl = applicationsUrl;
      return this;
    }

    /**
     * Initializes the value for the {@link _RouteEntity#getDomainId() domainId} attribute.
     * @param domainId The value for domainId (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("domain_guid")
    public final Builder domainId(@Nullable String domainId) {
      this.domainId = domainId;
      return this;
    }

    /**
     * Initializes the value for the {@link _RouteEntity#getDomainUrl() domainUrl} attribute.
     * @param domainUrl The value for domainUrl (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("domain_url")
    public final Builder domainUrl(@Nullable String domainUrl) {
      this.domainUrl = domainUrl;
      return this;
    }

    /**
     * Initializes the value for the {@link _RouteEntity#getHost() host} attribute.
     * @param host The value for host (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("host")
    public final Builder host(@Nullable String host) {
      this.host = host;
      return this;
    }

    /**
     * Initializes the value for the {@link _RouteEntity#getPath() path} attribute.
     * @param path The value for path (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("path")
    public final Builder path(@Nullable String path) {
      this.path = path;
      return this;
    }

    /**
     * Initializes the value for the {@link _RouteEntity#getPort() port} attribute.
     * @param port The value for port (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("port")
    public final Builder port(@Nullable Integer port) {
      this.port = port;
      return this;
    }

    /**
     * Initializes the value for the {@link _RouteEntity#getRouteMappingsUrl() routeMappingsUrl} attribute.
     * @param routeMappingsUrl The value for routeMappingsUrl (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("route_mappings_url")
    public final Builder routeMappingsUrl(@Nullable String routeMappingsUrl) {
      this.routeMappingsUrl = routeMappingsUrl;
      return this;
    }

    /**
     * Initializes the value for the {@link _RouteEntity#getServiceInstanceId() serviceInstanceId} attribute.
     * @param serviceInstanceId The value for serviceInstanceId (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("service_instance_guid")
    public final Builder serviceInstanceId(@Nullable String serviceInstanceId) {
      this.serviceInstanceId = serviceInstanceId;
      return this;
    }

    /**
     * Initializes the value for the {@link _RouteEntity#getServiceInstanceUrl() serviceInstanceUrl} attribute.
     * @param serviceInstanceUrl The value for serviceInstanceUrl (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("service_instance_url")
    public final Builder serviceInstanceUrl(@Nullable String serviceInstanceUrl) {
      this.serviceInstanceUrl = serviceInstanceUrl;
      return this;
    }

    /**
     * Initializes the value for the {@link _RouteEntity#getSpaceId() spaceId} attribute.
     * @param spaceId The value for spaceId (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("space_guid")
    public final Builder spaceId(@Nullable String spaceId) {
      this.spaceId = spaceId;
      return this;
    }

    /**
     * Initializes the value for the {@link _RouteEntity#getSpaceUrl() spaceUrl} attribute.
     * @param spaceUrl The value for spaceUrl (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("space_url")
    public final Builder spaceUrl(@Nullable String spaceUrl) {
      this.spaceUrl = spaceUrl;
      return this;
    }

    /**
     * Builds a new {@link RouteEntity RouteEntity}.
     * @return An immutable instance of RouteEntity
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public RouteEntity build() {
      return new RouteEntity(this);
    }
  }
}
