package org.cloudfoundry.client.v2.serviceinstances;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Generated;
import org.cloudfoundry.Nullable;

/**
 * The payload for Gateway Data
 */
@SuppressWarnings({"all"})
@Generated({"Immutables.generator", "_GatewayData"})
public final class GatewayData extends org.cloudfoundry.client.v2.serviceinstances._GatewayData {
  private final String name;
  private final @Nullable Map<String, String> options;
  private final String plan;

  private GatewayData(GatewayData.Builder builder) {
    this.name = builder.name;
    this.options = builder.options == null ? null : createUnmodifiableMap(false, false, builder.options);
    this.plan = builder.plan;
  }

  /**
   * The name
   */
  @JsonProperty("name")
  @Override
  public String getName() {
    return name;
  }

  /**
   * The options
   */
  @JsonProperty("options")
  @Override
  public @Nullable Map<String, String> getOptions() {
    return options;
  }

  /**
   * The plan
   */
  @JsonProperty("plan")
  @Override
  public String getPlan() {
    return plan;
  }

  /**
   * This instance is equal to all instances of {@code GatewayData} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof GatewayData
        && equalTo((GatewayData) another);
  }

  private boolean equalTo(GatewayData another) {
    return name.equals(another.name)
        && Objects.equals(options, another.options)
        && plan.equals(another.plan);
  }

  /**
   * Computes a hash code from attributes: {@code name}, {@code options}, {@code plan}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + name.hashCode();
    h += (h << 5) + Objects.hashCode(options);
    h += (h << 5) + plan.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code GatewayData} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "GatewayData{"
        + "name=" + name
        + ", options=" + options
        + ", plan=" + plan
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json extends org.cloudfoundry.client.v2.serviceinstances._GatewayData {
    String name;
    Map<String, String> options;
    String plan;
    @JsonProperty("name")
    public void setName(String name) {
      this.name = name;
    }
    @JsonProperty("options")
    public void setOptions(@Nullable Map<String, String> options) {
      this.options = options;
    }
    @JsonProperty("plan")
    public void setPlan(String plan) {
      this.plan = plan;
    }
    @Override
    public String getName() { throw new UnsupportedOperationException(); }
    @Override
    public Map<String, String> getOptions() { throw new UnsupportedOperationException(); }
    @Override
    public String getPlan() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static GatewayData fromJson(Json json) {
    GatewayData.Builder builder = GatewayData.builder();
    if (json.name != null) {
      builder.name(json.name);
    }
    if (json.options != null) {
      builder.putAllOptions(json.options);
    }
    if (json.plan != null) {
      builder.plan(json.plan);
    }
    return builder.build();
  }

  /**
   * Creates a builder for {@link GatewayData GatewayData}.
   * @return A new GatewayData builder
   */
  public static GatewayData.Builder builder() {
    return new GatewayData.Builder();
  }

  /**
   * Builds instances of type {@link GatewayData GatewayData}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  public static final class Builder {
    private static final long INIT_BIT_NAME = 0x1L;
    private static final long INIT_BIT_PLAN = 0x2L;
    private long initBits = 0x3L;

    private String name;
    private Map<String, String> options = null;
    private String plan;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code GatewayData} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(GatewayData instance) {
      return from((_GatewayData) instance);
    }

    /**
     * Copy abstract value type {@code _GatewayData} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_GatewayData instance) {
      Objects.requireNonNull(instance, "instance");
      name(instance.getName());
      Map<String, String> optionsValue = instance.getOptions();
      if (optionsValue != null) {
        putAllOptions(optionsValue);
      }
      plan(instance.getPlan());
      return this;
    }

    /**
     * Initializes the value for the {@link _GatewayData#getName() name} attribute.
     * @param name The value for name 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("name")
    public final Builder name(String name) {
      this.name = Objects.requireNonNull(name, "name");
      initBits &= ~INIT_BIT_NAME;
      return this;
    }

    /**
     * Put one entry to the {@link _GatewayData#getOptions() options} map.
     * @param key The key in the options map
     * @param value The associated value in the options map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder option(String key, String value) {
      if (this.options == null) {
        this.options = new LinkedHashMap<String, String>();
      }
      this.options.put(key, value);
      return this;
    }

    /**
     * Put one entry to the {@link _GatewayData#getOptions() options} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder option(Map.Entry<String, ? extends String> entry) {
      if (this.options == null) {
        this.options = new LinkedHashMap<String, String>();
      }
      String k = entry.getKey();
      String v = entry.getValue();
      this.options.put(k, v);
      return this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link _GatewayData#getOptions() options} map. Nulls are not permitted as keys or values, but parameter itself can be null
     * @param options The entries that will be added to the options map
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("options")
    public final Builder options(@Nullable Map<String, ? extends String> options) {
      if (options == null) {
        this.options = null;
        return this;
      }
      this.options = new LinkedHashMap<String, String>();
      return putAllOptions(options);
    }

    /**
     * Put all mappings from the specified map as entries to {@link _GatewayData#getOptions() options} map. Nulls are not permitted
     * @param options The entries that will be added to the options map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder putAllOptions(Map<String, ? extends String> options) {
      if (this.options == null) {
        this.options = new LinkedHashMap<String, String>();
      }
      for (Map.Entry<String, ? extends String> entry : options.entrySet()) {
        String k = entry.getKey();
        String v = entry.getValue();
        this.options.put(k, v);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link _GatewayData#getPlan() plan} attribute.
     * @param plan The value for plan 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("plan")
    public final Builder plan(String plan) {
      this.plan = Objects.requireNonNull(plan, "plan");
      initBits &= ~INIT_BIT_PLAN;
      return this;
    }

    /**
     * Builds a new {@link GatewayData GatewayData}.
     * @return An immutable instance of GatewayData
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public GatewayData build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new GatewayData(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<String>();
      if ((initBits & INIT_BIT_NAME) != 0) attributes.add("name");
      if ((initBits & INIT_BIT_PLAN) != 0) attributes.add("plan");
      return "Cannot build GatewayData, some of required attributes are not set " + attributes;
    }
  }

  private static <K, V> Map<K, V> createUnmodifiableMap(boolean checkNulls, boolean skipNulls, Map<? extends K, ? extends V> map) {
    switch (map.size()) {
    case 0: return Collections.emptyMap();
    case 1: {
      Map.Entry<? extends K, ? extends V> e = map.entrySet().iterator().next();
      K k = e.getKey();
      V v = e.getValue();
      if (checkNulls) {
        Objects.requireNonNull(k, "key");
        Objects.requireNonNull(v, "value");
      }
      if (skipNulls && (k == null || v == null)) {
        return Collections.emptyMap();
      }
      return Collections.singletonMap(k, v);
    }
    default: {
      Map<K, V> linkedMap = new LinkedHashMap<K, V>(map.size());
      if (skipNulls || checkNulls) {
        for (Map.Entry<? extends K, ? extends V> e : map.entrySet()) {
          K k = e.getKey();
          V v = e.getValue();
          if (skipNulls) {
            if (k == null || v == null) continue;
          } else if (checkNulls) {
            Objects.requireNonNull(k, "key");
            Objects.requireNonNull(v, "value");
          }
          linkedMap.put(k, v);
        }
      } else {
        linkedMap.putAll(map);
      }
      return Collections.unmodifiableMap(linkedMap);
    }
    }
  }
}
