package org.cloudfoundry.client.v2.serviceinstances;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.Generated;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.client.v2.OrderDirection;
import org.cloudfoundry.client.v2.PaginatedRequest;

/**
 * The request payload for the List Service Instances operation
 */
@SuppressWarnings({"all"})
@Generated({"Immutables.generator", "_ListServiceInstancesRequest"})
public final class ListServiceInstancesRequest
    extends org.cloudfoundry.client.v2.serviceinstances._ListServiceInstancesRequest {
  private final @Nullable List<String> gatewayNames;
  private final @Nullable List<String> names;
  private final @Nullable List<String> organizationIds;
  private final @Nullable List<String> serviceBindingIds;
  private final @Nullable List<String> serviceKeyIds;
  private final @Nullable List<String> servicePlanIds;
  private final @Nullable List<String> spaceIds;
  private final @Nullable OrderDirection orderDirection;
  private final @Nullable Integer page;
  private final @Nullable Integer resultsPerPage;

  private ListServiceInstancesRequest(ListServiceInstancesRequest.Builder builder) {
    this.gatewayNames = builder.gatewayNames == null ? null : createUnmodifiableList(true, builder.gatewayNames);
    this.names = builder.names == null ? null : createUnmodifiableList(true, builder.names);
    this.organizationIds = builder.organizationIds == null ? null : createUnmodifiableList(true, builder.organizationIds);
    this.serviceBindingIds = builder.serviceBindingIds == null ? null : createUnmodifiableList(true, builder.serviceBindingIds);
    this.serviceKeyIds = builder.serviceKeyIds == null ? null : createUnmodifiableList(true, builder.serviceKeyIds);
    this.servicePlanIds = builder.servicePlanIds == null ? null : createUnmodifiableList(true, builder.servicePlanIds);
    this.spaceIds = builder.spaceIds == null ? null : createUnmodifiableList(true, builder.spaceIds);
    this.orderDirection = builder.orderDirection;
    this.page = builder.page;
    this.resultsPerPage = builder.resultsPerPage;
  }

  /**
   * The gateway names
   */
  @Override
  public @Nullable List<String> getGatewayNames() {
    return gatewayNames;
  }

  /**
   * The names
   */
  @Override
  public @Nullable List<String> getNames() {
    return names;
  }

  /**
   * The organization ids
   */
  @Override
  public @Nullable List<String> getOrganizationIds() {
    return organizationIds;
  }

  /**
   * The service binding ids
   */
  @Override
  public @Nullable List<String> getServiceBindingIds() {
    return serviceBindingIds;
  }

  /**
   * The service key ids
   */
  @Override
  public @Nullable List<String> getServiceKeyIds() {
    return serviceKeyIds;
  }

  /**
   * The service plan ids
   */
  @Override
  public @Nullable List<String> getServicePlanIds() {
    return servicePlanIds;
  }

  /**
   * The space ids
   */
  @Override
  public @Nullable List<String> getSpaceIds() {
    return spaceIds;
  }

  /**
   * The order direction
   */
  @Override
  public @Nullable OrderDirection getOrderDirection() {
    return orderDirection;
  }

  /**
   * The page
   */
  @Override
  public @Nullable Integer getPage() {
    return page;
  }

  /**
   * The results per page
   */
  @Override
  public @Nullable Integer getResultsPerPage() {
    return resultsPerPage;
  }

  /**
   * This instance is equal to all instances of {@code ListServiceInstancesRequest} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ListServiceInstancesRequest
        && equalTo((ListServiceInstancesRequest) another);
  }

  private boolean equalTo(ListServiceInstancesRequest another) {
    return Objects.equals(gatewayNames, another.gatewayNames)
        && Objects.equals(names, another.names)
        && Objects.equals(organizationIds, another.organizationIds)
        && Objects.equals(serviceBindingIds, another.serviceBindingIds)
        && Objects.equals(serviceKeyIds, another.serviceKeyIds)
        && Objects.equals(servicePlanIds, another.servicePlanIds)
        && Objects.equals(spaceIds, another.spaceIds)
        && Objects.equals(orderDirection, another.orderDirection)
        && Objects.equals(page, another.page)
        && Objects.equals(resultsPerPage, another.resultsPerPage);
  }

  /**
   * Computes a hash code from attributes: {@code gatewayNames}, {@code names}, {@code organizationIds}, {@code serviceBindingIds}, {@code serviceKeyIds}, {@code servicePlanIds}, {@code spaceIds}, {@code orderDirection}, {@code page}, {@code resultsPerPage}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + Objects.hashCode(gatewayNames);
    h += (h << 5) + Objects.hashCode(names);
    h += (h << 5) + Objects.hashCode(organizationIds);
    h += (h << 5) + Objects.hashCode(serviceBindingIds);
    h += (h << 5) + Objects.hashCode(serviceKeyIds);
    h += (h << 5) + Objects.hashCode(servicePlanIds);
    h += (h << 5) + Objects.hashCode(spaceIds);
    h += (h << 5) + Objects.hashCode(orderDirection);
    h += (h << 5) + Objects.hashCode(page);
    h += (h << 5) + Objects.hashCode(resultsPerPage);
    return h;
  }

  /**
   * Prints the immutable value {@code ListServiceInstancesRequest} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "ListServiceInstancesRequest{"
        + "gatewayNames=" + gatewayNames
        + ", names=" + names
        + ", organizationIds=" + organizationIds
        + ", serviceBindingIds=" + serviceBindingIds
        + ", serviceKeyIds=" + serviceKeyIds
        + ", servicePlanIds=" + servicePlanIds
        + ", spaceIds=" + spaceIds
        + ", orderDirection=" + orderDirection
        + ", page=" + page
        + ", resultsPerPage=" + resultsPerPage
        + "}";
  }

  /**
   * Creates a builder for {@link ListServiceInstancesRequest ListServiceInstancesRequest}.
   * @return A new ListServiceInstancesRequest builder
   */
  public static ListServiceInstancesRequest.Builder builder() {
    return new ListServiceInstancesRequest.Builder();
  }

  /**
   * Builds instances of type {@link ListServiceInstancesRequest ListServiceInstancesRequest}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  public static final class Builder {
    private List<String> gatewayNames = null;
    private List<String> names = null;
    private List<String> organizationIds = null;
    private List<String> serviceBindingIds = null;
    private List<String> serviceKeyIds = null;
    private List<String> servicePlanIds = null;
    private List<String> spaceIds = null;
    private OrderDirection orderDirection;
    private Integer page;
    private Integer resultsPerPage;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code org.cloudfoundry.client.v2.PaginatedRequest} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(PaginatedRequest instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code ListServiceInstancesRequest} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(ListServiceInstancesRequest instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Copy abstract value type {@code _ListServiceInstancesRequest} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_ListServiceInstancesRequest instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    private void from(Object object) {
      if (object instanceof PaginatedRequest) {
        PaginatedRequest instance = (PaginatedRequest) object;
        OrderDirection orderDirectionValue = instance.getOrderDirection();
        if (orderDirectionValue != null) {
          orderDirection(orderDirectionValue);
        }
        Integer resultsPerPageValue = instance.getResultsPerPage();
        if (resultsPerPageValue != null) {
          resultsPerPage(resultsPerPageValue);
        }
        Integer pageValue = instance.getPage();
        if (pageValue != null) {
          page(pageValue);
        }
      }
      if (object instanceof org.cloudfoundry.client.v2.serviceinstances._ListServiceInstancesRequest) {
        org.cloudfoundry.client.v2.serviceinstances._ListServiceInstancesRequest instance = (org.cloudfoundry.client.v2.serviceinstances._ListServiceInstancesRequest) object;
        List<String> namesValue = instance.getNames();
        if (namesValue != null) {
          addAllNames(namesValue);
        }
        List<String> servicePlanIdsValue = instance.getServicePlanIds();
        if (servicePlanIdsValue != null) {
          addAllServicePlanIds(servicePlanIdsValue);
        }
        List<String> organizationIdsValue = instance.getOrganizationIds();
        if (organizationIdsValue != null) {
          addAllOrganizationIds(organizationIdsValue);
        }
        List<String> gatewayNamesValue = instance.getGatewayNames();
        if (gatewayNamesValue != null) {
          addAllGatewayNames(gatewayNamesValue);
        }
        List<String> serviceBindingIdsValue = instance.getServiceBindingIds();
        if (serviceBindingIdsValue != null) {
          addAllServiceBindingIds(serviceBindingIdsValue);
        }
        List<String> spaceIdsValue = instance.getSpaceIds();
        if (spaceIdsValue != null) {
          addAllSpaceIds(spaceIdsValue);
        }
        List<String> serviceKeyIdsValue = instance.getServiceKeyIds();
        if (serviceKeyIdsValue != null) {
          addAllServiceKeyIds(serviceKeyIdsValue);
        }
      }
    }

    /**
     * Adds one element to {@link _ListServiceInstancesRequest#getGatewayNames() gatewayNames} list.
     * @param element A gatewayNames element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder gatewayName(String element) {
      if (this.gatewayNames == null) {
        this.gatewayNames = new ArrayList<String>();
      }
      this.gatewayNames.add(Objects.requireNonNull(element, "gatewayNames element"));
      return this;
    }

    /**
     * Adds elements to {@link _ListServiceInstancesRequest#getGatewayNames() gatewayNames} list.
     * @param elements An array of gatewayNames elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder gatewayName(String... elements) {
      if (this.gatewayNames == null) {
        this.gatewayNames = new ArrayList<String>();
      }
      for (String element : elements) {
        this.gatewayNames.add(Objects.requireNonNull(element, "gatewayNames element"));
      }
      return this;
    }

    /**
     * Sets or replaces all elements for {@link _ListServiceInstancesRequest#getGatewayNames() gatewayNames} list.
     * @param elements An iterable of gatewayNames elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder gatewayNames(@Nullable Iterable<String> elements) {
      if (elements == null) {
        this.gatewayNames = null;
        return this;
      }
      this.gatewayNames = new ArrayList<String>();
      return addAllGatewayNames(elements);
    }

    /**
     * Adds elements to {@link _ListServiceInstancesRequest#getGatewayNames() gatewayNames} list.
     * @param elements An iterable of gatewayNames elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllGatewayNames(Iterable<String> elements) {
      Objects.requireNonNull(elements, "gatewayNames element");
      if (this.gatewayNames == null) {
        this.gatewayNames = new ArrayList<String>();
      }
      for (String element : elements) {
        this.gatewayNames.add(Objects.requireNonNull(element, "gatewayNames element"));
      }
      return this;
    }

    /**
     * Adds one element to {@link _ListServiceInstancesRequest#getNames() names} list.
     * @param element A names element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder name(String element) {
      if (this.names == null) {
        this.names = new ArrayList<String>();
      }
      this.names.add(Objects.requireNonNull(element, "names element"));
      return this;
    }

    /**
     * Adds elements to {@link _ListServiceInstancesRequest#getNames() names} list.
     * @param elements An array of names elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder name(String... elements) {
      if (this.names == null) {
        this.names = new ArrayList<String>();
      }
      for (String element : elements) {
        this.names.add(Objects.requireNonNull(element, "names element"));
      }
      return this;
    }

    /**
     * Sets or replaces all elements for {@link _ListServiceInstancesRequest#getNames() names} list.
     * @param elements An iterable of names elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder names(@Nullable Iterable<String> elements) {
      if (elements == null) {
        this.names = null;
        return this;
      }
      this.names = new ArrayList<String>();
      return addAllNames(elements);
    }

    /**
     * Adds elements to {@link _ListServiceInstancesRequest#getNames() names} list.
     * @param elements An iterable of names elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllNames(Iterable<String> elements) {
      Objects.requireNonNull(elements, "names element");
      if (this.names == null) {
        this.names = new ArrayList<String>();
      }
      for (String element : elements) {
        this.names.add(Objects.requireNonNull(element, "names element"));
      }
      return this;
    }

    /**
     * Adds one element to {@link _ListServiceInstancesRequest#getOrganizationIds() organizationIds} list.
     * @param element A organizationIds element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder organizationId(String element) {
      if (this.organizationIds == null) {
        this.organizationIds = new ArrayList<String>();
      }
      this.organizationIds.add(Objects.requireNonNull(element, "organizationIds element"));
      return this;
    }

    /**
     * Adds elements to {@link _ListServiceInstancesRequest#getOrganizationIds() organizationIds} list.
     * @param elements An array of organizationIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder organizationId(String... elements) {
      if (this.organizationIds == null) {
        this.organizationIds = new ArrayList<String>();
      }
      for (String element : elements) {
        this.organizationIds.add(Objects.requireNonNull(element, "organizationIds element"));
      }
      return this;
    }

    /**
     * Sets or replaces all elements for {@link _ListServiceInstancesRequest#getOrganizationIds() organizationIds} list.
     * @param elements An iterable of organizationIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder organizationIds(@Nullable Iterable<String> elements) {
      if (elements == null) {
        this.organizationIds = null;
        return this;
      }
      this.organizationIds = new ArrayList<String>();
      return addAllOrganizationIds(elements);
    }

    /**
     * Adds elements to {@link _ListServiceInstancesRequest#getOrganizationIds() organizationIds} list.
     * @param elements An iterable of organizationIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllOrganizationIds(Iterable<String> elements) {
      Objects.requireNonNull(elements, "organizationIds element");
      if (this.organizationIds == null) {
        this.organizationIds = new ArrayList<String>();
      }
      for (String element : elements) {
        this.organizationIds.add(Objects.requireNonNull(element, "organizationIds element"));
      }
      return this;
    }

    /**
     * Adds one element to {@link _ListServiceInstancesRequest#getServiceBindingIds() serviceBindingIds} list.
     * @param element A serviceBindingIds element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder serviceBindingId(String element) {
      if (this.serviceBindingIds == null) {
        this.serviceBindingIds = new ArrayList<String>();
      }
      this.serviceBindingIds.add(Objects.requireNonNull(element, "serviceBindingIds element"));
      return this;
    }

    /**
     * Adds elements to {@link _ListServiceInstancesRequest#getServiceBindingIds() serviceBindingIds} list.
     * @param elements An array of serviceBindingIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder serviceBindingId(String... elements) {
      if (this.serviceBindingIds == null) {
        this.serviceBindingIds = new ArrayList<String>();
      }
      for (String element : elements) {
        this.serviceBindingIds.add(Objects.requireNonNull(element, "serviceBindingIds element"));
      }
      return this;
    }

    /**
     * Sets or replaces all elements for {@link _ListServiceInstancesRequest#getServiceBindingIds() serviceBindingIds} list.
     * @param elements An iterable of serviceBindingIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder serviceBindingIds(@Nullable Iterable<String> elements) {
      if (elements == null) {
        this.serviceBindingIds = null;
        return this;
      }
      this.serviceBindingIds = new ArrayList<String>();
      return addAllServiceBindingIds(elements);
    }

    /**
     * Adds elements to {@link _ListServiceInstancesRequest#getServiceBindingIds() serviceBindingIds} list.
     * @param elements An iterable of serviceBindingIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllServiceBindingIds(Iterable<String> elements) {
      Objects.requireNonNull(elements, "serviceBindingIds element");
      if (this.serviceBindingIds == null) {
        this.serviceBindingIds = new ArrayList<String>();
      }
      for (String element : elements) {
        this.serviceBindingIds.add(Objects.requireNonNull(element, "serviceBindingIds element"));
      }
      return this;
    }

    /**
     * Adds one element to {@link _ListServiceInstancesRequest#getServiceKeyIds() serviceKeyIds} list.
     * @param element A serviceKeyIds element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder serviceKeyId(String element) {
      if (this.serviceKeyIds == null) {
        this.serviceKeyIds = new ArrayList<String>();
      }
      this.serviceKeyIds.add(Objects.requireNonNull(element, "serviceKeyIds element"));
      return this;
    }

    /**
     * Adds elements to {@link _ListServiceInstancesRequest#getServiceKeyIds() serviceKeyIds} list.
     * @param elements An array of serviceKeyIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder serviceKeyId(String... elements) {
      if (this.serviceKeyIds == null) {
        this.serviceKeyIds = new ArrayList<String>();
      }
      for (String element : elements) {
        this.serviceKeyIds.add(Objects.requireNonNull(element, "serviceKeyIds element"));
      }
      return this;
    }

    /**
     * Sets or replaces all elements for {@link _ListServiceInstancesRequest#getServiceKeyIds() serviceKeyIds} list.
     * @param elements An iterable of serviceKeyIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder serviceKeyIds(@Nullable Iterable<String> elements) {
      if (elements == null) {
        this.serviceKeyIds = null;
        return this;
      }
      this.serviceKeyIds = new ArrayList<String>();
      return addAllServiceKeyIds(elements);
    }

    /**
     * Adds elements to {@link _ListServiceInstancesRequest#getServiceKeyIds() serviceKeyIds} list.
     * @param elements An iterable of serviceKeyIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllServiceKeyIds(Iterable<String> elements) {
      Objects.requireNonNull(elements, "serviceKeyIds element");
      if (this.serviceKeyIds == null) {
        this.serviceKeyIds = new ArrayList<String>();
      }
      for (String element : elements) {
        this.serviceKeyIds.add(Objects.requireNonNull(element, "serviceKeyIds element"));
      }
      return this;
    }

    /**
     * Adds one element to {@link _ListServiceInstancesRequest#getServicePlanIds() servicePlanIds} list.
     * @param element A servicePlanIds element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder servicePlanId(String element) {
      if (this.servicePlanIds == null) {
        this.servicePlanIds = new ArrayList<String>();
      }
      this.servicePlanIds.add(Objects.requireNonNull(element, "servicePlanIds element"));
      return this;
    }

    /**
     * Adds elements to {@link _ListServiceInstancesRequest#getServicePlanIds() servicePlanIds} list.
     * @param elements An array of servicePlanIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder servicePlanId(String... elements) {
      if (this.servicePlanIds == null) {
        this.servicePlanIds = new ArrayList<String>();
      }
      for (String element : elements) {
        this.servicePlanIds.add(Objects.requireNonNull(element, "servicePlanIds element"));
      }
      return this;
    }

    /**
     * Sets or replaces all elements for {@link _ListServiceInstancesRequest#getServicePlanIds() servicePlanIds} list.
     * @param elements An iterable of servicePlanIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder servicePlanIds(@Nullable Iterable<String> elements) {
      if (elements == null) {
        this.servicePlanIds = null;
        return this;
      }
      this.servicePlanIds = new ArrayList<String>();
      return addAllServicePlanIds(elements);
    }

    /**
     * Adds elements to {@link _ListServiceInstancesRequest#getServicePlanIds() servicePlanIds} list.
     * @param elements An iterable of servicePlanIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllServicePlanIds(Iterable<String> elements) {
      Objects.requireNonNull(elements, "servicePlanIds element");
      if (this.servicePlanIds == null) {
        this.servicePlanIds = new ArrayList<String>();
      }
      for (String element : elements) {
        this.servicePlanIds.add(Objects.requireNonNull(element, "servicePlanIds element"));
      }
      return this;
    }

    /**
     * Adds one element to {@link _ListServiceInstancesRequest#getSpaceIds() spaceIds} list.
     * @param element A spaceIds element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder spaceId(String element) {
      if (this.spaceIds == null) {
        this.spaceIds = new ArrayList<String>();
      }
      this.spaceIds.add(Objects.requireNonNull(element, "spaceIds element"));
      return this;
    }

    /**
     * Adds elements to {@link _ListServiceInstancesRequest#getSpaceIds() spaceIds} list.
     * @param elements An array of spaceIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder spaceId(String... elements) {
      if (this.spaceIds == null) {
        this.spaceIds = new ArrayList<String>();
      }
      for (String element : elements) {
        this.spaceIds.add(Objects.requireNonNull(element, "spaceIds element"));
      }
      return this;
    }

    /**
     * Sets or replaces all elements for {@link _ListServiceInstancesRequest#getSpaceIds() spaceIds} list.
     * @param elements An iterable of spaceIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder spaceIds(@Nullable Iterable<String> elements) {
      if (elements == null) {
        this.spaceIds = null;
        return this;
      }
      this.spaceIds = new ArrayList<String>();
      return addAllSpaceIds(elements);
    }

    /**
     * Adds elements to {@link _ListServiceInstancesRequest#getSpaceIds() spaceIds} list.
     * @param elements An iterable of spaceIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllSpaceIds(Iterable<String> elements) {
      Objects.requireNonNull(elements, "spaceIds element");
      if (this.spaceIds == null) {
        this.spaceIds = new ArrayList<String>();
      }
      for (String element : elements) {
        this.spaceIds.add(Objects.requireNonNull(element, "spaceIds element"));
      }
      return this;
    }

    /**
     * Initializes the value for the {@link _ListServiceInstancesRequest#getOrderDirection() orderDirection} attribute.
     * @param orderDirection The value for orderDirection (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder orderDirection(@Nullable OrderDirection orderDirection) {
      this.orderDirection = orderDirection;
      return this;
    }

    /**
     * Initializes the value for the {@link _ListServiceInstancesRequest#getPage() page} attribute.
     * @param page The value for page (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder page(@Nullable Integer page) {
      this.page = page;
      return this;
    }

    /**
     * Initializes the value for the {@link _ListServiceInstancesRequest#getResultsPerPage() resultsPerPage} attribute.
     * @param resultsPerPage The value for resultsPerPage (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder resultsPerPage(@Nullable Integer resultsPerPage) {
      this.resultsPerPage = resultsPerPage;
      return this;
    }

    /**
     * Builds a new {@link ListServiceInstancesRequest ListServiceInstancesRequest}.
     * @return An immutable instance of ListServiceInstancesRequest
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ListServiceInstancesRequest build() {
      return new ListServiceInstancesRequest(this);
    }
  }

  private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
    ArrayList<T> list;
    if (iterable instanceof Collection<?>) {
      int size = ((Collection<?>) iterable).size();
      if (size == 0) return Collections.emptyList();
      list = new ArrayList<T>();
    } else {
      list = new ArrayList<T>();
    }
    for (T element : iterable) {
      if (skipNulls && element == null) continue;
      if (checkNulls) Objects.requireNonNull(element, "element");
      list.add(element);
    }
    return list;
  }

  private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
    switch(list.size()) {
    case 0: return Collections.emptyList();
    case 1: return Collections.singletonList(list.get(0));
    default:
      if (clone) {
        return Collections.unmodifiableList(new ArrayList<T>(list));
      } else {
        if (list instanceof ArrayList<?>) {
          ((ArrayList<?>) list).trimToSize();
        }
        return Collections.unmodifiableList(list);
      }
    }
  }
}
