package org.cloudfoundry.client.v2.serviceplans;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.Objects;
import javax.annotation.Generated;
import org.cloudfoundry.Nullable;

/**
 * The entity response payload for Service Plans
 */
@SuppressWarnings({"all"})
@Generated({"Immutables.generator", "_ServicePlanEntity"})
public final class ServicePlanEntity extends org.cloudfoundry.client.v2.serviceplans._ServicePlanEntity {
  private final @Nullable Boolean active;
  private final @Nullable Boolean bindable;
  private final @Nullable String description;
  private final @Nullable String extra;
  private final @Nullable Boolean free;
  private final @Nullable String name;
  private final @Nullable Boolean publiclyVisible;
  private final @Nullable String serviceId;
  private final @Nullable String serviceInstancesUrl;
  private final @Nullable String serviceUrl;
  private final @Nullable String uniqueId;

  private ServicePlanEntity(ServicePlanEntity.Builder builder) {
    this.active = builder.active;
    this.bindable = builder.bindable;
    this.description = builder.description;
    this.extra = builder.extra;
    this.free = builder.free;
    this.name = builder.name;
    this.publiclyVisible = builder.publiclyVisible;
    this.serviceId = builder.serviceId;
    this.serviceInstancesUrl = builder.serviceInstancesUrl;
    this.serviceUrl = builder.serviceUrl;
    this.uniqueId = builder.uniqueId;
  }

  /**
   * The active flag
   */
  @JsonProperty("active")
  @Override
  public @Nullable Boolean getActive() {
    return active;
  }

  /**
   * The bindable flag
   */
  @JsonProperty("bindable")
  @Override
  public @Nullable Boolean getBindable() {
    return bindable;
  }

  /**
   * The description
   */
  @JsonProperty("description")
  @Override
  public @Nullable String getDescription() {
    return description;
  }

  /**
   * The extra (A JSON string with additional data about the plan)
   */
  @JsonProperty("extra")
  @Override
  public @Nullable String getExtra() {
    return extra;
  }

  /**
   * The free flag
   */
  @JsonProperty("free")
  @Override
  public @Nullable Boolean getFree() {
    return free;
  }

  /**
   * The name
   */
  @JsonProperty("name")
  @Override
  public @Nullable String getName() {
    return name;
  }

  /**
   * The public flag
   */
  @JsonProperty("public")
  @Override
  public @Nullable Boolean getPubliclyVisible() {
    return publiclyVisible;
  }

  /**
   * The service id
   */
  @JsonProperty("service_guid")
  @Override
  public @Nullable String getServiceId() {
    return serviceId;
  }

  /**
   * The service instances url
   */
  @JsonProperty("service_instances_url")
  @Override
  public @Nullable String getServiceInstancesUrl() {
    return serviceInstancesUrl;
  }

  /**
   * The service url
   */
  @JsonProperty("service_url")
  @Override
  public @Nullable String getServiceUrl() {
    return serviceUrl;
  }

  /**
   * The unique id in the service broker
   */
  @JsonProperty("unique_id")
  @Override
  public @Nullable String getUniqueId() {
    return uniqueId;
  }

  /**
   * This instance is equal to all instances of {@code ServicePlanEntity} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ServicePlanEntity
        && equalTo((ServicePlanEntity) another);
  }

  private boolean equalTo(ServicePlanEntity another) {
    return Objects.equals(active, another.active)
        && Objects.equals(bindable, another.bindable)
        && Objects.equals(description, another.description)
        && Objects.equals(extra, another.extra)
        && Objects.equals(free, another.free)
        && Objects.equals(name, another.name)
        && Objects.equals(publiclyVisible, another.publiclyVisible)
        && Objects.equals(serviceId, another.serviceId)
        && Objects.equals(serviceInstancesUrl, another.serviceInstancesUrl)
        && Objects.equals(serviceUrl, another.serviceUrl)
        && Objects.equals(uniqueId, another.uniqueId);
  }

  /**
   * Computes a hash code from attributes: {@code active}, {@code bindable}, {@code description}, {@code extra}, {@code free}, {@code name}, {@code publiclyVisible}, {@code serviceId}, {@code serviceInstancesUrl}, {@code serviceUrl}, {@code uniqueId}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + Objects.hashCode(active);
    h += (h << 5) + Objects.hashCode(bindable);
    h += (h << 5) + Objects.hashCode(description);
    h += (h << 5) + Objects.hashCode(extra);
    h += (h << 5) + Objects.hashCode(free);
    h += (h << 5) + Objects.hashCode(name);
    h += (h << 5) + Objects.hashCode(publiclyVisible);
    h += (h << 5) + Objects.hashCode(serviceId);
    h += (h << 5) + Objects.hashCode(serviceInstancesUrl);
    h += (h << 5) + Objects.hashCode(serviceUrl);
    h += (h << 5) + Objects.hashCode(uniqueId);
    return h;
  }

  /**
   * Prints the immutable value {@code ServicePlanEntity} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "ServicePlanEntity{"
        + "active=" + active
        + ", bindable=" + bindable
        + ", description=" + description
        + ", extra=" + extra
        + ", free=" + free
        + ", name=" + name
        + ", publiclyVisible=" + publiclyVisible
        + ", serviceId=" + serviceId
        + ", serviceInstancesUrl=" + serviceInstancesUrl
        + ", serviceUrl=" + serviceUrl
        + ", uniqueId=" + uniqueId
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json extends org.cloudfoundry.client.v2.serviceplans._ServicePlanEntity {
    Boolean active;
    Boolean bindable;
    String description;
    String extra;
    Boolean free;
    String name;
    Boolean publiclyVisible;
    String serviceId;
    String serviceInstancesUrl;
    String serviceUrl;
    String uniqueId;
    @JsonProperty("active")
    public void setActive(@Nullable Boolean active) {
      this.active = active;
    }
    @JsonProperty("bindable")
    public void setBindable(@Nullable Boolean bindable) {
      this.bindable = bindable;
    }
    @JsonProperty("description")
    public void setDescription(@Nullable String description) {
      this.description = description;
    }
    @JsonProperty("extra")
    public void setExtra(@Nullable String extra) {
      this.extra = extra;
    }
    @JsonProperty("free")
    public void setFree(@Nullable Boolean free) {
      this.free = free;
    }
    @JsonProperty("name")
    public void setName(@Nullable String name) {
      this.name = name;
    }
    @JsonProperty("public")
    public void setPubliclyVisible(@Nullable Boolean publiclyVisible) {
      this.publiclyVisible = publiclyVisible;
    }
    @JsonProperty("service_guid")
    public void setServiceId(@Nullable String serviceId) {
      this.serviceId = serviceId;
    }
    @JsonProperty("service_instances_url")
    public void setServiceInstancesUrl(@Nullable String serviceInstancesUrl) {
      this.serviceInstancesUrl = serviceInstancesUrl;
    }
    @JsonProperty("service_url")
    public void setServiceUrl(@Nullable String serviceUrl) {
      this.serviceUrl = serviceUrl;
    }
    @JsonProperty("unique_id")
    public void setUniqueId(@Nullable String uniqueId) {
      this.uniqueId = uniqueId;
    }
    @Override
    public Boolean getActive() { throw new UnsupportedOperationException(); }
    @Override
    public Boolean getBindable() { throw new UnsupportedOperationException(); }
    @Override
    public String getDescription() { throw new UnsupportedOperationException(); }
    @Override
    public String getExtra() { throw new UnsupportedOperationException(); }
    @Override
    public Boolean getFree() { throw new UnsupportedOperationException(); }
    @Override
    public String getName() { throw new UnsupportedOperationException(); }
    @Override
    public Boolean getPubliclyVisible() { throw new UnsupportedOperationException(); }
    @Override
    public String getServiceId() { throw new UnsupportedOperationException(); }
    @Override
    public String getServiceInstancesUrl() { throw new UnsupportedOperationException(); }
    @Override
    public String getServiceUrl() { throw new UnsupportedOperationException(); }
    @Override
    public String getUniqueId() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ServicePlanEntity fromJson(Json json) {
    ServicePlanEntity.Builder builder = ServicePlanEntity.builder();
    if (json.active != null) {
      builder.active(json.active);
    }
    if (json.bindable != null) {
      builder.bindable(json.bindable);
    }
    if (json.description != null) {
      builder.description(json.description);
    }
    if (json.extra != null) {
      builder.extra(json.extra);
    }
    if (json.free != null) {
      builder.free(json.free);
    }
    if (json.name != null) {
      builder.name(json.name);
    }
    if (json.publiclyVisible != null) {
      builder.publiclyVisible(json.publiclyVisible);
    }
    if (json.serviceId != null) {
      builder.serviceId(json.serviceId);
    }
    if (json.serviceInstancesUrl != null) {
      builder.serviceInstancesUrl(json.serviceInstancesUrl);
    }
    if (json.serviceUrl != null) {
      builder.serviceUrl(json.serviceUrl);
    }
    if (json.uniqueId != null) {
      builder.uniqueId(json.uniqueId);
    }
    return builder.build();
  }

  /**
   * Creates a builder for {@link ServicePlanEntity ServicePlanEntity}.
   * @return A new ServicePlanEntity builder
   */
  public static ServicePlanEntity.Builder builder() {
    return new ServicePlanEntity.Builder();
  }

  /**
   * Builds instances of type {@link ServicePlanEntity ServicePlanEntity}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  public static final class Builder {
    private Boolean active;
    private Boolean bindable;
    private String description;
    private String extra;
    private Boolean free;
    private String name;
    private Boolean publiclyVisible;
    private String serviceId;
    private String serviceInstancesUrl;
    private String serviceUrl;
    private String uniqueId;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code ServicePlanEntity} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(ServicePlanEntity instance) {
      return from((_ServicePlanEntity) instance);
    }

    /**
     * Copy abstract value type {@code _ServicePlanEntity} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_ServicePlanEntity instance) {
      Objects.requireNonNull(instance, "instance");
      Boolean activeValue = instance.getActive();
      if (activeValue != null) {
        active(activeValue);
      }
      Boolean bindableValue = instance.getBindable();
      if (bindableValue != null) {
        bindable(bindableValue);
      }
      String descriptionValue = instance.getDescription();
      if (descriptionValue != null) {
        description(descriptionValue);
      }
      String extraValue = instance.getExtra();
      if (extraValue != null) {
        extra(extraValue);
      }
      Boolean freeValue = instance.getFree();
      if (freeValue != null) {
        free(freeValue);
      }
      String nameValue = instance.getName();
      if (nameValue != null) {
        name(nameValue);
      }
      Boolean publiclyVisibleValue = instance.getPubliclyVisible();
      if (publiclyVisibleValue != null) {
        publiclyVisible(publiclyVisibleValue);
      }
      String serviceIdValue = instance.getServiceId();
      if (serviceIdValue != null) {
        serviceId(serviceIdValue);
      }
      String serviceInstancesUrlValue = instance.getServiceInstancesUrl();
      if (serviceInstancesUrlValue != null) {
        serviceInstancesUrl(serviceInstancesUrlValue);
      }
      String serviceUrlValue = instance.getServiceUrl();
      if (serviceUrlValue != null) {
        serviceUrl(serviceUrlValue);
      }
      String uniqueIdValue = instance.getUniqueId();
      if (uniqueIdValue != null) {
        uniqueId(uniqueIdValue);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link _ServicePlanEntity#getActive() active} attribute.
     * @param active The value for active (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("active")
    public final Builder active(@Nullable Boolean active) {
      this.active = active;
      return this;
    }

    /**
     * Initializes the value for the {@link _ServicePlanEntity#getBindable() bindable} attribute.
     * @param bindable The value for bindable (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("bindable")
    public final Builder bindable(@Nullable Boolean bindable) {
      this.bindable = bindable;
      return this;
    }

    /**
     * Initializes the value for the {@link _ServicePlanEntity#getDescription() description} attribute.
     * @param description The value for description (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("description")
    public final Builder description(@Nullable String description) {
      this.description = description;
      return this;
    }

    /**
     * Initializes the value for the {@link _ServicePlanEntity#getExtra() extra} attribute.
     * @param extra The value for extra (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("extra")
    public final Builder extra(@Nullable String extra) {
      this.extra = extra;
      return this;
    }

    /**
     * Initializes the value for the {@link _ServicePlanEntity#getFree() free} attribute.
     * @param free The value for free (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("free")
    public final Builder free(@Nullable Boolean free) {
      this.free = free;
      return this;
    }

    /**
     * Initializes the value for the {@link _ServicePlanEntity#getName() name} attribute.
     * @param name The value for name (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("name")
    public final Builder name(@Nullable String name) {
      this.name = name;
      return this;
    }

    /**
     * Initializes the value for the {@link _ServicePlanEntity#getPubliclyVisible() publiclyVisible} attribute.
     * @param publiclyVisible The value for publiclyVisible (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("public")
    public final Builder publiclyVisible(@Nullable Boolean publiclyVisible) {
      this.publiclyVisible = publiclyVisible;
      return this;
    }

    /**
     * Initializes the value for the {@link _ServicePlanEntity#getServiceId() serviceId} attribute.
     * @param serviceId The value for serviceId (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("service_guid")
    public final Builder serviceId(@Nullable String serviceId) {
      this.serviceId = serviceId;
      return this;
    }

    /**
     * Initializes the value for the {@link _ServicePlanEntity#getServiceInstancesUrl() serviceInstancesUrl} attribute.
     * @param serviceInstancesUrl The value for serviceInstancesUrl (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("service_instances_url")
    public final Builder serviceInstancesUrl(@Nullable String serviceInstancesUrl) {
      this.serviceInstancesUrl = serviceInstancesUrl;
      return this;
    }

    /**
     * Initializes the value for the {@link _ServicePlanEntity#getServiceUrl() serviceUrl} attribute.
     * @param serviceUrl The value for serviceUrl (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("service_url")
    public final Builder serviceUrl(@Nullable String serviceUrl) {
      this.serviceUrl = serviceUrl;
      return this;
    }

    /**
     * Initializes the value for the {@link _ServicePlanEntity#getUniqueId() uniqueId} attribute.
     * @param uniqueId The value for uniqueId (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("unique_id")
    public final Builder uniqueId(@Nullable String uniqueId) {
      this.uniqueId = uniqueId;
      return this;
    }

    /**
     * Builds a new {@link ServicePlanEntity ServicePlanEntity}.
     * @return An immutable instance of ServicePlanEntity
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ServicePlanEntity build() {
      return new ServicePlanEntity(this);
    }
  }
}
