package org.cloudfoundry.client.v2.serviceusageevents;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.Generated;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.client.v2.OrderDirection;
import org.cloudfoundry.client.v2.PaginatedRequest;

/**
 * The request payload for the List Service Usage Events operation
 */
@SuppressWarnings({"all"})
@Generated({"Immutables.generator", "_ListServiceUsageEventsRequest"})
public final class ListServiceUsageEventsRequest
    extends org.cloudfoundry.client.v2.serviceusageevents._ListServiceUsageEventsRequest {
  private final @Nullable String afterServiceUsageEventId;
  private final @Nullable List<String> serviceIds;
  private final @Nullable List<String> serviceInstanceTypes;
  private final @Nullable OrderDirection orderDirection;
  private final @Nullable Integer page;
  private final @Nullable Integer resultsPerPage;

  private ListServiceUsageEventsRequest(ListServiceUsageEventsRequest.Builder builder) {
    this.afterServiceUsageEventId = builder.afterServiceUsageEventId;
    this.serviceIds = builder.serviceIds == null ? null : createUnmodifiableList(true, builder.serviceIds);
    this.serviceInstanceTypes = builder.serviceInstanceTypes == null ? null : createUnmodifiableList(true, builder.serviceInstanceTypes);
    this.orderDirection = builder.orderDirection;
    this.page = builder.page;
    this.resultsPerPage = builder.resultsPerPage;
  }

  /**
   * The after service usage event id: Restrict results to Service Usage Events after the one with the given id
   */
  @Override
  public @Nullable String getAfterServiceUsageEventId() {
    return afterServiceUsageEventId;
  }

  /**
   * The service ids
   */
  @Override
  public @Nullable List<String> getServiceIds() {
    return serviceIds;
  }

  /**
   * The service instance types
   */
  @Override
  public @Nullable List<String> getServiceInstanceTypes() {
    return serviceInstanceTypes;
  }

  /**
   * The order direction
   */
  @Override
  public @Nullable OrderDirection getOrderDirection() {
    return orderDirection;
  }

  /**
   * The page
   */
  @Override
  public @Nullable Integer getPage() {
    return page;
  }

  /**
   * The results per page
   */
  @Override
  public @Nullable Integer getResultsPerPage() {
    return resultsPerPage;
  }

  /**
   * This instance is equal to all instances of {@code ListServiceUsageEventsRequest} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ListServiceUsageEventsRequest
        && equalTo((ListServiceUsageEventsRequest) another);
  }

  private boolean equalTo(ListServiceUsageEventsRequest another) {
    return Objects.equals(afterServiceUsageEventId, another.afterServiceUsageEventId)
        && Objects.equals(serviceIds, another.serviceIds)
        && Objects.equals(serviceInstanceTypes, another.serviceInstanceTypes)
        && Objects.equals(orderDirection, another.orderDirection)
        && Objects.equals(page, another.page)
        && Objects.equals(resultsPerPage, another.resultsPerPage);
  }

  /**
   * Computes a hash code from attributes: {@code afterServiceUsageEventId}, {@code serviceIds}, {@code serviceInstanceTypes}, {@code orderDirection}, {@code page}, {@code resultsPerPage}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + Objects.hashCode(afterServiceUsageEventId);
    h += (h << 5) + Objects.hashCode(serviceIds);
    h += (h << 5) + Objects.hashCode(serviceInstanceTypes);
    h += (h << 5) + Objects.hashCode(orderDirection);
    h += (h << 5) + Objects.hashCode(page);
    h += (h << 5) + Objects.hashCode(resultsPerPage);
    return h;
  }

  /**
   * Prints the immutable value {@code ListServiceUsageEventsRequest} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "ListServiceUsageEventsRequest{"
        + "afterServiceUsageEventId=" + afterServiceUsageEventId
        + ", serviceIds=" + serviceIds
        + ", serviceInstanceTypes=" + serviceInstanceTypes
        + ", orderDirection=" + orderDirection
        + ", page=" + page
        + ", resultsPerPage=" + resultsPerPage
        + "}";
  }

  /**
   * Creates a builder for {@link ListServiceUsageEventsRequest ListServiceUsageEventsRequest}.
   * @return A new ListServiceUsageEventsRequest builder
   */
  public static ListServiceUsageEventsRequest.Builder builder() {
    return new ListServiceUsageEventsRequest.Builder();
  }

  /**
   * Builds instances of type {@link ListServiceUsageEventsRequest ListServiceUsageEventsRequest}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  public static final class Builder {
    private String afterServiceUsageEventId;
    private List<String> serviceIds = null;
    private List<String> serviceInstanceTypes = null;
    private OrderDirection orderDirection;
    private Integer page;
    private Integer resultsPerPage;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code org.cloudfoundry.client.v2.PaginatedRequest} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(PaginatedRequest instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code ListServiceUsageEventsRequest} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(ListServiceUsageEventsRequest instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Copy abstract value type {@code _ListServiceUsageEventsRequest} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_ListServiceUsageEventsRequest instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    private void from(Object object) {
      if (object instanceof PaginatedRequest) {
        PaginatedRequest instance = (PaginatedRequest) object;
        OrderDirection orderDirectionValue = instance.getOrderDirection();
        if (orderDirectionValue != null) {
          orderDirection(orderDirectionValue);
        }
        Integer resultsPerPageValue = instance.getResultsPerPage();
        if (resultsPerPageValue != null) {
          resultsPerPage(resultsPerPageValue);
        }
        Integer pageValue = instance.getPage();
        if (pageValue != null) {
          page(pageValue);
        }
      }
      if (object instanceof org.cloudfoundry.client.v2.serviceusageevents._ListServiceUsageEventsRequest) {
        org.cloudfoundry.client.v2.serviceusageevents._ListServiceUsageEventsRequest instance = (org.cloudfoundry.client.v2.serviceusageevents._ListServiceUsageEventsRequest) object;
        List<String> serviceIdsValue = instance.getServiceIds();
        if (serviceIdsValue != null) {
          addAllServiceIds(serviceIdsValue);
        }
        List<String> serviceInstanceTypesValue = instance.getServiceInstanceTypes();
        if (serviceInstanceTypesValue != null) {
          addAllServiceInstanceTypes(serviceInstanceTypesValue);
        }
        String afterServiceUsageEventIdValue = instance.getAfterServiceUsageEventId();
        if (afterServiceUsageEventIdValue != null) {
          afterServiceUsageEventId(afterServiceUsageEventIdValue);
        }
      }
    }

    /**
     * Initializes the value for the {@link _ListServiceUsageEventsRequest#getAfterServiceUsageEventId() afterServiceUsageEventId} attribute.
     * @param afterServiceUsageEventId The value for afterServiceUsageEventId (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder afterServiceUsageEventId(@Nullable String afterServiceUsageEventId) {
      this.afterServiceUsageEventId = afterServiceUsageEventId;
      return this;
    }

    /**
     * Adds one element to {@link _ListServiceUsageEventsRequest#getServiceIds() serviceIds} list.
     * @param element A serviceIds element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder serviceId(String element) {
      if (this.serviceIds == null) {
        this.serviceIds = new ArrayList<String>();
      }
      this.serviceIds.add(Objects.requireNonNull(element, "serviceIds element"));
      return this;
    }

    /**
     * Adds elements to {@link _ListServiceUsageEventsRequest#getServiceIds() serviceIds} list.
     * @param elements An array of serviceIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder serviceId(String... elements) {
      if (this.serviceIds == null) {
        this.serviceIds = new ArrayList<String>();
      }
      for (String element : elements) {
        this.serviceIds.add(Objects.requireNonNull(element, "serviceIds element"));
      }
      return this;
    }

    /**
     * Sets or replaces all elements for {@link _ListServiceUsageEventsRequest#getServiceIds() serviceIds} list.
     * @param elements An iterable of serviceIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder serviceIds(@Nullable Iterable<String> elements) {
      if (elements == null) {
        this.serviceIds = null;
        return this;
      }
      this.serviceIds = new ArrayList<String>();
      return addAllServiceIds(elements);
    }

    /**
     * Adds elements to {@link _ListServiceUsageEventsRequest#getServiceIds() serviceIds} list.
     * @param elements An iterable of serviceIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllServiceIds(Iterable<String> elements) {
      Objects.requireNonNull(elements, "serviceIds element");
      if (this.serviceIds == null) {
        this.serviceIds = new ArrayList<String>();
      }
      for (String element : elements) {
        this.serviceIds.add(Objects.requireNonNull(element, "serviceIds element"));
      }
      return this;
    }

    /**
     * Adds one element to {@link _ListServiceUsageEventsRequest#getServiceInstanceTypes() serviceInstanceTypes} list.
     * @param element A serviceInstanceTypes element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder serviceInstanceType(String element) {
      if (this.serviceInstanceTypes == null) {
        this.serviceInstanceTypes = new ArrayList<String>();
      }
      this.serviceInstanceTypes.add(Objects.requireNonNull(element, "serviceInstanceTypes element"));
      return this;
    }

    /**
     * Adds elements to {@link _ListServiceUsageEventsRequest#getServiceInstanceTypes() serviceInstanceTypes} list.
     * @param elements An array of serviceInstanceTypes elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder serviceInstanceType(String... elements) {
      if (this.serviceInstanceTypes == null) {
        this.serviceInstanceTypes = new ArrayList<String>();
      }
      for (String element : elements) {
        this.serviceInstanceTypes.add(Objects.requireNonNull(element, "serviceInstanceTypes element"));
      }
      return this;
    }

    /**
     * Sets or replaces all elements for {@link _ListServiceUsageEventsRequest#getServiceInstanceTypes() serviceInstanceTypes} list.
     * @param elements An iterable of serviceInstanceTypes elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder serviceInstanceTypes(@Nullable Iterable<String> elements) {
      if (elements == null) {
        this.serviceInstanceTypes = null;
        return this;
      }
      this.serviceInstanceTypes = new ArrayList<String>();
      return addAllServiceInstanceTypes(elements);
    }

    /**
     * Adds elements to {@link _ListServiceUsageEventsRequest#getServiceInstanceTypes() serviceInstanceTypes} list.
     * @param elements An iterable of serviceInstanceTypes elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllServiceInstanceTypes(Iterable<String> elements) {
      Objects.requireNonNull(elements, "serviceInstanceTypes element");
      if (this.serviceInstanceTypes == null) {
        this.serviceInstanceTypes = new ArrayList<String>();
      }
      for (String element : elements) {
        this.serviceInstanceTypes.add(Objects.requireNonNull(element, "serviceInstanceTypes element"));
      }
      return this;
    }

    /**
     * Initializes the value for the {@link _ListServiceUsageEventsRequest#getOrderDirection() orderDirection} attribute.
     * @param orderDirection The value for orderDirection (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder orderDirection(@Nullable OrderDirection orderDirection) {
      this.orderDirection = orderDirection;
      return this;
    }

    /**
     * Initializes the value for the {@link _ListServiceUsageEventsRequest#getPage() page} attribute.
     * @param page The value for page (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder page(@Nullable Integer page) {
      this.page = page;
      return this;
    }

    /**
     * Initializes the value for the {@link _ListServiceUsageEventsRequest#getResultsPerPage() resultsPerPage} attribute.
     * @param resultsPerPage The value for resultsPerPage (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder resultsPerPage(@Nullable Integer resultsPerPage) {
      this.resultsPerPage = resultsPerPage;
      return this;
    }

    /**
     * Builds a new {@link ListServiceUsageEventsRequest ListServiceUsageEventsRequest}.
     * @return An immutable instance of ListServiceUsageEventsRequest
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ListServiceUsageEventsRequest build() {
      return new ListServiceUsageEventsRequest(this);
    }
  }

  private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
    ArrayList<T> list;
    if (iterable instanceof Collection<?>) {
      int size = ((Collection<?>) iterable).size();
      if (size == 0) return Collections.emptyList();
      list = new ArrayList<T>();
    } else {
      list = new ArrayList<T>();
    }
    for (T element : iterable) {
      if (skipNulls && element == null) continue;
      if (checkNulls) Objects.requireNonNull(element, "element");
      list.add(element);
    }
    return list;
  }

  private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
    switch(list.size()) {
    case 0: return Collections.emptyList();
    case 1: return Collections.singletonList(list.get(0));
    default:
      if (clone) {
        return Collections.unmodifiableList(new ArrayList<T>(list));
      } else {
        if (list instanceof ArrayList<?>) {
          ((ArrayList<?>) list).trimToSize();
        }
        return Collections.unmodifiableList(list);
      }
    }
  }
}
