package org.cloudfoundry.client.v2.spaces;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.Objects;
import javax.annotation.Generated;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.client.v2.Metadata;

/**
 * User Role Resource in responses
 */
@SuppressWarnings({"all"})
@Generated({"Immutables.generator", "_UserSpaceRoleResource"})
public final class UserSpaceRoleResource extends org.cloudfoundry.client.v2.spaces._UserSpaceRoleResource {
  private final @Nullable UserSpaceRoleEntity entity;
  private final @Nullable Metadata metadata;

  private UserSpaceRoleResource(UserSpaceRoleResource.Builder builder) {
    this.entity = builder.entity;
    this.metadata = builder.metadata;
  }

  /**
   * The resource's entity
   */
  @JsonProperty("entity")
  @Override
  public @Nullable UserSpaceRoleEntity getEntity() {
    return entity;
  }

  /**
   * The resource's metadata
   */
  @JsonProperty("metadata")
  @Override
  public @Nullable Metadata getMetadata() {
    return metadata;
  }

  /**
   * This instance is equal to all instances of {@code UserSpaceRoleResource} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof UserSpaceRoleResource
        && equalTo((UserSpaceRoleResource) another);
  }

  private boolean equalTo(UserSpaceRoleResource another) {
    return Objects.equals(entity, another.entity)
        && Objects.equals(metadata, another.metadata);
  }

  /**
   * Computes a hash code from attributes: {@code entity}, {@code metadata}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + Objects.hashCode(entity);
    h += (h << 5) + Objects.hashCode(metadata);
    return h;
  }

  /**
   * Prints the immutable value {@code UserSpaceRoleResource} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "UserSpaceRoleResource{"
        + "entity=" + entity
        + ", metadata=" + metadata
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json extends org.cloudfoundry.client.v2.spaces._UserSpaceRoleResource {
    UserSpaceRoleEntity entity;
    Metadata metadata;
    @JsonProperty("entity")
    public void setEntity(@Nullable UserSpaceRoleEntity entity) {
      this.entity = entity;
    }
    @JsonProperty("metadata")
    public void setMetadata(@Nullable Metadata metadata) {
      this.metadata = metadata;
    }
    @Override
    public UserSpaceRoleEntity getEntity() { throw new UnsupportedOperationException(); }
    @Override
    public Metadata getMetadata() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static UserSpaceRoleResource fromJson(Json json) {
    UserSpaceRoleResource.Builder builder = UserSpaceRoleResource.builder();
    if (json.entity != null) {
      builder.entity(json.entity);
    }
    if (json.metadata != null) {
      builder.metadata(json.metadata);
    }
    return builder.build();
  }

  /**
   * Creates a builder for {@link UserSpaceRoleResource UserSpaceRoleResource}.
   * @return A new UserSpaceRoleResource builder
   */
  public static UserSpaceRoleResource.Builder builder() {
    return new UserSpaceRoleResource.Builder();
  }

  /**
   * Builds instances of type {@link UserSpaceRoleResource UserSpaceRoleResource}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  public static final class Builder {
    private UserSpaceRoleEntity entity;
    private Metadata metadata;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code UserSpaceRoleResource} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(UserSpaceRoleResource instance) {
      return from((_UserSpaceRoleResource) instance);
    }

    /**
     * Copy abstract value type {@code _UserSpaceRoleResource} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_UserSpaceRoleResource instance) {
      Objects.requireNonNull(instance, "instance");
      UserSpaceRoleEntity entityValue = instance.getEntity();
      if (entityValue != null) {
        entity(entityValue);
      }
      Metadata metadataValue = instance.getMetadata();
      if (metadataValue != null) {
        metadata(metadataValue);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link _UserSpaceRoleResource#getEntity() entity} attribute.
     * @param entity The value for entity (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("entity")
    public final Builder entity(@Nullable UserSpaceRoleEntity entity) {
      this.entity = entity;
      return this;
    }

    /**
     * Initializes the value for the {@link _UserSpaceRoleResource#getMetadata() metadata} attribute.
     * @param metadata The value for metadata (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("metadata")
    public final Builder metadata(@Nullable Metadata metadata) {
      this.metadata = metadata;
      return this;
    }

    /**
     * Builds a new {@link UserSpaceRoleResource UserSpaceRoleResource}.
     * @return An immutable instance of UserSpaceRoleResource
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public UserSpaceRoleResource build() {
      return new UserSpaceRoleResource(this);
    }
  }
}
