package org.cloudfoundry.client.v2.users;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Generated;
import org.cloudfoundry.Nullable;

/**
 * The request payload for the Create a User operation
 */
@SuppressWarnings({"all"})
@Generated({"Immutables.generator", "_CreateUserRequest"})
public final class CreateUserRequest extends org.cloudfoundry.client.v2.users._CreateUserRequest {
  private final @Nullable String defaultSpaceId;
  private final String uaaId;

  private CreateUserRequest(CreateUserRequest.Builder builder) {
    this.defaultSpaceId = builder.defaultSpaceId;
    this.uaaId = builder.uaaId;
  }

  /**
   * The ID of the default space for apps created by this user
   */
  @Override
  public @Nullable String getDefaultSpaceId() {
    return defaultSpaceId;
  }

  /**
   * The UAA ID of the user to create
   */
  @Override
  public String getUaaId() {
    return uaaId;
  }

  /**
   * This instance is equal to all instances of {@code CreateUserRequest} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof CreateUserRequest
        && equalTo((CreateUserRequest) another);
  }

  private boolean equalTo(CreateUserRequest another) {
    return Objects.equals(defaultSpaceId, another.defaultSpaceId)
        && uaaId.equals(another.uaaId);
  }

  /**
   * Computes a hash code from attributes: {@code defaultSpaceId}, {@code uaaId}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + Objects.hashCode(defaultSpaceId);
    h += (h << 5) + uaaId.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code CreateUserRequest} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "CreateUserRequest{"
        + "defaultSpaceId=" + defaultSpaceId
        + ", uaaId=" + uaaId
        + "}";
  }

  /**
   * Creates a builder for {@link CreateUserRequest CreateUserRequest}.
   * @return A new CreateUserRequest builder
   */
  public static CreateUserRequest.Builder builder() {
    return new CreateUserRequest.Builder();
  }

  /**
   * Builds instances of type {@link CreateUserRequest CreateUserRequest}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  public static final class Builder {
    private static final long INIT_BIT_UAA_ID = 0x1L;
    private long initBits = 0x1L;

    private String defaultSpaceId;
    private String uaaId;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code CreateUserRequest} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(CreateUserRequest instance) {
      return from((_CreateUserRequest) instance);
    }

    /**
     * Copy abstract value type {@code _CreateUserRequest} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_CreateUserRequest instance) {
      Objects.requireNonNull(instance, "instance");
      String defaultSpaceIdValue = instance.getDefaultSpaceId();
      if (defaultSpaceIdValue != null) {
        defaultSpaceId(defaultSpaceIdValue);
      }
      uaaId(instance.getUaaId());
      return this;
    }

    /**
     * Initializes the value for the {@link _CreateUserRequest#getDefaultSpaceId() defaultSpaceId} attribute.
     * @param defaultSpaceId The value for defaultSpaceId (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder defaultSpaceId(@Nullable String defaultSpaceId) {
      this.defaultSpaceId = defaultSpaceId;
      return this;
    }

    /**
     * Initializes the value for the {@link _CreateUserRequest#getUaaId() uaaId} attribute.
     * @param uaaId The value for uaaId 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder uaaId(String uaaId) {
      this.uaaId = Objects.requireNonNull(uaaId, "uaaId");
      initBits &= ~INIT_BIT_UAA_ID;
      return this;
    }

    /**
     * Builds a new {@link CreateUserRequest CreateUserRequest}.
     * @return An immutable instance of CreateUserRequest
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public CreateUserRequest build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new CreateUserRequest(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<String>();
      if ((initBits & INIT_BIT_UAA_ID) != 0) attributes.add("uaaId");
      return "Cannot build CreateUserRequest, some of required attributes are not set " + attributes;
    }
  }
}
