package org.cloudfoundry.client.v2.users;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Generated;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.client.v2.OrderDirection;
import org.cloudfoundry.client.v2.PaginatedRequest;

/**
 * The request payload for the List all Audited Organizations for the User operation
 */
@SuppressWarnings({"all"})
@Generated({"Immutables.generator", "_ListUserAuditedOrganizationsRequest"})
public final class ListUserAuditedOrganizationsRequest
    extends org.cloudfoundry.client.v2.users._ListUserAuditedOrganizationsRequest {
  private final @Nullable String auditorId;
  private final @Nullable String billingManagerId;
  private final @Nullable String managerId;
  private final @Nullable String name;
  private final @Nullable String spaceId;
  private final @Nullable String status;
  private final String userId;
  private final @Nullable OrderDirection orderDirection;
  private final @Nullable Integer page;
  private final @Nullable Integer resultsPerPage;

  private ListUserAuditedOrganizationsRequest(ListUserAuditedOrganizationsRequest.Builder builder) {
    this.auditorId = builder.auditorId;
    this.billingManagerId = builder.billingManagerId;
    this.managerId = builder.managerId;
    this.name = builder.name;
    this.spaceId = builder.spaceId;
    this.status = builder.status;
    this.userId = builder.userId;
    this.orderDirection = builder.orderDirection;
    this.page = builder.page;
    this.resultsPerPage = builder.resultsPerPage;
  }

  /**
   * The auditor id
   */
  @Override
  public @Nullable String getAuditorId() {
    return auditorId;
  }

  /**
   * The billing manager id
   */
  @Override
  public @Nullable String getBillingManagerId() {
    return billingManagerId;
  }

  /**
   * The manager id
   */
  @Override
  public @Nullable String getManagerId() {
    return managerId;
  }

  /**
   * The name
   */
  @Override
  public @Nullable String getName() {
    return name;
  }

  /**
   * The space id
   */
  @Override
  public @Nullable String getSpaceId() {
    return spaceId;
  }

  /**
   * The status
   */
  @Override
  public @Nullable String getStatus() {
    return status;
  }

  /**
   * The id of the user
   */
  @Override
  public String getUserId() {
    return userId;
  }

  /**
   * The order direction
   */
  @Override
  public @Nullable OrderDirection getOrderDirection() {
    return orderDirection;
  }

  /**
   * The page
   */
  @Override
  public @Nullable Integer getPage() {
    return page;
  }

  /**
   * The results per page
   */
  @Override
  public @Nullable Integer getResultsPerPage() {
    return resultsPerPage;
  }

  /**
   * This instance is equal to all instances of {@code ListUserAuditedOrganizationsRequest} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ListUserAuditedOrganizationsRequest
        && equalTo((ListUserAuditedOrganizationsRequest) another);
  }

  private boolean equalTo(ListUserAuditedOrganizationsRequest another) {
    return Objects.equals(auditorId, another.auditorId)
        && Objects.equals(billingManagerId, another.billingManagerId)
        && Objects.equals(managerId, another.managerId)
        && Objects.equals(name, another.name)
        && Objects.equals(spaceId, another.spaceId)
        && Objects.equals(status, another.status)
        && userId.equals(another.userId)
        && Objects.equals(orderDirection, another.orderDirection)
        && Objects.equals(page, another.page)
        && Objects.equals(resultsPerPage, another.resultsPerPage);
  }

  /**
   * Computes a hash code from attributes: {@code auditorId}, {@code billingManagerId}, {@code managerId}, {@code name}, {@code spaceId}, {@code status}, {@code userId}, {@code orderDirection}, {@code page}, {@code resultsPerPage}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + Objects.hashCode(auditorId);
    h += (h << 5) + Objects.hashCode(billingManagerId);
    h += (h << 5) + Objects.hashCode(managerId);
    h += (h << 5) + Objects.hashCode(name);
    h += (h << 5) + Objects.hashCode(spaceId);
    h += (h << 5) + Objects.hashCode(status);
    h += (h << 5) + userId.hashCode();
    h += (h << 5) + Objects.hashCode(orderDirection);
    h += (h << 5) + Objects.hashCode(page);
    h += (h << 5) + Objects.hashCode(resultsPerPage);
    return h;
  }

  /**
   * Prints the immutable value {@code ListUserAuditedOrganizationsRequest} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "ListUserAuditedOrganizationsRequest{"
        + "auditorId=" + auditorId
        + ", billingManagerId=" + billingManagerId
        + ", managerId=" + managerId
        + ", name=" + name
        + ", spaceId=" + spaceId
        + ", status=" + status
        + ", userId=" + userId
        + ", orderDirection=" + orderDirection
        + ", page=" + page
        + ", resultsPerPage=" + resultsPerPage
        + "}";
  }

  /**
   * Creates a builder for {@link ListUserAuditedOrganizationsRequest ListUserAuditedOrganizationsRequest}.
   * @return A new ListUserAuditedOrganizationsRequest builder
   */
  public static ListUserAuditedOrganizationsRequest.Builder builder() {
    return new ListUserAuditedOrganizationsRequest.Builder();
  }

  /**
   * Builds instances of type {@link ListUserAuditedOrganizationsRequest ListUserAuditedOrganizationsRequest}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  public static final class Builder {
    private static final long INIT_BIT_USER_ID = 0x1L;
    private long initBits = 0x1L;

    private String auditorId;
    private String billingManagerId;
    private String managerId;
    private String name;
    private String spaceId;
    private String status;
    private String userId;
    private OrderDirection orderDirection;
    private Integer page;
    private Integer resultsPerPage;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code org.cloudfoundry.client.v2.PaginatedRequest} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(PaginatedRequest instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code ListUserAuditedOrganizationsRequest} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(ListUserAuditedOrganizationsRequest instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Copy abstract value type {@code _ListUserAuditedOrganizationsRequest} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_ListUserAuditedOrganizationsRequest instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    private void from(Object object) {
      if (object instanceof PaginatedRequest) {
        PaginatedRequest instance = (PaginatedRequest) object;
        OrderDirection orderDirectionValue = instance.getOrderDirection();
        if (orderDirectionValue != null) {
          orderDirection(orderDirectionValue);
        }
        Integer resultsPerPageValue = instance.getResultsPerPage();
        if (resultsPerPageValue != null) {
          resultsPerPage(resultsPerPageValue);
        }
        Integer pageValue = instance.getPage();
        if (pageValue != null) {
          page(pageValue);
        }
      }
      if (object instanceof org.cloudfoundry.client.v2.users._ListUserAuditedOrganizationsRequest) {
        org.cloudfoundry.client.v2.users._ListUserAuditedOrganizationsRequest instance = (org.cloudfoundry.client.v2.users._ListUserAuditedOrganizationsRequest) object;
        String spaceIdValue = instance.getSpaceId();
        if (spaceIdValue != null) {
          spaceId(spaceIdValue);
        }
        String auditorIdValue = instance.getAuditorId();
        if (auditorIdValue != null) {
          auditorId(auditorIdValue);
        }
        String nameValue = instance.getName();
        if (nameValue != null) {
          name(nameValue);
        }
        String managerIdValue = instance.getManagerId();
        if (managerIdValue != null) {
          managerId(managerIdValue);
        }
        String billingManagerIdValue = instance.getBillingManagerId();
        if (billingManagerIdValue != null) {
          billingManagerId(billingManagerIdValue);
        }
        userId(instance.getUserId());
        String statusValue = instance.getStatus();
        if (statusValue != null) {
          status(statusValue);
        }
      }
    }

    /**
     * Initializes the value for the {@link _ListUserAuditedOrganizationsRequest#getAuditorId() auditorId} attribute.
     * @param auditorId The value for auditorId (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder auditorId(@Nullable String auditorId) {
      this.auditorId = auditorId;
      return this;
    }

    /**
     * Initializes the value for the {@link _ListUserAuditedOrganizationsRequest#getBillingManagerId() billingManagerId} attribute.
     * @param billingManagerId The value for billingManagerId (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder billingManagerId(@Nullable String billingManagerId) {
      this.billingManagerId = billingManagerId;
      return this;
    }

    /**
     * Initializes the value for the {@link _ListUserAuditedOrganizationsRequest#getManagerId() managerId} attribute.
     * @param managerId The value for managerId (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder managerId(@Nullable String managerId) {
      this.managerId = managerId;
      return this;
    }

    /**
     * Initializes the value for the {@link _ListUserAuditedOrganizationsRequest#getName() name} attribute.
     * @param name The value for name (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder name(@Nullable String name) {
      this.name = name;
      return this;
    }

    /**
     * Initializes the value for the {@link _ListUserAuditedOrganizationsRequest#getSpaceId() spaceId} attribute.
     * @param spaceId The value for spaceId (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder spaceId(@Nullable String spaceId) {
      this.spaceId = spaceId;
      return this;
    }

    /**
     * Initializes the value for the {@link _ListUserAuditedOrganizationsRequest#getStatus() status} attribute.
     * @param status The value for status (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder status(@Nullable String status) {
      this.status = status;
      return this;
    }

    /**
     * Initializes the value for the {@link _ListUserAuditedOrganizationsRequest#getUserId() userId} attribute.
     * @param userId The value for userId 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder userId(String userId) {
      this.userId = Objects.requireNonNull(userId, "userId");
      initBits &= ~INIT_BIT_USER_ID;
      return this;
    }

    /**
     * Initializes the value for the {@link _ListUserAuditedOrganizationsRequest#getOrderDirection() orderDirection} attribute.
     * @param orderDirection The value for orderDirection (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder orderDirection(@Nullable OrderDirection orderDirection) {
      this.orderDirection = orderDirection;
      return this;
    }

    /**
     * Initializes the value for the {@link _ListUserAuditedOrganizationsRequest#getPage() page} attribute.
     * @param page The value for page (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder page(@Nullable Integer page) {
      this.page = page;
      return this;
    }

    /**
     * Initializes the value for the {@link _ListUserAuditedOrganizationsRequest#getResultsPerPage() resultsPerPage} attribute.
     * @param resultsPerPage The value for resultsPerPage (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder resultsPerPage(@Nullable Integer resultsPerPage) {
      this.resultsPerPage = resultsPerPage;
      return this;
    }

    /**
     * Builds a new {@link ListUserAuditedOrganizationsRequest ListUserAuditedOrganizationsRequest}.
     * @return An immutable instance of ListUserAuditedOrganizationsRequest
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ListUserAuditedOrganizationsRequest build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ListUserAuditedOrganizationsRequest(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<String>();
      if ((initBits & INIT_BIT_USER_ID) != 0) attributes.add("userId");
      return "Cannot build ListUserAuditedOrganizationsRequest, some of required attributes are not set " + attributes;
    }
  }
}
