package org.cloudfoundry.client.v3.applications;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Generated;

/**
 * The request payload for the Assign Application Droplet operation
 */
@SuppressWarnings({"all"})
@Generated({"Immutables.generator", "_AssignApplicationDropletRequest"})
public final class AssignApplicationDropletRequest
    extends org.cloudfoundry.client.v3.applications._AssignApplicationDropletRequest {
  private final String applicationId;
  private final String dropletId;

  private AssignApplicationDropletRequest(AssignApplicationDropletRequest.Builder builder) {
    this.applicationId = builder.applicationId;
    this.dropletId = builder.dropletId;
  }

  /**
   * The application id
   */
  @Override
  public String getApplicationId() {
    return applicationId;
  }

  /**
   * The droplet id
   */
  @Override
  public String getDropletId() {
    return dropletId;
  }

  /**
   * This instance is equal to all instances of {@code AssignApplicationDropletRequest} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof AssignApplicationDropletRequest
        && equalTo((AssignApplicationDropletRequest) another);
  }

  private boolean equalTo(AssignApplicationDropletRequest another) {
    return applicationId.equals(another.applicationId)
        && dropletId.equals(another.dropletId);
  }

  /**
   * Computes a hash code from attributes: {@code applicationId}, {@code dropletId}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + applicationId.hashCode();
    h += (h << 5) + dropletId.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code AssignApplicationDropletRequest} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "AssignApplicationDropletRequest{"
        + "applicationId=" + applicationId
        + ", dropletId=" + dropletId
        + "}";
  }

  /**
   * Creates a builder for {@link AssignApplicationDropletRequest AssignApplicationDropletRequest}.
   * @return A new AssignApplicationDropletRequest builder
   */
  public static AssignApplicationDropletRequest.Builder builder() {
    return new AssignApplicationDropletRequest.Builder();
  }

  /**
   * Builds instances of type {@link AssignApplicationDropletRequest AssignApplicationDropletRequest}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  public static final class Builder {
    private static final long INIT_BIT_APPLICATION_ID = 0x1L;
    private static final long INIT_BIT_DROPLET_ID = 0x2L;
    private long initBits = 0x3L;

    private String applicationId;
    private String dropletId;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code AssignApplicationDropletRequest} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(AssignApplicationDropletRequest instance) {
      return from((_AssignApplicationDropletRequest) instance);
    }

    /**
     * Copy abstract value type {@code _AssignApplicationDropletRequest} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_AssignApplicationDropletRequest instance) {
      Objects.requireNonNull(instance, "instance");
      applicationId(instance.getApplicationId());
      dropletId(instance.getDropletId());
      return this;
    }

    /**
     * Initializes the value for the {@link _AssignApplicationDropletRequest#getApplicationId() applicationId} attribute.
     * @param applicationId The value for applicationId 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder applicationId(String applicationId) {
      this.applicationId = Objects.requireNonNull(applicationId, "applicationId");
      initBits &= ~INIT_BIT_APPLICATION_ID;
      return this;
    }

    /**
     * Initializes the value for the {@link _AssignApplicationDropletRequest#getDropletId() dropletId} attribute.
     * @param dropletId The value for dropletId 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder dropletId(String dropletId) {
      this.dropletId = Objects.requireNonNull(dropletId, "dropletId");
      initBits &= ~INIT_BIT_DROPLET_ID;
      return this;
    }

    /**
     * Builds a new {@link AssignApplicationDropletRequest AssignApplicationDropletRequest}.
     * @return An immutable instance of AssignApplicationDropletRequest
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public AssignApplicationDropletRequest build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new AssignApplicationDropletRequest(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<String>();
      if ((initBits & INIT_BIT_APPLICATION_ID) != 0) attributes.add("applicationId");
      if ((initBits & INIT_BIT_DROPLET_ID) != 0) attributes.add("dropletId");
      return "Cannot build AssignApplicationDropletRequest, some of required attributes are not set " + attributes;
    }
  }
}
