package org.cloudfoundry.client.v3.applications;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Generated;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.client.v3.Lifecycle;
import org.cloudfoundry.client.v3.Link;

/**
 * The response payload for the Create Application operation
 */
@SuppressWarnings({"all"})
@Generated({"Immutables.generator", "_CreateApplicationResponse"})
public final class CreateApplicationResponse
    extends org.cloudfoundry.client.v3.applications._CreateApplicationResponse {
  private final @Nullable String createdAt;
  private final @Nullable String desiredState;
  private final @Nullable Map<String, String> environmentVariables;
  private final @Nullable String id;
  private final @Nullable Lifecycle lifecycle;
  private final @Nullable Map<String, Link> links;
  private final @Nullable String name;
  private final @Nullable Integer totalDesiredInstances;
  private final @Nullable String updatedAt;

  private CreateApplicationResponse(CreateApplicationResponse.Builder builder) {
    this.createdAt = builder.createdAt;
    this.desiredState = builder.desiredState;
    this.environmentVariables = builder.environmentVariables == null ? null : createUnmodifiableMap(false, false, builder.environmentVariables);
    this.id = builder.id;
    this.lifecycle = builder.lifecycle;
    this.links = builder.links == null ? null : createUnmodifiableMap(false, false, builder.links);
    this.name = builder.name;
    this.totalDesiredInstances = builder.totalDesiredInstances;
    this.updatedAt = builder.updatedAt;
  }

  /**
   * When the application was created
   */
  @JsonProperty("created_at")
  @Override
  public @Nullable String getCreatedAt() {
    return createdAt;
  }

  /**
   * The desired state
   */
  @JsonProperty("desired_state")
  @Override
  public @Nullable String getDesiredState() {
    return desiredState;
  }

  /**
   * The environment variables\
   */
  @JsonProperty("environment_variables")
  @Override
  public @Nullable Map<String, String> getEnvironmentVariables() {
    return environmentVariables;
  }

  /**
   * The id
   */
  @JsonProperty("guid")
  @Override
  public @Nullable String getId() {
    return id;
  }

  /**
   * The lifecycle
   */
  @JsonProperty("lifecycle")
  @Override
  public @Nullable Lifecycle getLifecycle() {
    return lifecycle;
  }

  /**
   * The links
   */
  @JsonProperty("links")
  @Override
  public @Nullable Map<String, Link> getLinks() {
    return links;
  }

  /**
   * The name
   */
  @JsonProperty("name")
  @Override
  public @Nullable String getName() {
    return name;
  }

  /**
   * The total desired instances
   */
  @JsonProperty("total_desired_instances")
  @Override
  public @Nullable Integer getTotalDesiredInstances() {
    return totalDesiredInstances;
  }

  /**
   * When the application was updated
   */
  @JsonProperty("updated_at")
  @Override
  public @Nullable String getUpdatedAt() {
    return updatedAt;
  }

  /**
   * This instance is equal to all instances of {@code CreateApplicationResponse} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof CreateApplicationResponse
        && equalTo((CreateApplicationResponse) another);
  }

  private boolean equalTo(CreateApplicationResponse another) {
    return Objects.equals(createdAt, another.createdAt)
        && Objects.equals(desiredState, another.desiredState)
        && Objects.equals(environmentVariables, another.environmentVariables)
        && Objects.equals(id, another.id)
        && Objects.equals(lifecycle, another.lifecycle)
        && Objects.equals(links, another.links)
        && Objects.equals(name, another.name)
        && Objects.equals(totalDesiredInstances, another.totalDesiredInstances)
        && Objects.equals(updatedAt, another.updatedAt);
  }

  /**
   * Computes a hash code from attributes: {@code createdAt}, {@code desiredState}, {@code environmentVariables}, {@code id}, {@code lifecycle}, {@code links}, {@code name}, {@code totalDesiredInstances}, {@code updatedAt}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + Objects.hashCode(createdAt);
    h += (h << 5) + Objects.hashCode(desiredState);
    h += (h << 5) + Objects.hashCode(environmentVariables);
    h += (h << 5) + Objects.hashCode(id);
    h += (h << 5) + Objects.hashCode(lifecycle);
    h += (h << 5) + Objects.hashCode(links);
    h += (h << 5) + Objects.hashCode(name);
    h += (h << 5) + Objects.hashCode(totalDesiredInstances);
    h += (h << 5) + Objects.hashCode(updatedAt);
    return h;
  }

  /**
   * Prints the immutable value {@code CreateApplicationResponse} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "CreateApplicationResponse{"
        + "createdAt=" + createdAt
        + ", desiredState=" + desiredState
        + ", environmentVariables=" + environmentVariables
        + ", id=" + id
        + ", lifecycle=" + lifecycle
        + ", links=" + links
        + ", name=" + name
        + ", totalDesiredInstances=" + totalDesiredInstances
        + ", updatedAt=" + updatedAt
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json extends org.cloudfoundry.client.v3.applications._CreateApplicationResponse {
    String createdAt;
    String desiredState;
    Map<String, String> environmentVariables;
    String id;
    Lifecycle lifecycle;
    Map<String, Link> links;
    String name;
    Integer totalDesiredInstances;
    String updatedAt;
    @JsonProperty("created_at")
    public void setCreatedAt(@Nullable String createdAt) {
      this.createdAt = createdAt;
    }
    @JsonProperty("desired_state")
    public void setDesiredState(@Nullable String desiredState) {
      this.desiredState = desiredState;
    }
    @JsonProperty("environment_variables")
    public void setEnvironmentVariables(@Nullable Map<String, String> environmentVariables) {
      this.environmentVariables = environmentVariables;
    }
    @JsonProperty("guid")
    public void setId(@Nullable String id) {
      this.id = id;
    }
    @JsonProperty("lifecycle")
    public void setLifecycle(@Nullable Lifecycle lifecycle) {
      this.lifecycle = lifecycle;
    }
    @JsonProperty("links")
    public void setLinks(@Nullable Map<String, Link> links) {
      this.links = links;
    }
    @JsonProperty("name")
    public void setName(@Nullable String name) {
      this.name = name;
    }
    @JsonProperty("total_desired_instances")
    public void setTotalDesiredInstances(@Nullable Integer totalDesiredInstances) {
      this.totalDesiredInstances = totalDesiredInstances;
    }
    @JsonProperty("updated_at")
    public void setUpdatedAt(@Nullable String updatedAt) {
      this.updatedAt = updatedAt;
    }
    @Override
    public String getCreatedAt() { throw new UnsupportedOperationException(); }
    @Override
    public String getDesiredState() { throw new UnsupportedOperationException(); }
    @Override
    public Map<String, String> getEnvironmentVariables() { throw new UnsupportedOperationException(); }
    @Override
    public String getId() { throw new UnsupportedOperationException(); }
    @Override
    public Lifecycle getLifecycle() { throw new UnsupportedOperationException(); }
    @Override
    public Map<String, Link> getLinks() { throw new UnsupportedOperationException(); }
    @Override
    public String getName() { throw new UnsupportedOperationException(); }
    @Override
    public Integer getTotalDesiredInstances() { throw new UnsupportedOperationException(); }
    @Override
    public String getUpdatedAt() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static CreateApplicationResponse fromJson(Json json) {
    CreateApplicationResponse.Builder builder = CreateApplicationResponse.builder();
    if (json.createdAt != null) {
      builder.createdAt(json.createdAt);
    }
    if (json.desiredState != null) {
      builder.desiredState(json.desiredState);
    }
    if (json.environmentVariables != null) {
      builder.putAllEnvironmentVariables(json.environmentVariables);
    }
    if (json.id != null) {
      builder.id(json.id);
    }
    if (json.lifecycle != null) {
      builder.lifecycle(json.lifecycle);
    }
    if (json.links != null) {
      builder.putAllLinks(json.links);
    }
    if (json.name != null) {
      builder.name(json.name);
    }
    if (json.totalDesiredInstances != null) {
      builder.totalDesiredInstances(json.totalDesiredInstances);
    }
    if (json.updatedAt != null) {
      builder.updatedAt(json.updatedAt);
    }
    return builder.build();
  }

  /**
   * Creates a builder for {@link CreateApplicationResponse CreateApplicationResponse}.
   * @return A new CreateApplicationResponse builder
   */
  public static CreateApplicationResponse.Builder builder() {
    return new CreateApplicationResponse.Builder();
  }

  /**
   * Builds instances of type {@link CreateApplicationResponse CreateApplicationResponse}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  public static final class Builder {
    private String createdAt;
    private String desiredState;
    private Map<String, String> environmentVariables = null;
    private String id;
    private Lifecycle lifecycle;
    private Map<String, Link> links = null;
    private String name;
    private Integer totalDesiredInstances;
    private String updatedAt;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code org.cloudfoundry.client.v3.applications.Application} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(Application instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code CreateApplicationResponse} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(CreateApplicationResponse instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Copy abstract value type {@code _CreateApplicationResponse} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_CreateApplicationResponse instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    private void from(Object object) {
      if (object instanceof Application) {
        Application instance = (Application) object;
        Lifecycle lifecycleValue = instance.getLifecycle();
        if (lifecycleValue != null) {
          lifecycle(lifecycleValue);
        }
        String createdAtValue = instance.getCreatedAt();
        if (createdAtValue != null) {
          createdAt(createdAtValue);
        }
        String desiredStateValue = instance.getDesiredState();
        if (desiredStateValue != null) {
          desiredState(desiredStateValue);
        }
        Map<String, String> environmentVariablesValue = instance.getEnvironmentVariables();
        if (environmentVariablesValue != null) {
          putAllEnvironmentVariables(environmentVariablesValue);
        }
        String nameValue = instance.getName();
        if (nameValue != null) {
          name(nameValue);
        }
        Map<String, Link> linksValue = instance.getLinks();
        if (linksValue != null) {
          putAllLinks(linksValue);
        }
        String idValue = instance.getId();
        if (idValue != null) {
          id(idValue);
        }
        Integer totalDesiredInstancesValue = instance.getTotalDesiredInstances();
        if (totalDesiredInstancesValue != null) {
          totalDesiredInstances(totalDesiredInstancesValue);
        }
        String updatedAtValue = instance.getUpdatedAt();
        if (updatedAtValue != null) {
          updatedAt(updatedAtValue);
        }
      }
    }

    /**
     * Initializes the value for the {@link _CreateApplicationResponse#getCreatedAt() createdAt} attribute.
     * @param createdAt The value for createdAt (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("created_at")
    public final Builder createdAt(@Nullable String createdAt) {
      this.createdAt = createdAt;
      return this;
    }

    /**
     * Initializes the value for the {@link _CreateApplicationResponse#getDesiredState() desiredState} attribute.
     * @param desiredState The value for desiredState (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("desired_state")
    public final Builder desiredState(@Nullable String desiredState) {
      this.desiredState = desiredState;
      return this;
    }

    /**
     * Put one entry to the {@link _CreateApplicationResponse#getEnvironmentVariables() environmentVariables} map.
     * @param key The key in the environmentVariables map
     * @param value The associated value in the environmentVariables map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder environmentVariable(String key, String value) {
      if (this.environmentVariables == null) {
        this.environmentVariables = new LinkedHashMap<String, String>();
      }
      this.environmentVariables.put(key, value);
      return this;
    }

    /**
     * Put one entry to the {@link _CreateApplicationResponse#getEnvironmentVariables() environmentVariables} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder environmentVariable(Map.Entry<String, ? extends String> entry) {
      if (this.environmentVariables == null) {
        this.environmentVariables = new LinkedHashMap<String, String>();
      }
      String k = entry.getKey();
      String v = entry.getValue();
      this.environmentVariables.put(k, v);
      return this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link _CreateApplicationResponse#getEnvironmentVariables() environmentVariables} map. Nulls are not permitted as keys or values, but parameter itself can be null
     * @param environmentVariables The entries that will be added to the environmentVariables map
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("environment_variables")
    public final Builder environmentVariables(@Nullable Map<String, ? extends String> environmentVariables) {
      if (environmentVariables == null) {
        this.environmentVariables = null;
        return this;
      }
      this.environmentVariables = new LinkedHashMap<String, String>();
      return putAllEnvironmentVariables(environmentVariables);
    }

    /**
     * Put all mappings from the specified map as entries to {@link _CreateApplicationResponse#getEnvironmentVariables() environmentVariables} map. Nulls are not permitted
     * @param environmentVariables The entries that will be added to the environmentVariables map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder putAllEnvironmentVariables(Map<String, ? extends String> environmentVariables) {
      if (this.environmentVariables == null) {
        this.environmentVariables = new LinkedHashMap<String, String>();
      }
      for (Map.Entry<String, ? extends String> entry : environmentVariables.entrySet()) {
        String k = entry.getKey();
        String v = entry.getValue();
        this.environmentVariables.put(k, v);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link _CreateApplicationResponse#getId() id} attribute.
     * @param id The value for id (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("guid")
    public final Builder id(@Nullable String id) {
      this.id = id;
      return this;
    }

    /**
     * Initializes the value for the {@link _CreateApplicationResponse#getLifecycle() lifecycle} attribute.
     * @param lifecycle The value for lifecycle (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("lifecycle")
    public final Builder lifecycle(@Nullable Lifecycle lifecycle) {
      this.lifecycle = lifecycle;
      return this;
    }

    /**
     * Put one entry to the {@link _CreateApplicationResponse#getLinks() links} map.
     * @param key The key in the links map
     * @param value The associated value in the links map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder link(String key, Link value) {
      if (this.links == null) {
        this.links = new LinkedHashMap<String, Link>();
      }
      this.links.put(key, value);
      return this;
    }

    /**
     * Put one entry to the {@link _CreateApplicationResponse#getLinks() links} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder link(Map.Entry<String, ? extends Link> entry) {
      if (this.links == null) {
        this.links = new LinkedHashMap<String, Link>();
      }
      String k = entry.getKey();
      Link v = entry.getValue();
      this.links.put(k, v);
      return this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link _CreateApplicationResponse#getLinks() links} map. Nulls are not permitted as keys or values, but parameter itself can be null
     * @param links The entries that will be added to the links map
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("links")
    public final Builder links(@Nullable Map<String, ? extends Link> links) {
      if (links == null) {
        this.links = null;
        return this;
      }
      this.links = new LinkedHashMap<String, Link>();
      return putAllLinks(links);
    }

    /**
     * Put all mappings from the specified map as entries to {@link _CreateApplicationResponse#getLinks() links} map. Nulls are not permitted
     * @param links The entries that will be added to the links map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder putAllLinks(Map<String, ? extends Link> links) {
      if (this.links == null) {
        this.links = new LinkedHashMap<String, Link>();
      }
      for (Map.Entry<String, ? extends Link> entry : links.entrySet()) {
        String k = entry.getKey();
        Link v = entry.getValue();
        this.links.put(k, v);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link _CreateApplicationResponse#getName() name} attribute.
     * @param name The value for name (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("name")
    public final Builder name(@Nullable String name) {
      this.name = name;
      return this;
    }

    /**
     * Initializes the value for the {@link _CreateApplicationResponse#getTotalDesiredInstances() totalDesiredInstances} attribute.
     * @param totalDesiredInstances The value for totalDesiredInstances (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("total_desired_instances")
    public final Builder totalDesiredInstances(@Nullable Integer totalDesiredInstances) {
      this.totalDesiredInstances = totalDesiredInstances;
      return this;
    }

    /**
     * Initializes the value for the {@link _CreateApplicationResponse#getUpdatedAt() updatedAt} attribute.
     * @param updatedAt The value for updatedAt (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("updated_at")
    public final Builder updatedAt(@Nullable String updatedAt) {
      this.updatedAt = updatedAt;
      return this;
    }

    /**
     * Builds a new {@link CreateApplicationResponse CreateApplicationResponse}.
     * @return An immutable instance of CreateApplicationResponse
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public CreateApplicationResponse build() {
      return new CreateApplicationResponse(this);
    }
  }

  private static <K, V> Map<K, V> createUnmodifiableMap(boolean checkNulls, boolean skipNulls, Map<? extends K, ? extends V> map) {
    switch (map.size()) {
    case 0: return Collections.emptyMap();
    case 1: {
      Map.Entry<? extends K, ? extends V> e = map.entrySet().iterator().next();
      K k = e.getKey();
      V v = e.getValue();
      if (checkNulls) {
        Objects.requireNonNull(k, "key");
        Objects.requireNonNull(v, "value");
      }
      if (skipNulls && (k == null || v == null)) {
        return Collections.emptyMap();
      }
      return Collections.singletonMap(k, v);
    }
    default: {
      Map<K, V> linkedMap = new LinkedHashMap<K, V>(map.size());
      if (skipNulls || checkNulls) {
        for (Map.Entry<? extends K, ? extends V> e : map.entrySet()) {
          K k = e.getKey();
          V v = e.getValue();
          if (skipNulls) {
            if (k == null || v == null) continue;
          } else if (checkNulls) {
            Objects.requireNonNull(k, "key");
            Objects.requireNonNull(v, "value");
          }
          linkedMap.put(k, v);
        }
      } else {
        linkedMap.putAll(map);
      }
      return Collections.unmodifiableMap(linkedMap);
    }
    }
  }
}
