package org.cloudfoundry.client.v3.isolationsegments;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Generated;

/**
 * The request payload for the Update Isolation Segment operation.
 */
@SuppressWarnings({"all"})
@Generated({"Immutables.generator", "_UpdateIsolationSegmentRequest"})
public final class UpdateIsolationSegmentRequest
    extends org.cloudfoundry.client.v3.isolationsegments._UpdateIsolationSegmentRequest {
  private final String isolationSegmentId;
  private final String name;

  private UpdateIsolationSegmentRequest(UpdateIsolationSegmentRequest.Builder builder) {
    this.isolationSegmentId = builder.isolationSegmentId;
    this.name = builder.name;
  }

  /**
   * The id of the isolation segment
   */
  @Override
  public String getIsolationSegmentId() {
    return isolationSegmentId;
  }

  /**
   * The name of the isolation segment
   */
  @Override
  public String getName() {
    return name;
  }

  /**
   * This instance is equal to all instances of {@code UpdateIsolationSegmentRequest} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof UpdateIsolationSegmentRequest
        && equalTo((UpdateIsolationSegmentRequest) another);
  }

  private boolean equalTo(UpdateIsolationSegmentRequest another) {
    return isolationSegmentId.equals(another.isolationSegmentId)
        && name.equals(another.name);
  }

  /**
   * Computes a hash code from attributes: {@code isolationSegmentId}, {@code name}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + isolationSegmentId.hashCode();
    h += (h << 5) + name.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code UpdateIsolationSegmentRequest} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "UpdateIsolationSegmentRequest{"
        + "isolationSegmentId=" + isolationSegmentId
        + ", name=" + name
        + "}";
  }

  /**
   * Creates a builder for {@link UpdateIsolationSegmentRequest UpdateIsolationSegmentRequest}.
   * @return A new UpdateIsolationSegmentRequest builder
   */
  public static UpdateIsolationSegmentRequest.Builder builder() {
    return new UpdateIsolationSegmentRequest.Builder();
  }

  /**
   * Builds instances of type {@link UpdateIsolationSegmentRequest UpdateIsolationSegmentRequest}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  public static final class Builder {
    private static final long INIT_BIT_ISOLATION_SEGMENT_ID = 0x1L;
    private static final long INIT_BIT_NAME = 0x2L;
    private long initBits = 0x3L;

    private String isolationSegmentId;
    private String name;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code UpdateIsolationSegmentRequest} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(UpdateIsolationSegmentRequest instance) {
      return from((_UpdateIsolationSegmentRequest) instance);
    }

    /**
     * Copy abstract value type {@code _UpdateIsolationSegmentRequest} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_UpdateIsolationSegmentRequest instance) {
      Objects.requireNonNull(instance, "instance");
      isolationSegmentId(instance.getIsolationSegmentId());
      name(instance.getName());
      return this;
    }

    /**
     * Initializes the value for the {@link _UpdateIsolationSegmentRequest#getIsolationSegmentId() isolationSegmentId} attribute.
     * @param isolationSegmentId The value for isolationSegmentId 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder isolationSegmentId(String isolationSegmentId) {
      this.isolationSegmentId = Objects.requireNonNull(isolationSegmentId, "isolationSegmentId");
      initBits &= ~INIT_BIT_ISOLATION_SEGMENT_ID;
      return this;
    }

    /**
     * Initializes the value for the {@link _UpdateIsolationSegmentRequest#getName() name} attribute.
     * @param name The value for name 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder name(String name) {
      this.name = Objects.requireNonNull(name, "name");
      initBits &= ~INIT_BIT_NAME;
      return this;
    }

    /**
     * Builds a new {@link UpdateIsolationSegmentRequest UpdateIsolationSegmentRequest}.
     * @return An immutable instance of UpdateIsolationSegmentRequest
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public UpdateIsolationSegmentRequest build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new UpdateIsolationSegmentRequest(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<String>();
      if ((initBits & INIT_BIT_ISOLATION_SEGMENT_ID) != 0) attributes.add("isolationSegmentId");
      if ((initBits & INIT_BIT_NAME) != 0) attributes.add("name");
      return "Cannot build UpdateIsolationSegmentRequest, some of required attributes are not set " + attributes;
    }
  }
}
