package org.cloudfoundry.client.v3.processes;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Generated;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.client.v3.Link;

/**
 * The response payload for the Scale Process operation
 */
@SuppressWarnings({"all"})
@Generated({"Immutables.generator", "_ScaleProcessResponse"})
public final class ScaleProcessResponse extends org.cloudfoundry.client.v3.processes._ScaleProcessResponse {
  private final @Nullable String command;
  private final @Nullable String createdAt;
  private final @Nullable Integer diskInMb;
  private final @Nullable HealthCheck healthCheck;
  private final @Nullable String id;
  private final @Nullable Integer instances;
  private final @Nullable Map<String, Link> links;
  private final @Nullable Integer memoryInMb;
  private final @Nullable List<Integer> ports;
  private final @Nullable String type;
  private final @Nullable String updatedAt;

  private ScaleProcessResponse(ScaleProcessResponse.Builder builder) {
    this.command = builder.command;
    this.createdAt = builder.createdAt;
    this.diskInMb = builder.diskInMb;
    this.healthCheck = builder.healthCheck;
    this.id = builder.id;
    this.instances = builder.instances;
    this.links = builder.links == null ? null : createUnmodifiableMap(false, false, builder.links);
    this.memoryInMb = builder.memoryInMb;
    this.ports = builder.ports == null ? null : createUnmodifiableList(true, builder.ports);
    this.type = builder.type;
    this.updatedAt = builder.updatedAt;
  }

  /**
   * The command
   */
  @JsonProperty("command")
  @Override
  public @Nullable String getCommand() {
    return command;
  }

  /**
   * The created at
   */
  @JsonProperty("created_at")
  @Override
  public @Nullable String getCreatedAt() {
    return createdAt;
  }

  /**
   * The disk in megabytes
   */
  @JsonProperty("disk_in_mb")
  @Override
  public @Nullable Integer getDiskInMb() {
    return diskInMb;
  }

  /**
   * The health check
   */
  @JsonProperty("health_check")
  @Override
  public @Nullable HealthCheck getHealthCheck() {
    return healthCheck;
  }

  /**
   * The id
   */
  @JsonProperty("guid")
  @Override
  public @Nullable String getId() {
    return id;
  }

  /**
   * The instances
   */
  @JsonProperty("instances")
  @Override
  public @Nullable Integer getInstances() {
    return instances;
  }

  /**
   * The links
   */
  @JsonProperty("links")
  @Override
  public @Nullable Map<String, Link> getLinks() {
    return links;
  }

  /**
   * The memory in megabytes
   */
  @JsonProperty("memory_in_mb")
  @Override
  public @Nullable Integer getMemoryInMb() {
    return memoryInMb;
  }

  /**
   * The ports opened to the application
   */
  @JsonProperty("ports")
  @Override
  public @Nullable List<Integer> getPorts() {
    return ports;
  }

  /**
   * The type
   */
  @JsonProperty("type")
  @Override
  public @Nullable String getType() {
    return type;
  }

  /**
   * The updated at
   */
  @JsonProperty("updated_at")
  @Override
  public @Nullable String getUpdatedAt() {
    return updatedAt;
  }

  /**
   * This instance is equal to all instances of {@code ScaleProcessResponse} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ScaleProcessResponse
        && equalTo((ScaleProcessResponse) another);
  }

  private boolean equalTo(ScaleProcessResponse another) {
    return Objects.equals(command, another.command)
        && Objects.equals(createdAt, another.createdAt)
        && Objects.equals(diskInMb, another.diskInMb)
        && Objects.equals(healthCheck, another.healthCheck)
        && Objects.equals(id, another.id)
        && Objects.equals(instances, another.instances)
        && Objects.equals(links, another.links)
        && Objects.equals(memoryInMb, another.memoryInMb)
        && Objects.equals(ports, another.ports)
        && Objects.equals(type, another.type)
        && Objects.equals(updatedAt, another.updatedAt);
  }

  /**
   * Computes a hash code from attributes: {@code command}, {@code createdAt}, {@code diskInMb}, {@code healthCheck}, {@code id}, {@code instances}, {@code links}, {@code memoryInMb}, {@code ports}, {@code type}, {@code updatedAt}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + Objects.hashCode(command);
    h += (h << 5) + Objects.hashCode(createdAt);
    h += (h << 5) + Objects.hashCode(diskInMb);
    h += (h << 5) + Objects.hashCode(healthCheck);
    h += (h << 5) + Objects.hashCode(id);
    h += (h << 5) + Objects.hashCode(instances);
    h += (h << 5) + Objects.hashCode(links);
    h += (h << 5) + Objects.hashCode(memoryInMb);
    h += (h << 5) + Objects.hashCode(ports);
    h += (h << 5) + Objects.hashCode(type);
    h += (h << 5) + Objects.hashCode(updatedAt);
    return h;
  }

  /**
   * Prints the immutable value {@code ScaleProcessResponse} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "ScaleProcessResponse{"
        + "command=" + command
        + ", createdAt=" + createdAt
        + ", diskInMb=" + diskInMb
        + ", healthCheck=" + healthCheck
        + ", id=" + id
        + ", instances=" + instances
        + ", links=" + links
        + ", memoryInMb=" + memoryInMb
        + ", ports=" + ports
        + ", type=" + type
        + ", updatedAt=" + updatedAt
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json extends org.cloudfoundry.client.v3.processes._ScaleProcessResponse {
    String command;
    String createdAt;
    Integer diskInMb;
    HealthCheck healthCheck;
    String id;
    Integer instances;
    Map<String, Link> links;
    Integer memoryInMb;
    List<Integer> ports = null;
    String type;
    String updatedAt;
    @JsonProperty("command")
    public void setCommand(@Nullable String command) {
      this.command = command;
    }
    @JsonProperty("created_at")
    public void setCreatedAt(@Nullable String createdAt) {
      this.createdAt = createdAt;
    }
    @JsonProperty("disk_in_mb")
    public void setDiskInMb(@Nullable Integer diskInMb) {
      this.diskInMb = diskInMb;
    }
    @JsonProperty("health_check")
    public void setHealthCheck(@Nullable HealthCheck healthCheck) {
      this.healthCheck = healthCheck;
    }
    @JsonProperty("guid")
    public void setId(@Nullable String id) {
      this.id = id;
    }
    @JsonProperty("instances")
    public void setInstances(@Nullable Integer instances) {
      this.instances = instances;
    }
    @JsonProperty("links")
    public void setLinks(@Nullable Map<String, Link> links) {
      this.links = links;
    }
    @JsonProperty("memory_in_mb")
    public void setMemoryInMb(@Nullable Integer memoryInMb) {
      this.memoryInMb = memoryInMb;
    }
    @JsonProperty("ports")
    public void setPorts(@Nullable List<Integer> ports) {
      this.ports = ports;
    }
    @JsonProperty("type")
    public void setType(@Nullable String type) {
      this.type = type;
    }
    @JsonProperty("updated_at")
    public void setUpdatedAt(@Nullable String updatedAt) {
      this.updatedAt = updatedAt;
    }
    @Override
    public String getCommand() { throw new UnsupportedOperationException(); }
    @Override
    public String getCreatedAt() { throw new UnsupportedOperationException(); }
    @Override
    public Integer getDiskInMb() { throw new UnsupportedOperationException(); }
    @Override
    public HealthCheck getHealthCheck() { throw new UnsupportedOperationException(); }
    @Override
    public String getId() { throw new UnsupportedOperationException(); }
    @Override
    public Integer getInstances() { throw new UnsupportedOperationException(); }
    @Override
    public Map<String, Link> getLinks() { throw new UnsupportedOperationException(); }
    @Override
    public Integer getMemoryInMb() { throw new UnsupportedOperationException(); }
    @Override
    public List<Integer> getPorts() { throw new UnsupportedOperationException(); }
    @Override
    public String getType() { throw new UnsupportedOperationException(); }
    @Override
    public String getUpdatedAt() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ScaleProcessResponse fromJson(Json json) {
    ScaleProcessResponse.Builder builder = ScaleProcessResponse.builder();
    if (json.command != null) {
      builder.command(json.command);
    }
    if (json.createdAt != null) {
      builder.createdAt(json.createdAt);
    }
    if (json.diskInMb != null) {
      builder.diskInMb(json.diskInMb);
    }
    if (json.healthCheck != null) {
      builder.healthCheck(json.healthCheck);
    }
    if (json.id != null) {
      builder.id(json.id);
    }
    if (json.instances != null) {
      builder.instances(json.instances);
    }
    if (json.links != null) {
      builder.putAllLinks(json.links);
    }
    if (json.memoryInMb != null) {
      builder.memoryInMb(json.memoryInMb);
    }
    if (json.ports != null) {
      builder.addAllPorts(json.ports);
    }
    if (json.type != null) {
      builder.type(json.type);
    }
    if (json.updatedAt != null) {
      builder.updatedAt(json.updatedAt);
    }
    return builder.build();
  }

  /**
   * Creates a builder for {@link ScaleProcessResponse ScaleProcessResponse}.
   * @return A new ScaleProcessResponse builder
   */
  public static ScaleProcessResponse.Builder builder() {
    return new ScaleProcessResponse.Builder();
  }

  /**
   * Builds instances of type {@link ScaleProcessResponse ScaleProcessResponse}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  public static final class Builder {
    private String command;
    private String createdAt;
    private Integer diskInMb;
    private HealthCheck healthCheck;
    private String id;
    private Integer instances;
    private Map<String, Link> links = null;
    private Integer memoryInMb;
    private List<Integer> ports = null;
    private String type;
    private String updatedAt;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code org.cloudfoundry.client.v3.processes.Process} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(Process instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code ScaleProcessResponse} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(ScaleProcessResponse instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Copy abstract value type {@code _ScaleProcessResponse} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_ScaleProcessResponse instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    private void from(Object object) {
      if (object instanceof Process) {
        Process instance = (Process) object;
        Integer diskInMbValue = instance.getDiskInMb();
        if (diskInMbValue != null) {
          diskInMb(diskInMbValue);
        }
        String createdAtValue = instance.getCreatedAt();
        if (createdAtValue != null) {
          createdAt(createdAtValue);
        }
        Integer instancesValue = instance.getInstances();
        if (instancesValue != null) {
          instances(instancesValue);
        }
        Integer memoryInMbValue = instance.getMemoryInMb();
        if (memoryInMbValue != null) {
          memoryInMb(memoryInMbValue);
        }
        HealthCheck healthCheckValue = instance.getHealthCheck();
        if (healthCheckValue != null) {
          healthCheck(healthCheckValue);
        }
        Map<String, Link> linksValue = instance.getLinks();
        if (linksValue != null) {
          putAllLinks(linksValue);
        }
        String idValue = instance.getId();
        if (idValue != null) {
          id(idValue);
        }
        List<Integer> portsValue = instance.getPorts();
        if (portsValue != null) {
          addAllPorts(portsValue);
        }
        String typeValue = instance.getType();
        if (typeValue != null) {
          type(typeValue);
        }
        String commandValue = instance.getCommand();
        if (commandValue != null) {
          command(commandValue);
        }
        String updatedAtValue = instance.getUpdatedAt();
        if (updatedAtValue != null) {
          updatedAt(updatedAtValue);
        }
      }
    }

    /**
     * Initializes the value for the {@link _ScaleProcessResponse#getCommand() command} attribute.
     * @param command The value for command (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("command")
    public final Builder command(@Nullable String command) {
      this.command = command;
      return this;
    }

    /**
     * Initializes the value for the {@link _ScaleProcessResponse#getCreatedAt() createdAt} attribute.
     * @param createdAt The value for createdAt (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("created_at")
    public final Builder createdAt(@Nullable String createdAt) {
      this.createdAt = createdAt;
      return this;
    }

    /**
     * Initializes the value for the {@link _ScaleProcessResponse#getDiskInMb() diskInMb} attribute.
     * @param diskInMb The value for diskInMb (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("disk_in_mb")
    public final Builder diskInMb(@Nullable Integer diskInMb) {
      this.diskInMb = diskInMb;
      return this;
    }

    /**
     * Initializes the value for the {@link _ScaleProcessResponse#getHealthCheck() healthCheck} attribute.
     * @param healthCheck The value for healthCheck (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("health_check")
    public final Builder healthCheck(@Nullable HealthCheck healthCheck) {
      this.healthCheck = healthCheck;
      return this;
    }

    /**
     * Initializes the value for the {@link _ScaleProcessResponse#getId() id} attribute.
     * @param id The value for id (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("guid")
    public final Builder id(@Nullable String id) {
      this.id = id;
      return this;
    }

    /**
     * Initializes the value for the {@link _ScaleProcessResponse#getInstances() instances} attribute.
     * @param instances The value for instances (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("instances")
    public final Builder instances(@Nullable Integer instances) {
      this.instances = instances;
      return this;
    }

    /**
     * Put one entry to the {@link _ScaleProcessResponse#getLinks() links} map.
     * @param key The key in the links map
     * @param value The associated value in the links map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder link(String key, Link value) {
      if (this.links == null) {
        this.links = new LinkedHashMap<String, Link>();
      }
      this.links.put(key, value);
      return this;
    }

    /**
     * Put one entry to the {@link _ScaleProcessResponse#getLinks() links} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder link(Map.Entry<String, ? extends Link> entry) {
      if (this.links == null) {
        this.links = new LinkedHashMap<String, Link>();
      }
      String k = entry.getKey();
      Link v = entry.getValue();
      this.links.put(k, v);
      return this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link _ScaleProcessResponse#getLinks() links} map. Nulls are not permitted as keys or values, but parameter itself can be null
     * @param links The entries that will be added to the links map
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("links")
    public final Builder links(@Nullable Map<String, ? extends Link> links) {
      if (links == null) {
        this.links = null;
        return this;
      }
      this.links = new LinkedHashMap<String, Link>();
      return putAllLinks(links);
    }

    /**
     * Put all mappings from the specified map as entries to {@link _ScaleProcessResponse#getLinks() links} map. Nulls are not permitted
     * @param links The entries that will be added to the links map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder putAllLinks(Map<String, ? extends Link> links) {
      if (this.links == null) {
        this.links = new LinkedHashMap<String, Link>();
      }
      for (Map.Entry<String, ? extends Link> entry : links.entrySet()) {
        String k = entry.getKey();
        Link v = entry.getValue();
        this.links.put(k, v);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link _ScaleProcessResponse#getMemoryInMb() memoryInMb} attribute.
     * @param memoryInMb The value for memoryInMb (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("memory_in_mb")
    public final Builder memoryInMb(@Nullable Integer memoryInMb) {
      this.memoryInMb = memoryInMb;
      return this;
    }

    /**
     * Adds one element to {@link _ScaleProcessResponse#getPorts() ports} list.
     * @param element A ports element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder port(int element) {
      if (this.ports == null) {
        this.ports = new ArrayList<Integer>();
      }
      this.ports.add(element);
      return this;
    }

    /**
     * Adds elements to {@link _ScaleProcessResponse#getPorts() ports} list.
     * @param elements An array of ports elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder port(int... elements) {
      if (this.ports == null) {
        this.ports = new ArrayList<Integer>();
      }
      for (int element : elements) {
        this.ports.add(element);
      }
      return this;
    }

    /**
     * Sets or replaces all elements for {@link _ScaleProcessResponse#getPorts() ports} list.
     * @param elements An iterable of ports elements
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("ports")
    public final Builder ports(@Nullable Iterable<Integer> elements) {
      if (elements == null) {
        this.ports = null;
        return this;
      }
      this.ports = new ArrayList<Integer>();
      return addAllPorts(elements);
    }

    /**
     * Adds elements to {@link _ScaleProcessResponse#getPorts() ports} list.
     * @param elements An iterable of ports elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllPorts(Iterable<Integer> elements) {
      Objects.requireNonNull(elements, "ports element");
      if (this.ports == null) {
        this.ports = new ArrayList<Integer>();
      }
      for (int element : elements) {
        this.ports.add(Objects.requireNonNull(element, "ports element"));
      }
      return this;
    }

    /**
     * Initializes the value for the {@link _ScaleProcessResponse#getType() type} attribute.
     * @param type The value for type (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("type")
    public final Builder type(@Nullable String type) {
      this.type = type;
      return this;
    }

    /**
     * Initializes the value for the {@link _ScaleProcessResponse#getUpdatedAt() updatedAt} attribute.
     * @param updatedAt The value for updatedAt (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("updated_at")
    public final Builder updatedAt(@Nullable String updatedAt) {
      this.updatedAt = updatedAt;
      return this;
    }

    /**
     * Builds a new {@link ScaleProcessResponse ScaleProcessResponse}.
     * @return An immutable instance of ScaleProcessResponse
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ScaleProcessResponse build() {
      return new ScaleProcessResponse(this);
    }
  }

  private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
    ArrayList<T> list;
    if (iterable instanceof Collection<?>) {
      int size = ((Collection<?>) iterable).size();
      if (size == 0) return Collections.emptyList();
      list = new ArrayList<T>();
    } else {
      list = new ArrayList<T>();
    }
    for (T element : iterable) {
      if (skipNulls && element == null) continue;
      if (checkNulls) Objects.requireNonNull(element, "element");
      list.add(element);
    }
    return list;
  }

  private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
    switch(list.size()) {
    case 0: return Collections.emptyList();
    case 1: return Collections.singletonList(list.get(0));
    default:
      if (clone) {
        return Collections.unmodifiableList(new ArrayList<T>(list));
      } else {
        if (list instanceof ArrayList<?>) {
          ((ArrayList<?>) list).trimToSize();
        }
        return Collections.unmodifiableList(list);
      }
    }
  }

  private static <K, V> Map<K, V> createUnmodifiableMap(boolean checkNulls, boolean skipNulls, Map<? extends K, ? extends V> map) {
    switch (map.size()) {
    case 0: return Collections.emptyMap();
    case 1: {
      Map.Entry<? extends K, ? extends V> e = map.entrySet().iterator().next();
      K k = e.getKey();
      V v = e.getValue();
      if (checkNulls) {
        Objects.requireNonNull(k, "key");
        Objects.requireNonNull(v, "value");
      }
      if (skipNulls && (k == null || v == null)) {
        return Collections.emptyMap();
      }
      return Collections.singletonMap(k, v);
    }
    default: {
      Map<K, V> linkedMap = new LinkedHashMap<K, V>(map.size());
      if (skipNulls || checkNulls) {
        for (Map.Entry<? extends K, ? extends V> e : map.entrySet()) {
          K k = e.getKey();
          V v = e.getValue();
          if (skipNulls) {
            if (k == null || v == null) continue;
          } else if (checkNulls) {
            Objects.requireNonNull(k, "key");
            Objects.requireNonNull(v, "value");
          }
          linkedMap.put(k, v);
        }
      } else {
        linkedMap.putAll(map);
      }
      return Collections.unmodifiableMap(linkedMap);
    }
    }
  }
}
