package org.cloudfoundry.client.v3.servicebindings;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Generated;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.client.v3.Link;

/**
 * The response payload for Create Service Binding
 */
@SuppressWarnings({"all"})
@Generated({"Immutables.generator", "_CreateServiceBindingResponse"})
public final class CreateServiceBindingResponse
    extends org.cloudfoundry.client.v3.servicebindings._CreateServiceBindingResponse {
  private final @Nullable String createdAt;
  private final @Nullable ServiceBindingData data;
  private final @Nullable String id;
  private final @Nullable Map<String, Link> links;
  private final @Nullable String type;
  private final @Nullable String updatedAt;

  private CreateServiceBindingResponse(CreateServiceBindingResponse.Builder builder) {
    this.createdAt = builder.createdAt;
    this.data = builder.data;
    this.id = builder.id;
    this.links = builder.links == null ? null : createUnmodifiableMap(false, false, builder.links);
    this.type = builder.type;
    this.updatedAt = builder.updatedAt;
  }

  /**
   * The created at
   */
  @JsonProperty("created_at")
  @Override
  public @Nullable String getCreatedAt() {
    return createdAt;
  }

  /**
   * The datas
   */
  @JsonProperty("data")
  @Override
  public @Nullable ServiceBindingData getData() {
    return data;
  }

  /**
   * The id
   */
  @JsonProperty("guid")
  @Override
  public @Nullable String getId() {
    return id;
  }

  /**
   * The links
   */
  @JsonProperty("links")
  @Override
  public @Nullable Map<String, Link> getLinks() {
    return links;
  }

  /**
   * The type
   */
  @JsonProperty("type")
  @Override
  public @Nullable String getType() {
    return type;
  }

  /**
   * The updated at
   */
  @JsonProperty("updated_at")
  @Override
  public @Nullable String getUpdatedAt() {
    return updatedAt;
  }

  /**
   * This instance is equal to all instances of {@code CreateServiceBindingResponse} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof CreateServiceBindingResponse
        && equalTo((CreateServiceBindingResponse) another);
  }

  private boolean equalTo(CreateServiceBindingResponse another) {
    return Objects.equals(createdAt, another.createdAt)
        && Objects.equals(data, another.data)
        && Objects.equals(id, another.id)
        && Objects.equals(links, another.links)
        && Objects.equals(type, another.type)
        && Objects.equals(updatedAt, another.updatedAt);
  }

  /**
   * Computes a hash code from attributes: {@code createdAt}, {@code data}, {@code id}, {@code links}, {@code type}, {@code updatedAt}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + Objects.hashCode(createdAt);
    h += (h << 5) + Objects.hashCode(data);
    h += (h << 5) + Objects.hashCode(id);
    h += (h << 5) + Objects.hashCode(links);
    h += (h << 5) + Objects.hashCode(type);
    h += (h << 5) + Objects.hashCode(updatedAt);
    return h;
  }

  /**
   * Prints the immutable value {@code CreateServiceBindingResponse} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "CreateServiceBindingResponse{"
        + "createdAt=" + createdAt
        + ", data=" + data
        + ", id=" + id
        + ", links=" + links
        + ", type=" + type
        + ", updatedAt=" + updatedAt
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json extends org.cloudfoundry.client.v3.servicebindings._CreateServiceBindingResponse {
    String createdAt;
    ServiceBindingData data;
    String id;
    Map<String, Link> links;
    String type;
    String updatedAt;
    @JsonProperty("created_at")
    public void setCreatedAt(@Nullable String createdAt) {
      this.createdAt = createdAt;
    }
    @JsonProperty("data")
    public void setData(@Nullable ServiceBindingData data) {
      this.data = data;
    }
    @JsonProperty("guid")
    public void setId(@Nullable String id) {
      this.id = id;
    }
    @JsonProperty("links")
    public void setLinks(@Nullable Map<String, Link> links) {
      this.links = links;
    }
    @JsonProperty("type")
    public void setType(@Nullable String type) {
      this.type = type;
    }
    @JsonProperty("updated_at")
    public void setUpdatedAt(@Nullable String updatedAt) {
      this.updatedAt = updatedAt;
    }
    @Override
    public String getCreatedAt() { throw new UnsupportedOperationException(); }
    @Override
    public ServiceBindingData getData() { throw new UnsupportedOperationException(); }
    @Override
    public String getId() { throw new UnsupportedOperationException(); }
    @Override
    public Map<String, Link> getLinks() { throw new UnsupportedOperationException(); }
    @Override
    public String getType() { throw new UnsupportedOperationException(); }
    @Override
    public String getUpdatedAt() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static CreateServiceBindingResponse fromJson(Json json) {
    CreateServiceBindingResponse.Builder builder = CreateServiceBindingResponse.builder();
    if (json.createdAt != null) {
      builder.createdAt(json.createdAt);
    }
    if (json.data != null) {
      builder.data(json.data);
    }
    if (json.id != null) {
      builder.id(json.id);
    }
    if (json.links != null) {
      builder.putAllLinks(json.links);
    }
    if (json.type != null) {
      builder.type(json.type);
    }
    if (json.updatedAt != null) {
      builder.updatedAt(json.updatedAt);
    }
    return builder.build();
  }

  /**
   * Creates a builder for {@link CreateServiceBindingResponse CreateServiceBindingResponse}.
   * @return A new CreateServiceBindingResponse builder
   */
  public static CreateServiceBindingResponse.Builder builder() {
    return new CreateServiceBindingResponse.Builder();
  }

  /**
   * Builds instances of type {@link CreateServiceBindingResponse CreateServiceBindingResponse}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  public static final class Builder {
    private String createdAt;
    private ServiceBindingData data;
    private String id;
    private Map<String, Link> links = null;
    private String type;
    private String updatedAt;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code org.cloudfoundry.client.v3.servicebindings.ServiceBinding} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(ServiceBinding instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code CreateServiceBindingResponse} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(CreateServiceBindingResponse instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Copy abstract value type {@code _CreateServiceBindingResponse} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_CreateServiceBindingResponse instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    private void from(Object object) {
      if (object instanceof ServiceBinding) {
        ServiceBinding instance = (ServiceBinding) object;
        String createdAtValue = instance.getCreatedAt();
        if (createdAtValue != null) {
          createdAt(createdAtValue);
        }
        Map<String, Link> linksValue = instance.getLinks();
        if (linksValue != null) {
          putAllLinks(linksValue);
        }
        String idValue = instance.getId();
        if (idValue != null) {
          id(idValue);
        }
        ServiceBindingData dataValue = instance.getData();
        if (dataValue != null) {
          data(dataValue);
        }
        String typeValue = instance.getType();
        if (typeValue != null) {
          type(typeValue);
        }
        String updatedAtValue = instance.getUpdatedAt();
        if (updatedAtValue != null) {
          updatedAt(updatedAtValue);
        }
      }
    }

    /**
     * Initializes the value for the {@link _CreateServiceBindingResponse#getCreatedAt() createdAt} attribute.
     * @param createdAt The value for createdAt (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("created_at")
    public final Builder createdAt(@Nullable String createdAt) {
      this.createdAt = createdAt;
      return this;
    }

    /**
     * Initializes the value for the {@link _CreateServiceBindingResponse#getData() data} attribute.
     * @param data The value for data (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("data")
    public final Builder data(@Nullable ServiceBindingData data) {
      this.data = data;
      return this;
    }

    /**
     * Initializes the value for the {@link _CreateServiceBindingResponse#getId() id} attribute.
     * @param id The value for id (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("guid")
    public final Builder id(@Nullable String id) {
      this.id = id;
      return this;
    }

    /**
     * Put one entry to the {@link _CreateServiceBindingResponse#getLinks() links} map.
     * @param key The key in the links map
     * @param value The associated value in the links map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder link(String key, Link value) {
      if (this.links == null) {
        this.links = new LinkedHashMap<String, Link>();
      }
      this.links.put(key, value);
      return this;
    }

    /**
     * Put one entry to the {@link _CreateServiceBindingResponse#getLinks() links} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder link(Map.Entry<String, ? extends Link> entry) {
      if (this.links == null) {
        this.links = new LinkedHashMap<String, Link>();
      }
      String k = entry.getKey();
      Link v = entry.getValue();
      this.links.put(k, v);
      return this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link _CreateServiceBindingResponse#getLinks() links} map. Nulls are not permitted as keys or values, but parameter itself can be null
     * @param links The entries that will be added to the links map
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("links")
    public final Builder links(@Nullable Map<String, ? extends Link> links) {
      if (links == null) {
        this.links = null;
        return this;
      }
      this.links = new LinkedHashMap<String, Link>();
      return putAllLinks(links);
    }

    /**
     * Put all mappings from the specified map as entries to {@link _CreateServiceBindingResponse#getLinks() links} map. Nulls are not permitted
     * @param links The entries that will be added to the links map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder putAllLinks(Map<String, ? extends Link> links) {
      if (this.links == null) {
        this.links = new LinkedHashMap<String, Link>();
      }
      for (Map.Entry<String, ? extends Link> entry : links.entrySet()) {
        String k = entry.getKey();
        Link v = entry.getValue();
        this.links.put(k, v);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link _CreateServiceBindingResponse#getType() type} attribute.
     * @param type The value for type (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("type")
    public final Builder type(@Nullable String type) {
      this.type = type;
      return this;
    }

    /**
     * Initializes the value for the {@link _CreateServiceBindingResponse#getUpdatedAt() updatedAt} attribute.
     * @param updatedAt The value for updatedAt (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("updated_at")
    public final Builder updatedAt(@Nullable String updatedAt) {
      this.updatedAt = updatedAt;
      return this;
    }

    /**
     * Builds a new {@link CreateServiceBindingResponse CreateServiceBindingResponse}.
     * @return An immutable instance of CreateServiceBindingResponse
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public CreateServiceBindingResponse build() {
      return new CreateServiceBindingResponse(this);
    }
  }

  private static <K, V> Map<K, V> createUnmodifiableMap(boolean checkNulls, boolean skipNulls, Map<? extends K, ? extends V> map) {
    switch (map.size()) {
    case 0: return Collections.emptyMap();
    case 1: {
      Map.Entry<? extends K, ? extends V> e = map.entrySet().iterator().next();
      K k = e.getKey();
      V v = e.getValue();
      if (checkNulls) {
        Objects.requireNonNull(k, "key");
        Objects.requireNonNull(v, "value");
      }
      if (skipNulls && (k == null || v == null)) {
        return Collections.emptyMap();
      }
      return Collections.singletonMap(k, v);
    }
    default: {
      Map<K, V> linkedMap = new LinkedHashMap<K, V>(map.size());
      if (skipNulls || checkNulls) {
        for (Map.Entry<? extends K, ? extends V> e : map.entrySet()) {
          K k = e.getKey();
          V v = e.getValue();
          if (skipNulls) {
            if (k == null || v == null) continue;
          } else if (checkNulls) {
            Objects.requireNonNull(k, "key");
            Objects.requireNonNull(v, "value");
          }
          linkedMap.put(k, v);
        }
      } else {
        linkedMap.putAll(map);
      }
      return Collections.unmodifiableMap(linkedMap);
    }
    }
  }
}
