package org.cloudfoundry.client.v3.servicebindings;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Generated;
import org.cloudfoundry.client.v3.Relationship;

/**
 * The relationships for the Create Service Binding request
 */
@SuppressWarnings({"all"})
@Generated({"Immutables.generator", "_Relationships"})
public final class Relationships extends org.cloudfoundry.client.v3.servicebindings._Relationships {
  private final Relationship application;
  private final Relationship serviceInstance;

  private Relationships(Relationships.Builder builder) {
    this.application = builder.application;
    this.serviceInstance = builder.serviceInstance;
  }

  /**
   * The application relationship
   */
  @Override
  public Relationship getApplication() {
    return application;
  }

  /**
   * The service instance relationship
   */
  @Override
  public Relationship getServiceInstance() {
    return serviceInstance;
  }

  /**
   * This instance is equal to all instances of {@code Relationships} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof Relationships
        && equalTo((Relationships) another);
  }

  private boolean equalTo(Relationships another) {
    return application.equals(another.application)
        && serviceInstance.equals(another.serviceInstance);
  }

  /**
   * Computes a hash code from attributes: {@code application}, {@code serviceInstance}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + application.hashCode();
    h += (h << 5) + serviceInstance.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code Relationships} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "Relationships{"
        + "application=" + application
        + ", serviceInstance=" + serviceInstance
        + "}";
  }

  /**
   * Creates a builder for {@link Relationships Relationships}.
   * @return A new Relationships builder
   */
  public static Relationships.Builder builder() {
    return new Relationships.Builder();
  }

  /**
   * Builds instances of type {@link Relationships Relationships}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  public static final class Builder {
    private static final long INIT_BIT_APPLICATION = 0x1L;
    private static final long INIT_BIT_SERVICE_INSTANCE = 0x2L;
    private long initBits = 0x3L;

    private Relationship application;
    private Relationship serviceInstance;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code Relationships} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(Relationships instance) {
      return from((_Relationships) instance);
    }

    /**
     * Copy abstract value type {@code _Relationships} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_Relationships instance) {
      Objects.requireNonNull(instance, "instance");
      application(instance.getApplication());
      serviceInstance(instance.getServiceInstance());
      return this;
    }

    /**
     * Initializes the value for the {@link _Relationships#getApplication() application} attribute.
     * @param application The value for application 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder application(Relationship application) {
      this.application = Objects.requireNonNull(application, "application");
      initBits &= ~INIT_BIT_APPLICATION;
      return this;
    }

    /**
     * Initializes the value for the {@link _Relationships#getServiceInstance() serviceInstance} attribute.
     * @param serviceInstance The value for serviceInstance 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder serviceInstance(Relationship serviceInstance) {
      this.serviceInstance = Objects.requireNonNull(serviceInstance, "serviceInstance");
      initBits &= ~INIT_BIT_SERVICE_INSTANCE;
      return this;
    }

    /**
     * Builds a new {@link Relationships Relationships}.
     * @return An immutable instance of Relationships
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public Relationships build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new Relationships(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<String>();
      if ((initBits & INIT_BIT_APPLICATION) != 0) attributes.add("application");
      if ((initBits & INIT_BIT_SERVICE_INSTANCE) != 0) attributes.add("serviceInstance");
      return "Cannot build Relationships, some of required attributes are not set " + attributes;
    }
  }
}
