package org.cloudfoundry.client.v3.spaces;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Generated;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.client.v3.Relationship;

/**
 * The request payload for the Assign Isolation Segment operation
 */
@SuppressWarnings({"all"})
@Generated({"Immutables.generator", "_AssignSpaceIsolationSegmentRequest"})
public final class AssignSpaceIsolationSegmentRequest
    extends org.cloudfoundry.client.v3.spaces._AssignSpaceIsolationSegmentRequest {
  private final @Nullable Relationship data;
  private final String spaceId;

  private AssignSpaceIsolationSegmentRequest(AssignSpaceIsolationSegmentRequest.Builder builder) {
    this.data = builder.data;
    this.spaceId = builder.spaceId;
  }

  /**
   * The isolation segment to assign
   */
  @Override
  public @Nullable Relationship getData() {
    return data;
  }

  /**
   * The space id
   */
  @Override
  public String getSpaceId() {
    return spaceId;
  }

  /**
   * This instance is equal to all instances of {@code AssignSpaceIsolationSegmentRequest} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof AssignSpaceIsolationSegmentRequest
        && equalTo((AssignSpaceIsolationSegmentRequest) another);
  }

  private boolean equalTo(AssignSpaceIsolationSegmentRequest another) {
    return Objects.equals(data, another.data)
        && spaceId.equals(another.spaceId);
  }

  /**
   * Computes a hash code from attributes: {@code data}, {@code spaceId}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + Objects.hashCode(data);
    h += (h << 5) + spaceId.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code AssignSpaceIsolationSegmentRequest} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "AssignSpaceIsolationSegmentRequest{"
        + "data=" + data
        + ", spaceId=" + spaceId
        + "}";
  }

  /**
   * Creates a builder for {@link AssignSpaceIsolationSegmentRequest AssignSpaceIsolationSegmentRequest}.
   * @return A new AssignSpaceIsolationSegmentRequest builder
   */
  public static AssignSpaceIsolationSegmentRequest.Builder builder() {
    return new AssignSpaceIsolationSegmentRequest.Builder();
  }

  /**
   * Builds instances of type {@link AssignSpaceIsolationSegmentRequest AssignSpaceIsolationSegmentRequest}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  public static final class Builder {
    private static final long INIT_BIT_SPACE_ID = 0x1L;
    private long initBits = 0x1L;

    private Relationship data;
    private String spaceId;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code AssignSpaceIsolationSegmentRequest} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(AssignSpaceIsolationSegmentRequest instance) {
      return from((_AssignSpaceIsolationSegmentRequest) instance);
    }

    /**
     * Copy abstract value type {@code _AssignSpaceIsolationSegmentRequest} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_AssignSpaceIsolationSegmentRequest instance) {
      Objects.requireNonNull(instance, "instance");
      Relationship dataValue = instance.getData();
      if (dataValue != null) {
        data(dataValue);
      }
      spaceId(instance.getSpaceId());
      return this;
    }

    /**
     * Initializes the value for the {@link _AssignSpaceIsolationSegmentRequest#getData() data} attribute.
     * @param data The value for data (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder data(@Nullable Relationship data) {
      this.data = data;
      return this;
    }

    /**
     * Initializes the value for the {@link _AssignSpaceIsolationSegmentRequest#getSpaceId() spaceId} attribute.
     * @param spaceId The value for spaceId 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder spaceId(String spaceId) {
      this.spaceId = Objects.requireNonNull(spaceId, "spaceId");
      initBits &= ~INIT_BIT_SPACE_ID;
      return this;
    }

    /**
     * Builds a new {@link AssignSpaceIsolationSegmentRequest AssignSpaceIsolationSegmentRequest}.
     * @return An immutable instance of AssignSpaceIsolationSegmentRequest
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public AssignSpaceIsolationSegmentRequest build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new AssignSpaceIsolationSegmentRequest(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<String>();
      if ((initBits & INIT_BIT_SPACE_ID) != 0) attributes.add("spaceId");
      return "Cannot build AssignSpaceIsolationSegmentRequest, some of required attributes are not set " + attributes;
    }
  }
}
