package org.cloudfoundry.client.v3.spaces;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Generated;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.client.v3.Link;
import org.cloudfoundry.client.v3.Relationship;

/**
 * The response payload for the Get Isolation Segment operation
 */
@SuppressWarnings({"all"})
@Generated({"Immutables.generator", "_GetSpaceIsolationSegmentResponse"})
public final class GetSpaceIsolationSegmentResponse
    extends org.cloudfoundry.client.v3.spaces._GetSpaceIsolationSegmentResponse {
  private final @Nullable Relationship data;
  private final @Nullable Map<String, Link> links;

  private GetSpaceIsolationSegmentResponse(GetSpaceIsolationSegmentResponse.Builder builder) {
    this.data = builder.data;
    this.links = builder.links == null ? null : createUnmodifiableMap(false, false, builder.links);
  }

  /**
   * The isolation segment
   */
  @JsonProperty("data")
  @Override
  public @Nullable Relationship getData() {
    return data;
  }

  /**
   * The links
   */
  @JsonProperty("links")
  @Override
  public @Nullable Map<String, Link> getLinks() {
    return links;
  }

  /**
   * This instance is equal to all instances of {@code GetSpaceIsolationSegmentResponse} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof GetSpaceIsolationSegmentResponse
        && equalTo((GetSpaceIsolationSegmentResponse) another);
  }

  private boolean equalTo(GetSpaceIsolationSegmentResponse another) {
    return Objects.equals(data, another.data)
        && Objects.equals(links, another.links);
  }

  /**
   * Computes a hash code from attributes: {@code data}, {@code links}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + Objects.hashCode(data);
    h += (h << 5) + Objects.hashCode(links);
    return h;
  }

  /**
   * Prints the immutable value {@code GetSpaceIsolationSegmentResponse} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "GetSpaceIsolationSegmentResponse{"
        + "data=" + data
        + ", links=" + links
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json extends org.cloudfoundry.client.v3.spaces._GetSpaceIsolationSegmentResponse {
    Relationship data;
    Map<String, Link> links;
    @JsonProperty("data")
    public void setData(@Nullable Relationship data) {
      this.data = data;
    }
    @JsonProperty("links")
    public void setLinks(@Nullable Map<String, Link> links) {
      this.links = links;
    }
    @Override
    public Relationship getData() { throw new UnsupportedOperationException(); }
    @Override
    public Map<String, Link> getLinks() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static GetSpaceIsolationSegmentResponse fromJson(Json json) {
    GetSpaceIsolationSegmentResponse.Builder builder = GetSpaceIsolationSegmentResponse.builder();
    if (json.data != null) {
      builder.data(json.data);
    }
    if (json.links != null) {
      builder.putAllLinks(json.links);
    }
    return builder.build();
  }

  /**
   * Creates a builder for {@link GetSpaceIsolationSegmentResponse GetSpaceIsolationSegmentResponse}.
   * @return A new GetSpaceIsolationSegmentResponse builder
   */
  public static GetSpaceIsolationSegmentResponse.Builder builder() {
    return new GetSpaceIsolationSegmentResponse.Builder();
  }

  /**
   * Builds instances of type {@link GetSpaceIsolationSegmentResponse GetSpaceIsolationSegmentResponse}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  public static final class Builder {
    private Relationship data;
    private Map<String, Link> links = null;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code GetSpaceIsolationSegmentResponse} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(GetSpaceIsolationSegmentResponse instance) {
      return from((_GetSpaceIsolationSegmentResponse) instance);
    }

    /**
     * Copy abstract value type {@code _GetSpaceIsolationSegmentResponse} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_GetSpaceIsolationSegmentResponse instance) {
      Objects.requireNonNull(instance, "instance");
      Relationship dataValue = instance.getData();
      if (dataValue != null) {
        data(dataValue);
      }
      Map<String, Link> linksValue = instance.getLinks();
      if (linksValue != null) {
        putAllLinks(linksValue);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link _GetSpaceIsolationSegmentResponse#getData() data} attribute.
     * @param data The value for data (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("data")
    public final Builder data(@Nullable Relationship data) {
      this.data = data;
      return this;
    }

    /**
     * Put one entry to the {@link _GetSpaceIsolationSegmentResponse#getLinks() links} map.
     * @param key The key in the links map
     * @param value The associated value in the links map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder link(String key, Link value) {
      if (this.links == null) {
        this.links = new LinkedHashMap<String, Link>();
      }
      this.links.put(key, value);
      return this;
    }

    /**
     * Put one entry to the {@link _GetSpaceIsolationSegmentResponse#getLinks() links} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder link(Map.Entry<String, ? extends Link> entry) {
      if (this.links == null) {
        this.links = new LinkedHashMap<String, Link>();
      }
      String k = entry.getKey();
      Link v = entry.getValue();
      this.links.put(k, v);
      return this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link _GetSpaceIsolationSegmentResponse#getLinks() links} map. Nulls are not permitted as keys or values, but parameter itself can be null
     * @param links The entries that will be added to the links map
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("links")
    public final Builder links(@Nullable Map<String, ? extends Link> links) {
      if (links == null) {
        this.links = null;
        return this;
      }
      this.links = new LinkedHashMap<String, Link>();
      return putAllLinks(links);
    }

    /**
     * Put all mappings from the specified map as entries to {@link _GetSpaceIsolationSegmentResponse#getLinks() links} map. Nulls are not permitted
     * @param links The entries that will be added to the links map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder putAllLinks(Map<String, ? extends Link> links) {
      if (this.links == null) {
        this.links = new LinkedHashMap<String, Link>();
      }
      for (Map.Entry<String, ? extends Link> entry : links.entrySet()) {
        String k = entry.getKey();
        Link v = entry.getValue();
        this.links.put(k, v);
      }
      return this;
    }

    /**
     * Builds a new {@link GetSpaceIsolationSegmentResponse GetSpaceIsolationSegmentResponse}.
     * @return An immutable instance of GetSpaceIsolationSegmentResponse
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public GetSpaceIsolationSegmentResponse build() {
      return new GetSpaceIsolationSegmentResponse(this);
    }
  }

  private static <K, V> Map<K, V> createUnmodifiableMap(boolean checkNulls, boolean skipNulls, Map<? extends K, ? extends V> map) {
    switch (map.size()) {
    case 0: return Collections.emptyMap();
    case 1: {
      Map.Entry<? extends K, ? extends V> e = map.entrySet().iterator().next();
      K k = e.getKey();
      V v = e.getValue();
      if (checkNulls) {
        Objects.requireNonNull(k, "key");
        Objects.requireNonNull(v, "value");
      }
      if (skipNulls && (k == null || v == null)) {
        return Collections.emptyMap();
      }
      return Collections.singletonMap(k, v);
    }
    default: {
      Map<K, V> linkedMap = new LinkedHashMap<K, V>(map.size());
      if (skipNulls || checkNulls) {
        for (Map.Entry<? extends K, ? extends V> e : map.entrySet()) {
          K k = e.getKey();
          V v = e.getValue();
          if (skipNulls) {
            if (k == null || v == null) continue;
          } else if (checkNulls) {
            Objects.requireNonNull(k, "key");
            Objects.requireNonNull(v, "value");
          }
          linkedMap.put(k, v);
        }
      } else {
        linkedMap.putAll(map);
      }
      return Collections.unmodifiableMap(linkedMap);
    }
    }
  }
}
