package org.cloudfoundry.client.v3.tasks;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Generated;
import org.cloudfoundry.Nullable;

/**
 * The request payload for the Create Task endpoint
 */
@SuppressWarnings({"all"})
@Generated({"Immutables.generator", "_CreateTaskRequest"})
public final class CreateTaskRequest extends org.cloudfoundry.client.v3.tasks._CreateTaskRequest {
  private final String applicationId;
  private final String command;
  private final @Nullable String dropletId;
  private final @Nullable Map<String, String> environmentVariables;
  private final @Nullable Integer memoryInMb;
  private final String name;

  private CreateTaskRequest(CreateTaskRequest.Builder builder) {
    this.applicationId = builder.applicationId;
    this.command = builder.command;
    this.dropletId = builder.dropletId;
    this.environmentVariables = builder.environmentVariables == null ? null : createUnmodifiableMap(false, false, builder.environmentVariables);
    this.memoryInMb = builder.memoryInMb;
    this.name = builder.name;
  }

  /**
   * The application id
   */
  @Override
  public String getApplicationId() {
    return applicationId;
  }

  /**
   * The command
   */
  @Override
  public String getCommand() {
    return command;
  }

  /**
   * The droplet id
   */
  @Override
  public @Nullable String getDropletId() {
    return dropletId;
  }

  /**
   * The environment variables
   */
  @Override
  public @Nullable Map<String, String> getEnvironmentVariables() {
    return environmentVariables;
  }

  /**
   * The memoryInMb
   */
  @Override
  public @Nullable Integer getMemoryInMb() {
    return memoryInMb;
  }

  /**
   * The name
   */
  @Override
  public String getName() {
    return name;
  }

  /**
   * This instance is equal to all instances of {@code CreateTaskRequest} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof CreateTaskRequest
        && equalTo((CreateTaskRequest) another);
  }

  private boolean equalTo(CreateTaskRequest another) {
    return applicationId.equals(another.applicationId)
        && command.equals(another.command)
        && Objects.equals(dropletId, another.dropletId)
        && Objects.equals(environmentVariables, another.environmentVariables)
        && Objects.equals(memoryInMb, another.memoryInMb)
        && name.equals(another.name);
  }

  /**
   * Computes a hash code from attributes: {@code applicationId}, {@code command}, {@code dropletId}, {@code environmentVariables}, {@code memoryInMb}, {@code name}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + applicationId.hashCode();
    h += (h << 5) + command.hashCode();
    h += (h << 5) + Objects.hashCode(dropletId);
    h += (h << 5) + Objects.hashCode(environmentVariables);
    h += (h << 5) + Objects.hashCode(memoryInMb);
    h += (h << 5) + name.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code CreateTaskRequest} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "CreateTaskRequest{"
        + "applicationId=" + applicationId
        + ", command=" + command
        + ", dropletId=" + dropletId
        + ", environmentVariables=" + environmentVariables
        + ", memoryInMb=" + memoryInMb
        + ", name=" + name
        + "}";
  }

  /**
   * Creates a builder for {@link CreateTaskRequest CreateTaskRequest}.
   * @return A new CreateTaskRequest builder
   */
  public static CreateTaskRequest.Builder builder() {
    return new CreateTaskRequest.Builder();
  }

  /**
   * Builds instances of type {@link CreateTaskRequest CreateTaskRequest}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  public static final class Builder {
    private static final long INIT_BIT_APPLICATION_ID = 0x1L;
    private static final long INIT_BIT_COMMAND = 0x2L;
    private static final long INIT_BIT_NAME = 0x4L;
    private long initBits = 0x7L;

    private String applicationId;
    private String command;
    private String dropletId;
    private Map<String, String> environmentVariables = null;
    private Integer memoryInMb;
    private String name;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code CreateTaskRequest} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(CreateTaskRequest instance) {
      return from((_CreateTaskRequest) instance);
    }

    /**
     * Copy abstract value type {@code _CreateTaskRequest} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_CreateTaskRequest instance) {
      Objects.requireNonNull(instance, "instance");
      applicationId(instance.getApplicationId());
      command(instance.getCommand());
      String dropletIdValue = instance.getDropletId();
      if (dropletIdValue != null) {
        dropletId(dropletIdValue);
      }
      Map<String, String> environmentVariablesValue = instance.getEnvironmentVariables();
      if (environmentVariablesValue != null) {
        putAllEnvironmentVariables(environmentVariablesValue);
      }
      Integer memoryInMbValue = instance.getMemoryInMb();
      if (memoryInMbValue != null) {
        memoryInMb(memoryInMbValue);
      }
      name(instance.getName());
      return this;
    }

    /**
     * Initializes the value for the {@link _CreateTaskRequest#getApplicationId() applicationId} attribute.
     * @param applicationId The value for applicationId 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder applicationId(String applicationId) {
      this.applicationId = Objects.requireNonNull(applicationId, "applicationId");
      initBits &= ~INIT_BIT_APPLICATION_ID;
      return this;
    }

    /**
     * Initializes the value for the {@link _CreateTaskRequest#getCommand() command} attribute.
     * @param command The value for command 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder command(String command) {
      this.command = Objects.requireNonNull(command, "command");
      initBits &= ~INIT_BIT_COMMAND;
      return this;
    }

    /**
     * Initializes the value for the {@link _CreateTaskRequest#getDropletId() dropletId} attribute.
     * @param dropletId The value for dropletId (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder dropletId(@Nullable String dropletId) {
      this.dropletId = dropletId;
      return this;
    }

    /**
     * Put one entry to the {@link _CreateTaskRequest#getEnvironmentVariables() environmentVariables} map.
     * @param key The key in the environmentVariables map
     * @param value The associated value in the environmentVariables map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder environmentVariable(String key, String value) {
      if (this.environmentVariables == null) {
        this.environmentVariables = new LinkedHashMap<String, String>();
      }
      this.environmentVariables.put(key, value);
      return this;
    }

    /**
     * Put one entry to the {@link _CreateTaskRequest#getEnvironmentVariables() environmentVariables} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder environmentVariable(Map.Entry<String, ? extends String> entry) {
      if (this.environmentVariables == null) {
        this.environmentVariables = new LinkedHashMap<String, String>();
      }
      String k = entry.getKey();
      String v = entry.getValue();
      this.environmentVariables.put(k, v);
      return this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link _CreateTaskRequest#getEnvironmentVariables() environmentVariables} map. Nulls are not permitted as keys or values, but parameter itself can be null
     * @param environmentVariables The entries that will be added to the environmentVariables map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder environmentVariables(@Nullable Map<String, ? extends String> environmentVariables) {
      if (environmentVariables == null) {
        this.environmentVariables = null;
        return this;
      }
      this.environmentVariables = new LinkedHashMap<String, String>();
      return putAllEnvironmentVariables(environmentVariables);
    }

    /**
     * Put all mappings from the specified map as entries to {@link _CreateTaskRequest#getEnvironmentVariables() environmentVariables} map. Nulls are not permitted
     * @param environmentVariables The entries that will be added to the environmentVariables map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder putAllEnvironmentVariables(Map<String, ? extends String> environmentVariables) {
      if (this.environmentVariables == null) {
        this.environmentVariables = new LinkedHashMap<String, String>();
      }
      for (Map.Entry<String, ? extends String> entry : environmentVariables.entrySet()) {
        String k = entry.getKey();
        String v = entry.getValue();
        this.environmentVariables.put(k, v);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link _CreateTaskRequest#getMemoryInMb() memoryInMb} attribute.
     * @param memoryInMb The value for memoryInMb (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder memoryInMb(@Nullable Integer memoryInMb) {
      this.memoryInMb = memoryInMb;
      return this;
    }

    /**
     * Initializes the value for the {@link _CreateTaskRequest#getName() name} attribute.
     * @param name The value for name 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder name(String name) {
      this.name = Objects.requireNonNull(name, "name");
      initBits &= ~INIT_BIT_NAME;
      return this;
    }

    /**
     * Builds a new {@link CreateTaskRequest CreateTaskRequest}.
     * @return An immutable instance of CreateTaskRequest
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public CreateTaskRequest build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new CreateTaskRequest(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<String>();
      if ((initBits & INIT_BIT_APPLICATION_ID) != 0) attributes.add("applicationId");
      if ((initBits & INIT_BIT_COMMAND) != 0) attributes.add("command");
      if ((initBits & INIT_BIT_NAME) != 0) attributes.add("name");
      return "Cannot build CreateTaskRequest, some of required attributes are not set " + attributes;
    }
  }

  private static <K, V> Map<K, V> createUnmodifiableMap(boolean checkNulls, boolean skipNulls, Map<? extends K, ? extends V> map) {
    switch (map.size()) {
    case 0: return Collections.emptyMap();
    case 1: {
      Map.Entry<? extends K, ? extends V> e = map.entrySet().iterator().next();
      K k = e.getKey();
      V v = e.getValue();
      if (checkNulls) {
        Objects.requireNonNull(k, "key");
        Objects.requireNonNull(v, "value");
      }
      if (skipNulls && (k == null || v == null)) {
        return Collections.emptyMap();
      }
      return Collections.singletonMap(k, v);
    }
    default: {
      Map<K, V> linkedMap = new LinkedHashMap<K, V>(map.size());
      if (skipNulls || checkNulls) {
        for (Map.Entry<? extends K, ? extends V> e : map.entrySet()) {
          K k = e.getKey();
          V v = e.getValue();
          if (skipNulls) {
            if (k == null || v == null) continue;
          } else if (checkNulls) {
            Objects.requireNonNull(k, "key");
            Objects.requireNonNull(v, "value");
          }
          linkedMap.put(k, v);
        }
      } else {
        linkedMap.putAll(map);
      }
      return Collections.unmodifiableMap(linkedMap);
    }
    }
  }
}
