// Code generated by Wire protocol buffer compiler, do not edit.
// Source file: metric.proto at 9:1
package org.cloudfoundry.dropsonde.events;

import com.squareup.wire.FieldEncoding;
import com.squareup.wire.Message;
import com.squareup.wire.ProtoAdapter;
import com.squareup.wire.ProtoReader;
import com.squareup.wire.ProtoWriter;
import com.squareup.wire.WireField;
import com.squareup.wire.internal.Internal;
import java.io.IOException;
import java.lang.Double;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import okio.ByteString;

/**
 * / A ValueMetric indicates the value of a metric at an instant in time.
 */
public final class ValueMetric extends Message<ValueMetric, ValueMetric.Builder> {
  public static final ProtoAdapter<ValueMetric> ADAPTER = new ProtoAdapter_ValueMetric();

  private static final long serialVersionUID = 0L;

  public static final String DEFAULT_NAME = "";

  public static final Double DEFAULT_VALUE = 0.0d;

  public static final String DEFAULT_UNIT = "";

  /**
   * / Name of the metric. Must be consistent for downstream consumers to associate events semantically.
   */
  @WireField(
      tag = 1,
      adapter = "com.squareup.wire.ProtoAdapter#STRING",
      label = WireField.Label.REQUIRED
  )
  public final String name;

  /**
   * / Value at the time of event emission.
   */
  @WireField(
      tag = 2,
      adapter = "com.squareup.wire.ProtoAdapter#DOUBLE",
      label = WireField.Label.REQUIRED
  )
  public final Double value;

  /**
   * / Unit of the metric. Please see http://metrics20.org/spec/#units for ideas; SI units/prefixes are recommended where applicable. Should be consistent for the life of the metric (consumers are expected to report, but not interpret, prefixes).
   */
  @WireField(
      tag = 3,
      adapter = "com.squareup.wire.ProtoAdapter#STRING",
      label = WireField.Label.REQUIRED
  )
  public final String unit;

  public ValueMetric(String name, Double value, String unit) {
    this(name, value, unit, ByteString.EMPTY);
  }

  public ValueMetric(String name, Double value, String unit, ByteString unknownFields) {
    super(ADAPTER, unknownFields);
    this.name = name;
    this.value = value;
    this.unit = unit;
  }

  @Override
  public Builder newBuilder() {
    Builder builder = new Builder();
    builder.name = name;
    builder.value = value;
    builder.unit = unit;
    builder.addUnknownFields(unknownFields());
    return builder;
  }

  @Override
  public boolean equals(Object other) {
    if (other == this) return true;
    if (!(other instanceof ValueMetric)) return false;
    ValueMetric o = (ValueMetric) other;
    return unknownFields().equals(o.unknownFields())
        && name.equals(o.name)
        && value.equals(o.value)
        && unit.equals(o.unit);
  }

  @Override
  public int hashCode() {
    int result = super.hashCode;
    if (result == 0) {
      result = unknownFields().hashCode();
      result = result * 37 + name.hashCode();
      result = result * 37 + value.hashCode();
      result = result * 37 + unit.hashCode();
      super.hashCode = result;
    }
    return result;
  }

  @Override
  public String toString() {
    StringBuilder builder = new StringBuilder();
    builder.append(", name=").append(name);
    builder.append(", value=").append(value);
    builder.append(", unit=").append(unit);
    return builder.replace(0, 2, "ValueMetric{").append('}').toString();
  }

  public static final class Builder extends Message.Builder<ValueMetric, Builder> {
    public String name;

    public Double value;

    public String unit;

    public Builder() {
    }

    /**
     * / Name of the metric. Must be consistent for downstream consumers to associate events semantically.
     */
    public Builder name(String name) {
      this.name = name;
      return this;
    }

    /**
     * / Value at the time of event emission.
     */
    public Builder value(Double value) {
      this.value = value;
      return this;
    }

    /**
     * / Unit of the metric. Please see http://metrics20.org/spec/#units for ideas; SI units/prefixes are recommended where applicable. Should be consistent for the life of the metric (consumers are expected to report, but not interpret, prefixes).
     */
    public Builder unit(String unit) {
      this.unit = unit;
      return this;
    }

    @Override
    public ValueMetric build() {
      if (name == null
          || value == null
          || unit == null) {
        throw Internal.missingRequiredFields(name, "name",
            value, "value",
            unit, "unit");
      }
      return new ValueMetric(name, value, unit, super.buildUnknownFields());
    }
  }

  private static final class ProtoAdapter_ValueMetric extends ProtoAdapter<ValueMetric> {
    ProtoAdapter_ValueMetric() {
      super(FieldEncoding.LENGTH_DELIMITED, ValueMetric.class);
    }

    @Override
    public int encodedSize(ValueMetric value) {
      return ProtoAdapter.STRING.encodedSizeWithTag(1, value.name)
          + ProtoAdapter.DOUBLE.encodedSizeWithTag(2, value.value)
          + ProtoAdapter.STRING.encodedSizeWithTag(3, value.unit)
          + value.unknownFields().size();
    }

    @Override
    public void encode(ProtoWriter writer, ValueMetric value) throws IOException {
      ProtoAdapter.STRING.encodeWithTag(writer, 1, value.name);
      ProtoAdapter.DOUBLE.encodeWithTag(writer, 2, value.value);
      ProtoAdapter.STRING.encodeWithTag(writer, 3, value.unit);
      writer.writeBytes(value.unknownFields());
    }

    @Override
    public ValueMetric decode(ProtoReader reader) throws IOException {
      Builder builder = new Builder();
      long token = reader.beginMessage();
      for (int tag; (tag = reader.nextTag()) != -1;) {
        switch (tag) {
          case 1: builder.name(ProtoAdapter.STRING.decode(reader)); break;
          case 2: builder.value(ProtoAdapter.DOUBLE.decode(reader)); break;
          case 3: builder.unit(ProtoAdapter.STRING.decode(reader)); break;
          default: {
            FieldEncoding fieldEncoding = reader.peekFieldEncoding();
            Object value = fieldEncoding.rawProtoAdapter().decode(reader);
            builder.addUnknownField(tag, fieldEncoding, value);
          }
        }
      }
      reader.endMessage(token);
      return builder.build();
    }

    @Override
    public ValueMetric redact(ValueMetric value) {
      Builder builder = value.newBuilder();
      builder.clearUnknownFields();
      return builder.build();
    }
  }
}
