package org.cloudfoundry.uaa.groups;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Generated;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.uaa.IdentityZoned;

/**
 * The request payload to add a member to a group
 */
@SuppressWarnings({"all"})
@Generated({"Immutables.generator", "_AddMemberRequest"})
public final class AddMemberRequest extends org.cloudfoundry.uaa.groups._AddMemberRequest {
  private final String groupId;
  private final String memberId;
  private final String origin;
  private final MemberType type;
  private final @Nullable String identityZoneId;

  private AddMemberRequest(AddMemberRequest.Builder builder) {
    this.groupId = builder.groupId;
    this.memberId = builder.memberId;
    this.origin = builder.origin;
    this.type = builder.type;
    this.identityZoneId = builder.identityZoneId;
  }

  /**
   * The group id
   */
  @JsonProperty("groupId")
  @JsonIgnore
  @Override
  public String getGroupId() {
    return groupId;
  }

  /**
   * Globally unique identifier of the member, either a user ID or another group ID
   */
  @JsonProperty("value")
  @Override
  public String getMemberId() {
    return memberId;
  }

  /**
   * The alias of the identity provider that authenticated this user. "uaa" is an internal UAA user.
   */
  @JsonProperty("origin")
  @Override
  public String getOrigin() {
    return origin;
  }

  /**
   * The member type
   */
  @JsonProperty("type")
  @Override
  public MemberType getType() {
    return type;
  }

  /**
   * Returns the identity zone id
   * @return the identity zone id
   */
  @JsonProperty("identityZoneId")
  @JsonIgnore
  @Override
  public @Nullable String getIdentityZoneId() {
    return identityZoneId;
  }

  /**
   * This instance is equal to all instances of {@code AddMemberRequest} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof AddMemberRequest
        && equalTo((AddMemberRequest) another);
  }

  private boolean equalTo(AddMemberRequest another) {
    return groupId.equals(another.groupId)
        && memberId.equals(another.memberId)
        && origin.equals(another.origin)
        && type.equals(another.type)
        && Objects.equals(identityZoneId, another.identityZoneId);
  }

  /**
   * Computes a hash code from attributes: {@code groupId}, {@code memberId}, {@code origin}, {@code type}, {@code identityZoneId}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + groupId.hashCode();
    h += (h << 5) + memberId.hashCode();
    h += (h << 5) + origin.hashCode();
    h += (h << 5) + type.hashCode();
    h += (h << 5) + Objects.hashCode(identityZoneId);
    return h;
  }

  /**
   * Prints the immutable value {@code AddMemberRequest} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "AddMemberRequest{"
        + "groupId=" + groupId
        + ", memberId=" + memberId
        + ", origin=" + origin
        + ", type=" + type
        + ", identityZoneId=" + identityZoneId
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json extends org.cloudfoundry.uaa.groups._AddMemberRequest {
    String groupId;
    String memberId;
    String origin;
    MemberType type;
    String identityZoneId;
    @JsonProperty("groupId")
    @JsonIgnore
    public void setGroupId(String groupId) {
      this.groupId = groupId;
    }
    @JsonProperty("value")
    public void setMemberId(String memberId) {
      this.memberId = memberId;
    }
    @JsonProperty("origin")
    public void setOrigin(String origin) {
      this.origin = origin;
    }
    @JsonProperty("type")
    public void setType(MemberType type) {
      this.type = type;
    }
    @JsonProperty("identityZoneId")
    @JsonIgnore
    public void setIdentityZoneId(@Nullable String identityZoneId) {
      this.identityZoneId = identityZoneId;
    }
    @Override
    public String getGroupId() { throw new UnsupportedOperationException(); }
    @Override
    public String getMemberId() { throw new UnsupportedOperationException(); }
    @Override
    public String getOrigin() { throw new UnsupportedOperationException(); }
    @Override
    public MemberType getType() { throw new UnsupportedOperationException(); }
    @Override
    public String getIdentityZoneId() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static AddMemberRequest fromJson(Json json) {
    AddMemberRequest.Builder builder = AddMemberRequest.builder();
    if (json.groupId != null) {
      builder.groupId(json.groupId);
    }
    if (json.memberId != null) {
      builder.memberId(json.memberId);
    }
    if (json.origin != null) {
      builder.origin(json.origin);
    }
    if (json.type != null) {
      builder.type(json.type);
    }
    if (json.identityZoneId != null) {
      builder.identityZoneId(json.identityZoneId);
    }
    return builder.build();
  }

  /**
   * Creates a builder for {@link AddMemberRequest AddMemberRequest}.
   * @return A new AddMemberRequest builder
   */
  public static AddMemberRequest.Builder builder() {
    return new AddMemberRequest.Builder();
  }

  /**
   * Builds instances of type {@link AddMemberRequest AddMemberRequest}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  public static final class Builder {
    private static final long INIT_BIT_GROUP_ID = 0x1L;
    private static final long INIT_BIT_MEMBER_ID = 0x2L;
    private static final long INIT_BIT_ORIGIN = 0x4L;
    private static final long INIT_BIT_TYPE = 0x8L;
    private long initBits = 0xfL;

    private String groupId;
    private String memberId;
    private String origin;
    private MemberType type;
    private String identityZoneId;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code org.cloudfoundry.uaa.IdentityZoned} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(IdentityZoned instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code AddMemberRequest} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(AddMemberRequest instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Copy abstract value type {@code _AddMemberRequest} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_AddMemberRequest instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    private void from(Object object) {
      if (object instanceof IdentityZoned) {
        IdentityZoned instance = (IdentityZoned) object;
        String identityZoneIdValue = instance.getIdentityZoneId();
        if (identityZoneIdValue != null) {
          identityZoneId(identityZoneIdValue);
        }
      }
      if (object instanceof org.cloudfoundry.uaa.groups._AddMemberRequest) {
        org.cloudfoundry.uaa.groups._AddMemberRequest instance = (org.cloudfoundry.uaa.groups._AddMemberRequest) object;
        type(instance.getType());
        groupId(instance.getGroupId());
        origin(instance.getOrigin());
        memberId(instance.getMemberId());
      }
    }

    /**
     * Initializes the value for the {@link _AddMemberRequest#getGroupId() groupId} attribute.
     * @param groupId The value for groupId 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("groupId")
    @JsonIgnore
    public final Builder groupId(String groupId) {
      this.groupId = Objects.requireNonNull(groupId, "groupId");
      initBits &= ~INIT_BIT_GROUP_ID;
      return this;
    }

    /**
     * Initializes the value for the {@link _AddMemberRequest#getMemberId() memberId} attribute.
     * @param memberId The value for memberId 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("value")
    public final Builder memberId(String memberId) {
      this.memberId = Objects.requireNonNull(memberId, "memberId");
      initBits &= ~INIT_BIT_MEMBER_ID;
      return this;
    }

    /**
     * Initializes the value for the {@link _AddMemberRequest#getOrigin() origin} attribute.
     * @param origin The value for origin 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("origin")
    public final Builder origin(String origin) {
      this.origin = Objects.requireNonNull(origin, "origin");
      initBits &= ~INIT_BIT_ORIGIN;
      return this;
    }

    /**
     * Initializes the value for the {@link _AddMemberRequest#getType() type} attribute.
     * @param type The value for type 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("type")
    public final Builder type(MemberType type) {
      this.type = Objects.requireNonNull(type, "type");
      initBits &= ~INIT_BIT_TYPE;
      return this;
    }

    /**
     * Initializes the value for the {@link _AddMemberRequest#getIdentityZoneId() identityZoneId} attribute.
     * @param identityZoneId The value for identityZoneId (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("identityZoneId")
    @JsonIgnore
    public final Builder identityZoneId(@Nullable String identityZoneId) {
      this.identityZoneId = identityZoneId;
      return this;
    }

    /**
     * Builds a new {@link AddMemberRequest AddMemberRequest}.
     * @return An immutable instance of AddMemberRequest
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public AddMemberRequest build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new AddMemberRequest(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<String>();
      if ((initBits & INIT_BIT_GROUP_ID) != 0) attributes.add("groupId");
      if ((initBits & INIT_BIT_MEMBER_ID) != 0) attributes.add("memberId");
      if ((initBits & INIT_BIT_ORIGIN) != 0) attributes.add("origin");
      if ((initBits & INIT_BIT_TYPE) != 0) attributes.add("type");
      return "Cannot build AddMemberRequest, some of required attributes are not set " + attributes;
    }
  }
}
