package org.cloudfoundry.uaa.groups;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Generated;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.uaa.IdentityZoned;

/**
 * The request payload for the unmap external group by group display name request
 */
@SuppressWarnings({"all"})
@Generated({"Immutables.generator", "_UnmapExternalGroupByGroupDisplayNameRequest"})
public final class UnmapExternalGroupByGroupDisplayNameRequest
    extends org.cloudfoundry.uaa.groups._UnmapExternalGroupByGroupDisplayNameRequest {
  private final String externalGroup;
  private final String groupDisplayName;
  private final String origin;
  private final @Nullable String identityZoneId;

  private UnmapExternalGroupByGroupDisplayNameRequest(UnmapExternalGroupByGroupDisplayNameRequest.Builder builder) {
    this.externalGroup = builder.externalGroup;
    this.groupDisplayName = builder.groupDisplayName;
    this.origin = builder.origin;
    this.identityZoneId = builder.identityZoneId;
  }

  /**
   * The identifier for the group in external identity provider that needs to be unmapped to internal UAA groups
   */
  @Override
  public String getExternalGroup() {
    return externalGroup;
  }

  /**
   * The group's displayed name
   */
  @Override
  public String getGroupDisplayName() {
    return groupDisplayName;
  }

  /**
   * Unique alias of the identity provider
   */
  @Override
  public String getOrigin() {
    return origin;
  }

  /**
   * Returns the identity zone id
   * @return the identity zone id
   */
  @Override
  public @Nullable String getIdentityZoneId() {
    return identityZoneId;
  }

  /**
   * This instance is equal to all instances of {@code UnmapExternalGroupByGroupDisplayNameRequest} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof UnmapExternalGroupByGroupDisplayNameRequest
        && equalTo((UnmapExternalGroupByGroupDisplayNameRequest) another);
  }

  private boolean equalTo(UnmapExternalGroupByGroupDisplayNameRequest another) {
    return externalGroup.equals(another.externalGroup)
        && groupDisplayName.equals(another.groupDisplayName)
        && origin.equals(another.origin)
        && Objects.equals(identityZoneId, another.identityZoneId);
  }

  /**
   * Computes a hash code from attributes: {@code externalGroup}, {@code groupDisplayName}, {@code origin}, {@code identityZoneId}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + externalGroup.hashCode();
    h += (h << 5) + groupDisplayName.hashCode();
    h += (h << 5) + origin.hashCode();
    h += (h << 5) + Objects.hashCode(identityZoneId);
    return h;
  }

  /**
   * Prints the immutable value {@code UnmapExternalGroupByGroupDisplayNameRequest} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "UnmapExternalGroupByGroupDisplayNameRequest{"
        + "externalGroup=" + externalGroup
        + ", groupDisplayName=" + groupDisplayName
        + ", origin=" + origin
        + ", identityZoneId=" + identityZoneId
        + "}";
  }

  /**
   * Creates a builder for {@link UnmapExternalGroupByGroupDisplayNameRequest UnmapExternalGroupByGroupDisplayNameRequest}.
   * @return A new UnmapExternalGroupByGroupDisplayNameRequest builder
   */
  public static UnmapExternalGroupByGroupDisplayNameRequest.Builder builder() {
    return new UnmapExternalGroupByGroupDisplayNameRequest.Builder();
  }

  /**
   * Builds instances of type {@link UnmapExternalGroupByGroupDisplayNameRequest UnmapExternalGroupByGroupDisplayNameRequest}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  public static final class Builder {
    private static final long INIT_BIT_EXTERNAL_GROUP = 0x1L;
    private static final long INIT_BIT_GROUP_DISPLAY_NAME = 0x2L;
    private static final long INIT_BIT_ORIGIN = 0x4L;
    private long initBits = 0x7L;

    private String externalGroup;
    private String groupDisplayName;
    private String origin;
    private String identityZoneId;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code org.cloudfoundry.uaa.IdentityZoned} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(IdentityZoned instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code UnmapExternalGroupByGroupDisplayNameRequest} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(UnmapExternalGroupByGroupDisplayNameRequest instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Copy abstract value type {@code _UnmapExternalGroupByGroupDisplayNameRequest} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_UnmapExternalGroupByGroupDisplayNameRequest instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    private void from(Object object) {
      if (object instanceof IdentityZoned) {
        IdentityZoned instance = (IdentityZoned) object;
        String identityZoneIdValue = instance.getIdentityZoneId();
        if (identityZoneIdValue != null) {
          identityZoneId(identityZoneIdValue);
        }
      }
      if (object instanceof org.cloudfoundry.uaa.groups._UnmapExternalGroupByGroupDisplayNameRequest) {
        org.cloudfoundry.uaa.groups._UnmapExternalGroupByGroupDisplayNameRequest instance = (org.cloudfoundry.uaa.groups._UnmapExternalGroupByGroupDisplayNameRequest) object;
        groupDisplayName(instance.getGroupDisplayName());
        externalGroup(instance.getExternalGroup());
        origin(instance.getOrigin());
      }
    }

    /**
     * Initializes the value for the {@link _UnmapExternalGroupByGroupDisplayNameRequest#getExternalGroup() externalGroup} attribute.
     * @param externalGroup The value for externalGroup 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder externalGroup(String externalGroup) {
      this.externalGroup = Objects.requireNonNull(externalGroup, "externalGroup");
      initBits &= ~INIT_BIT_EXTERNAL_GROUP;
      return this;
    }

    /**
     * Initializes the value for the {@link _UnmapExternalGroupByGroupDisplayNameRequest#getGroupDisplayName() groupDisplayName} attribute.
     * @param groupDisplayName The value for groupDisplayName 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder groupDisplayName(String groupDisplayName) {
      this.groupDisplayName = Objects.requireNonNull(groupDisplayName, "groupDisplayName");
      initBits &= ~INIT_BIT_GROUP_DISPLAY_NAME;
      return this;
    }

    /**
     * Initializes the value for the {@link _UnmapExternalGroupByGroupDisplayNameRequest#getOrigin() origin} attribute.
     * @param origin The value for origin 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder origin(String origin) {
      this.origin = Objects.requireNonNull(origin, "origin");
      initBits &= ~INIT_BIT_ORIGIN;
      return this;
    }

    /**
     * Initializes the value for the {@link _UnmapExternalGroupByGroupDisplayNameRequest#getIdentityZoneId() identityZoneId} attribute.
     * @param identityZoneId The value for identityZoneId (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder identityZoneId(@Nullable String identityZoneId) {
      this.identityZoneId = identityZoneId;
      return this;
    }

    /**
     * Builds a new {@link UnmapExternalGroupByGroupDisplayNameRequest UnmapExternalGroupByGroupDisplayNameRequest}.
     * @return An immutable instance of UnmapExternalGroupByGroupDisplayNameRequest
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public UnmapExternalGroupByGroupDisplayNameRequest build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new UnmapExternalGroupByGroupDisplayNameRequest(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<String>();
      if ((initBits & INIT_BIT_EXTERNAL_GROUP) != 0) attributes.add("externalGroup");
      if ((initBits & INIT_BIT_GROUP_DISPLAY_NAME) != 0) attributes.add("groupDisplayName");
      if ((initBits & INIT_BIT_ORIGIN) != 0) attributes.add("origin");
      return "Cannot build UnmapExternalGroupByGroupDisplayNameRequest, some of required attributes are not set " + attributes;
    }
  }
}
