package org.cloudfoundry.uaa.identityproviders;

import java.util.Objects;
import javax.annotation.Generated;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.uaa.IdentityZoned;

/**
 * The request payload for the list identity provider
 */
@SuppressWarnings({"all"})
@Generated({"Immutables.generator", "_ListIdentityProvidersRequest"})
public final class ListIdentityProvidersRequest
    extends org.cloudfoundry.uaa.identityproviders._ListIdentityProvidersRequest {
  private final @Nullable String identityZoneId;

  private ListIdentityProvidersRequest(ListIdentityProvidersRequest.Builder builder) {
    this.identityZoneId = builder.identityZoneId;
  }

  /**
   * Returns the identity zone id
   * @return the identity zone id
   */
  @Override
  public @Nullable String getIdentityZoneId() {
    return identityZoneId;
  }

  /**
   * This instance is equal to all instances of {@code ListIdentityProvidersRequest} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ListIdentityProvidersRequest
        && equalTo((ListIdentityProvidersRequest) another);
  }

  private boolean equalTo(ListIdentityProvidersRequest another) {
    return Objects.equals(identityZoneId, another.identityZoneId);
  }

  /**
   * Computes a hash code from attributes: {@code identityZoneId}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + Objects.hashCode(identityZoneId);
    return h;
  }

  /**
   * Prints the immutable value {@code ListIdentityProvidersRequest} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "ListIdentityProvidersRequest{"
        + "identityZoneId=" + identityZoneId
        + "}";
  }

  /**
   * Creates a builder for {@link ListIdentityProvidersRequest ListIdentityProvidersRequest}.
   * @return A new ListIdentityProvidersRequest builder
   */
  public static ListIdentityProvidersRequest.Builder builder() {
    return new ListIdentityProvidersRequest.Builder();
  }

  /**
   * Builds instances of type {@link ListIdentityProvidersRequest ListIdentityProvidersRequest}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  public static final class Builder {
    private String identityZoneId;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code org.cloudfoundry.uaa.IdentityZoned} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(IdentityZoned instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code ListIdentityProvidersRequest} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(ListIdentityProvidersRequest instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Copy abstract value type {@code _ListIdentityProvidersRequest} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_ListIdentityProvidersRequest instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    private void from(Object object) {
      if (object instanceof IdentityZoned) {
        IdentityZoned instance = (IdentityZoned) object;
        String identityZoneIdValue = instance.getIdentityZoneId();
        if (identityZoneIdValue != null) {
          identityZoneId(identityZoneIdValue);
        }
      }
    }

    /**
     * Initializes the value for the {@link _ListIdentityProvidersRequest#getIdentityZoneId() identityZoneId} attribute.
     * @param identityZoneId The value for identityZoneId (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder identityZoneId(@Nullable String identityZoneId) {
      this.identityZoneId = identityZoneId;
      return this;
    }

    /**
     * Builds a new {@link ListIdentityProvidersRequest ListIdentityProvidersRequest}.
     * @return An immutable instance of ListIdentityProvidersRequest
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ListIdentityProvidersRequest build() {
      return new ListIdentityProvidersRequest(this);
    }
  }
}
