package org.cloudfoundry.uaa.tokens;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Generated;

/**
 * The response from the get token by OpenId request
 */
@SuppressWarnings({"all"})
@Generated({"Immutables.generator", "_GetTokenByOpenIdResponse"})
public final class GetTokenByOpenIdResponse extends org.cloudfoundry.uaa.tokens._GetTokenByOpenIdResponse {
  private final String openIdToken;
  private final String refreshToken;
  private final String accessToken;
  private final Integer expiresInSeconds;
  private final String scopes;
  private final String tokenId;
  private final String tokenType;

  private GetTokenByOpenIdResponse(GetTokenByOpenIdResponse.Builder builder) {
    this.openIdToken = builder.openIdToken;
    this.refreshToken = builder.refreshToken;
    this.accessToken = builder.accessToken;
    this.expiresInSeconds = builder.expiresInSeconds;
    this.scopes = builder.scopes;
    this.tokenId = builder.tokenId;
    this.tokenType = builder.tokenType;
  }

  /**
   * The OpenId token
   */
  @JsonProperty("id_token")
  @Override
  public String getOpenIdToken() {
    return openIdToken;
  }

  /**
   * The refresh token
   */
  @JsonProperty("refresh_token")
  @Override
  public String getRefreshToken() {
    return refreshToken;
  }

  /**
   * The access token
   */
  @JsonProperty("access_token")
  @Override
  public String getAccessToken() {
    return accessToken;
  }

  /**
   * The number of seconds until token expiry
   */
  @JsonProperty("expires_in")
  @Override
  public Integer getExpiresInSeconds() {
    return expiresInSeconds;
  }

  /**
   * The space-delimited list of scopes authorized by the user for this client
   */
  @JsonProperty("scope")
  @Override
  public String getScopes() {
    return scopes;
  }

  /**
   * The identifier for this token
   */
  @JsonProperty("jti")
  @Override
  public String getTokenId() {
    return tokenId;
  }

  /**
   * The type of the access token issued
   */
  @JsonProperty("token_type")
  @Override
  public String getTokenType() {
    return tokenType;
  }

  /**
   * This instance is equal to all instances of {@code GetTokenByOpenIdResponse} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof GetTokenByOpenIdResponse
        && equalTo((GetTokenByOpenIdResponse) another);
  }

  private boolean equalTo(GetTokenByOpenIdResponse another) {
    return openIdToken.equals(another.openIdToken)
        && refreshToken.equals(another.refreshToken)
        && accessToken.equals(another.accessToken)
        && expiresInSeconds.equals(another.expiresInSeconds)
        && scopes.equals(another.scopes)
        && tokenId.equals(another.tokenId)
        && tokenType.equals(another.tokenType);
  }

  /**
   * Computes a hash code from attributes: {@code openIdToken}, {@code refreshToken}, {@code accessToken}, {@code expiresInSeconds}, {@code scopes}, {@code tokenId}, {@code tokenType}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + openIdToken.hashCode();
    h += (h << 5) + refreshToken.hashCode();
    h += (h << 5) + accessToken.hashCode();
    h += (h << 5) + expiresInSeconds.hashCode();
    h += (h << 5) + scopes.hashCode();
    h += (h << 5) + tokenId.hashCode();
    h += (h << 5) + tokenType.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code GetTokenByOpenIdResponse} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "GetTokenByOpenIdResponse{"
        + "openIdToken=" + openIdToken
        + ", refreshToken=" + refreshToken
        + ", accessToken=" + accessToken
        + ", expiresInSeconds=" + expiresInSeconds
        + ", scopes=" + scopes
        + ", tokenId=" + tokenId
        + ", tokenType=" + tokenType
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json extends org.cloudfoundry.uaa.tokens._GetTokenByOpenIdResponse {
    String openIdToken;
    String refreshToken;
    String accessToken;
    Integer expiresInSeconds;
    String scopes;
    String tokenId;
    String tokenType;
    @JsonProperty("id_token")
    public void setOpenIdToken(String openIdToken) {
      this.openIdToken = openIdToken;
    }
    @JsonProperty("refresh_token")
    public void setRefreshToken(String refreshToken) {
      this.refreshToken = refreshToken;
    }
    @JsonProperty("access_token")
    public void setAccessToken(String accessToken) {
      this.accessToken = accessToken;
    }
    @JsonProperty("expires_in")
    public void setExpiresInSeconds(Integer expiresInSeconds) {
      this.expiresInSeconds = expiresInSeconds;
    }
    @JsonProperty("scope")
    public void setScopes(String scopes) {
      this.scopes = scopes;
    }
    @JsonProperty("jti")
    public void setTokenId(String tokenId) {
      this.tokenId = tokenId;
    }
    @JsonProperty("token_type")
    public void setTokenType(String tokenType) {
      this.tokenType = tokenType;
    }
    @Override
    public String getOpenIdToken() { throw new UnsupportedOperationException(); }
    @Override
    public String getRefreshToken() { throw new UnsupportedOperationException(); }
    @Override
    public String getAccessToken() { throw new UnsupportedOperationException(); }
    @Override
    public Integer getExpiresInSeconds() { throw new UnsupportedOperationException(); }
    @Override
    public String getScopes() { throw new UnsupportedOperationException(); }
    @Override
    public String getTokenId() { throw new UnsupportedOperationException(); }
    @Override
    public String getTokenType() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static GetTokenByOpenIdResponse fromJson(Json json) {
    GetTokenByOpenIdResponse.Builder builder = GetTokenByOpenIdResponse.builder();
    if (json.openIdToken != null) {
      builder.openIdToken(json.openIdToken);
    }
    if (json.refreshToken != null) {
      builder.refreshToken(json.refreshToken);
    }
    if (json.accessToken != null) {
      builder.accessToken(json.accessToken);
    }
    if (json.expiresInSeconds != null) {
      builder.expiresInSeconds(json.expiresInSeconds);
    }
    if (json.scopes != null) {
      builder.scopes(json.scopes);
    }
    if (json.tokenId != null) {
      builder.tokenId(json.tokenId);
    }
    if (json.tokenType != null) {
      builder.tokenType(json.tokenType);
    }
    return builder.build();
  }

  /**
   * Creates a builder for {@link GetTokenByOpenIdResponse GetTokenByOpenIdResponse}.
   * @return A new GetTokenByOpenIdResponse builder
   */
  public static GetTokenByOpenIdResponse.Builder builder() {
    return new GetTokenByOpenIdResponse.Builder();
  }

  /**
   * Builds instances of type {@link GetTokenByOpenIdResponse GetTokenByOpenIdResponse}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  public static final class Builder {
    private static final long INIT_BIT_OPEN_ID_TOKEN = 0x1L;
    private static final long INIT_BIT_REFRESH_TOKEN = 0x2L;
    private static final long INIT_BIT_ACCESS_TOKEN = 0x4L;
    private static final long INIT_BIT_EXPIRES_IN_SECONDS = 0x8L;
    private static final long INIT_BIT_SCOPES = 0x10L;
    private static final long INIT_BIT_TOKEN_ID = 0x20L;
    private static final long INIT_BIT_TOKEN_TYPE = 0x40L;
    private long initBits = 0x7fL;

    private String openIdToken;
    private String refreshToken;
    private String accessToken;
    private Integer expiresInSeconds;
    private String scopes;
    private String tokenId;
    private String tokenType;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code GetTokenByOpenIdResponse} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(GetTokenByOpenIdResponse instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Copy abstract value type {@code _GetTokenByOpenIdResponse} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_GetTokenByOpenIdResponse instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code org.cloudfoundry.uaa.tokens.AbstractToken} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(AbstractToken instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    private void from(Object object) {
      if (object instanceof org.cloudfoundry.uaa.tokens._GetTokenByOpenIdResponse) {
        org.cloudfoundry.uaa.tokens._GetTokenByOpenIdResponse instance = (org.cloudfoundry.uaa.tokens._GetTokenByOpenIdResponse) object;
        openIdToken(instance.getOpenIdToken());
        refreshToken(instance.getRefreshToken());
      }
      if (object instanceof AbstractToken) {
        AbstractToken instance = (AbstractToken) object;
        scopes(instance.getScopes());
        tokenId(instance.getTokenId());
        accessToken(instance.getAccessToken());
        tokenType(instance.getTokenType());
        expiresInSeconds(instance.getExpiresInSeconds());
      }
    }

    /**
     * Initializes the value for the {@link _GetTokenByOpenIdResponse#getOpenIdToken() openIdToken} attribute.
     * @param openIdToken The value for openIdToken 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("id_token")
    public final Builder openIdToken(String openIdToken) {
      this.openIdToken = Objects.requireNonNull(openIdToken, "openIdToken");
      initBits &= ~INIT_BIT_OPEN_ID_TOKEN;
      return this;
    }

    /**
     * Initializes the value for the {@link _GetTokenByOpenIdResponse#getRefreshToken() refreshToken} attribute.
     * @param refreshToken The value for refreshToken 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("refresh_token")
    public final Builder refreshToken(String refreshToken) {
      this.refreshToken = Objects.requireNonNull(refreshToken, "refreshToken");
      initBits &= ~INIT_BIT_REFRESH_TOKEN;
      return this;
    }

    /**
     * Initializes the value for the {@link _GetTokenByOpenIdResponse#getAccessToken() accessToken} attribute.
     * @param accessToken The value for accessToken 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("access_token")
    public final Builder accessToken(String accessToken) {
      this.accessToken = Objects.requireNonNull(accessToken, "accessToken");
      initBits &= ~INIT_BIT_ACCESS_TOKEN;
      return this;
    }

    /**
     * Initializes the value for the {@link _GetTokenByOpenIdResponse#getExpiresInSeconds() expiresInSeconds} attribute.
     * @param expiresInSeconds The value for expiresInSeconds 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("expires_in")
    public final Builder expiresInSeconds(Integer expiresInSeconds) {
      this.expiresInSeconds = Objects.requireNonNull(expiresInSeconds, "expiresInSeconds");
      initBits &= ~INIT_BIT_EXPIRES_IN_SECONDS;
      return this;
    }

    /**
     * Initializes the value for the {@link _GetTokenByOpenIdResponse#getScopes() scopes} attribute.
     * @param scopes The value for scopes 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("scope")
    public final Builder scopes(String scopes) {
      this.scopes = Objects.requireNonNull(scopes, "scopes");
      initBits &= ~INIT_BIT_SCOPES;
      return this;
    }

    /**
     * Initializes the value for the {@link _GetTokenByOpenIdResponse#getTokenId() tokenId} attribute.
     * @param tokenId The value for tokenId 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("jti")
    public final Builder tokenId(String tokenId) {
      this.tokenId = Objects.requireNonNull(tokenId, "tokenId");
      initBits &= ~INIT_BIT_TOKEN_ID;
      return this;
    }

    /**
     * Initializes the value for the {@link _GetTokenByOpenIdResponse#getTokenType() tokenType} attribute.
     * @param tokenType The value for tokenType 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("token_type")
    public final Builder tokenType(String tokenType) {
      this.tokenType = Objects.requireNonNull(tokenType, "tokenType");
      initBits &= ~INIT_BIT_TOKEN_TYPE;
      return this;
    }

    /**
     * Builds a new {@link GetTokenByOpenIdResponse GetTokenByOpenIdResponse}.
     * @return An immutable instance of GetTokenByOpenIdResponse
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public GetTokenByOpenIdResponse build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new GetTokenByOpenIdResponse(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<String>();
      if ((initBits & INIT_BIT_OPEN_ID_TOKEN) != 0) attributes.add("openIdToken");
      if ((initBits & INIT_BIT_REFRESH_TOKEN) != 0) attributes.add("refreshToken");
      if ((initBits & INIT_BIT_ACCESS_TOKEN) != 0) attributes.add("accessToken");
      if ((initBits & INIT_BIT_EXPIRES_IN_SECONDS) != 0) attributes.add("expiresInSeconds");
      if ((initBits & INIT_BIT_SCOPES) != 0) attributes.add("scopes");
      if ((initBits & INIT_BIT_TOKEN_ID) != 0) attributes.add("tokenId");
      if ((initBits & INIT_BIT_TOKEN_TYPE) != 0) attributes.add("tokenType");
      return "Cannot build GetTokenByOpenIdResponse, some of required attributes are not set " + attributes;
    }
  }
}
