package org.cloudfoundry.uaa.users;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.Generated;
import org.cloudfoundry.Nullable;

/**
 * The response from the verify user request
 */
@SuppressWarnings({"all"})
@Generated({"Immutables.generator", "_VerifyUserResponse"})
public final class VerifyUserResponse extends org.cloudfoundry.uaa.users._VerifyUserResponse {
  private final Boolean active;
  private final List<Email> email;
  private final @Nullable Long lastLogonTime;
  private final Meta meta;
  private final Name name;
  private final String passwordLastModified;
  private final @Nullable Long previousLoginTime;
  private final List<String> schemas;
  private final Boolean verified;
  private final String zoneId;
  private final String id;
  private final String origin;
  private final String userName;

  private VerifyUserResponse(VerifyUserResponse.Builder builder) {
    this.active = builder.active;
    this.email = createUnmodifiableList(true, builder.email);
    this.lastLogonTime = builder.lastLogonTime;
    this.meta = builder.meta;
    this.name = builder.name;
    this.passwordLastModified = builder.passwordLastModified;
    this.previousLoginTime = builder.previousLoginTime;
    this.schemas = createUnmodifiableList(true, builder.schemas);
    this.verified = builder.verified;
    this.zoneId = builder.zoneId;
    this.id = builder.id;
    this.origin = builder.origin;
    this.userName = builder.userName;
  }

  /**
   * Whether the user is active
   */
  @JsonProperty("active")
  @Override
  public Boolean getActive() {
    return active;
  }

  /**
   * The emails for the user
   */
  @JsonProperty("emails")
  @Override
  public List<Email> getEmail() {
    return email;
  }

  /**
   * The unix epoch timestamp of when the user last authenticated
   */
  @JsonProperty("lastLogonTime")
  @Override
  public @Nullable Long getLastLogonTime() {
    return lastLogonTime;
  }

  /**
   * Metadata for the result
   */
  @JsonProperty("meta")
  @Override
  public Meta getMeta() {
    return meta;
  }

  /**
   * The user's name
   */
  @JsonProperty("name")
  @Override
  public Name getName() {
    return name;
  }

  /**
   * The timestamp when the user's password was last modified
   */
  @JsonProperty("passwordLastModified")
  @Override
  public String getPasswordLastModified() {
    return passwordLastModified;
  }

  /**
   * The unix epoch timestamp of when the user last authenticated
   */
  @JsonProperty("previousLogonTime")
  @Override
  public @Nullable Long getPreviousLoginTime() {
    return previousLoginTime;
  }

  /**
   * The schemas
   */
  @JsonProperty("schemas")
  @Override
  public List<String> getSchemas() {
    return schemas;
  }

  /**
   * Whether the user's email is verified
   */
  @JsonProperty("verified")
  @Override
  public Boolean getVerified() {
    return verified;
  }

  /**
   * The zone id the user belongs to
   */
  @JsonProperty("zoneId")
  @Override
  public String getZoneId() {
    return zoneId;
  }

  /**
   * The id
   */
  @JsonProperty("id")
  @Override
  public String getId() {
    return id;
  }

  /**
   * The identity provider that authenticated this user
   */
  @JsonProperty("origin")
  @Override
  public String getOrigin() {
    return origin;
  }

  /**
   * The user name
   */
  @JsonProperty("userName")
  @Override
  public String getUserName() {
    return userName;
  }

  /**
   * This instance is equal to all instances of {@code VerifyUserResponse} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof VerifyUserResponse
        && equalTo((VerifyUserResponse) another);
  }

  private boolean equalTo(VerifyUserResponse another) {
    return active.equals(another.active)
        && email.equals(another.email)
        && Objects.equals(lastLogonTime, another.lastLogonTime)
        && meta.equals(another.meta)
        && name.equals(another.name)
        && passwordLastModified.equals(another.passwordLastModified)
        && Objects.equals(previousLoginTime, another.previousLoginTime)
        && schemas.equals(another.schemas)
        && verified.equals(another.verified)
        && zoneId.equals(another.zoneId)
        && id.equals(another.id)
        && origin.equals(another.origin)
        && userName.equals(another.userName);
  }

  /**
   * Computes a hash code from attributes: {@code active}, {@code email}, {@code lastLogonTime}, {@code meta}, {@code name}, {@code passwordLastModified}, {@code previousLoginTime}, {@code schemas}, {@code verified}, {@code zoneId}, {@code id}, {@code origin}, {@code userName}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + active.hashCode();
    h += (h << 5) + email.hashCode();
    h += (h << 5) + Objects.hashCode(lastLogonTime);
    h += (h << 5) + meta.hashCode();
    h += (h << 5) + name.hashCode();
    h += (h << 5) + passwordLastModified.hashCode();
    h += (h << 5) + Objects.hashCode(previousLoginTime);
    h += (h << 5) + schemas.hashCode();
    h += (h << 5) + verified.hashCode();
    h += (h << 5) + zoneId.hashCode();
    h += (h << 5) + id.hashCode();
    h += (h << 5) + origin.hashCode();
    h += (h << 5) + userName.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code VerifyUserResponse} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "VerifyUserResponse{"
        + "active=" + active
        + ", email=" + email
        + ", lastLogonTime=" + lastLogonTime
        + ", meta=" + meta
        + ", name=" + name
        + ", passwordLastModified=" + passwordLastModified
        + ", previousLoginTime=" + previousLoginTime
        + ", schemas=" + schemas
        + ", verified=" + verified
        + ", zoneId=" + zoneId
        + ", id=" + id
        + ", origin=" + origin
        + ", userName=" + userName
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json extends org.cloudfoundry.uaa.users._VerifyUserResponse {
    Boolean active;
    List<Email> email = Collections.emptyList();
    Long lastLogonTime;
    Meta meta;
    Name name;
    String passwordLastModified;
    Long previousLoginTime;
    List<String> schemas = Collections.emptyList();
    Boolean verified;
    String zoneId;
    String id;
    String origin;
    String userName;
    @JsonProperty("active")
    public void setActive(Boolean active) {
      this.active = active;
    }
    @JsonProperty("emails")
    public void setEmail(List<Email> email) {
      this.email = email;
    }
    @JsonProperty("lastLogonTime")
    public void setLastLogonTime(@Nullable Long lastLogonTime) {
      this.lastLogonTime = lastLogonTime;
    }
    @JsonProperty("meta")
    public void setMeta(Meta meta) {
      this.meta = meta;
    }
    @JsonProperty("name")
    public void setName(Name name) {
      this.name = name;
    }
    @JsonProperty("passwordLastModified")
    public void setPasswordLastModified(String passwordLastModified) {
      this.passwordLastModified = passwordLastModified;
    }
    @JsonProperty("previousLogonTime")
    public void setPreviousLoginTime(@Nullable Long previousLoginTime) {
      this.previousLoginTime = previousLoginTime;
    }
    @JsonProperty("schemas")
    public void setSchemas(List<String> schemas) {
      this.schemas = schemas;
    }
    @JsonProperty("verified")
    public void setVerified(Boolean verified) {
      this.verified = verified;
    }
    @JsonProperty("zoneId")
    public void setZoneId(String zoneId) {
      this.zoneId = zoneId;
    }
    @JsonProperty("id")
    public void setId(String id) {
      this.id = id;
    }
    @JsonProperty("origin")
    public void setOrigin(String origin) {
      this.origin = origin;
    }
    @JsonProperty("userName")
    public void setUserName(String userName) {
      this.userName = userName;
    }
    @Override
    public Boolean getActive() { throw new UnsupportedOperationException(); }
    @Override
    public List<Email> getEmail() { throw new UnsupportedOperationException(); }
    @Override
    public Long getLastLogonTime() { throw new UnsupportedOperationException(); }
    @Override
    public Meta getMeta() { throw new UnsupportedOperationException(); }
    @Override
    public Name getName() { throw new UnsupportedOperationException(); }
    @Override
    public String getPasswordLastModified() { throw new UnsupportedOperationException(); }
    @Override
    public Long getPreviousLoginTime() { throw new UnsupportedOperationException(); }
    @Override
    public List<String> getSchemas() { throw new UnsupportedOperationException(); }
    @Override
    public Boolean getVerified() { throw new UnsupportedOperationException(); }
    @Override
    public String getZoneId() { throw new UnsupportedOperationException(); }
    @Override
    public String getId() { throw new UnsupportedOperationException(); }
    @Override
    public String getOrigin() { throw new UnsupportedOperationException(); }
    @Override
    public String getUserName() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static VerifyUserResponse fromJson(Json json) {
    VerifyUserResponse.Builder builder = VerifyUserResponse.builder();
    if (json.active != null) {
      builder.active(json.active);
    }
    if (json.email != null) {
      builder.addAllEmail(json.email);
    }
    if (json.lastLogonTime != null) {
      builder.lastLogonTime(json.lastLogonTime);
    }
    if (json.meta != null) {
      builder.meta(json.meta);
    }
    if (json.name != null) {
      builder.name(json.name);
    }
    if (json.passwordLastModified != null) {
      builder.passwordLastModified(json.passwordLastModified);
    }
    if (json.previousLoginTime != null) {
      builder.previousLoginTime(json.previousLoginTime);
    }
    if (json.schemas != null) {
      builder.addAllSchemas(json.schemas);
    }
    if (json.verified != null) {
      builder.verified(json.verified);
    }
    if (json.zoneId != null) {
      builder.zoneId(json.zoneId);
    }
    if (json.id != null) {
      builder.id(json.id);
    }
    if (json.origin != null) {
      builder.origin(json.origin);
    }
    if (json.userName != null) {
      builder.userName(json.userName);
    }
    return builder.build();
  }

  /**
   * Creates a builder for {@link VerifyUserResponse VerifyUserResponse}.
   * @return A new VerifyUserResponse builder
   */
  public static VerifyUserResponse.Builder builder() {
    return new VerifyUserResponse.Builder();
  }

  /**
   * Builds instances of type {@link VerifyUserResponse VerifyUserResponse}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  public static final class Builder {
    private static final long INIT_BIT_ACTIVE = 0x1L;
    private static final long INIT_BIT_META = 0x2L;
    private static final long INIT_BIT_NAME = 0x4L;
    private static final long INIT_BIT_PASSWORD_LAST_MODIFIED = 0x8L;
    private static final long INIT_BIT_VERIFIED = 0x10L;
    private static final long INIT_BIT_ZONE_ID = 0x20L;
    private static final long INIT_BIT_ID = 0x40L;
    private static final long INIT_BIT_ORIGIN = 0x80L;
    private static final long INIT_BIT_USER_NAME = 0x100L;
    private long initBits = 0x1ffL;

    private Boolean active;
    private List<Email> email = new ArrayList<Email>();
    private Long lastLogonTime;
    private Meta meta;
    private Name name;
    private String passwordLastModified;
    private Long previousLoginTime;
    private List<String> schemas = new ArrayList<String>();
    private Boolean verified;
    private String zoneId;
    private String id;
    private String origin;
    private String userName;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code org.cloudfoundry.uaa.users.AbstractUserSummary} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(AbstractUserSummary instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code org.cloudfoundry.uaa.users.AbstractUserId} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(AbstractUserId instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code VerifyUserResponse} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(VerifyUserResponse instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Copy abstract value type {@code _VerifyUserResponse} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_VerifyUserResponse instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    private void from(Object object) {
      if (object instanceof AbstractUserSummary) {
        AbstractUserSummary instance = (AbstractUserSummary) object;
        Long lastLogonTimeValue = instance.getLastLogonTime();
        if (lastLogonTimeValue != null) {
          lastLogonTime(lastLogonTimeValue);
        }
        meta(instance.getMeta());
        addAllSchemas(instance.getSchemas());
        verified(instance.getVerified());
        name(instance.getName());
        active(instance.getActive());
        zoneId(instance.getZoneId());
        passwordLastModified(instance.getPasswordLastModified());
        Long previousLoginTimeValue = instance.getPreviousLoginTime();
        if (previousLoginTimeValue != null) {
          previousLoginTime(previousLoginTimeValue);
        }
        addAllEmail(instance.getEmail());
      }
      if (object instanceof AbstractUserId) {
        AbstractUserId instance = (AbstractUserId) object;
        userName(instance.getUserName());
        origin(instance.getOrigin());
        id(instance.getId());
      }
    }

    /**
     * Initializes the value for the {@link _VerifyUserResponse#getActive() active} attribute.
     * @param active The value for active 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("active")
    public final Builder active(Boolean active) {
      this.active = Objects.requireNonNull(active, "active");
      initBits &= ~INIT_BIT_ACTIVE;
      return this;
    }

    /**
     * Adds one element to {@link _VerifyUserResponse#getEmail() email} list.
     * @param element A email element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder email(Email element) {
      this.email.add(Objects.requireNonNull(element, "email element"));
      return this;
    }

    /**
     * Adds elements to {@link _VerifyUserResponse#getEmail() email} list.
     * @param elements An array of email elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder email(Email... elements) {
      for (Email element : elements) {
        this.email.add(Objects.requireNonNull(element, "email element"));
      }
      return this;
    }

    /**
     * Sets or replaces all elements for {@link _VerifyUserResponse#getEmail() email} list.
     * @param elements An iterable of email elements
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("emails")
    public final Builder email(Iterable<? extends Email> elements) {
      this.email.clear();
      return addAllEmail(elements);
    }

    /**
     * Adds elements to {@link _VerifyUserResponse#getEmail() email} list.
     * @param elements An iterable of email elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllEmail(Iterable<? extends Email> elements) {
      for (Email element : elements) {
        this.email.add(Objects.requireNonNull(element, "email element"));
      }
      return this;
    }

    /**
     * Initializes the value for the {@link _VerifyUserResponse#getLastLogonTime() lastLogonTime} attribute.
     * @param lastLogonTime The value for lastLogonTime (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("lastLogonTime")
    public final Builder lastLogonTime(@Nullable Long lastLogonTime) {
      this.lastLogonTime = lastLogonTime;
      return this;
    }

    /**
     * Initializes the value for the {@link _VerifyUserResponse#getMeta() meta} attribute.
     * @param meta The value for meta 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("meta")
    public final Builder meta(Meta meta) {
      this.meta = Objects.requireNonNull(meta, "meta");
      initBits &= ~INIT_BIT_META;
      return this;
    }

    /**
     * Initializes the value for the {@link _VerifyUserResponse#getName() name} attribute.
     * @param name The value for name 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("name")
    public final Builder name(Name name) {
      this.name = Objects.requireNonNull(name, "name");
      initBits &= ~INIT_BIT_NAME;
      return this;
    }

    /**
     * Initializes the value for the {@link _VerifyUserResponse#getPasswordLastModified() passwordLastModified} attribute.
     * @param passwordLastModified The value for passwordLastModified 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("passwordLastModified")
    public final Builder passwordLastModified(String passwordLastModified) {
      this.passwordLastModified = Objects.requireNonNull(passwordLastModified, "passwordLastModified");
      initBits &= ~INIT_BIT_PASSWORD_LAST_MODIFIED;
      return this;
    }

    /**
     * Initializes the value for the {@link _VerifyUserResponse#getPreviousLoginTime() previousLoginTime} attribute.
     * @param previousLoginTime The value for previousLoginTime (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("previousLogonTime")
    public final Builder previousLoginTime(@Nullable Long previousLoginTime) {
      this.previousLoginTime = previousLoginTime;
      return this;
    }

    /**
     * Adds one element to {@link _VerifyUserResponse#getSchemas() schemas} list.
     * @param element A schemas element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder schema(String element) {
      this.schemas.add(Objects.requireNonNull(element, "schemas element"));
      return this;
    }

    /**
     * Adds elements to {@link _VerifyUserResponse#getSchemas() schemas} list.
     * @param elements An array of schemas elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder schema(String... elements) {
      for (String element : elements) {
        this.schemas.add(Objects.requireNonNull(element, "schemas element"));
      }
      return this;
    }

    /**
     * Sets or replaces all elements for {@link _VerifyUserResponse#getSchemas() schemas} list.
     * @param elements An iterable of schemas elements
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("schemas")
    public final Builder schemas(Iterable<String> elements) {
      this.schemas.clear();
      return addAllSchemas(elements);
    }

    /**
     * Adds elements to {@link _VerifyUserResponse#getSchemas() schemas} list.
     * @param elements An iterable of schemas elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllSchemas(Iterable<String> elements) {
      for (String element : elements) {
        this.schemas.add(Objects.requireNonNull(element, "schemas element"));
      }
      return this;
    }

    /**
     * Initializes the value for the {@link _VerifyUserResponse#getVerified() verified} attribute.
     * @param verified The value for verified 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("verified")
    public final Builder verified(Boolean verified) {
      this.verified = Objects.requireNonNull(verified, "verified");
      initBits &= ~INIT_BIT_VERIFIED;
      return this;
    }

    /**
     * Initializes the value for the {@link _VerifyUserResponse#getZoneId() zoneId} attribute.
     * @param zoneId The value for zoneId 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("zoneId")
    public final Builder zoneId(String zoneId) {
      this.zoneId = Objects.requireNonNull(zoneId, "zoneId");
      initBits &= ~INIT_BIT_ZONE_ID;
      return this;
    }

    /**
     * Initializes the value for the {@link _VerifyUserResponse#getId() id} attribute.
     * @param id The value for id 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("id")
    public final Builder id(String id) {
      this.id = Objects.requireNonNull(id, "id");
      initBits &= ~INIT_BIT_ID;
      return this;
    }

    /**
     * Initializes the value for the {@link _VerifyUserResponse#getOrigin() origin} attribute.
     * @param origin The value for origin 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("origin")
    public final Builder origin(String origin) {
      this.origin = Objects.requireNonNull(origin, "origin");
      initBits &= ~INIT_BIT_ORIGIN;
      return this;
    }

    /**
     * Initializes the value for the {@link _VerifyUserResponse#getUserName() userName} attribute.
     * @param userName The value for userName 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("userName")
    public final Builder userName(String userName) {
      this.userName = Objects.requireNonNull(userName, "userName");
      initBits &= ~INIT_BIT_USER_NAME;
      return this;
    }

    /**
     * Builds a new {@link VerifyUserResponse VerifyUserResponse}.
     * @return An immutable instance of VerifyUserResponse
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public VerifyUserResponse build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new VerifyUserResponse(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<String>();
      if ((initBits & INIT_BIT_ACTIVE) != 0) attributes.add("active");
      if ((initBits & INIT_BIT_META) != 0) attributes.add("meta");
      if ((initBits & INIT_BIT_NAME) != 0) attributes.add("name");
      if ((initBits & INIT_BIT_PASSWORD_LAST_MODIFIED) != 0) attributes.add("passwordLastModified");
      if ((initBits & INIT_BIT_VERIFIED) != 0) attributes.add("verified");
      if ((initBits & INIT_BIT_ZONE_ID) != 0) attributes.add("zoneId");
      if ((initBits & INIT_BIT_ID) != 0) attributes.add("id");
      if ((initBits & INIT_BIT_ORIGIN) != 0) attributes.add("origin");
      if ((initBits & INIT_BIT_USER_NAME) != 0) attributes.add("userName");
      return "Cannot build VerifyUserResponse, some of required attributes are not set " + attributes;
    }
  }

  private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
    ArrayList<T> list;
    if (iterable instanceof Collection<?>) {
      int size = ((Collection<?>) iterable).size();
      if (size == 0) return Collections.emptyList();
      list = new ArrayList<T>();
    } else {
      list = new ArrayList<T>();
    }
    for (T element : iterable) {
      if (skipNulls && element == null) continue;
      if (checkNulls) Objects.requireNonNull(element, "element");
      list.add(element);
    }
    return list;
  }

  private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
    switch(list.size()) {
    case 0: return Collections.emptyList();
    case 1: return Collections.singletonList(list.get(0));
    default:
      if (clone) {
        return Collections.unmodifiableList(new ArrayList<T>(list));
      } else {
        if (list instanceof ArrayList<?>) {
          ((ArrayList<?>) list).trimToSize();
        }
        return Collections.unmodifiableList(list);
      }
    }
  }
}
