package org.cloudfoundry.client.v2.applications;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.Objects;
import javax.annotation.Generated;
import org.cloudfoundry.Nullable;

/**
 * Immutable implementation of {@link _InstanceStatistics}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code InstanceStatistics.builder()}.
 */
@SuppressWarnings({"all"})
@Generated({"Immutables.generator", "_InstanceStatistics"})
public final class InstanceStatistics extends org.cloudfoundry.client.v2.applications._InstanceStatistics {
  private final @Nullable String state;
  private final @Nullable Statistics statistics;

  private InstanceStatistics(InstanceStatistics.Builder builder) {
    this.state = builder.state;
    this.statistics = builder.statistics;
  }

  /**
   * The instance state
   */
  @JsonProperty("state")
  @Override
  public @Nullable String getState() {
    return state;
  }

  /**
   * The instance statistics
   */
  @JsonProperty("stats")
  @Override
  public @Nullable Statistics getStatistics() {
    return statistics;
  }

  /**
   * This instance is equal to all instances of {@code InstanceStatistics} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof InstanceStatistics
        && equalTo((InstanceStatistics) another);
  }

  private boolean equalTo(InstanceStatistics another) {
    return Objects.equals(state, another.state)
        && Objects.equals(statistics, another.statistics);
  }

  /**
   * Computes a hash code from attributes: {@code state}, {@code statistics}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + Objects.hashCode(state);
    h += (h << 5) + Objects.hashCode(statistics);
    return h;
  }

  /**
   * Prints the immutable value {@code InstanceStatistics} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "InstanceStatistics{"
        + "state=" + state
        + ", statistics=" + statistics
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json extends org.cloudfoundry.client.v2.applications._InstanceStatistics {
    String state;
    Statistics statistics;
    @JsonProperty("state")
    public void setState(@Nullable String state) {
      this.state = state;
    }
    @JsonProperty("stats")
    public void setStatistics(@Nullable Statistics statistics) {
      this.statistics = statistics;
    }
    @Override
    public String getState() { throw new UnsupportedOperationException(); }
    @Override
    public Statistics getStatistics() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static InstanceStatistics fromJson(Json json) {
    InstanceStatistics.Builder builder = InstanceStatistics.builder();
    if (json.state != null) {
      builder.state(json.state);
    }
    if (json.statistics != null) {
      builder.statistics(json.statistics);
    }
    return builder.build();
  }

  /**
   * Creates a builder for {@link InstanceStatistics InstanceStatistics}.
   * @return A new InstanceStatistics builder
   */
  public static InstanceStatistics.Builder builder() {
    return new InstanceStatistics.Builder();
  }

  /**
   * Builds instances of type {@link InstanceStatistics InstanceStatistics}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  public static final class Builder {
    private String state;
    private Statistics statistics;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code InstanceStatistics} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(InstanceStatistics instance) {
      return from((_InstanceStatistics) instance);
    }

    /**
     * Copy abstract value type {@code _InstanceStatistics} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_InstanceStatistics instance) {
      Objects.requireNonNull(instance, "instance");
      String stateValue = instance.getState();
      if (stateValue != null) {
        state(stateValue);
      }
      Statistics statisticsValue = instance.getStatistics();
      if (statisticsValue != null) {
        statistics(statisticsValue);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link _InstanceStatistics#getState() state} attribute.
     * @param state The value for state (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("state")
    public final Builder state(@Nullable String state) {
      this.state = state;
      return this;
    }

    /**
     * Initializes the value for the {@link _InstanceStatistics#getStatistics() statistics} attribute.
     * @param statistics The value for statistics (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("stats")
    public final Builder statistics(@Nullable Statistics statistics) {
      this.statistics = statistics;
      return this;
    }

    /**
     * Builds a new {@link InstanceStatistics InstanceStatistics}.
     * @return An immutable instance of InstanceStatistics
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public InstanceStatistics build() {
      return new InstanceStatistics(this);
    }
  }
}
