package org.cloudfoundry.client.v2.resourcematch;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.Objects;
import javax.annotation.Generated;
import org.cloudfoundry.Nullable;

/**
 * A resource used for matching or has been matched
 */
@SuppressWarnings({"all"})
@Generated({"Immutables.generator", "_Resource"})
public final class Resource extends org.cloudfoundry.client.v2.resourcematch._Resource {
  private final @Nullable String hash;
  private final @Nullable String mode;
  private final @Nullable Integer size;

  private Resource(Resource.Builder builder) {
    this.hash = builder.hash;
    this.mode = builder.mode;
    this.size = builder.size;
  }

  /**
   * The hash
   */
  @JsonProperty("sha1")
  @Override
  public @Nullable String getHash() {
    return hash;
  }

  /**
   * The POSIX file mode in an octal representation
   */
  @JsonProperty("mode")
  @Override
  public @Nullable String getMode() {
    return mode;
  }

  /**
   * The size
   */
  @JsonProperty("size")
  @Override
  public @Nullable Integer getSize() {
    return size;
  }

  /**
   * This instance is equal to all instances of {@code Resource} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof Resource
        && equalTo((Resource) another);
  }

  private boolean equalTo(Resource another) {
    return Objects.equals(hash, another.hash)
        && Objects.equals(mode, another.mode)
        && Objects.equals(size, another.size);
  }

  /**
   * Computes a hash code from attributes: {@code hash}, {@code mode}, {@code size}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + Objects.hashCode(hash);
    h += (h << 5) + Objects.hashCode(mode);
    h += (h << 5) + Objects.hashCode(size);
    return h;
  }

  /**
   * Prints the immutable value {@code Resource} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "Resource{"
        + "hash=" + hash
        + ", mode=" + mode
        + ", size=" + size
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json extends org.cloudfoundry.client.v2.resourcematch._Resource {
    String hash;
    String mode;
    Integer size;
    @JsonProperty("sha1")
    public void setHash(@Nullable String hash) {
      this.hash = hash;
    }
    @JsonProperty("mode")
    public void setMode(@Nullable String mode) {
      this.mode = mode;
    }
    @JsonProperty("size")
    public void setSize(@Nullable Integer size) {
      this.size = size;
    }
    @Override
    public String getHash() { throw new UnsupportedOperationException(); }
    @Override
    public String getMode() { throw new UnsupportedOperationException(); }
    @Override
    public Integer getSize() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static Resource fromJson(Json json) {
    Resource.Builder builder = Resource.builder();
    if (json.hash != null) {
      builder.hash(json.hash);
    }
    if (json.mode != null) {
      builder.mode(json.mode);
    }
    if (json.size != null) {
      builder.size(json.size);
    }
    return builder.build();
  }

  /**
   * Creates a builder for {@link Resource Resource}.
   * @return A new Resource builder
   */
  public static Resource.Builder builder() {
    return new Resource.Builder();
  }

  /**
   * Builds instances of type {@link Resource Resource}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  public static final class Builder {
    private String hash;
    private String mode;
    private Integer size;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code Resource} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(Resource instance) {
      return from((_Resource) instance);
    }

    /**
     * Copy abstract value type {@code _Resource} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_Resource instance) {
      Objects.requireNonNull(instance, "instance");
      String hashValue = instance.getHash();
      if (hashValue != null) {
        hash(hashValue);
      }
      String modeValue = instance.getMode();
      if (modeValue != null) {
        mode(modeValue);
      }
      Integer sizeValue = instance.getSize();
      if (sizeValue != null) {
        size(sizeValue);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link _Resource#getHash() hash} attribute.
     * @param hash The value for hash (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("sha1")
    public final Builder hash(@Nullable String hash) {
      this.hash = hash;
      return this;
    }

    /**
     * Initializes the value for the {@link _Resource#getMode() mode} attribute.
     * @param mode The value for mode (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("mode")
    public final Builder mode(@Nullable String mode) {
      this.mode = mode;
      return this;
    }

    /**
     * Initializes the value for the {@link _Resource#getSize() size} attribute.
     * @param size The value for size (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("size")
    public final Builder size(@Nullable Integer size) {
      this.size = size;
      return this;
    }

    /**
     * Builds a new {@link Resource Resource}.
     * @return An immutable instance of Resource
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public Resource build() {
      return new Resource(this);
    }
  }
}
