package org.cloudfoundry.client.v2.serviceinstances;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.Objects;
import javax.annotation.Generated;
import org.cloudfoundry.Nullable;

/**
 * A service instance
 */
@SuppressWarnings({"all"})
@Generated({"Immutables.generator", "_ServiceInstance"})
public final class ServiceInstance extends org.cloudfoundry.client.v2.serviceinstances._ServiceInstance {
  private final @Nullable Integer boundApplicationCount;
  private final @Nullable String dashboardUrl;
  private final @Nullable String id;
  private final @Nullable LastOperation lastOperation;
  private final @Nullable String name;
  private final @Nullable Plan servicePlan;

  private ServiceInstance(ServiceInstance.Builder builder) {
    this.boundApplicationCount = builder.boundApplicationCount;
    this.dashboardUrl = builder.dashboardUrl;
    this.id = builder.id;
    this.lastOperation = builder.lastOperation;
    this.name = builder.name;
    this.servicePlan = builder.servicePlan;
  }

  /**
   * The bound application count
   */
  @JsonProperty("bound_app_count")
  @Override
  public @Nullable Integer getBoundApplicationCount() {
    return boundApplicationCount;
  }

  /**
   * The dashboard url
   */
  @JsonProperty("dashboard_url")
  @Override
  public @Nullable String getDashboardUrl() {
    return dashboardUrl;
  }

  /**
   * The id
   */
  @JsonProperty("guid")
  @Override
  public @Nullable String getId() {
    return id;
  }

  /**
   * The last operation
   */
  @JsonProperty("last_operation")
  @Override
  public @Nullable LastOperation getLastOperation() {
    return lastOperation;
  }

  /**
   * The name
   */
  @JsonProperty("name")
  @Override
  public @Nullable String getName() {
    return name;
  }

  /**
   * The service plan
   */
  @JsonProperty("service_plan")
  @Override
  public @Nullable Plan getServicePlan() {
    return servicePlan;
  }

  /**
   * This instance is equal to all instances of {@code ServiceInstance} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ServiceInstance
        && equalTo((ServiceInstance) another);
  }

  private boolean equalTo(ServiceInstance another) {
    return Objects.equals(boundApplicationCount, another.boundApplicationCount)
        && Objects.equals(dashboardUrl, another.dashboardUrl)
        && Objects.equals(id, another.id)
        && Objects.equals(lastOperation, another.lastOperation)
        && Objects.equals(name, another.name)
        && Objects.equals(servicePlan, another.servicePlan);
  }

  /**
   * Computes a hash code from attributes: {@code boundApplicationCount}, {@code dashboardUrl}, {@code id}, {@code lastOperation}, {@code name}, {@code servicePlan}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + Objects.hashCode(boundApplicationCount);
    h += (h << 5) + Objects.hashCode(dashboardUrl);
    h += (h << 5) + Objects.hashCode(id);
    h += (h << 5) + Objects.hashCode(lastOperation);
    h += (h << 5) + Objects.hashCode(name);
    h += (h << 5) + Objects.hashCode(servicePlan);
    return h;
  }

  /**
   * Prints the immutable value {@code ServiceInstance} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "ServiceInstance{"
        + "boundApplicationCount=" + boundApplicationCount
        + ", dashboardUrl=" + dashboardUrl
        + ", id=" + id
        + ", lastOperation=" + lastOperation
        + ", name=" + name
        + ", servicePlan=" + servicePlan
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json extends org.cloudfoundry.client.v2.serviceinstances._ServiceInstance {
    Integer boundApplicationCount;
    String dashboardUrl;
    String id;
    LastOperation lastOperation;
    String name;
    Plan servicePlan;
    @JsonProperty("bound_app_count")
    public void setBoundApplicationCount(@Nullable Integer boundApplicationCount) {
      this.boundApplicationCount = boundApplicationCount;
    }
    @JsonProperty("dashboard_url")
    public void setDashboardUrl(@Nullable String dashboardUrl) {
      this.dashboardUrl = dashboardUrl;
    }
    @JsonProperty("guid")
    public void setId(@Nullable String id) {
      this.id = id;
    }
    @JsonProperty("last_operation")
    public void setLastOperation(@Nullable LastOperation lastOperation) {
      this.lastOperation = lastOperation;
    }
    @JsonProperty("name")
    public void setName(@Nullable String name) {
      this.name = name;
    }
    @JsonProperty("service_plan")
    public void setServicePlan(@Nullable Plan servicePlan) {
      this.servicePlan = servicePlan;
    }
    @Override
    public Integer getBoundApplicationCount() { throw new UnsupportedOperationException(); }
    @Override
    public String getDashboardUrl() { throw new UnsupportedOperationException(); }
    @Override
    public String getId() { throw new UnsupportedOperationException(); }
    @Override
    public LastOperation getLastOperation() { throw new UnsupportedOperationException(); }
    @Override
    public String getName() { throw new UnsupportedOperationException(); }
    @Override
    public Plan getServicePlan() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ServiceInstance fromJson(Json json) {
    ServiceInstance.Builder builder = ServiceInstance.builder();
    if (json.boundApplicationCount != null) {
      builder.boundApplicationCount(json.boundApplicationCount);
    }
    if (json.dashboardUrl != null) {
      builder.dashboardUrl(json.dashboardUrl);
    }
    if (json.id != null) {
      builder.id(json.id);
    }
    if (json.lastOperation != null) {
      builder.lastOperation(json.lastOperation);
    }
    if (json.name != null) {
      builder.name(json.name);
    }
    if (json.servicePlan != null) {
      builder.servicePlan(json.servicePlan);
    }
    return builder.build();
  }

  /**
   * Creates a builder for {@link ServiceInstance ServiceInstance}.
   * @return A new ServiceInstance builder
   */
  public static ServiceInstance.Builder builder() {
    return new ServiceInstance.Builder();
  }

  /**
   * Builds instances of type {@link ServiceInstance ServiceInstance}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  public static final class Builder {
    private Integer boundApplicationCount;
    private String dashboardUrl;
    private String id;
    private LastOperation lastOperation;
    private String name;
    private Plan servicePlan;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code ServiceInstance} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(ServiceInstance instance) {
      return from((_ServiceInstance) instance);
    }

    /**
     * Copy abstract value type {@code _ServiceInstance} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_ServiceInstance instance) {
      Objects.requireNonNull(instance, "instance");
      Integer boundApplicationCountValue = instance.getBoundApplicationCount();
      if (boundApplicationCountValue != null) {
        boundApplicationCount(boundApplicationCountValue);
      }
      String dashboardUrlValue = instance.getDashboardUrl();
      if (dashboardUrlValue != null) {
        dashboardUrl(dashboardUrlValue);
      }
      String idValue = instance.getId();
      if (idValue != null) {
        id(idValue);
      }
      LastOperation lastOperationValue = instance.getLastOperation();
      if (lastOperationValue != null) {
        lastOperation(lastOperationValue);
      }
      String nameValue = instance.getName();
      if (nameValue != null) {
        name(nameValue);
      }
      Plan servicePlanValue = instance.getServicePlan();
      if (servicePlanValue != null) {
        servicePlan(servicePlanValue);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link _ServiceInstance#getBoundApplicationCount() boundApplicationCount} attribute.
     * @param boundApplicationCount The value for boundApplicationCount (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("bound_app_count")
    public final Builder boundApplicationCount(@Nullable Integer boundApplicationCount) {
      this.boundApplicationCount = boundApplicationCount;
      return this;
    }

    /**
     * Initializes the value for the {@link _ServiceInstance#getDashboardUrl() dashboardUrl} attribute.
     * @param dashboardUrl The value for dashboardUrl (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("dashboard_url")
    public final Builder dashboardUrl(@Nullable String dashboardUrl) {
      this.dashboardUrl = dashboardUrl;
      return this;
    }

    /**
     * Initializes the value for the {@link _ServiceInstance#getId() id} attribute.
     * @param id The value for id (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("guid")
    public final Builder id(@Nullable String id) {
      this.id = id;
      return this;
    }

    /**
     * Initializes the value for the {@link _ServiceInstance#getLastOperation() lastOperation} attribute.
     * @param lastOperation The value for lastOperation (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("last_operation")
    public final Builder lastOperation(@Nullable LastOperation lastOperation) {
      this.lastOperation = lastOperation;
      return this;
    }

    /**
     * Initializes the value for the {@link _ServiceInstance#getName() name} attribute.
     * @param name The value for name (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("name")
    public final Builder name(@Nullable String name) {
      this.name = name;
      return this;
    }

    /**
     * Initializes the value for the {@link _ServiceInstance#getServicePlan() servicePlan} attribute.
     * @param servicePlan The value for servicePlan (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("service_plan")
    public final Builder servicePlan(@Nullable Plan servicePlan) {
      this.servicePlan = servicePlan;
      return this;
    }

    /**
     * Builds a new {@link ServiceInstance ServiceInstance}.
     * @return An immutable instance of ServiceInstance
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ServiceInstance build() {
      return new ServiceInstance(this);
    }
  }
}
