package org.cloudfoundry.client.v3;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.Objects;
import javax.annotation.Generated;
import org.cloudfoundry.Nullable;

/**
 * Represents the lifecycle of an application
 */
@SuppressWarnings({"all"})
@Generated({"Immutables.generator", "_Lifecycle"})
public final class Lifecycle extends org.cloudfoundry.client.v3._Lifecycle {
  private final @Nullable Data data;
  private final @Nullable Type type;

  private Lifecycle(Lifecycle.Builder builder) {
    this.data = builder.data;
    this.type = builder.type;
  }

  /**
   * The datas
   */
  @JsonTypeInfo(use = JsonTypeInfo.Id.NAME, include = JsonTypeInfo.As.EXTERNAL_PROPERTY, property = "type")
  @JsonSubTypes({@JsonSubTypes.Type(name = "buildpack", value = BuildpackData.class), @JsonSubTypes.Type(name = "docker", value = DockerData.class)})
  @JsonProperty("data")
  @Override
  public @Nullable Data getData() {
    return data;
  }

  /**
   * The type
   */
  @JsonProperty("type")
  @Override
  public @Nullable Type getType() {
    return type;
  }

  /**
   * This instance is equal to all instances of {@code Lifecycle} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof Lifecycle
        && equalTo((Lifecycle) another);
  }

  private boolean equalTo(Lifecycle another) {
    return Objects.equals(data, another.data)
        && Objects.equals(type, another.type);
  }

  /**
   * Computes a hash code from attributes: {@code data}, {@code type}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + Objects.hashCode(data);
    h += (h << 5) + Objects.hashCode(type);
    return h;
  }

  /**
   * Prints the immutable value {@code Lifecycle} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "Lifecycle{"
        + "data=" + data
        + ", type=" + type
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json extends org.cloudfoundry.client.v3._Lifecycle {
    Data data;
    Type type;
    @JsonTypeInfo(use = JsonTypeInfo.Id.NAME, include = JsonTypeInfo.As.EXTERNAL_PROPERTY, property = "type")
    @JsonSubTypes({@JsonSubTypes.Type(name = "buildpack", value = BuildpackData.class), @JsonSubTypes.Type(name = "docker", value = DockerData.class)})
    @JsonProperty("data")
    public void setData(@Nullable Data data) {
      this.data = data;
    }
    @JsonProperty("type")
    public void setType(@Nullable Type type) {
      this.type = type;
    }
    @Override
    public Data getData() { throw new UnsupportedOperationException(); }
    @Override
    public Type getType() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static Lifecycle fromJson(Json json) {
    Lifecycle.Builder builder = Lifecycle.builder();
    if (json.data != null) {
      builder.data(json.data);
    }
    if (json.type != null) {
      builder.type(json.type);
    }
    return builder.build();
  }

  /**
   * Creates a builder for {@link Lifecycle Lifecycle}.
   * @return A new Lifecycle builder
   */
  public static Lifecycle.Builder builder() {
    return new Lifecycle.Builder();
  }

  /**
   * Builds instances of type {@link Lifecycle Lifecycle}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  public static final class Builder {
    private Data data;
    private Type type;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code Lifecycle} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(Lifecycle instance) {
      return from((_Lifecycle) instance);
    }

    /**
     * Copy abstract value type {@code _Lifecycle} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_Lifecycle instance) {
      Objects.requireNonNull(instance, "instance");
      Data dataValue = instance.getData();
      if (dataValue != null) {
        data(dataValue);
      }
      Type typeValue = instance.getType();
      if (typeValue != null) {
        type(typeValue);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link _Lifecycle#getData() data} attribute.
     * @param data The value for data (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonTypeInfo(use = JsonTypeInfo.Id.NAME, include = JsonTypeInfo.As.EXTERNAL_PROPERTY, property = "type")
    @JsonSubTypes({@JsonSubTypes.Type(name = "buildpack", value = BuildpackData.class), @JsonSubTypes.Type(name = "docker", value = DockerData.class)})
    @JsonProperty("data")
    public final Builder data(@Nullable Data data) {
      this.data = data;
      return this;
    }

    /**
     * Initializes the value for the {@link _Lifecycle#getType() type} attribute.
     * @param type The value for type (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("type")
    public final Builder type(@Nullable Type type) {
      this.type = type;
      return this;
    }

    /**
     * Builds a new {@link Lifecycle Lifecycle}.
     * @return An immutable instance of Lifecycle
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public Lifecycle build() {
      return new Lifecycle(this);
    }
  }
}
