package org.cloudfoundry.client.v3.applications;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Generated;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.client.v3.Link;
import org.cloudfoundry.client.v3.tasks.Result;
import org.cloudfoundry.client.v3.tasks.State;
import org.cloudfoundry.client.v3.tasks.Task;

/**
 * The response payload for the Get Application Task endpoint
 */
@SuppressWarnings({"all"})
@Generated({"Immutables.generator", "_GetApplicationTaskResponse"})
public final class GetApplicationTaskResponse
    extends org.cloudfoundry.client.v3.applications._GetApplicationTaskResponse {
  private final @Nullable String command;
  private final @Nullable String createdAt;
  private final @Nullable Map<String, String> environmentVariables;
  private final @Nullable String id;
  private final @Nullable Map<String, Link> links;
  private final @Nullable Integer memoryInMb;
  private final @Nullable String name;
  private final @Nullable Result result;
  private final @Nullable State state;
  private final @Nullable String updatedAt;

  private GetApplicationTaskResponse(GetApplicationTaskResponse.Builder builder) {
    this.command = builder.command;
    this.createdAt = builder.createdAt;
    this.environmentVariables = builder.environmentVariables == null ? null : createUnmodifiableMap(false, false, builder.environmentVariables);
    this.id = builder.id;
    this.links = builder.links == null ? null : createUnmodifiableMap(false, false, builder.links);
    this.memoryInMb = builder.memoryInMb;
    this.name = builder.name;
    this.result = builder.result;
    this.state = builder.state;
    this.updatedAt = builder.updatedAt;
  }

  /**
   * The command
   */
  @JsonProperty("command")
  @Override
  public @Nullable String getCommand() {
    return command;
  }

  /**
   * The created at
   */
  @JsonProperty("created_at")
  @Override
  public @Nullable String getCreatedAt() {
    return createdAt;
  }

  /**
   * The environment variables
   */
  @JsonProperty("environment_variables")
  @Override
  public @Nullable Map<String, String> getEnvironmentVariables() {
    return environmentVariables;
  }

  /**
   * The id
   */
  @JsonProperty("guid")
  @Override
  public @Nullable String getId() {
    return id;
  }

  /**
   * The links
   */
  @JsonProperty("links")
  @Override
  public @Nullable Map<String, Link> getLinks() {
    return links;
  }

  /**
   * The memory in megabytes=
   */
  @JsonProperty("memory_in_mb")
  @Override
  public @Nullable Integer getMemoryInMb() {
    return memoryInMb;
  }

  /**
   * The tasks name
   */
  @JsonProperty("name")
  @Override
  public @Nullable String getName() {
    return name;
  }

  /**
   * The task result
   */
  @JsonProperty("result")
  @Override
  public @Nullable Result getResult() {
    return result;
  }

  /**
   * The task state
   */
  @JsonProperty("state")
  @Override
  public @Nullable State getState() {
    return state;
  }

  /**
   * The updated at
   */
  @JsonProperty("updated_at")
  @Override
  public @Nullable String getUpdatedAt() {
    return updatedAt;
  }

  /**
   * This instance is equal to all instances of {@code GetApplicationTaskResponse} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof GetApplicationTaskResponse
        && equalTo((GetApplicationTaskResponse) another);
  }

  private boolean equalTo(GetApplicationTaskResponse another) {
    return Objects.equals(command, another.command)
        && Objects.equals(createdAt, another.createdAt)
        && Objects.equals(environmentVariables, another.environmentVariables)
        && Objects.equals(id, another.id)
        && Objects.equals(links, another.links)
        && Objects.equals(memoryInMb, another.memoryInMb)
        && Objects.equals(name, another.name)
        && Objects.equals(result, another.result)
        && Objects.equals(state, another.state)
        && Objects.equals(updatedAt, another.updatedAt);
  }

  /**
   * Computes a hash code from attributes: {@code command}, {@code createdAt}, {@code environmentVariables}, {@code id}, {@code links}, {@code memoryInMb}, {@code name}, {@code result}, {@code state}, {@code updatedAt}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + Objects.hashCode(command);
    h += (h << 5) + Objects.hashCode(createdAt);
    h += (h << 5) + Objects.hashCode(environmentVariables);
    h += (h << 5) + Objects.hashCode(id);
    h += (h << 5) + Objects.hashCode(links);
    h += (h << 5) + Objects.hashCode(memoryInMb);
    h += (h << 5) + Objects.hashCode(name);
    h += (h << 5) + Objects.hashCode(result);
    h += (h << 5) + Objects.hashCode(state);
    h += (h << 5) + Objects.hashCode(updatedAt);
    return h;
  }

  /**
   * Prints the immutable value {@code GetApplicationTaskResponse} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "GetApplicationTaskResponse{"
        + "command=" + command
        + ", createdAt=" + createdAt
        + ", environmentVariables=" + environmentVariables
        + ", id=" + id
        + ", links=" + links
        + ", memoryInMb=" + memoryInMb
        + ", name=" + name
        + ", result=" + result
        + ", state=" + state
        + ", updatedAt=" + updatedAt
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json extends org.cloudfoundry.client.v3.applications._GetApplicationTaskResponse {
    String command;
    String createdAt;
    Map<String, String> environmentVariables;
    String id;
    Map<String, Link> links;
    Integer memoryInMb;
    String name;
    Result result;
    State state;
    String updatedAt;
    @JsonProperty("command")
    public void setCommand(@Nullable String command) {
      this.command = command;
    }
    @JsonProperty("created_at")
    public void setCreatedAt(@Nullable String createdAt) {
      this.createdAt = createdAt;
    }
    @JsonProperty("environment_variables")
    public void setEnvironmentVariables(@Nullable Map<String, String> environmentVariables) {
      this.environmentVariables = environmentVariables;
    }
    @JsonProperty("guid")
    public void setId(@Nullable String id) {
      this.id = id;
    }
    @JsonProperty("links")
    public void setLinks(@Nullable Map<String, Link> links) {
      this.links = links;
    }
    @JsonProperty("memory_in_mb")
    public void setMemoryInMb(@Nullable Integer memoryInMb) {
      this.memoryInMb = memoryInMb;
    }
    @JsonProperty("name")
    public void setName(@Nullable String name) {
      this.name = name;
    }
    @JsonProperty("result")
    public void setResult(@Nullable Result result) {
      this.result = result;
    }
    @JsonProperty("state")
    public void setState(@Nullable State state) {
      this.state = state;
    }
    @JsonProperty("updated_at")
    public void setUpdatedAt(@Nullable String updatedAt) {
      this.updatedAt = updatedAt;
    }
    @Override
    public String getCommand() { throw new UnsupportedOperationException(); }
    @Override
    public String getCreatedAt() { throw new UnsupportedOperationException(); }
    @Override
    public Map<String, String> getEnvironmentVariables() { throw new UnsupportedOperationException(); }
    @Override
    public String getId() { throw new UnsupportedOperationException(); }
    @Override
    public Map<String, Link> getLinks() { throw new UnsupportedOperationException(); }
    @Override
    public Integer getMemoryInMb() { throw new UnsupportedOperationException(); }
    @Override
    public String getName() { throw new UnsupportedOperationException(); }
    @Override
    public Result getResult() { throw new UnsupportedOperationException(); }
    @Override
    public State getState() { throw new UnsupportedOperationException(); }
    @Override
    public String getUpdatedAt() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static GetApplicationTaskResponse fromJson(Json json) {
    GetApplicationTaskResponse.Builder builder = GetApplicationTaskResponse.builder();
    if (json.command != null) {
      builder.command(json.command);
    }
    if (json.createdAt != null) {
      builder.createdAt(json.createdAt);
    }
    if (json.environmentVariables != null) {
      builder.putAllEnvironmentVariables(json.environmentVariables);
    }
    if (json.id != null) {
      builder.id(json.id);
    }
    if (json.links != null) {
      builder.putAllLinks(json.links);
    }
    if (json.memoryInMb != null) {
      builder.memoryInMb(json.memoryInMb);
    }
    if (json.name != null) {
      builder.name(json.name);
    }
    if (json.result != null) {
      builder.result(json.result);
    }
    if (json.state != null) {
      builder.state(json.state);
    }
    if (json.updatedAt != null) {
      builder.updatedAt(json.updatedAt);
    }
    return builder.build();
  }

  /**
   * Creates a builder for {@link GetApplicationTaskResponse GetApplicationTaskResponse}.
   * @return A new GetApplicationTaskResponse builder
   */
  public static GetApplicationTaskResponse.Builder builder() {
    return new GetApplicationTaskResponse.Builder();
  }

  /**
   * Builds instances of type {@link GetApplicationTaskResponse GetApplicationTaskResponse}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  public static final class Builder {
    private String command;
    private String createdAt;
    private Map<String, String> environmentVariables = null;
    private String id;
    private Map<String, Link> links = null;
    private Integer memoryInMb;
    private String name;
    private Result result;
    private State state;
    private String updatedAt;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code org.cloudfoundry.client.v3.tasks.Task} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(Task instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code GetApplicationTaskResponse} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(GetApplicationTaskResponse instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Copy abstract value type {@code _GetApplicationTaskResponse} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_GetApplicationTaskResponse instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    private void from(Object object) {
      if (object instanceof Task) {
        Task instance = (Task) object;
        Result resultValue = instance.getResult();
        if (resultValue != null) {
          result(resultValue);
        }
        String createdAtValue = instance.getCreatedAt();
        if (createdAtValue != null) {
          createdAt(createdAtValue);
        }
        Map<String, String> environmentVariablesValue = instance.getEnvironmentVariables();
        if (environmentVariablesValue != null) {
          putAllEnvironmentVariables(environmentVariablesValue);
        }
        Integer memoryInMbValue = instance.getMemoryInMb();
        if (memoryInMbValue != null) {
          memoryInMb(memoryInMbValue);
        }
        String nameValue = instance.getName();
        if (nameValue != null) {
          name(nameValue);
        }
        Map<String, Link> linksValue = instance.getLinks();
        if (linksValue != null) {
          putAllLinks(linksValue);
        }
        String idValue = instance.getId();
        if (idValue != null) {
          id(idValue);
        }
        State stateValue = instance.getState();
        if (stateValue != null) {
          state(stateValue);
        }
        String commandValue = instance.getCommand();
        if (commandValue != null) {
          command(commandValue);
        }
        String updatedAtValue = instance.getUpdatedAt();
        if (updatedAtValue != null) {
          updatedAt(updatedAtValue);
        }
      }
    }

    /**
     * Initializes the value for the {@link _GetApplicationTaskResponse#getCommand() command} attribute.
     * @param command The value for command (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("command")
    public final Builder command(@Nullable String command) {
      this.command = command;
      return this;
    }

    /**
     * Initializes the value for the {@link _GetApplicationTaskResponse#getCreatedAt() createdAt} attribute.
     * @param createdAt The value for createdAt (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("created_at")
    public final Builder createdAt(@Nullable String createdAt) {
      this.createdAt = createdAt;
      return this;
    }

    /**
     * Put one entry to the {@link _GetApplicationTaskResponse#getEnvironmentVariables() environmentVariables} map.
     * @param key The key in the environmentVariables map
     * @param value The associated value in the environmentVariables map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder environmentVariable(String key, String value) {
      if (this.environmentVariables == null) {
        this.environmentVariables = new LinkedHashMap<String, String>();
      }
      this.environmentVariables.put(key, value);
      return this;
    }

    /**
     * Put one entry to the {@link _GetApplicationTaskResponse#getEnvironmentVariables() environmentVariables} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder environmentVariable(Map.Entry<String, ? extends String> entry) {
      if (this.environmentVariables == null) {
        this.environmentVariables = new LinkedHashMap<String, String>();
      }
      String k = entry.getKey();
      String v = entry.getValue();
      this.environmentVariables.put(k, v);
      return this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link _GetApplicationTaskResponse#getEnvironmentVariables() environmentVariables} map. Nulls are not permitted as keys or values, but parameter itself can be null
     * @param environmentVariables The entries that will be added to the environmentVariables map
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("environment_variables")
    public final Builder environmentVariables(@Nullable Map<String, ? extends String> environmentVariables) {
      if (environmentVariables == null) {
        this.environmentVariables = null;
        return this;
      }
      this.environmentVariables = new LinkedHashMap<String, String>();
      return putAllEnvironmentVariables(environmentVariables);
    }

    /**
     * Put all mappings from the specified map as entries to {@link _GetApplicationTaskResponse#getEnvironmentVariables() environmentVariables} map. Nulls are not permitted
     * @param environmentVariables The entries that will be added to the environmentVariables map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder putAllEnvironmentVariables(Map<String, ? extends String> environmentVariables) {
      if (this.environmentVariables == null) {
        this.environmentVariables = new LinkedHashMap<String, String>();
      }
      for (Map.Entry<String, ? extends String> entry : environmentVariables.entrySet()) {
        String k = entry.getKey();
        String v = entry.getValue();
        this.environmentVariables.put(k, v);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link _GetApplicationTaskResponse#getId() id} attribute.
     * @param id The value for id (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("guid")
    public final Builder id(@Nullable String id) {
      this.id = id;
      return this;
    }

    /**
     * Put one entry to the {@link _GetApplicationTaskResponse#getLinks() links} map.
     * @param key The key in the links map
     * @param value The associated value in the links map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder link(String key, Link value) {
      if (this.links == null) {
        this.links = new LinkedHashMap<String, Link>();
      }
      this.links.put(key, value);
      return this;
    }

    /**
     * Put one entry to the {@link _GetApplicationTaskResponse#getLinks() links} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder link(Map.Entry<String, ? extends Link> entry) {
      if (this.links == null) {
        this.links = new LinkedHashMap<String, Link>();
      }
      String k = entry.getKey();
      Link v = entry.getValue();
      this.links.put(k, v);
      return this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link _GetApplicationTaskResponse#getLinks() links} map. Nulls are not permitted as keys or values, but parameter itself can be null
     * @param links The entries that will be added to the links map
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("links")
    public final Builder links(@Nullable Map<String, ? extends Link> links) {
      if (links == null) {
        this.links = null;
        return this;
      }
      this.links = new LinkedHashMap<String, Link>();
      return putAllLinks(links);
    }

    /**
     * Put all mappings from the specified map as entries to {@link _GetApplicationTaskResponse#getLinks() links} map. Nulls are not permitted
     * @param links The entries that will be added to the links map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder putAllLinks(Map<String, ? extends Link> links) {
      if (this.links == null) {
        this.links = new LinkedHashMap<String, Link>();
      }
      for (Map.Entry<String, ? extends Link> entry : links.entrySet()) {
        String k = entry.getKey();
        Link v = entry.getValue();
        this.links.put(k, v);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link _GetApplicationTaskResponse#getMemoryInMb() memoryInMb} attribute.
     * @param memoryInMb The value for memoryInMb (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("memory_in_mb")
    public final Builder memoryInMb(@Nullable Integer memoryInMb) {
      this.memoryInMb = memoryInMb;
      return this;
    }

    /**
     * Initializes the value for the {@link _GetApplicationTaskResponse#getName() name} attribute.
     * @param name The value for name (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("name")
    public final Builder name(@Nullable String name) {
      this.name = name;
      return this;
    }

    /**
     * Initializes the value for the {@link _GetApplicationTaskResponse#getResult() result} attribute.
     * @param result The value for result (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("result")
    public final Builder result(@Nullable Result result) {
      this.result = result;
      return this;
    }

    /**
     * Initializes the value for the {@link _GetApplicationTaskResponse#getState() state} attribute.
     * @param state The value for state (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("state")
    public final Builder state(@Nullable State state) {
      this.state = state;
      return this;
    }

    /**
     * Initializes the value for the {@link _GetApplicationTaskResponse#getUpdatedAt() updatedAt} attribute.
     * @param updatedAt The value for updatedAt (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("updated_at")
    public final Builder updatedAt(@Nullable String updatedAt) {
      this.updatedAt = updatedAt;
      return this;
    }

    /**
     * Builds a new {@link GetApplicationTaskResponse GetApplicationTaskResponse}.
     * @return An immutable instance of GetApplicationTaskResponse
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public GetApplicationTaskResponse build() {
      return new GetApplicationTaskResponse(this);
    }
  }

  private static <K, V> Map<K, V> createUnmodifiableMap(boolean checkNulls, boolean skipNulls, Map<? extends K, ? extends V> map) {
    switch (map.size()) {
    case 0: return Collections.emptyMap();
    case 1: {
      Map.Entry<? extends K, ? extends V> e = map.entrySet().iterator().next();
      K k = e.getKey();
      V v = e.getValue();
      if (checkNulls) {
        Objects.requireNonNull(k, "key");
        Objects.requireNonNull(v, "value");
      }
      if (skipNulls && (k == null || v == null)) {
        return Collections.emptyMap();
      }
      return Collections.singletonMap(k, v);
    }
    default: {
      Map<K, V> linkedMap = new LinkedHashMap<K, V>(map.size());
      if (skipNulls || checkNulls) {
        for (Map.Entry<? extends K, ? extends V> e : map.entrySet()) {
          K k = e.getKey();
          V v = e.getValue();
          if (skipNulls) {
            if (k == null || v == null) continue;
          } else if (checkNulls) {
            Objects.requireNonNull(k, "key");
            Objects.requireNonNull(v, "value");
          }
          linkedMap.put(k, v);
        }
      } else {
        linkedMap.putAll(map);
      }
      return Collections.unmodifiableMap(linkedMap);
    }
    }
  }
}
