package org.cloudfoundry.client.v3.applications;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Generated;
import org.cloudfoundry.client.v3.Relationship;

/**
 * The relationships for the Create Application request
 */
@SuppressWarnings({"all"})
@Generated({"Immutables.generator", "_Relationships"})
public final class Relationships extends org.cloudfoundry.client.v3.applications._Relationships {
  private final Relationship space;

  private Relationships(Relationships.Builder builder) {
    this.space = builder.space;
  }

  /**
   * The space relationship
   */
  @Override
  public Relationship getSpace() {
    return space;
  }

  /**
   * This instance is equal to all instances of {@code Relationships} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof Relationships
        && equalTo((Relationships) another);
  }

  private boolean equalTo(Relationships another) {
    return space.equals(another.space);
  }

  /**
   * Computes a hash code from attributes: {@code space}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + space.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code Relationships} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "Relationships{"
        + "space=" + space
        + "}";
  }

  /**
   * Creates a builder for {@link Relationships Relationships}.
   * @return A new Relationships builder
   */
  public static Relationships.Builder builder() {
    return new Relationships.Builder();
  }

  /**
   * Builds instances of type {@link Relationships Relationships}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  public static final class Builder {
    private static final long INIT_BIT_SPACE = 0x1L;
    private long initBits = 0x1L;

    private Relationship space;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code Relationships} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(Relationships instance) {
      return from((_Relationships) instance);
    }

    /**
     * Copy abstract value type {@code _Relationships} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_Relationships instance) {
      Objects.requireNonNull(instance, "instance");
      space(instance.getSpace());
      return this;
    }

    /**
     * Initializes the value for the {@link _Relationships#getSpace() space} attribute.
     * @param space The value for space 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder space(Relationship space) {
      this.space = Objects.requireNonNull(space, "space");
      initBits &= ~INIT_BIT_SPACE;
      return this;
    }

    /**
     * Builds a new {@link Relationships Relationships}.
     * @return An immutable instance of Relationships
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public Relationships build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new Relationships(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<String>();
      if ((initBits & INIT_BIT_SPACE) != 0) attributes.add("space");
      return "Cannot build Relationships, some of required attributes are not set " + attributes;
    }
  }
}
