/*
 * Copyright 2013-2017 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.cloudfoundry.client.v3.droplets;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import org.cloudfoundry.AllowNulls;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.client.v3.Hash;
import org.immutables.value.Value;

import java.util.List;
import java.util.Map;

@JsonDeserialize
@Value.Immutable
abstract class _StagedResult implements Result {

    @JsonProperty("buildpacks")
    @Nullable
    abstract List<String> getBuildpacks();

    @JsonProperty("execution_metadata")
    @Nullable
    abstract String getExecutionMetadata();

    @JsonProperty("hash")
    @Nullable
    abstract Hash getHash();

    @AllowNulls
    @JsonProperty("process_types")
    @Nullable
    abstract Map<String, String> getProcessTypes();

    @JsonProperty("stack")
    @Nullable
    abstract String getStack();

}
