package org.cloudfoundry.client.v3.isolationsegments;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.Generated;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.client.v3.PaginatedRequest;

/**
 * The request payload for the List Isolation Segments operation.
 */
@SuppressWarnings({"all"})
@Generated({"Immutables.generator", "_ListIsolationSegmentsRequest"})
public final class ListIsolationSegmentsRequest
    extends org.cloudfoundry.client.v3.isolationsegments._ListIsolationSegmentsRequest {
  private final List<String> ids;
  private final List<String> names;
  private final List<String> organizationIds;
  private final @Nullable Integer page;
  private final @Nullable Integer perPage;

  private ListIsolationSegmentsRequest(ListIsolationSegmentsRequest.Builder builder) {
    this.ids = createUnmodifiableList(true, builder.ids);
    this.names = createUnmodifiableList(true, builder.names);
    this.organizationIds = createUnmodifiableList(true, builder.organizationIds);
    this.page = builder.page;
    this.perPage = builder.perPage;
  }

  /**
   * The ids
   */
  @Override
  public List<String> getIds() {
    return ids;
  }

  /**
   * The names
   */
  @Override
  public List<String> getNames() {
    return names;
  }

  /**
   * The organization ids
   */
  @Override
  public List<String> getOrganizationIds() {
    return organizationIds;
  }

  /**
   * The page
   */
  @Override
  public @Nullable Integer getPage() {
    return page;
  }

  /**
   * The results per page
   */
  @Override
  public @Nullable Integer getPerPage() {
    return perPage;
  }

  /**
   * This instance is equal to all instances of {@code ListIsolationSegmentsRequest} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ListIsolationSegmentsRequest
        && equalTo((ListIsolationSegmentsRequest) another);
  }

  private boolean equalTo(ListIsolationSegmentsRequest another) {
    return ids.equals(another.ids)
        && names.equals(another.names)
        && organizationIds.equals(another.organizationIds)
        && Objects.equals(page, another.page)
        && Objects.equals(perPage, another.perPage);
  }

  /**
   * Computes a hash code from attributes: {@code ids}, {@code names}, {@code organizationIds}, {@code page}, {@code perPage}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + ids.hashCode();
    h += (h << 5) + names.hashCode();
    h += (h << 5) + organizationIds.hashCode();
    h += (h << 5) + Objects.hashCode(page);
    h += (h << 5) + Objects.hashCode(perPage);
    return h;
  }

  /**
   * Prints the immutable value {@code ListIsolationSegmentsRequest} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "ListIsolationSegmentsRequest{"
        + "ids=" + ids
        + ", names=" + names
        + ", organizationIds=" + organizationIds
        + ", page=" + page
        + ", perPage=" + perPage
        + "}";
  }

  /**
   * Creates a builder for {@link ListIsolationSegmentsRequest ListIsolationSegmentsRequest}.
   * @return A new ListIsolationSegmentsRequest builder
   */
  public static ListIsolationSegmentsRequest.Builder builder() {
    return new ListIsolationSegmentsRequest.Builder();
  }

  /**
   * Builds instances of type {@link ListIsolationSegmentsRequest ListIsolationSegmentsRequest}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  public static final class Builder {
    private List<String> ids = new ArrayList<String>();
    private List<String> names = new ArrayList<String>();
    private List<String> organizationIds = new ArrayList<String>();
    private Integer page;
    private Integer perPage;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code ListIsolationSegmentsRequest} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(ListIsolationSegmentsRequest instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Copy abstract value type {@code _ListIsolationSegmentsRequest} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_ListIsolationSegmentsRequest instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code org.cloudfoundry.client.v3.PaginatedRequest} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(PaginatedRequest instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    private void from(Object object) {
      if (object instanceof org.cloudfoundry.client.v3.isolationsegments._ListIsolationSegmentsRequest) {
        org.cloudfoundry.client.v3.isolationsegments._ListIsolationSegmentsRequest instance = (org.cloudfoundry.client.v3.isolationsegments._ListIsolationSegmentsRequest) object;
        addAllOrganizationIds(instance.getOrganizationIds());
        addAllIds(instance.getIds());
        addAllNames(instance.getNames());
      }
      if (object instanceof PaginatedRequest) {
        PaginatedRequest instance = (PaginatedRequest) object;
        Integer perPageValue = instance.getPerPage();
        if (perPageValue != null) {
          perPage(perPageValue);
        }
        Integer pageValue = instance.getPage();
        if (pageValue != null) {
          page(pageValue);
        }
      }
    }

    /**
     * Adds one element to {@link _ListIsolationSegmentsRequest#getIds() ids} list.
     * @param element A ids element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder id(String element) {
      this.ids.add(Objects.requireNonNull(element, "ids element"));
      return this;
    }

    /**
     * Adds elements to {@link _ListIsolationSegmentsRequest#getIds() ids} list.
     * @param elements An array of ids elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder id(String... elements) {
      for (String element : elements) {
        this.ids.add(Objects.requireNonNull(element, "ids element"));
      }
      return this;
    }

    /**
     * Sets or replaces all elements for {@link _ListIsolationSegmentsRequest#getIds() ids} list.
     * @param elements An iterable of ids elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder ids(Iterable<String> elements) {
      this.ids.clear();
      return addAllIds(elements);
    }

    /**
     * Adds elements to {@link _ListIsolationSegmentsRequest#getIds() ids} list.
     * @param elements An iterable of ids elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllIds(Iterable<String> elements) {
      for (String element : elements) {
        this.ids.add(Objects.requireNonNull(element, "ids element"));
      }
      return this;
    }

    /**
     * Adds one element to {@link _ListIsolationSegmentsRequest#getNames() names} list.
     * @param element A names element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder name(String element) {
      this.names.add(Objects.requireNonNull(element, "names element"));
      return this;
    }

    /**
     * Adds elements to {@link _ListIsolationSegmentsRequest#getNames() names} list.
     * @param elements An array of names elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder name(String... elements) {
      for (String element : elements) {
        this.names.add(Objects.requireNonNull(element, "names element"));
      }
      return this;
    }

    /**
     * Sets or replaces all elements for {@link _ListIsolationSegmentsRequest#getNames() names} list.
     * @param elements An iterable of names elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder names(Iterable<String> elements) {
      this.names.clear();
      return addAllNames(elements);
    }

    /**
     * Adds elements to {@link _ListIsolationSegmentsRequest#getNames() names} list.
     * @param elements An iterable of names elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllNames(Iterable<String> elements) {
      for (String element : elements) {
        this.names.add(Objects.requireNonNull(element, "names element"));
      }
      return this;
    }

    /**
     * Adds one element to {@link _ListIsolationSegmentsRequest#getOrganizationIds() organizationIds} list.
     * @param element A organizationIds element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder organizationId(String element) {
      this.organizationIds.add(Objects.requireNonNull(element, "organizationIds element"));
      return this;
    }

    /**
     * Adds elements to {@link _ListIsolationSegmentsRequest#getOrganizationIds() organizationIds} list.
     * @param elements An array of organizationIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder organizationId(String... elements) {
      for (String element : elements) {
        this.organizationIds.add(Objects.requireNonNull(element, "organizationIds element"));
      }
      return this;
    }

    /**
     * Sets or replaces all elements for {@link _ListIsolationSegmentsRequest#getOrganizationIds() organizationIds} list.
     * @param elements An iterable of organizationIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder organizationIds(Iterable<String> elements) {
      this.organizationIds.clear();
      return addAllOrganizationIds(elements);
    }

    /**
     * Adds elements to {@link _ListIsolationSegmentsRequest#getOrganizationIds() organizationIds} list.
     * @param elements An iterable of organizationIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllOrganizationIds(Iterable<String> elements) {
      for (String element : elements) {
        this.organizationIds.add(Objects.requireNonNull(element, "organizationIds element"));
      }
      return this;
    }

    /**
     * Initializes the value for the {@link _ListIsolationSegmentsRequest#getPage() page} attribute.
     * @param page The value for page (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder page(@Nullable Integer page) {
      this.page = page;
      return this;
    }

    /**
     * Initializes the value for the {@link _ListIsolationSegmentsRequest#getPerPage() perPage} attribute.
     * @param perPage The value for perPage (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder perPage(@Nullable Integer perPage) {
      this.perPage = perPage;
      return this;
    }

    /**
     * Builds a new {@link ListIsolationSegmentsRequest ListIsolationSegmentsRequest}.
     * @return An immutable instance of ListIsolationSegmentsRequest
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ListIsolationSegmentsRequest build() {
      return new ListIsolationSegmentsRequest(this);
    }
  }

  private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
    ArrayList<T> list;
    if (iterable instanceof Collection<?>) {
      int size = ((Collection<?>) iterable).size();
      if (size == 0) return Collections.emptyList();
      list = new ArrayList<T>();
    } else {
      list = new ArrayList<T>();
    }
    for (T element : iterable) {
      if (skipNulls && element == null) continue;
      if (checkNulls) Objects.requireNonNull(element, "element");
      list.add(element);
    }
    return list;
  }

  private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
    switch(list.size()) {
    case 0: return Collections.emptyList();
    case 1: return Collections.singletonList(list.get(0));
    default:
      if (clone) {
        return Collections.unmodifiableList(new ArrayList<T>(list));
      } else {
        if (list instanceof ArrayList<?>) {
          ((ArrayList<?>) list).trimToSize();
        }
        return Collections.unmodifiableList(list);
      }
    }
  }
}
