package org.cloudfoundry.client.v3.organizations;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Generated;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.client.v3.Link;

/**
 * The Resource response payload for the List Organizations operation
 */
@SuppressWarnings({"all"})
@Generated({"Immutables.generator", "_OrganizationResource"})
public final class OrganizationResource extends org.cloudfoundry.client.v3.organizations._OrganizationResource {
  private final @Nullable String createdAt;
  private final @Nullable String id;
  private final @Nullable Map<String, Link> links;
  private final @Nullable String name;
  private final @Nullable String updatedAt;

  private OrganizationResource(OrganizationResource.Builder builder) {
    this.createdAt = builder.createdAt;
    this.id = builder.id;
    this.links = builder.links == null ? null : createUnmodifiableMap(false, false, builder.links);
    this.name = builder.name;
    this.updatedAt = builder.updatedAt;
  }

  /**
   * The created at
   */
  @JsonProperty("created_at")
  @Override
  public @Nullable String getCreatedAt() {
    return createdAt;
  }

  /**
   * The organization id
   */
  @JsonProperty("guid")
  @Override
  public @Nullable String getId() {
    return id;
  }

  /**
   * The links
   */
  @JsonProperty("links")
  @Override
  public @Nullable Map<String, Link> getLinks() {
    return links;
  }

  /**
   * The name
   */
  @JsonProperty("name")
  @Override
  public @Nullable String getName() {
    return name;
  }

  /**
   * The updated at
   */
  @JsonProperty("updated_at")
  @Override
  public @Nullable String getUpdatedAt() {
    return updatedAt;
  }

  /**
   * This instance is equal to all instances of {@code OrganizationResource} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof OrganizationResource
        && equalTo((OrganizationResource) another);
  }

  private boolean equalTo(OrganizationResource another) {
    return Objects.equals(createdAt, another.createdAt)
        && Objects.equals(id, another.id)
        && Objects.equals(links, another.links)
        && Objects.equals(name, another.name)
        && Objects.equals(updatedAt, another.updatedAt);
  }

  /**
   * Computes a hash code from attributes: {@code createdAt}, {@code id}, {@code links}, {@code name}, {@code updatedAt}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + Objects.hashCode(createdAt);
    h += (h << 5) + Objects.hashCode(id);
    h += (h << 5) + Objects.hashCode(links);
    h += (h << 5) + Objects.hashCode(name);
    h += (h << 5) + Objects.hashCode(updatedAt);
    return h;
  }

  /**
   * Prints the immutable value {@code OrganizationResource} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "OrganizationResource{"
        + "createdAt=" + createdAt
        + ", id=" + id
        + ", links=" + links
        + ", name=" + name
        + ", updatedAt=" + updatedAt
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json extends org.cloudfoundry.client.v3.organizations._OrganizationResource {
    String createdAt;
    String id;
    Map<String, Link> links;
    String name;
    String updatedAt;
    @JsonProperty("created_at")
    public void setCreatedAt(@Nullable String createdAt) {
      this.createdAt = createdAt;
    }
    @JsonProperty("guid")
    public void setId(@Nullable String id) {
      this.id = id;
    }
    @JsonProperty("links")
    public void setLinks(@Nullable Map<String, Link> links) {
      this.links = links;
    }
    @JsonProperty("name")
    public void setName(@Nullable String name) {
      this.name = name;
    }
    @JsonProperty("updated_at")
    public void setUpdatedAt(@Nullable String updatedAt) {
      this.updatedAt = updatedAt;
    }
    @Override
    public String getCreatedAt() { throw new UnsupportedOperationException(); }
    @Override
    public String getId() { throw new UnsupportedOperationException(); }
    @Override
    public Map<String, Link> getLinks() { throw new UnsupportedOperationException(); }
    @Override
    public String getName() { throw new UnsupportedOperationException(); }
    @Override
    public String getUpdatedAt() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static OrganizationResource fromJson(Json json) {
    OrganizationResource.Builder builder = OrganizationResource.builder();
    if (json.createdAt != null) {
      builder.createdAt(json.createdAt);
    }
    if (json.id != null) {
      builder.id(json.id);
    }
    if (json.links != null) {
      builder.putAllLinks(json.links);
    }
    if (json.name != null) {
      builder.name(json.name);
    }
    if (json.updatedAt != null) {
      builder.updatedAt(json.updatedAt);
    }
    return builder.build();
  }

  /**
   * Creates a builder for {@link OrganizationResource OrganizationResource}.
   * @return A new OrganizationResource builder
   */
  public static OrganizationResource.Builder builder() {
    return new OrganizationResource.Builder();
  }

  /**
   * Builds instances of type {@link OrganizationResource OrganizationResource}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  public static final class Builder {
    private String createdAt;
    private String id;
    private Map<String, Link> links = null;
    private String name;
    private String updatedAt;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code org.cloudfoundry.client.v3.organizations.Organization} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(Organization instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code OrganizationResource} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(OrganizationResource instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Copy abstract value type {@code _OrganizationResource} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_OrganizationResource instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    private void from(Object object) {
      if (object instanceof Organization) {
        Organization instance = (Organization) object;
        String nameValue = instance.getName();
        if (nameValue != null) {
          name(nameValue);
        }
        String createdAtValue = instance.getCreatedAt();
        if (createdAtValue != null) {
          createdAt(createdAtValue);
        }
        Map<String, Link> linksValue = instance.getLinks();
        if (linksValue != null) {
          putAllLinks(linksValue);
        }
        String idValue = instance.getId();
        if (idValue != null) {
          id(idValue);
        }
        String updatedAtValue = instance.getUpdatedAt();
        if (updatedAtValue != null) {
          updatedAt(updatedAtValue);
        }
      }
    }

    /**
     * Initializes the value for the {@link _OrganizationResource#getCreatedAt() createdAt} attribute.
     * @param createdAt The value for createdAt (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("created_at")
    public final Builder createdAt(@Nullable String createdAt) {
      this.createdAt = createdAt;
      return this;
    }

    /**
     * Initializes the value for the {@link _OrganizationResource#getId() id} attribute.
     * @param id The value for id (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("guid")
    public final Builder id(@Nullable String id) {
      this.id = id;
      return this;
    }

    /**
     * Put one entry to the {@link _OrganizationResource#getLinks() links} map.
     * @param key The key in the links map
     * @param value The associated value in the links map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder link(String key, Link value) {
      if (this.links == null) {
        this.links = new LinkedHashMap<String, Link>();
      }
      this.links.put(key, value);
      return this;
    }

    /**
     * Put one entry to the {@link _OrganizationResource#getLinks() links} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder link(Map.Entry<String, ? extends Link> entry) {
      if (this.links == null) {
        this.links = new LinkedHashMap<String, Link>();
      }
      String k = entry.getKey();
      Link v = entry.getValue();
      this.links.put(k, v);
      return this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link _OrganizationResource#getLinks() links} map. Nulls are not permitted as keys or values, but parameter itself can be null
     * @param links The entries that will be added to the links map
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("links")
    public final Builder links(@Nullable Map<String, ? extends Link> links) {
      if (links == null) {
        this.links = null;
        return this;
      }
      this.links = new LinkedHashMap<String, Link>();
      return putAllLinks(links);
    }

    /**
     * Put all mappings from the specified map as entries to {@link _OrganizationResource#getLinks() links} map. Nulls are not permitted
     * @param links The entries that will be added to the links map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder putAllLinks(Map<String, ? extends Link> links) {
      if (this.links == null) {
        this.links = new LinkedHashMap<String, Link>();
      }
      for (Map.Entry<String, ? extends Link> entry : links.entrySet()) {
        String k = entry.getKey();
        Link v = entry.getValue();
        this.links.put(k, v);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link _OrganizationResource#getName() name} attribute.
     * @param name The value for name (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("name")
    public final Builder name(@Nullable String name) {
      this.name = name;
      return this;
    }

    /**
     * Initializes the value for the {@link _OrganizationResource#getUpdatedAt() updatedAt} attribute.
     * @param updatedAt The value for updatedAt (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("updated_at")
    public final Builder updatedAt(@Nullable String updatedAt) {
      this.updatedAt = updatedAt;
      return this;
    }

    /**
     * Builds a new {@link OrganizationResource OrganizationResource}.
     * @return An immutable instance of OrganizationResource
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public OrganizationResource build() {
      return new OrganizationResource(this);
    }
  }

  private static <K, V> Map<K, V> createUnmodifiableMap(boolean checkNulls, boolean skipNulls, Map<? extends K, ? extends V> map) {
    switch (map.size()) {
    case 0: return Collections.emptyMap();
    case 1: {
      Map.Entry<? extends K, ? extends V> e = map.entrySet().iterator().next();
      K k = e.getKey();
      V v = e.getValue();
      if (checkNulls) {
        Objects.requireNonNull(k, "key");
        Objects.requireNonNull(v, "value");
      }
      if (skipNulls && (k == null || v == null)) {
        return Collections.emptyMap();
      }
      return Collections.singletonMap(k, v);
    }
    default: {
      Map<K, V> linkedMap = new LinkedHashMap<K, V>(map.size());
      if (skipNulls || checkNulls) {
        for (Map.Entry<? extends K, ? extends V> e : map.entrySet()) {
          K k = e.getKey();
          V v = e.getValue();
          if (skipNulls) {
            if (k == null || v == null) continue;
          } else if (checkNulls) {
            Objects.requireNonNull(k, "key");
            Objects.requireNonNull(v, "value");
          }
          linkedMap.put(k, v);
        }
      } else {
        linkedMap.putAll(map);
      }
      return Collections.unmodifiableMap(linkedMap);
    }
    }
  }
}
