package org.cloudfoundry.client.v3.packages;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Generated;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.client.v3.Lifecycle;

/**
 * The request payload for the Stage Package operation
 */
@SuppressWarnings({"all"})
@Generated({"Immutables.generator", "_StagePackageRequest"})
public final class StagePackageRequest extends org.cloudfoundry.client.v3.packages._StagePackageRequest {
  private final @Nullable Map<String, Object> environmentVariables;
  private final @Nullable Lifecycle lifecycle;
  private final String packageId;
  private final @Nullable Integer stagingDiskInMb;
  private final @Nullable Integer stagingMemoryInMb;

  private StagePackageRequest(StagePackageRequest.Builder builder) {
    this.environmentVariables = builder.environmentVariables == null ? null : createUnmodifiableMap(false, false, builder.environmentVariables);
    this.lifecycle = builder.lifecycle;
    this.packageId = builder.packageId;
    this.stagingDiskInMb = builder.stagingDiskInMb;
    this.stagingMemoryInMb = builder.stagingMemoryInMb;
  }

  /**
   * The environment variables
   */
  @Override
  public @Nullable Map<String, Object> getEnvironmentVariables() {
    return environmentVariables;
  }

  /**
   * The lifecycle
   */
  @Override
  public @Nullable Lifecycle getLifecycle() {
    return lifecycle;
  }

  /**
   * The package id
   */
  @Override
  public String getPackageId() {
    return packageId;
  }

  /**
   * The staging disk in MB
   */
  @Override
  public @Nullable Integer getStagingDiskInMb() {
    return stagingDiskInMb;
  }

  /**
   * The staging memory in MB
   */
  @Override
  public @Nullable Integer getStagingMemoryInMb() {
    return stagingMemoryInMb;
  }

  /**
   * This instance is equal to all instances of {@code StagePackageRequest} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof StagePackageRequest
        && equalTo((StagePackageRequest) another);
  }

  private boolean equalTo(StagePackageRequest another) {
    return Objects.equals(environmentVariables, another.environmentVariables)
        && Objects.equals(lifecycle, another.lifecycle)
        && packageId.equals(another.packageId)
        && Objects.equals(stagingDiskInMb, another.stagingDiskInMb)
        && Objects.equals(stagingMemoryInMb, another.stagingMemoryInMb);
  }

  /**
   * Computes a hash code from attributes: {@code environmentVariables}, {@code lifecycle}, {@code packageId}, {@code stagingDiskInMb}, {@code stagingMemoryInMb}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + Objects.hashCode(environmentVariables);
    h += (h << 5) + Objects.hashCode(lifecycle);
    h += (h << 5) + packageId.hashCode();
    h += (h << 5) + Objects.hashCode(stagingDiskInMb);
    h += (h << 5) + Objects.hashCode(stagingMemoryInMb);
    return h;
  }

  /**
   * Prints the immutable value {@code StagePackageRequest} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "StagePackageRequest{"
        + "environmentVariables=" + environmentVariables
        + ", lifecycle=" + lifecycle
        + ", packageId=" + packageId
        + ", stagingDiskInMb=" + stagingDiskInMb
        + ", stagingMemoryInMb=" + stagingMemoryInMb
        + "}";
  }

  /**
   * Creates a builder for {@link StagePackageRequest StagePackageRequest}.
   * @return A new StagePackageRequest builder
   */
  public static StagePackageRequest.Builder builder() {
    return new StagePackageRequest.Builder();
  }

  /**
   * Builds instances of type {@link StagePackageRequest StagePackageRequest}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  public static final class Builder {
    private static final long INIT_BIT_PACKAGE_ID = 0x1L;
    private long initBits = 0x1L;

    private Map<String, Object> environmentVariables = null;
    private Lifecycle lifecycle;
    private String packageId;
    private Integer stagingDiskInMb;
    private Integer stagingMemoryInMb;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code StagePackageRequest} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(StagePackageRequest instance) {
      return from((_StagePackageRequest) instance);
    }

    /**
     * Copy abstract value type {@code _StagePackageRequest} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_StagePackageRequest instance) {
      Objects.requireNonNull(instance, "instance");
      Map<String, Object> environmentVariablesValue = instance.getEnvironmentVariables();
      if (environmentVariablesValue != null) {
        putAllEnvironmentVariables(environmentVariablesValue);
      }
      Lifecycle lifecycleValue = instance.getLifecycle();
      if (lifecycleValue != null) {
        lifecycle(lifecycleValue);
      }
      packageId(instance.getPackageId());
      Integer stagingDiskInMbValue = instance.getStagingDiskInMb();
      if (stagingDiskInMbValue != null) {
        stagingDiskInMb(stagingDiskInMbValue);
      }
      Integer stagingMemoryInMbValue = instance.getStagingMemoryInMb();
      if (stagingMemoryInMbValue != null) {
        stagingMemoryInMb(stagingMemoryInMbValue);
      }
      return this;
    }

    /**
     * Put one entry to the {@link _StagePackageRequest#getEnvironmentVariables() environmentVariables} map.
     * @param key The key in the environmentVariables map
     * @param value The associated value in the environmentVariables map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder environmentVariable(String key, Object value) {
      if (this.environmentVariables == null) {
        this.environmentVariables = new LinkedHashMap<String, Object>();
      }
      this.environmentVariables.put(key, value);
      return this;
    }

    /**
     * Put one entry to the {@link _StagePackageRequest#getEnvironmentVariables() environmentVariables} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder environmentVariable(Map.Entry<String, ? extends Object> entry) {
      if (this.environmentVariables == null) {
        this.environmentVariables = new LinkedHashMap<String, Object>();
      }
      String k = entry.getKey();
      Object v = entry.getValue();
      this.environmentVariables.put(k, v);
      return this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link _StagePackageRequest#getEnvironmentVariables() environmentVariables} map. Nulls are not permitted as keys or values, but parameter itself can be null
     * @param environmentVariables The entries that will be added to the environmentVariables map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder environmentVariables(@Nullable Map<String, ? extends Object> environmentVariables) {
      if (environmentVariables == null) {
        this.environmentVariables = null;
        return this;
      }
      this.environmentVariables = new LinkedHashMap<String, Object>();
      return putAllEnvironmentVariables(environmentVariables);
    }

    /**
     * Put all mappings from the specified map as entries to {@link _StagePackageRequest#getEnvironmentVariables() environmentVariables} map. Nulls are not permitted
     * @param environmentVariables The entries that will be added to the environmentVariables map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder putAllEnvironmentVariables(Map<String, ? extends Object> environmentVariables) {
      if (this.environmentVariables == null) {
        this.environmentVariables = new LinkedHashMap<String, Object>();
      }
      for (Map.Entry<String, ? extends Object> entry : environmentVariables.entrySet()) {
        String k = entry.getKey();
        Object v = entry.getValue();
        this.environmentVariables.put(k, v);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link _StagePackageRequest#getLifecycle() lifecycle} attribute.
     * @param lifecycle The value for lifecycle (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder lifecycle(@Nullable Lifecycle lifecycle) {
      this.lifecycle = lifecycle;
      return this;
    }

    /**
     * Initializes the value for the {@link _StagePackageRequest#getPackageId() packageId} attribute.
     * @param packageId The value for packageId 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder packageId(String packageId) {
      this.packageId = Objects.requireNonNull(packageId, "packageId");
      initBits &= ~INIT_BIT_PACKAGE_ID;
      return this;
    }

    /**
     * Initializes the value for the {@link _StagePackageRequest#getStagingDiskInMb() stagingDiskInMb} attribute.
     * @param stagingDiskInMb The value for stagingDiskInMb (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder stagingDiskInMb(@Nullable Integer stagingDiskInMb) {
      this.stagingDiskInMb = stagingDiskInMb;
      return this;
    }

    /**
     * Initializes the value for the {@link _StagePackageRequest#getStagingMemoryInMb() stagingMemoryInMb} attribute.
     * @param stagingMemoryInMb The value for stagingMemoryInMb (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder stagingMemoryInMb(@Nullable Integer stagingMemoryInMb) {
      this.stagingMemoryInMb = stagingMemoryInMb;
      return this;
    }

    /**
     * Builds a new {@link StagePackageRequest StagePackageRequest}.
     * @return An immutable instance of StagePackageRequest
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public StagePackageRequest build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new StagePackageRequest(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<String>();
      if ((initBits & INIT_BIT_PACKAGE_ID) != 0) attributes.add("packageId");
      return "Cannot build StagePackageRequest, some of required attributes are not set " + attributes;
    }
  }

  private static <K, V> Map<K, V> createUnmodifiableMap(boolean checkNulls, boolean skipNulls, Map<? extends K, ? extends V> map) {
    switch (map.size()) {
    case 0: return Collections.emptyMap();
    case 1: {
      Map.Entry<? extends K, ? extends V> e = map.entrySet().iterator().next();
      K k = e.getKey();
      V v = e.getValue();
      if (checkNulls) {
        Objects.requireNonNull(k, "key");
        Objects.requireNonNull(v, "value");
      }
      if (skipNulls && (k == null || v == null)) {
        return Collections.emptyMap();
      }
      return Collections.singletonMap(k, v);
    }
    default: {
      Map<K, V> linkedMap = new LinkedHashMap<K, V>(map.size());
      if (skipNulls || checkNulls) {
        for (Map.Entry<? extends K, ? extends V> e : map.entrySet()) {
          K k = e.getKey();
          V v = e.getValue();
          if (skipNulls) {
            if (k == null || v == null) continue;
          } else if (checkNulls) {
            Objects.requireNonNull(k, "key");
            Objects.requireNonNull(v, "value");
          }
          linkedMap.put(k, v);
        }
      } else {
        linkedMap.putAll(map);
      }
      return Collections.unmodifiableMap(linkedMap);
    }
    }
  }
}
