package org.cloudfoundry.client.v3.processes;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Generated;
import org.cloudfoundry.Nullable;

/**
 * The request payload for the Scale Process operation
 */
@SuppressWarnings({"all"})
@Generated({"Immutables.generator", "_ScaleProcessRequest"})
public final class ScaleProcessRequest extends org.cloudfoundry.client.v3.processes._ScaleProcessRequest {
  private final @Nullable Integer diskInMb;
  private final @Nullable Integer instances;
  private final @Nullable Integer memoryInMb;
  private final String processId;

  private ScaleProcessRequest(ScaleProcessRequest.Builder builder) {
    this.diskInMb = builder.diskInMb;
    this.instances = builder.instances;
    this.memoryInMb = builder.memoryInMb;
    this.processId = builder.processId;
  }

  /**
   * The disk in megabytes
   */
  @Override
  public @Nullable Integer getDiskInMb() {
    return diskInMb;
  }

  /**
   * The number of instances
   */
  @Override
  public @Nullable Integer getInstances() {
    return instances;
  }

  /**
   * The memory in megabytes
   */
  @Override
  public @Nullable Integer getMemoryInMb() {
    return memoryInMb;
  }

  /**
   * The process id
   */
  @Override
  public String getProcessId() {
    return processId;
  }

  /**
   * This instance is equal to all instances of {@code ScaleProcessRequest} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ScaleProcessRequest
        && equalTo((ScaleProcessRequest) another);
  }

  private boolean equalTo(ScaleProcessRequest another) {
    return Objects.equals(diskInMb, another.diskInMb)
        && Objects.equals(instances, another.instances)
        && Objects.equals(memoryInMb, another.memoryInMb)
        && processId.equals(another.processId);
  }

  /**
   * Computes a hash code from attributes: {@code diskInMb}, {@code instances}, {@code memoryInMb}, {@code processId}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + Objects.hashCode(diskInMb);
    h += (h << 5) + Objects.hashCode(instances);
    h += (h << 5) + Objects.hashCode(memoryInMb);
    h += (h << 5) + processId.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code ScaleProcessRequest} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "ScaleProcessRequest{"
        + "diskInMb=" + diskInMb
        + ", instances=" + instances
        + ", memoryInMb=" + memoryInMb
        + ", processId=" + processId
        + "}";
  }

  /**
   * Creates a builder for {@link ScaleProcessRequest ScaleProcessRequest}.
   * @return A new ScaleProcessRequest builder
   */
  public static ScaleProcessRequest.Builder builder() {
    return new ScaleProcessRequest.Builder();
  }

  /**
   * Builds instances of type {@link ScaleProcessRequest ScaleProcessRequest}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  public static final class Builder {
    private static final long INIT_BIT_PROCESS_ID = 0x1L;
    private long initBits = 0x1L;

    private Integer diskInMb;
    private Integer instances;
    private Integer memoryInMb;
    private String processId;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code ScaleProcessRequest} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(ScaleProcessRequest instance) {
      return from((_ScaleProcessRequest) instance);
    }

    /**
     * Copy abstract value type {@code _ScaleProcessRequest} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_ScaleProcessRequest instance) {
      Objects.requireNonNull(instance, "instance");
      Integer diskInMbValue = instance.getDiskInMb();
      if (diskInMbValue != null) {
        diskInMb(diskInMbValue);
      }
      Integer instancesValue = instance.getInstances();
      if (instancesValue != null) {
        instances(instancesValue);
      }
      Integer memoryInMbValue = instance.getMemoryInMb();
      if (memoryInMbValue != null) {
        memoryInMb(memoryInMbValue);
      }
      processId(instance.getProcessId());
      return this;
    }

    /**
     * Initializes the value for the {@link _ScaleProcessRequest#getDiskInMb() diskInMb} attribute.
     * @param diskInMb The value for diskInMb (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder diskInMb(@Nullable Integer diskInMb) {
      this.diskInMb = diskInMb;
      return this;
    }

    /**
     * Initializes the value for the {@link _ScaleProcessRequest#getInstances() instances} attribute.
     * @param instances The value for instances (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder instances(@Nullable Integer instances) {
      this.instances = instances;
      return this;
    }

    /**
     * Initializes the value for the {@link _ScaleProcessRequest#getMemoryInMb() memoryInMb} attribute.
     * @param memoryInMb The value for memoryInMb (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder memoryInMb(@Nullable Integer memoryInMb) {
      this.memoryInMb = memoryInMb;
      return this;
    }

    /**
     * Initializes the value for the {@link _ScaleProcessRequest#getProcessId() processId} attribute.
     * @param processId The value for processId 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder processId(String processId) {
      this.processId = Objects.requireNonNull(processId, "processId");
      initBits &= ~INIT_BIT_PROCESS_ID;
      return this;
    }

    /**
     * Builds a new {@link ScaleProcessRequest ScaleProcessRequest}.
     * @return An immutable instance of ScaleProcessRequest
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ScaleProcessRequest build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ScaleProcessRequest(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<String>();
      if ((initBits & INIT_BIT_PROCESS_ID) != 0) attributes.add("processId");
      return "Cannot build ScaleProcessRequest, some of required attributes are not set " + attributes;
    }
  }
}
