package org.cloudfoundry.uaa.clients;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Generated;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.uaa.IdentityZoned;

/**
 * The request payload for Change Secret
 */
@SuppressWarnings({"all"})
@Generated({"Immutables.generator", "_ChangeSecretRequest"})
public final class ChangeSecretRequest extends org.cloudfoundry.uaa.clients._ChangeSecretRequest {
  private final String clientId;
  private final @Nullable String oldSecret;
  private final String secret;
  private final @Nullable String identityZoneId;

  private ChangeSecretRequest(ChangeSecretRequest.Builder builder) {
    this.clientId = builder.clientId;
    this.oldSecret = builder.oldSecret;
    this.secret = builder.secret;
    this.identityZoneId = builder.identityZoneId;
  }

  /**
   * The client id
   */
  @Override
  public String getClientId() {
    return clientId;
  }

  /**
   * The old secret
   */
  @Override
  public @Nullable String getOldSecret() {
    return oldSecret;
  }

  /**
   * The new secret
   */
  @Override
  public String getSecret() {
    return secret;
  }

  /**
   * Returns the identity zone id
   * @return the identity zone id
   */
  @Override
  public @Nullable String getIdentityZoneId() {
    return identityZoneId;
  }

  /**
   * This instance is equal to all instances of {@code ChangeSecretRequest} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ChangeSecretRequest
        && equalTo((ChangeSecretRequest) another);
  }

  private boolean equalTo(ChangeSecretRequest another) {
    return clientId.equals(another.clientId)
        && Objects.equals(oldSecret, another.oldSecret)
        && secret.equals(another.secret)
        && Objects.equals(identityZoneId, another.identityZoneId);
  }

  /**
   * Computes a hash code from attributes: {@code clientId}, {@code oldSecret}, {@code secret}, {@code identityZoneId}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + clientId.hashCode();
    h += (h << 5) + Objects.hashCode(oldSecret);
    h += (h << 5) + secret.hashCode();
    h += (h << 5) + Objects.hashCode(identityZoneId);
    return h;
  }

  /**
   * Prints the immutable value {@code ChangeSecretRequest} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "ChangeSecretRequest{"
        + "clientId=" + clientId
        + ", oldSecret=" + oldSecret
        + ", secret=" + secret
        + ", identityZoneId=" + identityZoneId
        + "}";
  }

  /**
   * Creates a builder for {@link ChangeSecretRequest ChangeSecretRequest}.
   * @return A new ChangeSecretRequest builder
   */
  public static ChangeSecretRequest.Builder builder() {
    return new ChangeSecretRequest.Builder();
  }

  /**
   * Builds instances of type {@link ChangeSecretRequest ChangeSecretRequest}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  public static final class Builder {
    private static final long INIT_BIT_CLIENT_ID = 0x1L;
    private static final long INIT_BIT_SECRET = 0x2L;
    private long initBits = 0x3L;

    private String clientId;
    private String oldSecret;
    private String secret;
    private String identityZoneId;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code org.cloudfoundry.uaa.IdentityZoned} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(IdentityZoned instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code org.cloudfoundry.uaa.clients.AbstractChangeSecret} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(AbstractChangeSecret instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code ChangeSecretRequest} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(ChangeSecretRequest instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Copy abstract value type {@code _ChangeSecretRequest} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_ChangeSecretRequest instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    private void from(Object object) {
      if (object instanceof IdentityZoned) {
        IdentityZoned instance = (IdentityZoned) object;
        String identityZoneIdValue = instance.getIdentityZoneId();
        if (identityZoneIdValue != null) {
          identityZoneId(identityZoneIdValue);
        }
      }
      if (object instanceof AbstractChangeSecret) {
        AbstractChangeSecret instance = (AbstractChangeSecret) object;
        String oldSecretValue = instance.getOldSecret();
        if (oldSecretValue != null) {
          oldSecret(oldSecretValue);
        }
        clientId(instance.getClientId());
        secret(instance.getSecret());
      }
    }

    /**
     * Initializes the value for the {@link _ChangeSecretRequest#getClientId() clientId} attribute.
     * @param clientId The value for clientId 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder clientId(String clientId) {
      this.clientId = Objects.requireNonNull(clientId, "clientId");
      initBits &= ~INIT_BIT_CLIENT_ID;
      return this;
    }

    /**
     * Initializes the value for the {@link _ChangeSecretRequest#getOldSecret() oldSecret} attribute.
     * @param oldSecret The value for oldSecret (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder oldSecret(@Nullable String oldSecret) {
      this.oldSecret = oldSecret;
      return this;
    }

    /**
     * Initializes the value for the {@link _ChangeSecretRequest#getSecret() secret} attribute.
     * @param secret The value for secret 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder secret(String secret) {
      this.secret = Objects.requireNonNull(secret, "secret");
      initBits &= ~INIT_BIT_SECRET;
      return this;
    }

    /**
     * Initializes the value for the {@link _ChangeSecretRequest#getIdentityZoneId() identityZoneId} attribute.
     * @param identityZoneId The value for identityZoneId (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder identityZoneId(@Nullable String identityZoneId) {
      this.identityZoneId = identityZoneId;
      return this;
    }

    /**
     * Builds a new {@link ChangeSecretRequest ChangeSecretRequest}.
     * @return An immutable instance of ChangeSecretRequest
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ChangeSecretRequest build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ChangeSecretRequest(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<String>();
      if ((initBits & INIT_BIT_CLIENT_ID) != 0) attributes.add("clientId");
      if ((initBits & INIT_BIT_SECRET) != 0) attributes.add("secret");
      return "Cannot build ChangeSecretRequest, some of required attributes are not set " + attributes;
    }
  }
}
