package org.cloudfoundry.uaa.identityzones;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Generated;
import org.cloudfoundry.Nullable;

/**
 * The request payload for the create identity zone operation
 */
@SuppressWarnings({"all"})
@Generated({"Immutables.generator", "_CreateIdentityZoneRequest"})
public final class CreateIdentityZoneRequest
    extends org.cloudfoundry.uaa.identityzones._CreateIdentityZoneRequest {
  private final @Nullable IdentityZoneConfiguration configuration;
  private final @Nullable Long createdAt;
  private final @Nullable String description;
  private final @Nullable String identityZoneId;
  private final @Nullable Long lastModified;
  private final String name;
  private final String subdomain;
  private final @Nullable Integer version;

  private CreateIdentityZoneRequest(CreateIdentityZoneRequest.Builder builder) {
    this.configuration = builder.configuration;
    this.createdAt = builder.createdAt;
    this.description = builder.description;
    this.identityZoneId = builder.identityZoneId;
    this.lastModified = builder.lastModified;
    this.name = builder.name;
    this.subdomain = builder.subdomain;
    this.version = builder.version;
  }

  /**
   * The configuration
   */
  @Override
  public @Nullable IdentityZoneConfiguration getConfiguration() {
    return configuration;
  }

  /**
   * The creation date of the identity zone
   */
  @Override
  public @Nullable Long getCreatedAt() {
    return createdAt;
  }

  /**
   * The description of the identity zone
   */
  @Override
  public @Nullable String getDescription() {
    return description;
  }

  /**
   * The id of the identity zone. When not provided, an identifier will be generated
   */
  @Override
  public @Nullable String getIdentityZoneId() {
    return identityZoneId;
  }

  /**
   * The last modification date of the identity zone
   */
  @Override
  public @Nullable Long getLastModified() {
    return lastModified;
  }

  /**
   * The name of the identity zone
   */
  @Override
  public String getName() {
    return name;
  }

  /**
   * The unique subdomain. It will be converted into lowercase upon creation.
   */
  @Override
  public String getSubdomain() {
    return subdomain;
  }

  /**
   * The version of the identity zone
   */
  @Override
  public @Nullable Integer getVersion() {
    return version;
  }

  /**
   * This instance is equal to all instances of {@code CreateIdentityZoneRequest} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof CreateIdentityZoneRequest
        && equalTo((CreateIdentityZoneRequest) another);
  }

  private boolean equalTo(CreateIdentityZoneRequest another) {
    return Objects.equals(configuration, another.configuration)
        && Objects.equals(createdAt, another.createdAt)
        && Objects.equals(description, another.description)
        && Objects.equals(identityZoneId, another.identityZoneId)
        && Objects.equals(lastModified, another.lastModified)
        && name.equals(another.name)
        && subdomain.equals(another.subdomain)
        && Objects.equals(version, another.version);
  }

  /**
   * Computes a hash code from attributes: {@code configuration}, {@code createdAt}, {@code description}, {@code identityZoneId}, {@code lastModified}, {@code name}, {@code subdomain}, {@code version}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + Objects.hashCode(configuration);
    h += (h << 5) + Objects.hashCode(createdAt);
    h += (h << 5) + Objects.hashCode(description);
    h += (h << 5) + Objects.hashCode(identityZoneId);
    h += (h << 5) + Objects.hashCode(lastModified);
    h += (h << 5) + name.hashCode();
    h += (h << 5) + subdomain.hashCode();
    h += (h << 5) + Objects.hashCode(version);
    return h;
  }

  /**
   * Prints the immutable value {@code CreateIdentityZoneRequest} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "CreateIdentityZoneRequest{"
        + "configuration=" + configuration
        + ", createdAt=" + createdAt
        + ", description=" + description
        + ", identityZoneId=" + identityZoneId
        + ", lastModified=" + lastModified
        + ", name=" + name
        + ", subdomain=" + subdomain
        + ", version=" + version
        + "}";
  }

  /**
   * Creates a builder for {@link CreateIdentityZoneRequest CreateIdentityZoneRequest}.
   * @return A new CreateIdentityZoneRequest builder
   */
  public static CreateIdentityZoneRequest.Builder builder() {
    return new CreateIdentityZoneRequest.Builder();
  }

  /**
   * Builds instances of type {@link CreateIdentityZoneRequest CreateIdentityZoneRequest}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  public static final class Builder {
    private static final long INIT_BIT_NAME = 0x1L;
    private static final long INIT_BIT_SUBDOMAIN = 0x2L;
    private long initBits = 0x3L;

    private IdentityZoneConfiguration configuration;
    private Long createdAt;
    private String description;
    private String identityZoneId;
    private Long lastModified;
    private String name;
    private String subdomain;
    private Integer version;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code CreateIdentityZoneRequest} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(CreateIdentityZoneRequest instance) {
      return from((_CreateIdentityZoneRequest) instance);
    }

    /**
     * Copy abstract value type {@code _CreateIdentityZoneRequest} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_CreateIdentityZoneRequest instance) {
      Objects.requireNonNull(instance, "instance");
      IdentityZoneConfiguration configurationValue = instance.getConfiguration();
      if (configurationValue != null) {
        configuration(configurationValue);
      }
      Long createdAtValue = instance.getCreatedAt();
      if (createdAtValue != null) {
        createdAt(createdAtValue);
      }
      String descriptionValue = instance.getDescription();
      if (descriptionValue != null) {
        description(descriptionValue);
      }
      String identityZoneIdValue = instance.getIdentityZoneId();
      if (identityZoneIdValue != null) {
        identityZoneId(identityZoneIdValue);
      }
      Long lastModifiedValue = instance.getLastModified();
      if (lastModifiedValue != null) {
        lastModified(lastModifiedValue);
      }
      name(instance.getName());
      subdomain(instance.getSubdomain());
      Integer versionValue = instance.getVersion();
      if (versionValue != null) {
        version(versionValue);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link _CreateIdentityZoneRequest#getConfiguration() configuration} attribute.
     * @param configuration The value for configuration (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder configuration(@Nullable IdentityZoneConfiguration configuration) {
      this.configuration = configuration;
      return this;
    }

    /**
     * Initializes the value for the {@link _CreateIdentityZoneRequest#getCreatedAt() createdAt} attribute.
     * @param createdAt The value for createdAt (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder createdAt(@Nullable Long createdAt) {
      this.createdAt = createdAt;
      return this;
    }

    /**
     * Initializes the value for the {@link _CreateIdentityZoneRequest#getDescription() description} attribute.
     * @param description The value for description (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder description(@Nullable String description) {
      this.description = description;
      return this;
    }

    /**
     * Initializes the value for the {@link _CreateIdentityZoneRequest#getIdentityZoneId() identityZoneId} attribute.
     * @param identityZoneId The value for identityZoneId (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder identityZoneId(@Nullable String identityZoneId) {
      this.identityZoneId = identityZoneId;
      return this;
    }

    /**
     * Initializes the value for the {@link _CreateIdentityZoneRequest#getLastModified() lastModified} attribute.
     * @param lastModified The value for lastModified (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder lastModified(@Nullable Long lastModified) {
      this.lastModified = lastModified;
      return this;
    }

    /**
     * Initializes the value for the {@link _CreateIdentityZoneRequest#getName() name} attribute.
     * @param name The value for name 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder name(String name) {
      this.name = Objects.requireNonNull(name, "name");
      initBits &= ~INIT_BIT_NAME;
      return this;
    }

    /**
     * Initializes the value for the {@link _CreateIdentityZoneRequest#getSubdomain() subdomain} attribute.
     * @param subdomain The value for subdomain 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder subdomain(String subdomain) {
      this.subdomain = Objects.requireNonNull(subdomain, "subdomain");
      initBits &= ~INIT_BIT_SUBDOMAIN;
      return this;
    }

    /**
     * Initializes the value for the {@link _CreateIdentityZoneRequest#getVersion() version} attribute.
     * @param version The value for version (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder version(@Nullable Integer version) {
      this.version = version;
      return this;
    }

    /**
     * Builds a new {@link CreateIdentityZoneRequest CreateIdentityZoneRequest}.
     * @return An immutable instance of CreateIdentityZoneRequest
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public CreateIdentityZoneRequest build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new CreateIdentityZoneRequest(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<String>();
      if ((initBits & INIT_BIT_NAME) != 0) attributes.add("name");
      if ((initBits & INIT_BIT_SUBDOMAIN) != 0) attributes.add("subdomain");
      return "Cannot build CreateIdentityZoneRequest, some of required attributes are not set " + attributes;
    }
  }
}
