package org.cloudfoundry.uaa.identityzones;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.Objects;
import javax.annotation.Generated;
import org.cloudfoundry.Nullable;

/**
 * The payload for the identity zone saml configuration
 */
@SuppressWarnings({"all"})
@Generated({"Immutables.generator", "_SamlConfiguration"})
public final class SamlConfiguration extends org.cloudfoundry.uaa.identityzones._SamlConfiguration {
  private final @Nullable Boolean assertionSigned;
  private final @Nullable Integer assertionTimeToLive;
  private final @Nullable String certificate;
  private final @Nullable String privateKey;
  private final @Nullable String privateKeyPassword;
  private final @Nullable Boolean requestSigned;
  private final @Nullable Boolean wantAssertionSigned;
  private final @Nullable Boolean wantPartnerAuthenticationRequestSigned;

  private SamlConfiguration(SamlConfiguration.Builder builder) {
    this.assertionSigned = builder.assertionSigned;
    this.assertionTimeToLive = builder.assertionTimeToLive;
    this.certificate = builder.certificate;
    this.privateKey = builder.privateKey;
    this.privateKeyPassword = builder.privateKeyPassword;
    this.requestSigned = builder.requestSigned;
    this.wantAssertionSigned = builder.wantAssertionSigned;
    this.wantPartnerAuthenticationRequestSigned = builder.wantPartnerAuthenticationRequestSigned;
  }

  /**
   * If true, the SAML provider will sign all assertions.
   */
  @JsonProperty("assertionSigned")
  @Override
  public @Nullable Boolean getAssertionSigned() {
    return assertionSigned;
  }

  /**
   * The lifetime of a SAML assertion in seconds.
   */
  @JsonProperty("assertionTimeToLiveSeconds")
  @Override
  public @Nullable Integer getAssertionTimeToLive() {
    return assertionTimeToLive;
  }

  /**
   * Exposed SAML metadata property. The certificate used to sign all communications.
   */
  @JsonProperty("certificate")
  @Override
  public @Nullable String getCertificate() {
    return certificate;
  }

  /**
   * Exposed SAML metadata property. The SAML provider’s private key.
   */
  @JsonProperty("privateKey")
  @Override
  public @Nullable String getPrivateKey() {
    return privateKey;
  }

  /**
   * Exposed SAML metadata property. The SAML provider’s private key password. Reserved for future use.
   */
  @JsonProperty("privateKeyPassword")
  @Override
  public @Nullable String getPrivateKeyPassword() {
    return privateKeyPassword;
  }

  /**
   * Exposed SAML metadata property. If true, the service provider will sign all outgoing authentication requests.
   */
  @JsonProperty("requestSigned")
  @Override
  public @Nullable Boolean getRequestSigned() {
    return requestSigned;
  }

  /**
   * Exposed SAML metadata property. If true, all assertions received by the SAML provider must be signed.
   */
  @JsonProperty("wantAssertionSigned")
  @Override
  public @Nullable Boolean getWantAssertionSigned() {
    return wantAssertionSigned;
  }

  /**
   * If true, the authentication request from the partner service provider must be signed.
   */
  @JsonProperty("wantAuthnRequestSigned")
  @Override
  public @Nullable Boolean getWantPartnerAuthenticationRequestSigned() {
    return wantPartnerAuthenticationRequestSigned;
  }

  /**
   * This instance is equal to all instances of {@code SamlConfiguration} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof SamlConfiguration
        && equalTo((SamlConfiguration) another);
  }

  private boolean equalTo(SamlConfiguration another) {
    return Objects.equals(assertionSigned, another.assertionSigned)
        && Objects.equals(assertionTimeToLive, another.assertionTimeToLive)
        && Objects.equals(certificate, another.certificate)
        && Objects.equals(privateKey, another.privateKey)
        && Objects.equals(privateKeyPassword, another.privateKeyPassword)
        && Objects.equals(requestSigned, another.requestSigned)
        && Objects.equals(wantAssertionSigned, another.wantAssertionSigned)
        && Objects.equals(wantPartnerAuthenticationRequestSigned, another.wantPartnerAuthenticationRequestSigned);
  }

  /**
   * Computes a hash code from attributes: {@code assertionSigned}, {@code assertionTimeToLive}, {@code certificate}, {@code privateKey}, {@code privateKeyPassword}, {@code requestSigned}, {@code wantAssertionSigned}, {@code wantPartnerAuthenticationRequestSigned}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + Objects.hashCode(assertionSigned);
    h += (h << 5) + Objects.hashCode(assertionTimeToLive);
    h += (h << 5) + Objects.hashCode(certificate);
    h += (h << 5) + Objects.hashCode(privateKey);
    h += (h << 5) + Objects.hashCode(privateKeyPassword);
    h += (h << 5) + Objects.hashCode(requestSigned);
    h += (h << 5) + Objects.hashCode(wantAssertionSigned);
    h += (h << 5) + Objects.hashCode(wantPartnerAuthenticationRequestSigned);
    return h;
  }

  /**
   * Prints the immutable value {@code SamlConfiguration} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "SamlConfiguration{"
        + "assertionSigned=" + assertionSigned
        + ", assertionTimeToLive=" + assertionTimeToLive
        + ", certificate=" + certificate
        + ", privateKey=" + privateKey
        + ", privateKeyPassword=" + privateKeyPassword
        + ", requestSigned=" + requestSigned
        + ", wantAssertionSigned=" + wantAssertionSigned
        + ", wantPartnerAuthenticationRequestSigned=" + wantPartnerAuthenticationRequestSigned
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json extends org.cloudfoundry.uaa.identityzones._SamlConfiguration {
    Boolean assertionSigned;
    Integer assertionTimeToLive;
    String certificate;
    String privateKey;
    String privateKeyPassword;
    Boolean requestSigned;
    Boolean wantAssertionSigned;
    Boolean wantPartnerAuthenticationRequestSigned;
    @JsonProperty("assertionSigned")
    public void setAssertionSigned(@Nullable Boolean assertionSigned) {
      this.assertionSigned = assertionSigned;
    }
    @JsonProperty("assertionTimeToLiveSeconds")
    public void setAssertionTimeToLive(@Nullable Integer assertionTimeToLive) {
      this.assertionTimeToLive = assertionTimeToLive;
    }
    @JsonProperty("certificate")
    public void setCertificate(@Nullable String certificate) {
      this.certificate = certificate;
    }
    @JsonProperty("privateKey")
    public void setPrivateKey(@Nullable String privateKey) {
      this.privateKey = privateKey;
    }
    @JsonProperty("privateKeyPassword")
    public void setPrivateKeyPassword(@Nullable String privateKeyPassword) {
      this.privateKeyPassword = privateKeyPassword;
    }
    @JsonProperty("requestSigned")
    public void setRequestSigned(@Nullable Boolean requestSigned) {
      this.requestSigned = requestSigned;
    }
    @JsonProperty("wantAssertionSigned")
    public void setWantAssertionSigned(@Nullable Boolean wantAssertionSigned) {
      this.wantAssertionSigned = wantAssertionSigned;
    }
    @JsonProperty("wantAuthnRequestSigned")
    public void setWantPartnerAuthenticationRequestSigned(@Nullable Boolean wantPartnerAuthenticationRequestSigned) {
      this.wantPartnerAuthenticationRequestSigned = wantPartnerAuthenticationRequestSigned;
    }
    @Override
    public Boolean getAssertionSigned() { throw new UnsupportedOperationException(); }
    @Override
    public Integer getAssertionTimeToLive() { throw new UnsupportedOperationException(); }
    @Override
    public String getCertificate() { throw new UnsupportedOperationException(); }
    @Override
    public String getPrivateKey() { throw new UnsupportedOperationException(); }
    @Override
    public String getPrivateKeyPassword() { throw new UnsupportedOperationException(); }
    @Override
    public Boolean getRequestSigned() { throw new UnsupportedOperationException(); }
    @Override
    public Boolean getWantAssertionSigned() { throw new UnsupportedOperationException(); }
    @Override
    public Boolean getWantPartnerAuthenticationRequestSigned() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static SamlConfiguration fromJson(Json json) {
    SamlConfiguration.Builder builder = SamlConfiguration.builder();
    if (json.assertionSigned != null) {
      builder.assertionSigned(json.assertionSigned);
    }
    if (json.assertionTimeToLive != null) {
      builder.assertionTimeToLive(json.assertionTimeToLive);
    }
    if (json.certificate != null) {
      builder.certificate(json.certificate);
    }
    if (json.privateKey != null) {
      builder.privateKey(json.privateKey);
    }
    if (json.privateKeyPassword != null) {
      builder.privateKeyPassword(json.privateKeyPassword);
    }
    if (json.requestSigned != null) {
      builder.requestSigned(json.requestSigned);
    }
    if (json.wantAssertionSigned != null) {
      builder.wantAssertionSigned(json.wantAssertionSigned);
    }
    if (json.wantPartnerAuthenticationRequestSigned != null) {
      builder.wantPartnerAuthenticationRequestSigned(json.wantPartnerAuthenticationRequestSigned);
    }
    return builder.build();
  }

  /**
   * Creates a builder for {@link SamlConfiguration SamlConfiguration}.
   * @return A new SamlConfiguration builder
   */
  public static SamlConfiguration.Builder builder() {
    return new SamlConfiguration.Builder();
  }

  /**
   * Builds instances of type {@link SamlConfiguration SamlConfiguration}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  public static final class Builder {
    private Boolean assertionSigned;
    private Integer assertionTimeToLive;
    private String certificate;
    private String privateKey;
    private String privateKeyPassword;
    private Boolean requestSigned;
    private Boolean wantAssertionSigned;
    private Boolean wantPartnerAuthenticationRequestSigned;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code SamlConfiguration} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(SamlConfiguration instance) {
      return from((_SamlConfiguration) instance);
    }

    /**
     * Copy abstract value type {@code _SamlConfiguration} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_SamlConfiguration instance) {
      Objects.requireNonNull(instance, "instance");
      Boolean assertionSignedValue = instance.getAssertionSigned();
      if (assertionSignedValue != null) {
        assertionSigned(assertionSignedValue);
      }
      Integer assertionTimeToLiveValue = instance.getAssertionTimeToLive();
      if (assertionTimeToLiveValue != null) {
        assertionTimeToLive(assertionTimeToLiveValue);
      }
      String certificateValue = instance.getCertificate();
      if (certificateValue != null) {
        certificate(certificateValue);
      }
      String privateKeyValue = instance.getPrivateKey();
      if (privateKeyValue != null) {
        privateKey(privateKeyValue);
      }
      String privateKeyPasswordValue = instance.getPrivateKeyPassword();
      if (privateKeyPasswordValue != null) {
        privateKeyPassword(privateKeyPasswordValue);
      }
      Boolean requestSignedValue = instance.getRequestSigned();
      if (requestSignedValue != null) {
        requestSigned(requestSignedValue);
      }
      Boolean wantAssertionSignedValue = instance.getWantAssertionSigned();
      if (wantAssertionSignedValue != null) {
        wantAssertionSigned(wantAssertionSignedValue);
      }
      Boolean wantPartnerAuthenticationRequestSignedValue = instance.getWantPartnerAuthenticationRequestSigned();
      if (wantPartnerAuthenticationRequestSignedValue != null) {
        wantPartnerAuthenticationRequestSigned(wantPartnerAuthenticationRequestSignedValue);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link _SamlConfiguration#getAssertionSigned() assertionSigned} attribute.
     * @param assertionSigned The value for assertionSigned (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("assertionSigned")
    public final Builder assertionSigned(@Nullable Boolean assertionSigned) {
      this.assertionSigned = assertionSigned;
      return this;
    }

    /**
     * Initializes the value for the {@link _SamlConfiguration#getAssertionTimeToLive() assertionTimeToLive} attribute.
     * @param assertionTimeToLive The value for assertionTimeToLive (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("assertionTimeToLiveSeconds")
    public final Builder assertionTimeToLive(@Nullable Integer assertionTimeToLive) {
      this.assertionTimeToLive = assertionTimeToLive;
      return this;
    }

    /**
     * Initializes the value for the {@link _SamlConfiguration#getCertificate() certificate} attribute.
     * @param certificate The value for certificate (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("certificate")
    public final Builder certificate(@Nullable String certificate) {
      this.certificate = certificate;
      return this;
    }

    /**
     * Initializes the value for the {@link _SamlConfiguration#getPrivateKey() privateKey} attribute.
     * @param privateKey The value for privateKey (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("privateKey")
    public final Builder privateKey(@Nullable String privateKey) {
      this.privateKey = privateKey;
      return this;
    }

    /**
     * Initializes the value for the {@link _SamlConfiguration#getPrivateKeyPassword() privateKeyPassword} attribute.
     * @param privateKeyPassword The value for privateKeyPassword (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("privateKeyPassword")
    public final Builder privateKeyPassword(@Nullable String privateKeyPassword) {
      this.privateKeyPassword = privateKeyPassword;
      return this;
    }

    /**
     * Initializes the value for the {@link _SamlConfiguration#getRequestSigned() requestSigned} attribute.
     * @param requestSigned The value for requestSigned (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("requestSigned")
    public final Builder requestSigned(@Nullable Boolean requestSigned) {
      this.requestSigned = requestSigned;
      return this;
    }

    /**
     * Initializes the value for the {@link _SamlConfiguration#getWantAssertionSigned() wantAssertionSigned} attribute.
     * @param wantAssertionSigned The value for wantAssertionSigned (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("wantAssertionSigned")
    public final Builder wantAssertionSigned(@Nullable Boolean wantAssertionSigned) {
      this.wantAssertionSigned = wantAssertionSigned;
      return this;
    }

    /**
     * Initializes the value for the {@link _SamlConfiguration#getWantPartnerAuthenticationRequestSigned() wantPartnerAuthenticationRequestSigned} attribute.
     * @param wantPartnerAuthenticationRequestSigned The value for wantPartnerAuthenticationRequestSigned (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("wantAuthnRequestSigned")
    public final Builder wantPartnerAuthenticationRequestSigned(@Nullable Boolean wantPartnerAuthenticationRequestSigned) {
      this.wantPartnerAuthenticationRequestSigned = wantPartnerAuthenticationRequestSigned;
      return this;
    }

    /**
     * Builds a new {@link SamlConfiguration SamlConfiguration}.
     * @return An immutable instance of SamlConfiguration
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public SamlConfiguration build() {
      return new SamlConfiguration(this);
    }
  }
}
