package org.cloudfoundry.uaa.identityzones;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Generated;
import org.cloudfoundry.Nullable;

/**
 * The payload for the identity zone token policy
 */
@SuppressWarnings({"all"})
@Generated({"Immutables.generator", "_TokenPolicy"})
public final class TokenPolicy extends org.cloudfoundry.uaa.identityzones._TokenPolicy {
  private final @Nullable Integer accessTokenValidity;
  private final @Nullable String activeKeyId;
  private final @Nullable Boolean jwtRevocable;
  private final @Nullable Map<String, Object> keys;
  private final @Nullable RefreshTokenFormat refreshTokenFormat;
  private final @Nullable Boolean refreshTokenUnique;
  private final @Nullable Integer refreshTokenValidity;

  private TokenPolicy(TokenPolicy.Builder builder) {
    this.accessTokenValidity = builder.accessTokenValidity;
    this.activeKeyId = builder.activeKeyId;
    this.jwtRevocable = builder.jwtRevocable;
    this.keys = builder.keys == null ? null : createUnmodifiableMap(false, false, builder.keys);
    this.refreshTokenFormat = builder.refreshTokenFormat;
    this.refreshTokenUnique = builder.refreshTokenUnique;
    this.refreshTokenValidity = builder.refreshTokenValidity;
  }

  /**
   * Time in seconds between when a access token is issued and when it expires
   */
  @JsonProperty("accessTokenValidity")
  @Override
  public @Nullable Integer getAccessTokenValidity() {
    return accessTokenValidity;
  }

  /**
   * The ID of the key that is used to sign tokens
   */
  @JsonProperty("activeKeyId")
  @Override
  public @Nullable String getActiveKeyId() {
    return activeKeyId;
  }

  /**
   * Whether the JWT token is revocable
   */
  @JsonProperty("jwtRevocable")
  @Override
  public @Nullable Boolean getJwtRevocable() {
    return jwtRevocable;
  }

  /**
   * The keys of the token policy
   */
  @JsonProperty("keys")
  @Override
  public @Nullable Map<String, Object> getKeys() {
    return keys;
  }

  /**
   * The format for the refresh token
   */
  @JsonProperty("refreshTokenFormat")
  @Override
  public @Nullable RefreshTokenFormat getRefreshTokenFormat() {
    return refreshTokenFormat;
  }

  /**
   * If true, uaa will only issue one refresh token per client_id/user_id combination
   */
  @JsonProperty("refreshTokenUnique")
  @Override
  public @Nullable Boolean getRefreshTokenUnique() {
    return refreshTokenUnique;
  }

  /**
   * Time in seconds between when a refresh token is issued and when it expires
   */
  @JsonProperty("refreshTokenValidity")
  @Override
  public @Nullable Integer getRefreshTokenValidity() {
    return refreshTokenValidity;
  }

  /**
   * This instance is equal to all instances of {@code TokenPolicy} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof TokenPolicy
        && equalTo((TokenPolicy) another);
  }

  private boolean equalTo(TokenPolicy another) {
    return Objects.equals(accessTokenValidity, another.accessTokenValidity)
        && Objects.equals(activeKeyId, another.activeKeyId)
        && Objects.equals(jwtRevocable, another.jwtRevocable)
        && Objects.equals(keys, another.keys)
        && Objects.equals(refreshTokenFormat, another.refreshTokenFormat)
        && Objects.equals(refreshTokenUnique, another.refreshTokenUnique)
        && Objects.equals(refreshTokenValidity, another.refreshTokenValidity);
  }

  /**
   * Computes a hash code from attributes: {@code accessTokenValidity}, {@code activeKeyId}, {@code jwtRevocable}, {@code keys}, {@code refreshTokenFormat}, {@code refreshTokenUnique}, {@code refreshTokenValidity}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + Objects.hashCode(accessTokenValidity);
    h += (h << 5) + Objects.hashCode(activeKeyId);
    h += (h << 5) + Objects.hashCode(jwtRevocable);
    h += (h << 5) + Objects.hashCode(keys);
    h += (h << 5) + Objects.hashCode(refreshTokenFormat);
    h += (h << 5) + Objects.hashCode(refreshTokenUnique);
    h += (h << 5) + Objects.hashCode(refreshTokenValidity);
    return h;
  }

  /**
   * Prints the immutable value {@code TokenPolicy} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "TokenPolicy{"
        + "accessTokenValidity=" + accessTokenValidity
        + ", activeKeyId=" + activeKeyId
        + ", jwtRevocable=" + jwtRevocable
        + ", keys=" + keys
        + ", refreshTokenFormat=" + refreshTokenFormat
        + ", refreshTokenUnique=" + refreshTokenUnique
        + ", refreshTokenValidity=" + refreshTokenValidity
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json extends org.cloudfoundry.uaa.identityzones._TokenPolicy {
    Integer accessTokenValidity;
    String activeKeyId;
    Boolean jwtRevocable;
    Map<String, Object> keys;
    RefreshTokenFormat refreshTokenFormat;
    Boolean refreshTokenUnique;
    Integer refreshTokenValidity;
    @JsonProperty("accessTokenValidity")
    public void setAccessTokenValidity(@Nullable Integer accessTokenValidity) {
      this.accessTokenValidity = accessTokenValidity;
    }
    @JsonProperty("activeKeyId")
    public void setActiveKeyId(@Nullable String activeKeyId) {
      this.activeKeyId = activeKeyId;
    }
    @JsonProperty("jwtRevocable")
    public void setJwtRevocable(@Nullable Boolean jwtRevocable) {
      this.jwtRevocable = jwtRevocable;
    }
    @JsonProperty("keys")
    public void setKeys(@Nullable Map<String, Object> keys) {
      this.keys = keys;
    }
    @JsonProperty("refreshTokenFormat")
    public void setRefreshTokenFormat(@Nullable RefreshTokenFormat refreshTokenFormat) {
      this.refreshTokenFormat = refreshTokenFormat;
    }
    @JsonProperty("refreshTokenUnique")
    public void setRefreshTokenUnique(@Nullable Boolean refreshTokenUnique) {
      this.refreshTokenUnique = refreshTokenUnique;
    }
    @JsonProperty("refreshTokenValidity")
    public void setRefreshTokenValidity(@Nullable Integer refreshTokenValidity) {
      this.refreshTokenValidity = refreshTokenValidity;
    }
    @Override
    public Integer getAccessTokenValidity() { throw new UnsupportedOperationException(); }
    @Override
    public String getActiveKeyId() { throw new UnsupportedOperationException(); }
    @Override
    public Boolean getJwtRevocable() { throw new UnsupportedOperationException(); }
    @Override
    public Map<String, Object> getKeys() { throw new UnsupportedOperationException(); }
    @Override
    public RefreshTokenFormat getRefreshTokenFormat() { throw new UnsupportedOperationException(); }
    @Override
    public Boolean getRefreshTokenUnique() { throw new UnsupportedOperationException(); }
    @Override
    public Integer getRefreshTokenValidity() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static TokenPolicy fromJson(Json json) {
    TokenPolicy.Builder builder = TokenPolicy.builder();
    if (json.accessTokenValidity != null) {
      builder.accessTokenValidity(json.accessTokenValidity);
    }
    if (json.activeKeyId != null) {
      builder.activeKeyId(json.activeKeyId);
    }
    if (json.jwtRevocable != null) {
      builder.jwtRevocable(json.jwtRevocable);
    }
    if (json.keys != null) {
      builder.putAllKeys(json.keys);
    }
    if (json.refreshTokenFormat != null) {
      builder.refreshTokenFormat(json.refreshTokenFormat);
    }
    if (json.refreshTokenUnique != null) {
      builder.refreshTokenUnique(json.refreshTokenUnique);
    }
    if (json.refreshTokenValidity != null) {
      builder.refreshTokenValidity(json.refreshTokenValidity);
    }
    return builder.build();
  }

  /**
   * Creates a builder for {@link TokenPolicy TokenPolicy}.
   * @return A new TokenPolicy builder
   */
  public static TokenPolicy.Builder builder() {
    return new TokenPolicy.Builder();
  }

  /**
   * Builds instances of type {@link TokenPolicy TokenPolicy}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  public static final class Builder {
    private Integer accessTokenValidity;
    private String activeKeyId;
    private Boolean jwtRevocable;
    private Map<String, Object> keys = null;
    private RefreshTokenFormat refreshTokenFormat;
    private Boolean refreshTokenUnique;
    private Integer refreshTokenValidity;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code TokenPolicy} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(TokenPolicy instance) {
      return from((_TokenPolicy) instance);
    }

    /**
     * Copy abstract value type {@code _TokenPolicy} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_TokenPolicy instance) {
      Objects.requireNonNull(instance, "instance");
      Integer accessTokenValidityValue = instance.getAccessTokenValidity();
      if (accessTokenValidityValue != null) {
        accessTokenValidity(accessTokenValidityValue);
      }
      String activeKeyIdValue = instance.getActiveKeyId();
      if (activeKeyIdValue != null) {
        activeKeyId(activeKeyIdValue);
      }
      Boolean jwtRevocableValue = instance.getJwtRevocable();
      if (jwtRevocableValue != null) {
        jwtRevocable(jwtRevocableValue);
      }
      Map<String, Object> keysValue = instance.getKeys();
      if (keysValue != null) {
        putAllKeys(keysValue);
      }
      RefreshTokenFormat refreshTokenFormatValue = instance.getRefreshTokenFormat();
      if (refreshTokenFormatValue != null) {
        refreshTokenFormat(refreshTokenFormatValue);
      }
      Boolean refreshTokenUniqueValue = instance.getRefreshTokenUnique();
      if (refreshTokenUniqueValue != null) {
        refreshTokenUnique(refreshTokenUniqueValue);
      }
      Integer refreshTokenValidityValue = instance.getRefreshTokenValidity();
      if (refreshTokenValidityValue != null) {
        refreshTokenValidity(refreshTokenValidityValue);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link _TokenPolicy#getAccessTokenValidity() accessTokenValidity} attribute.
     * @param accessTokenValidity The value for accessTokenValidity (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("accessTokenValidity")
    public final Builder accessTokenValidity(@Nullable Integer accessTokenValidity) {
      this.accessTokenValidity = accessTokenValidity;
      return this;
    }

    /**
     * Initializes the value for the {@link _TokenPolicy#getActiveKeyId() activeKeyId} attribute.
     * @param activeKeyId The value for activeKeyId (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("activeKeyId")
    public final Builder activeKeyId(@Nullable String activeKeyId) {
      this.activeKeyId = activeKeyId;
      return this;
    }

    /**
     * Initializes the value for the {@link _TokenPolicy#getJwtRevocable() jwtRevocable} attribute.
     * @param jwtRevocable The value for jwtRevocable (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("jwtRevocable")
    public final Builder jwtRevocable(@Nullable Boolean jwtRevocable) {
      this.jwtRevocable = jwtRevocable;
      return this;
    }

    /**
     * Put one entry to the {@link _TokenPolicy#getKeys() keys} map.
     * @param key The key in the keys map
     * @param value The associated value in the keys map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder key(String key, Object value) {
      if (this.keys == null) {
        this.keys = new LinkedHashMap<String, Object>();
      }
      this.keys.put(key, value);
      return this;
    }

    /**
     * Put one entry to the {@link _TokenPolicy#getKeys() keys} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder key(Map.Entry<String, ? extends Object> entry) {
      if (this.keys == null) {
        this.keys = new LinkedHashMap<String, Object>();
      }
      String k = entry.getKey();
      Object v = entry.getValue();
      this.keys.put(k, v);
      return this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link _TokenPolicy#getKeys() keys} map. Nulls are not permitted as keys or values, but parameter itself can be null
     * @param keys The entries that will be added to the keys map
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("keys")
    public final Builder keys(@Nullable Map<String, ? extends Object> keys) {
      if (keys == null) {
        this.keys = null;
        return this;
      }
      this.keys = new LinkedHashMap<String, Object>();
      return putAllKeys(keys);
    }

    /**
     * Put all mappings from the specified map as entries to {@link _TokenPolicy#getKeys() keys} map. Nulls are not permitted
     * @param keys The entries that will be added to the keys map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder putAllKeys(Map<String, ? extends Object> keys) {
      if (this.keys == null) {
        this.keys = new LinkedHashMap<String, Object>();
      }
      for (Map.Entry<String, ? extends Object> entry : keys.entrySet()) {
        String k = entry.getKey();
        Object v = entry.getValue();
        this.keys.put(k, v);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link _TokenPolicy#getRefreshTokenFormat() refreshTokenFormat} attribute.
     * @param refreshTokenFormat The value for refreshTokenFormat (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("refreshTokenFormat")
    public final Builder refreshTokenFormat(@Nullable RefreshTokenFormat refreshTokenFormat) {
      this.refreshTokenFormat = refreshTokenFormat;
      return this;
    }

    /**
     * Initializes the value for the {@link _TokenPolicy#getRefreshTokenUnique() refreshTokenUnique} attribute.
     * @param refreshTokenUnique The value for refreshTokenUnique (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("refreshTokenUnique")
    public final Builder refreshTokenUnique(@Nullable Boolean refreshTokenUnique) {
      this.refreshTokenUnique = refreshTokenUnique;
      return this;
    }

    /**
     * Initializes the value for the {@link _TokenPolicy#getRefreshTokenValidity() refreshTokenValidity} attribute.
     * @param refreshTokenValidity The value for refreshTokenValidity (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("refreshTokenValidity")
    public final Builder refreshTokenValidity(@Nullable Integer refreshTokenValidity) {
      this.refreshTokenValidity = refreshTokenValidity;
      return this;
    }

    /**
     * Builds a new {@link TokenPolicy TokenPolicy}.
     * @return An immutable instance of TokenPolicy
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public TokenPolicy build() {
      return new TokenPolicy(this);
    }
  }

  private static <K, V> Map<K, V> createUnmodifiableMap(boolean checkNulls, boolean skipNulls, Map<? extends K, ? extends V> map) {
    switch (map.size()) {
    case 0: return Collections.emptyMap();
    case 1: {
      Map.Entry<? extends K, ? extends V> e = map.entrySet().iterator().next();
      K k = e.getKey();
      V v = e.getValue();
      if (checkNulls) {
        Objects.requireNonNull(k, "key");
        Objects.requireNonNull(v, "value");
      }
      if (skipNulls && (k == null || v == null)) {
        return Collections.emptyMap();
      }
      return Collections.singletonMap(k, v);
    }
    default: {
      Map<K, V> linkedMap = new LinkedHashMap<K, V>(map.size());
      if (skipNulls || checkNulls) {
        for (Map.Entry<? extends K, ? extends V> e : map.entrySet()) {
          K k = e.getKey();
          V v = e.getValue();
          if (skipNulls) {
            if (k == null || v == null) continue;
          } else if (checkNulls) {
            Objects.requireNonNull(k, "key");
            Objects.requireNonNull(v, "value");
          }
          linkedMap.put(k, v);
        }
      } else {
        linkedMap.putAll(map);
      }
      return Collections.unmodifiableMap(linkedMap);
    }
    }
  }
}
