package org.cloudfoundry.uaa.users;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Generated;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.uaa.IdentityZoned;

/**
 * The request payload for the change user password operation
 */
@SuppressWarnings({"all"})
@Generated({"Immutables.generator", "_ChangeUserPasswordRequest"})
public final class ChangeUserPasswordRequest extends org.cloudfoundry.uaa.users._ChangeUserPasswordRequest {
  private final String oldPassword;
  private final String password;
  private final String userId;
  private final @Nullable String identityZoneId;

  private ChangeUserPasswordRequest(ChangeUserPasswordRequest.Builder builder) {
    this.oldPassword = builder.oldPassword;
    this.password = builder.password;
    this.userId = builder.userId;
    this.identityZoneId = builder.identityZoneId;
  }

  /**
   * The user's existing password
   */
  @Override
  public String getOldPassword() {
    return oldPassword;
  }

  /**
   * The user's desired password
   */
  @Override
  public String getPassword() {
    return password;
  }

  /**
   * The user id
   */
  @Override
  public String getUserId() {
    return userId;
  }

  /**
   * Returns the identity zone id
   * @return the identity zone id
   */
  @Override
  public @Nullable String getIdentityZoneId() {
    return identityZoneId;
  }

  /**
   * This instance is equal to all instances of {@code ChangeUserPasswordRequest} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ChangeUserPasswordRequest
        && equalTo((ChangeUserPasswordRequest) another);
  }

  private boolean equalTo(ChangeUserPasswordRequest another) {
    return oldPassword.equals(another.oldPassword)
        && password.equals(another.password)
        && userId.equals(another.userId)
        && Objects.equals(identityZoneId, another.identityZoneId);
  }

  /**
   * Computes a hash code from attributes: {@code oldPassword}, {@code password}, {@code userId}, {@code identityZoneId}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + oldPassword.hashCode();
    h += (h << 5) + password.hashCode();
    h += (h << 5) + userId.hashCode();
    h += (h << 5) + Objects.hashCode(identityZoneId);
    return h;
  }

  /**
   * Prints the immutable value {@code ChangeUserPasswordRequest} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "ChangeUserPasswordRequest{"
        + "oldPassword=" + oldPassword
        + ", password=" + password
        + ", userId=" + userId
        + ", identityZoneId=" + identityZoneId
        + "}";
  }

  /**
   * Creates a builder for {@link ChangeUserPasswordRequest ChangeUserPasswordRequest}.
   * @return A new ChangeUserPasswordRequest builder
   */
  public static ChangeUserPasswordRequest.Builder builder() {
    return new ChangeUserPasswordRequest.Builder();
  }

  /**
   * Builds instances of type {@link ChangeUserPasswordRequest ChangeUserPasswordRequest}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  public static final class Builder {
    private static final long INIT_BIT_OLD_PASSWORD = 0x1L;
    private static final long INIT_BIT_PASSWORD = 0x2L;
    private static final long INIT_BIT_USER_ID = 0x4L;
    private long initBits = 0x7L;

    private String oldPassword;
    private String password;
    private String userId;
    private String identityZoneId;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code org.cloudfoundry.uaa.IdentityZoned} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(IdentityZoned instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code ChangeUserPasswordRequest} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(ChangeUserPasswordRequest instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Copy abstract value type {@code _ChangeUserPasswordRequest} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_ChangeUserPasswordRequest instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    private void from(Object object) {
      if (object instanceof IdentityZoned) {
        IdentityZoned instance = (IdentityZoned) object;
        String identityZoneIdValue = instance.getIdentityZoneId();
        if (identityZoneIdValue != null) {
          identityZoneId(identityZoneIdValue);
        }
      }
      if (object instanceof org.cloudfoundry.uaa.users._ChangeUserPasswordRequest) {
        org.cloudfoundry.uaa.users._ChangeUserPasswordRequest instance = (org.cloudfoundry.uaa.users._ChangeUserPasswordRequest) object;
        userId(instance.getUserId());
        password(instance.getPassword());
        oldPassword(instance.getOldPassword());
      }
    }

    /**
     * Initializes the value for the {@link _ChangeUserPasswordRequest#getOldPassword() oldPassword} attribute.
     * @param oldPassword The value for oldPassword 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder oldPassword(String oldPassword) {
      this.oldPassword = Objects.requireNonNull(oldPassword, "oldPassword");
      initBits &= ~INIT_BIT_OLD_PASSWORD;
      return this;
    }

    /**
     * Initializes the value for the {@link _ChangeUserPasswordRequest#getPassword() password} attribute.
     * @param password The value for password 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder password(String password) {
      this.password = Objects.requireNonNull(password, "password");
      initBits &= ~INIT_BIT_PASSWORD;
      return this;
    }

    /**
     * Initializes the value for the {@link _ChangeUserPasswordRequest#getUserId() userId} attribute.
     * @param userId The value for userId 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder userId(String userId) {
      this.userId = Objects.requireNonNull(userId, "userId");
      initBits &= ~INIT_BIT_USER_ID;
      return this;
    }

    /**
     * Initializes the value for the {@link _ChangeUserPasswordRequest#getIdentityZoneId() identityZoneId} attribute.
     * @param identityZoneId The value for identityZoneId (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder identityZoneId(@Nullable String identityZoneId) {
      this.identityZoneId = identityZoneId;
      return this;
    }

    /**
     * Builds a new {@link ChangeUserPasswordRequest ChangeUserPasswordRequest}.
     * @return An immutable instance of ChangeUserPasswordRequest
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ChangeUserPasswordRequest build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ChangeUserPasswordRequest(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<String>();
      if ((initBits & INIT_BIT_OLD_PASSWORD) != 0) attributes.add("oldPassword");
      if ((initBits & INIT_BIT_PASSWORD) != 0) attributes.add("password");
      if ((initBits & INIT_BIT_USER_ID) != 0) attributes.add("userId");
      return "Cannot build ChangeUserPasswordRequest, some of required attributes are not set " + attributes;
    }
  }
}
