package org.cloudfoundry.uaa.users;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.Generated;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.uaa.IdentityZoned;

/**
 * The request payload for the create user operation
 */
@SuppressWarnings({"all"})
@Generated({"Immutables.generator", "_CreateUserRequest"})
public final class CreateUserRequest extends org.cloudfoundry.uaa.users._CreateUserRequest {
  private final @Nullable Boolean active;
  private final List<Email> email;
  private final @Nullable String externalId;
  private final Name name;
  private final @Nullable String origin;
  private final String password;
  private final String userName;
  private final @Nullable Boolean verified;
  private final @Nullable List<PhoneNumber> phoneNumbers;
  private final @Nullable String identityZoneId;

  private CreateUserRequest(CreateUserRequest.Builder builder) {
    this.active = builder.active;
    this.email = createUnmodifiableList(true, builder.email);
    this.externalId = builder.externalId;
    this.name = builder.name;
    this.origin = builder.origin;
    this.password = builder.password;
    this.userName = builder.userName;
    this.verified = builder.verified;
    this.phoneNumbers = builder.phoneNumbers == null ? null : createUnmodifiableList(true, builder.phoneNumbers);
    this.identityZoneId = builder.identityZoneId;
  }

  /**
   * Whether the user is active
   */
  @Override
  public @Nullable Boolean getActive() {
    return active;
  }

  /**
   * The emails for the user
   */
  @Override
  public List<Email> getEmail() {
    return email;
  }

  /**
   * The external id
   */
  @Override
  public @Nullable String getExternalId() {
    return externalId;
  }

  /**
   * The user's name
   */
  @Override
  public Name getName() {
    return name;
  }

  /**
   * The identity provider that authenticated this user
   */
  @Override
  public @Nullable String getOrigin() {
    return origin;
  }

  /**
   * The password
   */
  @Override
  public String getPassword() {
    return password;
  }

  /**
   * The user name
   */
  @Override
  public String getUserName() {
    return userName;
  }

  /**
   * Whether the user's email is verified
   */
  @Override
  public @Nullable Boolean getVerified() {
    return verified;
  }

  /**
   * The phone numbers for the user
   */
  @Override
  public @Nullable List<PhoneNumber> getPhoneNumbers() {
    return phoneNumbers;
  }

  /**
   * Returns the identity zone id
   * @return the identity zone id
   */
  @Override
  public @Nullable String getIdentityZoneId() {
    return identityZoneId;
  }

  /**
   * This instance is equal to all instances of {@code CreateUserRequest} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof CreateUserRequest
        && equalTo((CreateUserRequest) another);
  }

  private boolean equalTo(CreateUserRequest another) {
    return Objects.equals(active, another.active)
        && email.equals(another.email)
        && Objects.equals(externalId, another.externalId)
        && name.equals(another.name)
        && Objects.equals(origin, another.origin)
        && password.equals(another.password)
        && userName.equals(another.userName)
        && Objects.equals(verified, another.verified)
        && Objects.equals(phoneNumbers, another.phoneNumbers)
        && Objects.equals(identityZoneId, another.identityZoneId);
  }

  /**
   * Computes a hash code from attributes: {@code active}, {@code email}, {@code externalId}, {@code name}, {@code origin}, {@code password}, {@code userName}, {@code verified}, {@code phoneNumbers}, {@code identityZoneId}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + Objects.hashCode(active);
    h += (h << 5) + email.hashCode();
    h += (h << 5) + Objects.hashCode(externalId);
    h += (h << 5) + name.hashCode();
    h += (h << 5) + Objects.hashCode(origin);
    h += (h << 5) + password.hashCode();
    h += (h << 5) + userName.hashCode();
    h += (h << 5) + Objects.hashCode(verified);
    h += (h << 5) + Objects.hashCode(phoneNumbers);
    h += (h << 5) + Objects.hashCode(identityZoneId);
    return h;
  }

  /**
   * Prints the immutable value {@code CreateUserRequest} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "CreateUserRequest{"
        + "active=" + active
        + ", email=" + email
        + ", externalId=" + externalId
        + ", name=" + name
        + ", origin=" + origin
        + ", password=" + password
        + ", userName=" + userName
        + ", verified=" + verified
        + ", phoneNumbers=" + phoneNumbers
        + ", identityZoneId=" + identityZoneId
        + "}";
  }


  private static CreateUserRequest validate(CreateUserRequest instance) {
    instance.check();
    return instance;
  }

  /**
   * Creates a builder for {@link CreateUserRequest CreateUserRequest}.
   * @return A new CreateUserRequest builder
   */
  public static CreateUserRequest.Builder builder() {
    return new CreateUserRequest.Builder();
  }

  /**
   * Builds instances of type {@link CreateUserRequest CreateUserRequest}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  public static final class Builder {
    private static final long INIT_BIT_NAME = 0x1L;
    private static final long INIT_BIT_PASSWORD = 0x2L;
    private static final long INIT_BIT_USER_NAME = 0x4L;
    private long initBits = 0x7L;

    private Boolean active;
    private List<Email> email = new ArrayList<Email>();
    private String externalId;
    private Name name;
    private String origin;
    private String password;
    private String userName;
    private Boolean verified;
    private List<PhoneNumber> phoneNumbers = null;
    private String identityZoneId;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code org.cloudfoundry.uaa.IdentityZoned} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(IdentityZoned instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code CreateUserRequest} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(CreateUserRequest instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Copy abstract value type {@code _CreateUserRequest} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_CreateUserRequest instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    private void from(Object object) {
      if (object instanceof IdentityZoned) {
        IdentityZoned instance = (IdentityZoned) object;
        String identityZoneIdValue = instance.getIdentityZoneId();
        if (identityZoneIdValue != null) {
          identityZoneId(identityZoneIdValue);
        }
      }
      if (object instanceof org.cloudfoundry.uaa.users._CreateUserRequest) {
        org.cloudfoundry.uaa.users._CreateUserRequest instance = (org.cloudfoundry.uaa.users._CreateUserRequest) object;
        password(instance.getPassword());
        String originValue = instance.getOrigin();
        if (originValue != null) {
          origin(originValue);
        }
        name(instance.getName());
        Boolean verifiedValue = instance.getVerified();
        if (verifiedValue != null) {
          verified(verifiedValue);
        }
        Boolean activeValue = instance.getActive();
        if (activeValue != null) {
          active(activeValue);
        }
        String externalIdValue = instance.getExternalId();
        if (externalIdValue != null) {
          externalId(externalIdValue);
        }
        userName(instance.getUserName());
        addAllEmail(instance.getEmail());
        List<PhoneNumber> phoneNumbersValue = instance.getPhoneNumbers();
        if (phoneNumbersValue != null) {
          addAllPhoneNumbers(phoneNumbersValue);
        }
      }
    }

    /**
     * Initializes the value for the {@link _CreateUserRequest#getActive() active} attribute.
     * @param active The value for active (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder active(@Nullable Boolean active) {
      this.active = active;
      return this;
    }

    /**
     * Adds one element to {@link _CreateUserRequest#getEmail() email} list.
     * @param element A email element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder email(Email element) {
      this.email.add(Objects.requireNonNull(element, "email element"));
      return this;
    }

    /**
     * Adds elements to {@link _CreateUserRequest#getEmail() email} list.
     * @param elements An array of email elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder email(Email... elements) {
      for (Email element : elements) {
        this.email.add(Objects.requireNonNull(element, "email element"));
      }
      return this;
    }

    /**
     * Sets or replaces all elements for {@link _CreateUserRequest#getEmail() email} list.
     * @param elements An iterable of email elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder email(Iterable<? extends Email> elements) {
      this.email.clear();
      return addAllEmail(elements);
    }

    /**
     * Adds elements to {@link _CreateUserRequest#getEmail() email} list.
     * @param elements An iterable of email elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllEmail(Iterable<? extends Email> elements) {
      for (Email element : elements) {
        this.email.add(Objects.requireNonNull(element, "email element"));
      }
      return this;
    }

    /**
     * Initializes the value for the {@link _CreateUserRequest#getExternalId() externalId} attribute.
     * @param externalId The value for externalId (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder externalId(@Nullable String externalId) {
      this.externalId = externalId;
      return this;
    }

    /**
     * Initializes the value for the {@link _CreateUserRequest#getName() name} attribute.
     * @param name The value for name 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder name(Name name) {
      this.name = Objects.requireNonNull(name, "name");
      initBits &= ~INIT_BIT_NAME;
      return this;
    }

    /**
     * Initializes the value for the {@link _CreateUserRequest#getOrigin() origin} attribute.
     * @param origin The value for origin (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder origin(@Nullable String origin) {
      this.origin = origin;
      return this;
    }

    /**
     * Initializes the value for the {@link _CreateUserRequest#getPassword() password} attribute.
     * @param password The value for password 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder password(String password) {
      this.password = Objects.requireNonNull(password, "password");
      initBits &= ~INIT_BIT_PASSWORD;
      return this;
    }

    /**
     * Initializes the value for the {@link _CreateUserRequest#getUserName() userName} attribute.
     * @param userName The value for userName 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder userName(String userName) {
      this.userName = Objects.requireNonNull(userName, "userName");
      initBits &= ~INIT_BIT_USER_NAME;
      return this;
    }

    /**
     * Initializes the value for the {@link _CreateUserRequest#getVerified() verified} attribute.
     * @param verified The value for verified (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder verified(@Nullable Boolean verified) {
      this.verified = verified;
      return this;
    }

    /**
     * Adds one element to {@link _CreateUserRequest#getPhoneNumbers() phoneNumbers} list.
     * @param element A phoneNumbers element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder phoneNumber(PhoneNumber element) {
      if (this.phoneNumbers == null) {
        this.phoneNumbers = new ArrayList<PhoneNumber>();
      }
      this.phoneNumbers.add(Objects.requireNonNull(element, "phoneNumbers element"));
      return this;
    }

    /**
     * Adds elements to {@link _CreateUserRequest#getPhoneNumbers() phoneNumbers} list.
     * @param elements An array of phoneNumbers elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder phoneNumber(PhoneNumber... elements) {
      if (this.phoneNumbers == null) {
        this.phoneNumbers = new ArrayList<PhoneNumber>();
      }
      for (PhoneNumber element : elements) {
        this.phoneNumbers.add(Objects.requireNonNull(element, "phoneNumbers element"));
      }
      return this;
    }

    /**
     * Sets or replaces all elements for {@link _CreateUserRequest#getPhoneNumbers() phoneNumbers} list.
     * @param elements An iterable of phoneNumbers elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder phoneNumbers(@Nullable Iterable<? extends PhoneNumber> elements) {
      if (elements == null) {
        this.phoneNumbers = null;
        return this;
      }
      this.phoneNumbers = new ArrayList<PhoneNumber>();
      return addAllPhoneNumbers(elements);
    }

    /**
     * Adds elements to {@link _CreateUserRequest#getPhoneNumbers() phoneNumbers} list.
     * @param elements An iterable of phoneNumbers elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllPhoneNumbers(Iterable<? extends PhoneNumber> elements) {
      Objects.requireNonNull(elements, "phoneNumbers element");
      if (this.phoneNumbers == null) {
        this.phoneNumbers = new ArrayList<PhoneNumber>();
      }
      for (PhoneNumber element : elements) {
        this.phoneNumbers.add(Objects.requireNonNull(element, "phoneNumbers element"));
      }
      return this;
    }

    /**
     * Initializes the value for the {@link _CreateUserRequest#getIdentityZoneId() identityZoneId} attribute.
     * @param identityZoneId The value for identityZoneId (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder identityZoneId(@Nullable String identityZoneId) {
      this.identityZoneId = identityZoneId;
      return this;
    }

    /**
     * Builds a new {@link CreateUserRequest CreateUserRequest}.
     * @return An immutable instance of CreateUserRequest
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public CreateUserRequest build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return CreateUserRequest.validate(new CreateUserRequest(this));
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<String>();
      if ((initBits & INIT_BIT_NAME) != 0) attributes.add("name");
      if ((initBits & INIT_BIT_PASSWORD) != 0) attributes.add("password");
      if ((initBits & INIT_BIT_USER_NAME) != 0) attributes.add("userName");
      return "Cannot build CreateUserRequest, some of required attributes are not set " + attributes;
    }
  }

  private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
    ArrayList<T> list;
    if (iterable instanceof Collection<?>) {
      int size = ((Collection<?>) iterable).size();
      if (size == 0) return Collections.emptyList();
      list = new ArrayList<T>();
    } else {
      list = new ArrayList<T>();
    }
    for (T element : iterable) {
      if (skipNulls && element == null) continue;
      if (checkNulls) Objects.requireNonNull(element, "element");
      list.add(element);
    }
    return list;
  }

  private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
    switch(list.size()) {
    case 0: return Collections.emptyList();
    case 1: return Collections.singletonList(list.get(0));
    default:
      if (clone) {
        return Collections.unmodifiableList(new ArrayList<T>(list));
      } else {
        if (list instanceof ArrayList<?>) {
          ((ArrayList<?>) list).trimToSize();
        }
        return Collections.unmodifiableList(list);
      }
    }
  }
}
