package org.cloudfoundry.uaa.users;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Generated;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.uaa.IdentityZoned;
import org.cloudfoundry.uaa.Versioned;

/**
 * The request payload for the delete user operation
 */
@SuppressWarnings({"all"})
@Generated({"Immutables.generator", "_DeleteUserRequest"})
public final class DeleteUserRequest extends org.cloudfoundry.uaa.users._DeleteUserRequest {
  private final String userId;
  private final @Nullable String identityZoneId;
  private final @Nullable String version;

  private DeleteUserRequest(DeleteUserRequest.Builder builder) {
    this.userId = builder.userId;
    this.identityZoneId = builder.identityZoneId;
    this.version = builder.version;
  }

  /**
   * The user id
   */
  @Override
  public String getUserId() {
    return userId;
  }

  /**
   * Returns the identity zone id
   * @return the identity zone id
   */
  @Override
  public @Nullable String getIdentityZoneId() {
    return identityZoneId;
  }

  /**
   * Returns the version
   */
  @Override
  public @Nullable String getVersion() {
    return version;
  }

  /**
   * This instance is equal to all instances of {@code DeleteUserRequest} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof DeleteUserRequest
        && equalTo((DeleteUserRequest) another);
  }

  private boolean equalTo(DeleteUserRequest another) {
    return userId.equals(another.userId)
        && Objects.equals(identityZoneId, another.identityZoneId)
        && Objects.equals(version, another.version);
  }

  /**
   * Computes a hash code from attributes: {@code userId}, {@code identityZoneId}, {@code version}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + userId.hashCode();
    h += (h << 5) + Objects.hashCode(identityZoneId);
    h += (h << 5) + Objects.hashCode(version);
    return h;
  }

  /**
   * Prints the immutable value {@code DeleteUserRequest} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "DeleteUserRequest{"
        + "userId=" + userId
        + ", identityZoneId=" + identityZoneId
        + ", version=" + version
        + "}";
  }

  /**
   * Creates a builder for {@link DeleteUserRequest DeleteUserRequest}.
   * @return A new DeleteUserRequest builder
   */
  public static DeleteUserRequest.Builder builder() {
    return new DeleteUserRequest.Builder();
  }

  /**
   * Builds instances of type {@link DeleteUserRequest DeleteUserRequest}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  public static final class Builder {
    private static final long INIT_BIT_USER_ID = 0x1L;
    private long initBits = 0x1L;

    private String userId;
    private String identityZoneId;
    private String version;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code org.cloudfoundry.uaa.IdentityZoned} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(IdentityZoned instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code DeleteUserRequest} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(DeleteUserRequest instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Copy abstract value type {@code _DeleteUserRequest} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_DeleteUserRequest instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code org.cloudfoundry.uaa.Versioned} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(Versioned instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    private void from(Object object) {
      if (object instanceof IdentityZoned) {
        IdentityZoned instance = (IdentityZoned) object;
        String identityZoneIdValue = instance.getIdentityZoneId();
        if (identityZoneIdValue != null) {
          identityZoneId(identityZoneIdValue);
        }
      }
      if (object instanceof org.cloudfoundry.uaa.users._DeleteUserRequest) {
        org.cloudfoundry.uaa.users._DeleteUserRequest instance = (org.cloudfoundry.uaa.users._DeleteUserRequest) object;
        userId(instance.getUserId());
      }
      if (object instanceof Versioned) {
        Versioned instance = (Versioned) object;
        String versionValue = instance.getVersion();
        if (versionValue != null) {
          version(versionValue);
        }
      }
    }

    /**
     * Initializes the value for the {@link _DeleteUserRequest#getUserId() userId} attribute.
     * @param userId The value for userId 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder userId(String userId) {
      this.userId = Objects.requireNonNull(userId, "userId");
      initBits &= ~INIT_BIT_USER_ID;
      return this;
    }

    /**
     * Initializes the value for the {@link _DeleteUserRequest#getIdentityZoneId() identityZoneId} attribute.
     * @param identityZoneId The value for identityZoneId (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder identityZoneId(@Nullable String identityZoneId) {
      this.identityZoneId = identityZoneId;
      return this;
    }

    /**
     * Initializes the value for the {@link _DeleteUserRequest#getVersion() version} attribute.
     * @param version The value for version (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder version(@Nullable String version) {
      this.version = version;
      return this;
    }

    /**
     * Builds a new {@link DeleteUserRequest DeleteUserRequest}.
     * @return An immutable instance of DeleteUserRequest
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public DeleteUserRequest build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new DeleteUserRequest(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<String>();
      if ((initBits & INIT_BIT_USER_ID) != 0) attributes.add("userId");
      return "Cannot build DeleteUserRequest, some of required attributes are not set " + attributes;
    }
  }
}
