package org.cloudfoundry.uaa.users;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Generated;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.uaa.IdentityZoned;

/**
 * The request payload for the get user verification link operation
 */
@SuppressWarnings({"all"})
@Generated({"Immutables.generator", "_GetUserVerificationLinkRequest"})
public final class GetUserVerificationLinkRequest
    extends org.cloudfoundry.uaa.users._GetUserVerificationLinkRequest {
  private final String redirectUri;
  private final String userId;
  private final @Nullable String identityZoneId;

  private GetUserVerificationLinkRequest(GetUserVerificationLinkRequest.Builder builder) {
    this.redirectUri = builder.redirectUri;
    this.userId = builder.userId;
    this.identityZoneId = builder.identityZoneId;
  }

  /**
   * The redirect URI
   */
  @Override
  public String getRedirectUri() {
    return redirectUri;
  }

  /**
   * The user id
   */
  @Override
  public String getUserId() {
    return userId;
  }

  /**
   * Returns the identity zone id
   * @return the identity zone id
   */
  @Override
  public @Nullable String getIdentityZoneId() {
    return identityZoneId;
  }

  /**
   * This instance is equal to all instances of {@code GetUserVerificationLinkRequest} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof GetUserVerificationLinkRequest
        && equalTo((GetUserVerificationLinkRequest) another);
  }

  private boolean equalTo(GetUserVerificationLinkRequest another) {
    return redirectUri.equals(another.redirectUri)
        && userId.equals(another.userId)
        && Objects.equals(identityZoneId, another.identityZoneId);
  }

  /**
   * Computes a hash code from attributes: {@code redirectUri}, {@code userId}, {@code identityZoneId}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + redirectUri.hashCode();
    h += (h << 5) + userId.hashCode();
    h += (h << 5) + Objects.hashCode(identityZoneId);
    return h;
  }

  /**
   * Prints the immutable value {@code GetUserVerificationLinkRequest} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "GetUserVerificationLinkRequest{"
        + "redirectUri=" + redirectUri
        + ", userId=" + userId
        + ", identityZoneId=" + identityZoneId
        + "}";
  }

  /**
   * Creates a builder for {@link GetUserVerificationLinkRequest GetUserVerificationLinkRequest}.
   * @return A new GetUserVerificationLinkRequest builder
   */
  public static GetUserVerificationLinkRequest.Builder builder() {
    return new GetUserVerificationLinkRequest.Builder();
  }

  /**
   * Builds instances of type {@link GetUserVerificationLinkRequest GetUserVerificationLinkRequest}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  public static final class Builder {
    private static final long INIT_BIT_REDIRECT_URI = 0x1L;
    private static final long INIT_BIT_USER_ID = 0x2L;
    private long initBits = 0x3L;

    private String redirectUri;
    private String userId;
    private String identityZoneId;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code org.cloudfoundry.uaa.IdentityZoned} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(IdentityZoned instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code GetUserVerificationLinkRequest} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(GetUserVerificationLinkRequest instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Copy abstract value type {@code _GetUserVerificationLinkRequest} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_GetUserVerificationLinkRequest instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    private void from(Object object) {
      if (object instanceof IdentityZoned) {
        IdentityZoned instance = (IdentityZoned) object;
        String identityZoneIdValue = instance.getIdentityZoneId();
        if (identityZoneIdValue != null) {
          identityZoneId(identityZoneIdValue);
        }
      }
      if (object instanceof org.cloudfoundry.uaa.users._GetUserVerificationLinkRequest) {
        org.cloudfoundry.uaa.users._GetUserVerificationLinkRequest instance = (org.cloudfoundry.uaa.users._GetUserVerificationLinkRequest) object;
        redirectUri(instance.getRedirectUri());
        userId(instance.getUserId());
      }
    }

    /**
     * Initializes the value for the {@link _GetUserVerificationLinkRequest#getRedirectUri() redirectUri} attribute.
     * @param redirectUri The value for redirectUri 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder redirectUri(String redirectUri) {
      this.redirectUri = Objects.requireNonNull(redirectUri, "redirectUri");
      initBits &= ~INIT_BIT_REDIRECT_URI;
      return this;
    }

    /**
     * Initializes the value for the {@link _GetUserVerificationLinkRequest#getUserId() userId} attribute.
     * @param userId The value for userId 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder userId(String userId) {
      this.userId = Objects.requireNonNull(userId, "userId");
      initBits &= ~INIT_BIT_USER_ID;
      return this;
    }

    /**
     * Initializes the value for the {@link _GetUserVerificationLinkRequest#getIdentityZoneId() identityZoneId} attribute.
     * @param identityZoneId The value for identityZoneId (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder identityZoneId(@Nullable String identityZoneId) {
      this.identityZoneId = identityZoneId;
      return this;
    }

    /**
     * Builds a new {@link GetUserVerificationLinkRequest GetUserVerificationLinkRequest}.
     * @return An immutable instance of GetUserVerificationLinkRequest
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public GetUserVerificationLinkRequest build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new GetUserVerificationLinkRequest(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<String>();
      if ((initBits & INIT_BIT_REDIRECT_URI) != 0) attributes.add("redirectUri");
      if ((initBits & INIT_BIT_USER_ID) != 0) attributes.add("userId");
      return "Cannot build GetUserVerificationLinkRequest, some of required attributes are not set " + attributes;
    }
  }
}
