package org.cloudfoundry.uaa.users;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.Generated;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.uaa.IdentityZoned;
import org.cloudfoundry.uaa.Versioned;

/**
 * The request payload for the update user operation
 */
@SuppressWarnings({"all"})
@Generated({"Immutables.generator", "_UpdateUserRequest"})
public final class UpdateUserRequest extends org.cloudfoundry.uaa.users._UpdateUserRequest {
  private final String version;
  private final @Nullable Boolean active;
  private final List<Email> emails;
  private final @Nullable String externalId;
  private final String id;
  private final Name name;
  private final @Nullable String origin;
  private final List<PhoneNumber> phoneNumbers;
  private final String userName;
  private final @Nullable Boolean verified;
  private final @Nullable String identityZoneId;

  private UpdateUserRequest(UpdateUserRequest.Builder builder) {
    this.version = builder.version;
    this.active = builder.active;
    this.emails = createUnmodifiableList(true, builder.emails);
    this.externalId = builder.externalId;
    this.id = builder.id;
    this.name = builder.name;
    this.origin = builder.origin;
    this.phoneNumbers = createUnmodifiableList(true, builder.phoneNumbers);
    this.userName = builder.userName;
    this.verified = builder.verified;
    this.identityZoneId = builder.identityZoneId;
  }

  /**
   * The version
   */
  @Override
  public String getVersion() {
    return version;
  }

  /**
   * Whether the user is active
   */
  @Override
  public @Nullable Boolean getActive() {
    return active;
  }

  /**
   * The emails for the user
   */
  @Override
  public List<Email> getEmails() {
    return emails;
  }

  /**
   * The external id
   */
  @Override
  public @Nullable String getExternalId() {
    return externalId;
  }

  /**
   * The id
   */
  @Override
  public String getId() {
    return id;
  }

  /**
   * The user's name
   */
  @Override
  public Name getName() {
    return name;
  }

  /**
   * The identity provider that authenticated this user
   */
  @Override
  public @Nullable String getOrigin() {
    return origin;
  }

  /**
   * The phone numbers for the user
   */
  @Override
  public List<PhoneNumber> getPhoneNumbers() {
    return phoneNumbers;
  }

  /**
   * The user name
   */
  @Override
  public String getUserName() {
    return userName;
  }

  /**
   * Whether the user's email is verified
   */
  @Override
  public @Nullable Boolean getVerified() {
    return verified;
  }

  /**
   * Returns the identity zone id
   * @return the identity zone id
   */
  @Override
  public @Nullable String getIdentityZoneId() {
    return identityZoneId;
  }

  /**
   * This instance is equal to all instances of {@code UpdateUserRequest} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof UpdateUserRequest
        && equalTo((UpdateUserRequest) another);
  }

  private boolean equalTo(UpdateUserRequest another) {
    return version.equals(another.version)
        && Objects.equals(active, another.active)
        && emails.equals(another.emails)
        && Objects.equals(externalId, another.externalId)
        && id.equals(another.id)
        && name.equals(another.name)
        && Objects.equals(origin, another.origin)
        && phoneNumbers.equals(another.phoneNumbers)
        && userName.equals(another.userName)
        && Objects.equals(verified, another.verified)
        && Objects.equals(identityZoneId, another.identityZoneId);
  }

  /**
   * Computes a hash code from attributes: {@code version}, {@code active}, {@code emails}, {@code externalId}, {@code id}, {@code name}, {@code origin}, {@code phoneNumbers}, {@code userName}, {@code verified}, {@code identityZoneId}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + version.hashCode();
    h += (h << 5) + Objects.hashCode(active);
    h += (h << 5) + emails.hashCode();
    h += (h << 5) + Objects.hashCode(externalId);
    h += (h << 5) + id.hashCode();
    h += (h << 5) + name.hashCode();
    h += (h << 5) + Objects.hashCode(origin);
    h += (h << 5) + phoneNumbers.hashCode();
    h += (h << 5) + userName.hashCode();
    h += (h << 5) + Objects.hashCode(verified);
    h += (h << 5) + Objects.hashCode(identityZoneId);
    return h;
  }

  /**
   * Prints the immutable value {@code UpdateUserRequest} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "UpdateUserRequest{"
        + "version=" + version
        + ", active=" + active
        + ", emails=" + emails
        + ", externalId=" + externalId
        + ", id=" + id
        + ", name=" + name
        + ", origin=" + origin
        + ", phoneNumbers=" + phoneNumbers
        + ", userName=" + userName
        + ", verified=" + verified
        + ", identityZoneId=" + identityZoneId
        + "}";
  }


  private static UpdateUserRequest validate(UpdateUserRequest instance) {
    instance.check();
    return instance;
  }

  /**
   * Creates a builder for {@link UpdateUserRequest UpdateUserRequest}.
   * @return A new UpdateUserRequest builder
   */
  public static UpdateUserRequest.Builder builder() {
    return new UpdateUserRequest.Builder();
  }

  /**
   * Builds instances of type {@link UpdateUserRequest UpdateUserRequest}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  public static final class Builder {
    private static final long INIT_BIT_VERSION = 0x1L;
    private static final long INIT_BIT_ID = 0x2L;
    private static final long INIT_BIT_NAME = 0x4L;
    private static final long INIT_BIT_USER_NAME = 0x8L;
    private long initBits = 0xfL;

    private String version;
    private Boolean active;
    private List<Email> emails = new ArrayList<Email>();
    private String externalId;
    private String id;
    private Name name;
    private String origin;
    private List<PhoneNumber> phoneNumbers = new ArrayList<PhoneNumber>();
    private String userName;
    private Boolean verified;
    private String identityZoneId;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code org.cloudfoundry.uaa.IdentityZoned} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(IdentityZoned instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code org.cloudfoundry.uaa.Versioned} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(Versioned instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code UpdateUserRequest} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(UpdateUserRequest instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Copy abstract value type {@code _UpdateUserRequest} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_UpdateUserRequest instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    private void from(Object object) {
      long bits = 0;
      if (object instanceof IdentityZoned) {
        IdentityZoned instance = (IdentityZoned) object;
        String identityZoneIdValue = instance.getIdentityZoneId();
        if (identityZoneIdValue != null) {
          identityZoneId(identityZoneIdValue);
        }
      }
      if (object instanceof Versioned) {
        Versioned instance = (Versioned) object;
        if ((bits & 0x1L) == 0) {
          version(instance.getVersion());
          bits |= 0x1L;
        }
      }
      if (object instanceof org.cloudfoundry.uaa.users._UpdateUserRequest) {
        org.cloudfoundry.uaa.users._UpdateUserRequest instance = (org.cloudfoundry.uaa.users._UpdateUserRequest) object;
        addAllEmails(instance.getEmails());
        String originValue = instance.getOrigin();
        if (originValue != null) {
          origin(originValue);
        }
        name(instance.getName());
        Boolean verifiedValue = instance.getVerified();
        if (verifiedValue != null) {
          verified(verifiedValue);
        }
        Boolean activeValue = instance.getActive();
        if (activeValue != null) {
          active(activeValue);
        }
        String externalIdValue = instance.getExternalId();
        if (externalIdValue != null) {
          externalId(externalIdValue);
        }
        id(instance.getId());
        userName(instance.getUserName());
        if ((bits & 0x1L) == 0) {
          version(instance.getVersion());
          bits |= 0x1L;
        }
        addAllPhoneNumbers(instance.getPhoneNumbers());
      }
    }

    /**
     * Initializes the value for the {@link _UpdateUserRequest#getVersion() version} attribute.
     * @param version The value for version 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder version(String version) {
      this.version = Objects.requireNonNull(version, "version");
      initBits &= ~INIT_BIT_VERSION;
      return this;
    }

    /**
     * Initializes the value for the {@link _UpdateUserRequest#getActive() active} attribute.
     * @param active The value for active (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder active(@Nullable Boolean active) {
      this.active = active;
      return this;
    }

    /**
     * Adds one element to {@link _UpdateUserRequest#getEmails() emails} list.
     * @param element A emails element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder email(Email element) {
      this.emails.add(Objects.requireNonNull(element, "emails element"));
      return this;
    }

    /**
     * Adds elements to {@link _UpdateUserRequest#getEmails() emails} list.
     * @param elements An array of emails elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder email(Email... elements) {
      for (Email element : elements) {
        this.emails.add(Objects.requireNonNull(element, "emails element"));
      }
      return this;
    }

    /**
     * Sets or replaces all elements for {@link _UpdateUserRequest#getEmails() emails} list.
     * @param elements An iterable of emails elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder emails(Iterable<? extends Email> elements) {
      this.emails.clear();
      return addAllEmails(elements);
    }

    /**
     * Adds elements to {@link _UpdateUserRequest#getEmails() emails} list.
     * @param elements An iterable of emails elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllEmails(Iterable<? extends Email> elements) {
      for (Email element : elements) {
        this.emails.add(Objects.requireNonNull(element, "emails element"));
      }
      return this;
    }

    /**
     * Initializes the value for the {@link _UpdateUserRequest#getExternalId() externalId} attribute.
     * @param externalId The value for externalId (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder externalId(@Nullable String externalId) {
      this.externalId = externalId;
      return this;
    }

    /**
     * Initializes the value for the {@link _UpdateUserRequest#getId() id} attribute.
     * @param id The value for id 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder id(String id) {
      this.id = Objects.requireNonNull(id, "id");
      initBits &= ~INIT_BIT_ID;
      return this;
    }

    /**
     * Initializes the value for the {@link _UpdateUserRequest#getName() name} attribute.
     * @param name The value for name 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder name(Name name) {
      this.name = Objects.requireNonNull(name, "name");
      initBits &= ~INIT_BIT_NAME;
      return this;
    }

    /**
     * Initializes the value for the {@link _UpdateUserRequest#getOrigin() origin} attribute.
     * @param origin The value for origin (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder origin(@Nullable String origin) {
      this.origin = origin;
      return this;
    }

    /**
     * Adds one element to {@link _UpdateUserRequest#getPhoneNumbers() phoneNumbers} list.
     * @param element A phoneNumbers element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder phoneNumber(PhoneNumber element) {
      this.phoneNumbers.add(Objects.requireNonNull(element, "phoneNumbers element"));
      return this;
    }

    /**
     * Adds elements to {@link _UpdateUserRequest#getPhoneNumbers() phoneNumbers} list.
     * @param elements An array of phoneNumbers elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder phoneNumber(PhoneNumber... elements) {
      for (PhoneNumber element : elements) {
        this.phoneNumbers.add(Objects.requireNonNull(element, "phoneNumbers element"));
      }
      return this;
    }

    /**
     * Sets or replaces all elements for {@link _UpdateUserRequest#getPhoneNumbers() phoneNumbers} list.
     * @param elements An iterable of phoneNumbers elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder phoneNumbers(Iterable<? extends PhoneNumber> elements) {
      this.phoneNumbers.clear();
      return addAllPhoneNumbers(elements);
    }

    /**
     * Adds elements to {@link _UpdateUserRequest#getPhoneNumbers() phoneNumbers} list.
     * @param elements An iterable of phoneNumbers elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllPhoneNumbers(Iterable<? extends PhoneNumber> elements) {
      for (PhoneNumber element : elements) {
        this.phoneNumbers.add(Objects.requireNonNull(element, "phoneNumbers element"));
      }
      return this;
    }

    /**
     * Initializes the value for the {@link _UpdateUserRequest#getUserName() userName} attribute.
     * @param userName The value for userName 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder userName(String userName) {
      this.userName = Objects.requireNonNull(userName, "userName");
      initBits &= ~INIT_BIT_USER_NAME;
      return this;
    }

    /**
     * Initializes the value for the {@link _UpdateUserRequest#getVerified() verified} attribute.
     * @param verified The value for verified (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder verified(@Nullable Boolean verified) {
      this.verified = verified;
      return this;
    }

    /**
     * Initializes the value for the {@link _UpdateUserRequest#getIdentityZoneId() identityZoneId} attribute.
     * @param identityZoneId The value for identityZoneId (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder identityZoneId(@Nullable String identityZoneId) {
      this.identityZoneId = identityZoneId;
      return this;
    }

    /**
     * Builds a new {@link UpdateUserRequest UpdateUserRequest}.
     * @return An immutable instance of UpdateUserRequest
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public UpdateUserRequest build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return UpdateUserRequest.validate(new UpdateUserRequest(this));
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<String>();
      if ((initBits & INIT_BIT_VERSION) != 0) attributes.add("version");
      if ((initBits & INIT_BIT_ID) != 0) attributes.add("id");
      if ((initBits & INIT_BIT_NAME) != 0) attributes.add("name");
      if ((initBits & INIT_BIT_USER_NAME) != 0) attributes.add("userName");
      return "Cannot build UpdateUserRequest, some of required attributes are not set " + attributes;
    }
  }

  private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
    ArrayList<T> list;
    if (iterable instanceof Collection<?>) {
      int size = ((Collection<?>) iterable).size();
      if (size == 0) return Collections.emptyList();
      list = new ArrayList<T>();
    } else {
      list = new ArrayList<T>();
    }
    for (T element : iterable) {
      if (skipNulls && element == null) continue;
      if (checkNulls) Objects.requireNonNull(element, "element");
      list.add(element);
    }
    return list;
  }

  private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
    switch(list.size()) {
    case 0: return Collections.emptyList();
    case 1: return Collections.singletonList(list.get(0));
    default:
      if (clone) {
        return Collections.unmodifiableList(new ArrayList<T>(list));
      } else {
        if (list instanceof ArrayList<?>) {
          ((ArrayList<?>) list).trimToSize();
        }
        return Collections.unmodifiableList(list);
      }
    }
  }
}
